'
'(C)1990, 1991 Marquis Computing - All Rights Reserved. Proudly written in
'pure BASIC by Hank Marquis.
'

 DEFINT A-Z

 '--- DBF type & declarations
 '$INCLUDE: 'DBFUNC.BI'

 DECLARE SUB GetRec (File, Record&, Record$)
 DECLARE SUB GetNumrecs (File, HeadRecs&)
 DECLARE SUB GetField (File, Record$, FldNum, FldData$)

 DECLARE FUNCTION MAXError (Msg$)

SUB SearchFLD (File, SearchData$, FldNum, RecNum&, FldData$) STATIC

  'Searches a DBF field for the pattern held in SearchData$.
  'Used because DBASFUNC LIB does not process dBASE index files. More
  'specific than using SearchDBF which looks at the whole record.
  '
  'On entry:
  '     SearchData$ is the data to find
  '     File is the file to seach
  '     FldNum is the field to search
  '
  'On exit:
  '     FldData$ is the field containing SearchData$
  '

  '---get last record
  GetNumrecs File, LastRec&

  '---reset to first record
  Rec& = 1
  GetRec File, Rec&, Record$
  GetField File, Record$, FldNum, FldData$
  FldData$ = UCASE$(FldData$)
  SearchData$ = UCASE$(SearchData$)
 
  '---step through DBF
  DO

    '---look through record
    IF INSTR(FldData$, SearchData$) THEN
      RecNum& = Rec&
      EXIT DO
    END IF
 
    '---reset record
    Rec& = 0
 
    '---get the record
    GetRec File, Rec&, Record$
    GetField File, Record$, FldNum, FldData$
    FldData$ = UCASE$(FldData$)

    '---check for error
    IF Rec& > LastRec& THEN EXIT DO
 
  LOOP
  
END SUB

