'
'(C)1990, 1991 Marquis Computing - All Rights Reserved. Proudly written in
'pure BASIC by Hank Marquis.
'
'Returns a database fields data.
'

 DEFINT A-Z

 '--- DBF type & declarations
 '$INCLUDE: 'DBFUNC.BI'

 DECLARE SUB CheckFields (File)
 DECLARE SUB SetMAXError (ErrNum)

 DECLARE FUNCTION Trim$ (A$)

SUB GetField (FileNum, Record$, FldNum, FldData$)

   '
   'Returns the contents of field Fld from record Record$ in
   'variable FldData$. Uses MAXBASIC FldInfo Fld() type array.
   '
   'NOTE: You must have opened a database and gotten a record using
   '      GetRec to do this - otherwise FldData$ will be bogus.
   '

   '--- get DBF definition
   CheckFields FileNum
  
   '--- get fld from record$
   FldData$ = Trim$(MID$(Record$, Fld(FldNum).OffSet, Fld(FldNum).FLen))

   '--- process LEADING nulls in a number. dBASE number fields are stored
   '    with NULLS as the leading characters & we gotta remove them . . .
  
   IF Fld(FldNum).FType = "N" THEN              'is this a NUMERIC field?
     FldData = VAL(FldData$)                    'change to number
     FldData$ = LTRIM$(STR$(FldData))           'strip space & make a string
   END IF

   '--- error handler
   SetMAXError 0                                'set error level
  
END SUB

