' CRCTEST.BAS
' Written by Lyle Jensen October 4, 1991.
' The CRC calculation is adapted from Peter Boswell's "Xmodem, CRC Xmodem,
' Wxmodem File Transfer Protocols" wherein he cites a paper written by
' Steven Satchell, "Test of CRC Routines for CRC-CCITT".

DECLARE SUB CRCCalc (Block$, CRC$)
DEFINT A-Z
DIM CRCTAB(0 TO 255)
RANDOMIZE TIMER                        ' User value of TIMER as seed to
                                       ' initialize random number generator.
CLS
GOSUB CRCInit

Block$ = ""

FOR I = 1 TO 128                       ' Generate a 128 byte string of
   C = INT((122 - 48 + 1) * RND + 48)  ' random characters.
   Block$ = Block$ + CHR$(C)
NEXT I

PRINT "Test data block: ": PRINT Block$
PRINT "Length: "; LEN(Block$)
  
Block$ = Block$ + STRING$(2, 0)

PRINT : PRINT "CRC Calculation"
Time1! = TIMER
CALL CRCCalc(Block$, CRC$)
Time2! = TIMER
PRINT "CRC:  High="; ASC(LEFT$(CRC$, 1)), "Low="; ASC(RIGHT$(CRC$, 1))
PRINT "Elapsed time: "; Time2! - Time1!; "seconds"

END                                    ' End of program

CRCInit:
FOR I% = 0 TO 255
   READ CRCTAB(I%)
NEXT I%
RETURN

DATA 0,4129,8258,12387,16516,20645,24774,28903
DATA -32504,-28375,-24246,-20117,-15988,-11859,-7730,-3601
DATA 4657,528,12915,8786,21173,17044,29431,25302
DATA -27847,-31976,-19589,-23718,-11331,-15460,-3073,-7202
DATA 9314,13379,1056,5121,25830,29895,17572,21637
DATA -23190,-19125,-31448,-27383,-6674,-2609,-14932,-10867
DATA 13907,9842,5649,1584,30423,26358,22165,18100
DATA -18597,-22662,-26855,-30920,-2081,-6146,-10339,-14404
DATA 18628,22757,26758,30887,2112,6241,10242,14371
DATA -13876,-9747,-5746,-1617,-30392,-26263,-22262,-18133
DATA 23285,19156,31415,27286,6769,2640,14899,10770
DATA -9219,-13348,-1089,-5218,-25735,-29864,-17605,-21734
DATA 27814,31879,19684,23749,11298,15363,3168,7233
DATA -4690,-625,-12820,-8755,-21206,-17141,-29336,-25271
DATA 32407,28342,24277,20212,15891,11826,7761,3696
DATA -97,-4162,-8227,-12292,-16613,-20678,-24743,-28808
DATA -28280,-32343,-20022,-24085,-12020,-16083,-3762,-7825
DATA 4224,161,12482,8419,20484,16421,28742,24679
DATA -31815,-27752,-23557,-19494,-15555,-11492,-7297,-3234
DATA 689,4752,8947,13010,16949,21012,25207,29270
DATA -18966,-23093,-27224,-31351,-2706,-6833,-10964,-15091
DATA 13538,9411,5280,1153,29798,25671,21540,17413
DATA -22565,-18438,-30823,-26696,-6305,-2178,-14563,-10436
DATA 9939,14066,1681,5808,26199,30326,17941,22068
DATA -9908,-13971,-1778,-5841,-26168,-30231,-18038,-22101
DATA 22596,18533,30726,26663,6336,2273,14466,10403
DATA -13443,-9380,-5313,-1250,-29703,-25640,-21573,-17510
DATA 19061,23124,27191,31254,2801,6864,10931,14994
DATA -722,-4849,-8852,-12979,-16982,-21109,-25112,-29239
DATA 31782,27655,23652,19525,15522,11395,7392,3265
DATA -4321,-194,-12451,-8324,-20581,-16454,-28711,-24584
DATA 28183,32310,20053,24180,11923,16050,3793,7920

SUB CRCCalc (V$, CRCX$)
   SHARED CRCTAB()
   CRCX$ = CHR$(0) + CHR$(0)                     ' Initialize to zero
   FOR J = 1 TO 128
      CRCH1 = ASC(LEFT$(CRCX$, 1))               ' CRC >> 8 AND 255
      CRCL2 = CVI(CHR$(0) + RIGHT$(CRCX$, 1))    ' CRC << 8 AND 255
      CRC1$ = MKI$(CRCTAB(CRCH1 XOR ASC(MID$(V$, J, 1))) XOR CRCL2)
      CRCX$ = RIGHT$(CRC1$, 1) + LEFT$(CRC1$, 1) ' Set it back!
   NEXT J

END SUB

