'  Program CLINE.BAS
'  Version 1.00
'  Parses the command tail into an array holding all
'  command line arguments.
'  Written by: J. Derek Lyons.
'  November 1991
'  Released into the public domain to the extent of my ability to do so.

DECLARE SUB ParCline (Arg$(), MaxArg%, Res%)

DEFINT A-Z
OPTION BASE 0

DIM Arg$(5)             'Array to hold the arguments
MaxArg% = 5             'Maximum number of arguments
'
'  To demonstrate CLINE, simply compile this program inside Quick Basic
'  or from the command line.
'
'  Many more options are discussed in CLINE.DOC
'
CLS
CALL ParCline(Arg$(), MaxArg%, Res%)
FOR x = 1 TO 5: PRINT Arg$(x): NEXT x
IF Res% = -1 THEN PRINT "Too Many Arguments"
IF Res% = 0 THEN PRINT "Sucessful Processing"
IF Res% = 1 THEN PRINT "No Arguments Found"
END

SUB ParCline (Arg$(), MaxArg%, Res%)
'  Inputs
'     MaxArg%   Maximum number of arguments
'     Arg$()    Empty array to hold the arguments                 
'               To work properly should be DIMed as Arg$(MaxArg%)
'  Outputs
'     Res%      Result of subroutine
'               -1 = Too many arguments
'                0 = Sucessful processing
'                1 = No arguments found
'     Arg$()    Array holding the arguments
'
                        'numarg and argpos must be initialized
                        'because QB initializes them as 0
NumArg = 1              'Because there is no leading space for the
                        'first argument we must add 1 to the total
                        'number of space to find the total number
                        'of arguments
ArgPos = 1              'The first position in the array

Cline$ = LTRIM$(RTRIM$(COMMAND$))
                        'Get the command line and trim all the spaces
Clen = LEN(Cline$)      'Get the length of the command line

IF Clen = 0 THEN        'There are no arguments so there is no reason
                        'to continue processing the command line
   Res% = 1
   EXIT SUB
END IF

FOR Scount = 1 TO Clen  'Get the number of arguments
   IF MID$(Cline$, Scount, 1) = " " THEN NumArg = NumArg + 1
                        'Each time a space is found in the command line
                        'the number of arguments is incremented
NEXT Scount

IF NumArg > MaxArg% THEN
                        'So we don't crash the program by trying to
                        'write past the end of the array
   Res% = -1
   EXIT SUB
END IF

FOR wcount = 1 TO Clen
   IF MID$(Cline$, wcount, 1) <> " " THEN
      Arg$(ArgPos) = Arg$(ArgPos) + MID$(Cline$, wcount, 1)
                        'If a character is found, then add it to the
                        'current string
   ELSEIF MID$(Cline$, wcount, 1) = " " THEN
      ArgPos = ArgPos + 1
                        'If a space is found, start processing the
                        'next string
   END IF
NEXT wcount

END SUB

