/* This version is for Microsoft C 5.1
 * and Quick C 2.0
 *
 * Compilation syntax:
 *    cl -W3 -Ox go.c -F 1000
 * or
 *    qcl -W3 -Ox go.c -F 1000
 */

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <direct.h>
#include <string.h>

#ifndef TRUE
	#define TRUE  1
	#define FALSE 0
#endif



int   file_search = TRUE;
int   dir_search  = TRUE;
int   orig_drive;
char *orig_dir;
int   search_drive;
char *search_string;
char *dir_search_string;
int   dir_search_length;
char *file_search_string;
int   reset_drive = FALSE;
int   reset_dir   = FALSE;

void do_resets(void);
void help(void);
void test_dir(void);

void main(int argc, char **argv)
{
	unsigned new_drive, total_drives;

	atexit(do_resets);

	if (argc < 2 || argc > 3)
		help();

	_dos_getdrive(&orig_drive);
	orig_dir = getcwd(NULL,0);

	if (argc == 3)
		if (strcmpi(argv[2],"-F") == 0 || strcmpi(argv[2],"/F") == 0)
			dir_search  = FALSE;
		else
			help();
 
	search_string = strdup(strupr(argv[1]));
	if(search_string[1] == ':')
		{
		new_drive = search_string[0] - 'A' + 1;
		_dos_setdrive(new_drive, &total_drives);
		reset_drive = TRUE;
		search_string += 2;
		}

	if (search_string[0] == '\\')
		{
		search_string++;
		file_search = FALSE;
		}

	if(strchr(search_string,'?') || strchr(search_string,'*'))
		dir_search = FALSE;

	if (dir_search)
		{
		dir_search_string = search_string;
		dir_search_length = strlen(dir_search_string);
		}

	if (file_search)
		{
		file_search_string = malloc(strlen(search_string)+3);
		strcpy(file_search_string, search_string);
		if(! strchr(file_search_string, '.' ))
			strcat(file_search_string, ".*");
		}

	if (dir_search | file_search)
		{
		chdir("\\");
		test_dir();
		reset_dir = TRUE;
		exit(0);
		}
	else
		help();
}

void help(void)
{
	puts("\nGO moves you quickly from one subdirectory to another.");
	puts("Syntax:");
	puts("      GO [d:][\\]pathname [-F]");
	puts("         the pathname can be either the name of a directory or");
	puts("         the name of a file.  It may contain wild cards.\n");
	puts("         If 'd:' is included, drive 'd:' will be used instead");
	puts("         of the current drive.\n");
	puts("         If '\\' is included at the beginning of the pathname,");
	puts("         only subdirectory names will be searched.\n");
	puts("         If '-F' or /F' is included, or if the pathname includes");
	puts("         wild card sybmols, only file names will be searched\n");
	puts("         Normally, both file names and subdirectory names are");
	puts("         searched to match the specified pathname.");
	exit(0);
}

void do_resets(void)
{
	unsigned total_drives;

	if(reset_dir)
		{
		chdir(orig_dir);
		puts ("   Requested subdirectory not found\a");
		}
	else
		{
		fputs("   New Directory: ",stdout);
		puts (getcwd(NULL,0));
		}
	
	if(reset_drive)
		_dos_setdrive(orig_drive,&total_drives);
}

void test_dir(void)
{
	char  *current_dir, *cptr;
	int    i;
	struct find_t find_buffer;

	current_dir = getcwd(NULL,0);
	if(dir_search && ((i = strlen(current_dir)) >= dir_search_length))
		{
		cptr = current_dir + (i - dir_search_length);
		if (!strcmp(cptr,search_string))
			exit(0);
		}

	if(file_search)
		{
		if(! _dos_findfirst(file_search_string,_A_NORMAL,&find_buffer))
			exit(0);
		}

	_dos_findfirst("*.*", _A_SUBDIR, &find_buffer);
	if(find_buffer.attrib == _A_SUBDIR && find_buffer.name[0] != '.')
		{
		chdir(find_buffer.name);
		test_dir();
		chdir(current_dir);
		}

	while (! _dos_findnext(&find_buffer))
		if(find_buffer.attrib == _A_SUBDIR && find_buffer.name[0] != '.')
			{
			chdir(find_buffer.name);
			test_dir();
			chdir(current_dir);
			}

	free(current_dir);
}
           