DEFINT A-Z
'$INCLUDE: 'qb.bi'

DECLARE SUB GetDefaultDrive ()
DECLARE SUB GetDriveInfo ()
DECLARE SUB GetMemory ()

DIM SHARED InRegs AS RegType, OutRegs AS RegType
DIM SHARED Drive, PSP

IF LEN(COMMAND$) = 0 THEN
GetDefaultDrive
ELSE
IF MID$(COMMAND$, 2, 1) = ":" THEN
	Drive = ASC(LEFT$(COMMAND$, 1)) - ASC("A") + 1
	ELSE
		Drive = -1
	END IF
END IF

GetDriveInfo
GetMemory
END

SUB GetDefaultDrive
InRegs.ax = &H1900
CALL INTERRUPT(&H21, InRegs, OutRegs)
Drive = (OutRegs.ax AND 255) + 1
END SUB

SUB GetDriveInfo
InRegs.ax = &H3600
InRegs.dx = Drive
CALL INTERRUPT(&H21, InRegs, OutRegs)
IF OutRegs.ax = &HFFFF THEN
PRINT "Invalid Drive"
ELSE
ClusterSize& = CLNG(OutRegs.ax) * CLNG(OutRegs.cx)
TotalBytes& = CLNG(OutRegs.dx) * ClusterSize&
FreeBytes& = CLNG(OutRegs.bx) * ClusterSize&
PRINT USING "Drive !:"; CHR$(Drive + ASC("A") - 1)
PRINT USING "  ######### bytes total disk space"; TotalBytes&
PRINT USING "  ######### bytes available disk space"; FreeBytes&
PRINT
END IF
END SUB

SUB GetMemory
InRegs.ax = &H6200
CALL INTERRUPT(&H21, InRegs, OutRegs)
PSP = OutRegs.bx
CALL INTERRUPT(&H12, InRegs, OutRegs)
MemSize& = OutRegs.ax * 64&
PRINT USING "  ######### bytes total memory"; CLNG(OutRegs.ax) * 1024&
PRINT USING "  ######### bytes free memory"; (MemSize& - CLNG(PSP) + 1&) * 16&
PRINT
PRINT "  Next program will load at "; HEX$(PSP); ":0000 hex"
PRINT
END SUB

