;
;Title:SAVEWIND         JUNE 1 , 1990

Basic_setup    MACRO
               PUSH     BP
               MOV      BP,SP

               PUSH     AX
               PUSH     BX
               PUSH     CX
               PUSH     DX

               PUSH     SI
               PUSH     DI
               PUSH     DS
               PUSH     ES
               ENDM

Basic_cleanup  MACRO
               CLD
               POP      ES
               POP      DS
               POP      DI
               POP      SI
               POP      DX
               POP      CX
               POP      BX
               POP      AX
               POP      BP
               ENDM

Stack          STRUC
Bpsav          DW       ?                       ;saved by us
Retoff         DW       ?                       ;from callf
Retseg         DW       ?                       ;from basic
Return_code    DW       ?
Array_off      DW       ?                       ;pointer to array in ds
Array_seg      DW       ?                       ;pointer to array in ds
Col2           DW       ?                       ;get characters from row1,col1
Row2           DW       ?                       ;to row2,col2
Col1           DW       ?
Row1           DW       ?
Stack          ENDS

;
               .Model Medium
               .Code

               PUBLIC   Savewind

Savewind       PROC
               Basic_setup

               MOV      BX,[BP].Return_code
               MOV      WORD PTR [BX],0

               MOV      SI,[BP].Row2            ;si -> row2
               MOV      AX,[SI]                 ;ax has last row
               MOV      SI,[BP].Row1            ;si -> row1
               MOV      BX,[SI]                 ;form # of rows in ax
               SUB      AX,BX                   ;ax=rows-1
               INC      AX                      ;ax=rows
               MOV      SI,[BP].Col2            ;si -> col2
               MOV      CX,[SI]                 ;now form # of cols in cx
               MOV      SI,[BP].Col1            ;si -> col1
               MOV      BX,[SI]                 ;bx=col1
               SUB      CX,BX                   ;cx has # of cols-1
               INC      CX                      ;cx has # of cols
               MOV      BX,AX                   ;bx=# of rows

               PUSH     DS                      ;save ds
               POP      ES                      ;es points to basic's ds

               MOV      SI,[BP].Row1            ;si -> row1
               MOV      DX,[SI]                 ;si will -> regen buffer
               DEC      DX                      ;make zero-rel
               MOV      AX,160                  ;multiplier
               MUL      DL                      ;ax=offset to row
               MOV      SI,[BP].Col1            ;si -> col1
               MOV      SI,[SI]
               DEC      SI                      ;make col zero-rel
               SHL      SI,1                    ;si=offset in row to col
               ADD      SI,AX                   ;total offset in si

               CALL     Getvid                  ;get video address

               PUSH     BX
               MOV      BX,[BP].Array_off
               MOV      DI,[BX]
               MOV      BX,[BP].Array_seg       ;locate the memory block that is to hold
               MOV      ES,[BX]                 ;a copy of a rectangular screen area
               POP      BX

               MOV      DS,AX                   ;ax=segment address of video regeb buffer

               CLD

               MOV      AX,CX                   ;save col count
               MOV      DX,AX
               ADD      DX,AX                   ;twice because 2 bytes per char

;
LOOP_BACK:
               CLI
               REPZ     MOVSW
               STI

               ADD      SI,160                  ;new row
               MOV      CX,AX                   ;cx=col count
               SUB      SI,DX                   ;move back to right place

               DEC      BX                      ;row count
               JNZ      Loop_back

               Basic_cleanup

               RET      14                      ;get rid of 7 parms
Savewind       ENDP

;
Getvid         PROC     NEAR
               PUSH     BX                      ;save bx register

               MOV      AX,0                    ;clear ax
               MOV      AH,15                   ;video mode bios call
               INT      010H                    ;do the bios call
               CMP      AL,07H                  ;see if it's monochrome
               JZ       Ismono                  ;yes

               MOV      AX,0B800H               ;set it up for graphics
               JMP      Endvid                  ;exit
ISMONO:
               MOV      AX,0B000H               ;set it up for monochrome
ENDVID:
               POP      BX                      ;restore bx register
               RET

Getvid         ENDP
               END
