;
;
;Title:NEWSCRN.ASM              JUNE 1 , 1990
;
;==============================================================================
;
;
;  Module (external) : SAVESCRN
;
;   INPUT  :  BP+8 - address of the address to Basic's 4k save area (offset)
;
;             BP+0a- address of the Segment address of Basic's save area
;
;             BP+0c- address of interger variable that indicates how to
;                    handle refresh of video for CGA monitors.
;
;  OUTPUT:   [BP+a]:[BP+8] - an area allocated by Basic that contains copy of
;                        the screen image.
;
;            ALL OTHER REGS PRESERVED.
;
;  Module (external) : RESTSCRN
;
;   INPUT  :  BP+8 - address of the address to Basic's save area (offset)
;
;             BP+0a- address of the Segment address of Basic's save area
;
;             BP+0c- address of interger variable that indicates how to
;                    handle refresh of video for CGA monitors.
;
;  OUTPUT:  The 2000 words at [BP+a]:[BP+8] are moved to the video regen buffer
;
;            ALL OTHER REGS PRESERVED.
;
;============================================================================

;
Basic_setup    MACRO
               PUSH     BP
               MOV      BP,SP


               PUSH     AX
               PUSH     BX
               PUSH     CX
               PUSH     DX

               PUSH     SI
               PUSH     DI
               PUSH     DS
               PUSH     ES
               ENDM

Basic_cleanup  MACRO
               CLD
               POP      ES
               POP      DS
               POP      DI
               POP      SI
               POP      DX
               POP      CX
               POP      BX
               POP      AX

               POP      BP
               ENDM

Bios_data      SEGMENT  At 40H
               ORG      10H
Equip_flag     LABEL    WORD
               ORG      63H
Addr_6845      LABEL    WORD
Bios_data      ENDS

Stack          STRUC
Bpsav          DW       ?                       ;saved by us
Retoff         DW       ?                       ;from callf
Retseg         DW       ?                       ;from basic
Return_code    DW       ?
Array_off      DW       ?                       ;pointer to array in far heap
Array_seg      DW       ?                       ;pointer to array in far heap
Retrace        DW       ?                       ;vertical retrace wait indicator
Stack          ENDS

;
Code           SEGMENT  BYTE PUBLIC 'CODE'
               ASSUME   CS:Code,DS:Code

               PUBLIC   Savescrn
               PUBLIC   Restscrn

;
Savescrn       PROC     FAR
               Basic_setup                      ;save for basic

               MOV      BX,[BP].Return_code
               MOV      WORD PTR [BX],0

               MOV      BX,[BP].Array_off       ;get location of array
               MOV      SI,[BX]                 ;

               MOV      BX,[BP].Array_seg       ;get location to segment
               MOV      DS,[BX]                 ;address of basics save area

               CALL     Get_set                 ;set up transfer conditions

               PUSH     ES                      ;exchange es and ds registers
               PUSH     DS                      ;since we are moving data

               POP      ES                      ;from screen to array
               POP      DS                      ;

               XCHG     SI,DI                   ;exchange indexes too

               CALL     Go                      ;do transfer

               Basic_cleanup                    ;prepare to return to basic

               RET      8                       ;go past 4 integer parameters
Savescrn       ENDP

;
Restscrn       PROC     FAR
               Basic_setup                      ;save for basic

               MOV      BX,[BP].Return_code
               MOV      WORD PTR [BX],0

               MOV      BX,[BP].Array_off       ;get offset address of basica
               MOV      SI,[BX]                 ;save area

               MOV      BX,[BP].Array_seg       ;get data segement address of
               MOV      DS,[BX]                 ;basics save area

               CALL     Get_set                 ;set up transfer conditions

               CALL     Go                      ;do transfer

               Basic_cleanup                    ;prepare to return to basic

               RET      8                       ;go past 4 integer parameter
Restscrn       ENDP

;
Get_set        PROC     NEAR
               XOR      DI,DI                   ;point di to 0(zero) offset to an area

               MOV      CX,2000D                ;number of words (4096) bytes to move

               MOV      BX,Bios_data            ;
               MOV      ES,BX                   ;point to bios data block

               MOV      DX,ES:Addr_6845         ;set up dx to base of 6845
               ADD      DX,6                    ;set it up for status port

               MOV      AX,0B800H               ;assume it is a color card segment address

               MOV      BX,ES:Equip_flag        ;test to see if it is a cga card installed

               AND      BX,30H                  ;mask out all but the correct bits
               CMP      BX,30H                  ;
               JNE      Ok                      ;ok it is color

               MOV      AX,0B000H               ;no, it's monochrome adapter installed
OK:
               MOV      ES,AX                   ;set up correct segment address of video adapter

               RET
Get_set        ENDP

;
Go             PROC     NEAR
               CLD                              ;do a forward move
               MOV      AX,[BP].Retrace         ;get snowtest parameter
               CMP      AX,1                    ;is it ok for no snow?
               JZ       Notest                  ;yes, do fast transfer

TESTCARD:
               MOV      BX,ES                   ;test destination
               CMP      BX,0B000H               ;is it monochrome?
               JZ       Notest                  ;yes, do fast transfer
AGAIN:
               MOV      BX,DS                   ;test source
               CMP      BX,0B000H               ;same here except for screen
               JZ       Notest                  ;restore

; if all above tests fail, card must be an IBM CGA  and must test for snow

IBMCGA:
               CLI                              ;disable interrupts
TEST_LO:
               IN       AL,DX                   ;test horizontal retrace
               JMP      SHORT $+2
               SHR      AL,1                    ;wait 'til it's low
               JC       Test_lo
TEST_HI:
               IN       AL,DX                   ;now test 'til it's high
               JMP      SHORT $+2
               SHR      AL,1
               JNC      Test_hi

               MOVSW                            ;ok now to move char and attr

               STI                              ;restore interrupts

               LOOP     Ibmcga                  ;do 2000 times for full screen

               RET

NOTEST:
               MOVSW                            ;move character and attribute
               LOOP     Notest                  ;do 2000 times

               RET
Go             ENDP

Code           ENDS
               END
