;
;TITLE: MOUSE.ASM    JUNE 1, 1990

Mouse          EQU      33H
Cursor_on      EQU      0001
Cursor_off     EQU      0002
False          EQU      0
True           EQU      NOT False
Pressed        EQU      True
Not_pressed    EQU      False

Basic_setup    MACRO
               PUSH     BP
               MOV      BP,SP

               PUSH     AX
               PUSH     BX
               PUSH     CX
               PUSH     DX

               PUSH     SI
               PUSH     DI
               PUSH     DS
               PUSH     ES
               ENDM

Basic_cleanup  MACRO
               CLD
               POP      ES
               POP      DS
               POP      DI
               POP      SI
               POP      DX
               POP      CX
               POP      BX
               POP      AX
               POP      BP
               ENDM

;
;CODE          SEGMENT BYTE PUBLIC 'CODE'
;              ASSUME CS:CODE

                Dosseg                          ;requires masm 5.0 or higher
               .Model Medium

;       Define all publicly accessible routines.
               PUBLIC   Mmcheck
               PUBLIC   Mmcursoron
               PUBLIC   Mmcursoroff
               PUBLIC   Mmclick
               PUBLIC   Mmbuttonpress
               PUBLIC   Mmbuttonrelease
               PUBLIC   Mmbutton
               PUBLIC   Mmgetloc
               PUBLIC   Mmgetlocinfo
               PUBLIC   Mmsetloc
               PUBLIC   Mmsetrange

               .Code

;
;
;******************************************************************************
;*      THIS CALL MUST BE MADE BEFORE ANY OTHER MOUSE CALLS WILL FUNCTION     *
;******************************************************************************
;
; BASIC: CALL MMCHECK(MOUSE%)
;
; FUNCTION=0
;
;          CHECK FOR AN INSTALLED MOUSE, RESET THE MOUSE, INITIALIZE ALL MOTION
;          COUNTERS AND SET MOUSE TO CENTER POSITION.
;
;        ENTRY PARAMETERS:
;                         AH=0    (INITIALIZE/RESET MOUSE)
;
;        EXIT PARAMETERS :
;
;                         AX = 0  IF NO MOUSE INSTALLED
;                         BX = NUMBER OF BUTTONS ON THE MOUSE
;
;
Mmcheck        PROC     FAR

               Basic_setup

               XOR      AX,AX                   ;point to memory segment 0
               MOV      ES,AX

               XOR      BX,BX

               MOV      SI,Mouse*4H             ;calculate mouse interrupt offset

               CMP      AX,ES:[SI+2]            ;has a mouse handler been installed
               JNZ      _mouse_initialize

               CMP      AX,ES:[SI]
               JZ       _mouse_not_found        ;segment:offset was all zeros (no mouse driver)

_MOUSE_INITIALIZE:
               INT      Mouse

               OR       AX,AX                   ;was a mouse found?
               JNZ      _mouse_found            ;yes!

_MOUSE_NOT_FOUND:
               MOV      BX,0                    ;indicate mouse not found
_MOUSE_FOUND:
               MOV      SI,[BP+6]               ;return the number of mouse buttons
               MOV      [SI],BX

               MOV      CS:_mouse,BX            ;save the number of mouse buttons found

               Basic_cleanup

MMCHECK_EXIT:
               RET      2D

Mmcheck        ENDP

;
;
;
; BASIC: CALL MMCURSORON
;
; FUNCTION=1
;
;        IF THE CURSOR IS OFF,THE CURSOR WILL STILL FOLLOW THE MOUSES
;        MOVEMENTS, BUT THE CURSOR WILL NOT BE SEEN UNTIL TURNED ON.
;
;        ENTRY PARAMETERS:
;
;                         AH=1    (TURN MOUSE CURSOR ON)
;
;        EXIT PARAMETERS :
;
;
Mmcursoron     PROC     FAR
               CMP      CS:_mouse,0             ;is a mouse installed and initialized
               JZ       Mmcursoron_exit         ;no

               Basic_setup

               MOV      AX,Cursor_on
               MOV      AX,0001H
               INT      Mouse

               Basic_cleanup

MMCURSORON_EXIT:
               RET

Mmcursoron     ENDP

;
;
; BASIC: CALL MMCURSOROFF
;
; FUNCTION=2
;
;        HIDE THE DISPLAY CURSOR. THE CURSOR WILL STILL FOLLOW THE MOUSES
;        MOVEMENTS, BUT THE CURSOR WILL NOT BE SEEN.
;
;        ENTRY PARAMETERS:
;
;                         AH=2    (TURN MOUSE CURSOR OFF)
;
;        EXIT PARAMETERS :
;
;
;
Mmcursoroff    PROC     FAR
               CMP      CS:_mouse,0             ;is a mouse installed and initialized
               JZ       Mmcursoroff_exit        ;no

               Basic_setup

               MOV      AX,Cursor_off
               MOV      AX,0002H
               INT      Mouse

               Basic_cleanup

MMCURSOROFF_EXIT:
               RET

Mmcursoroff    ENDP


;
;
; BASIC: CALL MMGETLOC(COL%,ROW%)
;
; FUNCTION=3
;
;        ENTRY PARAMETERS:
;
;                         AH=3    (GET CURRENT MOUSE CURSOR LOCATION)
;
;        EXIT PARAMETERS :
;
;                         BX = BUTTON STATUS FOR ALL BUTTONS (BIT SET=PRESSED)
;                         CX = X COORDINATE
;                         DX = Y COORDINATE
;
;
;        NOTE: THE 'X' CO-ORDINATE IS A VALUE FROM 0-639 (COLUMN) AND THE
;             'Y' CO-ORDINATE (ROW) IS A VALUE FROM 0-199. TO 'NORMALIZE'
;             THE CO-ORDINATE VALUES FOR A 80X25 TEXT SCREEN, DIVIDE EACH
;             VALUE BY 8. IF YOU ARE IN LOW RES GRAPHICS , DIVIDE BY 2.
;             IF YOU ARE IN HIGH RES GRAPHICS , THE VALUES ARE FINE.
;
;        NOTE: THE BUTTON STATUS WORD RETURNS THE PRESSED STATUS FOR ALL
;             BUTTONS. EACH BIT IN THE WORD CORRESPONDS TO ONE BUTTON:
;             (BIT 0=1ST BUTTON, BIT 1=SECOND BUTTON..ETC).
;             IF A BIT IS SET (1)  THEN ITS ASSOCIATED BUTTON IS CURRENTLY
;             PRESSED DOWN.
;
Mmgetloc       PROC     FAR
               CMP      CS:_mouse,0             ;is a mouse installed and initialized
               JZ       Mmgetloc_exit           ;no

               Basic_setup

               MOV      AX,0003H
               INT      Mouse

               MOV      SI,[BP+8]               ;return the 'x' co-ordinate  (column)
               MOV      [SI],CX

               MOV      SI,[BP+6]               ;return the 'y' coordinate   (row)
               MOV      [SI],DX

               Basic_cleanup

MMGETLOC_EXIT:
               RET      4D

Mmgetloc       ENDP

;
;
; BASIC: CALL MMGETLOCINFO(BUTTONS%,COL%,ROW%)
;
; FUNCTION=3
;
;        ENTRY PARAMETERS:
;
;                         AH=3    (GET CURRENT MOUSE CURSOR LOCATION)
;
;        EXIT PARAMETERS :
;
;                         BX = BUTTON STATUS FOR ALL BUTTONS (BIT SET=PRESSED)
;                         CX = X COORDINATE
;                         DX = Y COORDINATE
;
;
;        NOTE: THE 'X' CO-ORDINATE IS A VALUE FROM 0-639 (COLUMN) AND THE
;             'Y' CO-ORDINATE (ROW) IS A VALUE FROM 0-199. TO 'NORMALIZE'
;             THE CO-ORDINATE VALUES FOR A 80X25 TEXT SCREEN, DIVIDE EACH
;             VALUE BY 8. IF YOU ARE IN LOW RES GRAPHICS , DIVIDE BY 2.
;             IF YOU ARE IN HIGH RES GRAPHICS , THE VALUES ARE FINE.
;
;        NOTE: THE BUTTON STATUS WORD RETURNS THE PRESSED STATUS FOR ALL
;             BUTTONS. EACH BIT IN THE WORD CORRESPONDS TO ONE BUTTON:
;             (BIT 0=1ST BUTTON, BIT 1=SECOND BUTTON..ETC).
;             IF A BIT IS SET (1)  THEN ITS ASSOCIATED BUTTON IS CURRENTLY
;             PRESSED DOWN.
;
;
Mmgetlocinfo   PROC     FAR
               CMP      CS:_mouse,0             ;is a mouse installed and initialized
               JZ       Mmgetlocinfo_exit       ;no

               Basic_setup

               MOV      AX,0003H
               INT      Mouse

               MOV      SI,[BP+0AH]             ;return the buttons pressed status
               MOV      [SI],BX

               MOV      SI,[BP+08H]             ;return the 'x' co-ordinate  (column)
               MOV      [SI],CX

               MOV      SI,[BP+6H]              ;return the 'y' coordinate   (row)
               MOV      [SI],DX


               Basic_cleanup

MMGETLOCINFO_EXIT:
               RET      6D

Mmgetlocinfo   ENDP

;
;
;
; BASIC: CALL MMSETLOC(COL%,ROW%)
;
; FUNCTION=4
;
;        ENTRY PARAMETERS:
;
;                         AH=4    (SET CURRENT MOUSE CURSOR LOCATION)
;                         CX = X COORDINATE
;                         DX = Y COORDINATE
;
;        EXIT PARAMETERS :
;
;                         BX = BUTTON STATUS FOR ALL BUTTONS (BIT SET=PRESSED)
;                         CX = X COORDINATE
;                         DX = Y COORDINATE
;
;
;        NOTE: THE 'X' CO-ORDINATE IS A VALUE FROM 0-639 (COLUMN) AND THE
;             'Y' CO-ORDINATE (ROW) IS A VALUE FROM 0-199. TO 'NORMALIZE'
;             THE CO-ORDINATE VALUES FOR A 80X25 TEXT SCREEN, DIVIDE EACH
;             VALUE BY 8. IF YOU ARE IN LOW RES GRAPHICS , DIVIDE BY 2.
;             IF YOU ARE IN HIGH RES GRAPHICS , THE VALUES ARE FINE.
;
;        NOTE: THE BUTTON STATUS WORD RETURNS THE PRESSED STATUS FOR ALL
;             BUTTONS. EACH BIT IN THE WORD CORRESPONDS TO ONE BUTTON:
;             (BIT 0=1ST BUTTON, BIT 1=SECOND BUTTON..ETC).
;            IF A BIT IS SET (1)  THEN ITS ASSOCIATED BUTTON IS CURRENTLY
;             PRESSED DOWN.
;
Mmsetloc       PROC     FAR
               CMP      CS:_mouse,0             ;is a mouse installed and initialized
               JZ       Mmsetloc_exit           ;no

               Basic_setup

               MOV      SI,[BP+8]               ;get the 'x' co-ordinate (column) to set
               MOV      CX,[SI]

               MOV      SI,[BP+6]               ;get the 'y' co-ordinate (row) to set
               MOV      DX,[SI]

               MOV      AX,0004H
               INT      Mouse

               Basic_cleanup

MMSETLOC_EXIT:
               RET      4D

Mmsetloc       ENDP

;
;
; BASIC: CALL MMCLICK(LEFT.BUTTON%,RIGHT.BUTTON%)
;
; FUNCTION=5
;
;        ENTRY PARAMETERS:
;
;                         AH=5    (GET BUTTON PRESS INFO)
;                         AL=O-?  (BUTTON NUMBER TO GET INFO FOR)
;
;        EXIT PARAMETERS :
;
;                         AX = BUTTON STATUS FOR ALL BUTTONS (BIT SET=PRESSED)
;                         BX = NUMBER OF PRESSES FOR THIS BUTTON SINCE LAST CALL
;                              (0=32768)
;                         CX = X COORDINATE AT LAST PRESS TIME
;                         DX = Y COORDINATE AT LAST PRESS TIME
;
;        NOTE: THE BUTTON STATUS WORD RETURNS THE PRESS/RELEASE STATUS FOR ALL
;             BUTTONS. EACH BIT IN THE WORD CORRESPONDS TO ONE BUTTON:
;             (BIT 0=1ST BUTTON, BIT 1=SECOND BUTTON..ETC).
;             IF A BIT IS SET (1)  THENS ITS ASSOCIATED BUTTON IS CURRENTLY
;             PRESSED DOWN.
;
;              FUNCTION 5 DOES NOT DOESN'T DETECT OVERFLOW.
;
;              THE PRESS COUNT IS RESET TO ZERO(0) AFTER EACH CALL.
;
;              THE VALUES OF THE HORIZONTAL AND VERTICAL COORDINATES ARE IN
;             IN THE RANGES DEFINED BY THE VIRTUAL SCREEN. THESE VALUES
;             REPRESENT THE CURSOR POSITION WHEN YOU LAST PRESSED THE BUTTON,
;             NOT THE CURSOR/S CURRENT POSITION.
;
Mmclick        PROC     FAR
               CMP      CS:_mouse,0             ;is a mouse installed and initialized
               JZ       Mmclick_exit            ;no

               Basic_setup

               MOV      BX,0000H                ;get release info for button 1 (left)
               MOV      AX,0005H
               INT      Mouse

               MOV      SI,[BP+8]               ;pass back number of releases for this button
               MOV      [SI],BX

               MOV      BX,0001H                ;get release info for button 2 (right)
               MOV      AX,0005H
               INT      Mouse

               MOV      SI,[BP+6]               ;pass back number of releases for this button
               MOV      [SI],BX

               Basic_cleanup

MMCLICK_EXIT:
               RET      4D

Mmclick        ENDP

;
;
; FUNCTION=5
;
; BASIC: CALL MMButtonPress(MMButton%,_
;                           MMButton.status%,_
;                           MMButton.presses%,_
;                           MMPress.xord%,_
;                           MMPress.yord%)
;        ENTRY PARAMETERS:
;
;                         AH=5    (GET BUTTON PRESS INFO)
;                         AL=O-?  (BUTTON NUMBER TO GET INFO FOR)
;
;        EXIT PARAMETERS :
;
;                         AX = BUTTON STATUS FOR ALL BUTTONS (BIT SET=PRESSED)
;                         BX = NUMBER OF PRESSES FOR THIS BUTTON SINCE LAST
;                              CALL (0-65535)
;                         CX = X COORDINATE AT LAST PRESS TIME
;                         DX = Y COORDINATE AT LAST PRESS TIME
;
;        NOTE: THE BUTTON STATUS WORD RETURNS THE CURRENT PRESSED/RELEASED
;             STATUS FOR ALL BUTTONS. EACH BIT IN THE WORD CORRESPONDS TO
;             ONE BUTTON: (BIT 0=1ST BUTTON, BIT 1=SECOND BUTTON..ETC).
;              IF A BIT IS SET (1)  THENS ITS ASSOCIATED BUTTON IS CURRENTLY
;             PRESSED DOWN.
;
;              FUNCTION 5 DOES NOT DOESN'T DETECT OVERFLOW.
;
;              THE PRESS COUNT IS RESET TO ZERO(0) AFTER EACH CALL.
;
;              THE VALUES OF THE HORIZONTAL AND VERTICAL COORDINATES ARE IN
;             IN THE RANGES DEFINED BY THE VIRTUAL SCREEN. THESE VALUES
;             REPRESENT THE CURSOR POSITION WHEN YOU LAST PRESSED THE BUTTON,
;             NOT THE CURSOR'S CURRENT POSITION.
;
Mmbuttonpress  PROC     FAR
               Basic_setup

               XOR      AX,AX                   ;setup in case mouse not installed
               XOR      BX,BX
               XOR      CX,CX
               XOR      DX,DX

               CMP      CS:_mouse,0             ;is a mouse installed and initialized
               JZ       Mmbuttonpress_exit      ;no

               MOV      SI,[BP+0EH]             ;get the mouse button that you want checked
               MOV      BX,[SI]

               MOV      AX,0005H
               INT      Mouse

MMBUTTONPRESS_EXIT:
               MOV      SI,[BP+0CH]             ;button status for all buttons
               MOV      [SI],AX

               MOV      SI,[BP+0AH]             ;number of releases for this button
               MOV      [SI],BX

               MOV      SI,[BP+08H]             ;x coordinate at last press time
               MOV      [SI],CX

               MOV      SI,[BP+06H]             ;y coordinate at last press time
               MOV      [SI],DX


               Basic_cleanup

               RET      10D

Mmbuttonpress  ENDP

;
;
; FUNCTION=6
;
; BASIC: CALL MMButtonRelease(MMButton%,_
;                             MMButton.status%,_
;                             MMButton.releases%,_
;                             MMPress.xord%,_
;                             MMPress.yord%)
;        ENTRY PARAMETERS:
;
;                         AH=6    (GET BUTTON RELEASE INFO)
;                         AL=O-?  (BUTTON NUMBER TO GET INFO FOR)
;
;        EXIT PARAMETERS :
;
;                         AX = BUTTON STATUS FOR ALL BUTTONS (BIT SET=PRESSED)
;                         BX = NUMBER OF RELEASES FOR THIS BUTTON SINCE LAST
;                              CALL (0-65535)
;                         CX = X COORDINATE AT LAST RELEASE TIME
;                         DX = Y COORDINATE AT LAST RELEASE TIME
;
;        NOTE: THE BUTTON STATUS WORD RETURNS THE CURRENT PRESS/RELEASE STATUS
;             FOR ALL BUTTONS. EACH BIT IN THE WORD CORRESPONDS TO ONE BUTTON:
;             (BIT 0=1ST BUTTON, BIT 1=SECOND BUTTON..ETC).
;              IF A BIT IS SET (1)  THENS ITS ASSOCIATED BUTTON IS CURRENTLY
;             PRESSED DOWN.
;
;              FUNCTION 6 DOES NOT DOESN'T DETECT OVERFLOW.
;
;              THE RELEASE COUNT IS RESET TO ZERO(0) AFTER EACH CALL.
;
;              THE VALUES OF THE HORIZONTAL AND VERTICAL COORDINATES ARE IN
;             IN THE RANGES DEFINED BY THE VIRTUAL SCREEN. THESE VALUES
;             REPRESENT THE CURSOR POSITION WHEN YOU LAST RELEASED THE BUTTON,
;             NOT THE CURSOR'S CURRENT POSITION.
;
Mmbuttonrelease PROC FAR
               Basic_setup

               XOR      AX,AX                   ;setup in case mouse not installed
               XOR      BX,BX
               XOR      CX,CX
               XOR      DX,DX

               CMP      CS:_mouse,0             ;is a mouse installed and initialized
               JZ       Mmbuttonrelease_exit    ;no

               MOV      SI,[BP+0EH]             ;get the mouse button that you want checked
               MOV      BX,[SI]

               MOV      AX,0006H
               INT      Mouse

MMBUTTONRELEASE_EXIT:
               MOV      SI,[BP+0CH]             ;button status for all buttons
               MOV      [SI],AX

               MOV      SI,[BP+0AH]             ;number of releases for this button
               MOV      [SI],BX

               MOV      SI,[BP+08H]             ;x coordinate at last release time
               MOV      [SI],CX

               MOV      SI,[BP+06H]             ;y coordinate at last release time
               MOV      [SI],DX

               Basic_cleanup

               RET      10D

Mmbuttonrelease ENDP

;
;
;
; BASIC: CALL MMBUTTON(LEFT.BUTTON%,RIGHT.BUTTON%)
;
; FUNCTION=6
;
;        ENTRY PARAMETERS:
;
;                         AH=6    (GET BUTTON RELEASE INFO)
;                         AL=O-?  (BUTTON NUMBER TO GET INFO FOR)
;
;        EXIT PARAMETERS :
;
;                         AX = BUTTON STATUS FOR ALL BUTTONS (BIT SET=PRESSED)
;                         BX = NUMBER OF RELEASE FOR THIS BUTTON
;                              (0=32768)
;                         CX = X COORDINATE AT LAST RELEASE TIME
;                         DX = Y COORDINATE AT LAST RELEASE TIME
;
;        NOTE: THE BUTTON STATUS WORD RETURNS THE PRESSED STATUS FOR ALL
;             BUTTONS. EACH BIT IN THE WORD CORRESPONDS TO ONE BUTTON:
;             (BIT 0=1ST BUTTON, BIT 1=SECOND BUTTON..ETC).
;             IF A BIT IS SET (1)  THENS ITS ASSOCIATED BUTTON IS CURRENTLY
;             PRESSED DOWN.
;
;              FUNCTION 6 DOES NOT DOESN'T DETECT OVERFLOW.
;
;              THE RELEASE COUNT IS RESET TO ZERO(0) AFTER EACH CALL.
;
;              THE VALUES OF THE HORIZONTAL AND VERTICAL COORDINATES ARE IN
;             IN THE RANGES DEFINED BY THE VIRTUAL SCREEN. THESE VALUES
;             REPRESENT THE CURSOR POSITION WHEN YOU LAST RELEASED THE BUTTON,
;             NOT THE CURSOR'S CURRENT POSITION.
;

Mmbutton       PROC     FAR
               CMP      CS:_mouse,0             ;is a mouse installed and initialized
               JZ       Mmbutton_exit           ;no

               Basic_setup


               XOR      BX,BX                   ;


               MOV      AX,0006                 ;check which buttons have been released
               INT      Mouse

               MOV      BX,Not_pressed          ;assume "false" (not pressed) for button 1

               SHR      AX,1                    ;button 1 (left pressed) ?
               JNB      Mmbutton_1              ;no,

               MOV      BX,Pressed              ;"true" (pressed)
MMBUTTON_1:
               MOV      SI,[BP+8]               ;return button 1 (left) pressed/released state
               MOV      [SI],BX

               MOV      BX,Not_pressed          ;assume "false" (not pressed) for button 2

               SHR      AX,1                    ;button 2 (right) pressed?
               JNB      Mmbutton_2              ;no

               MOV      BX,Pressed              ;"true" (pressed)
MMBUTTON_2:
               MOV      SI,[BP+6]               ;return button 2 (right) pressed/released state
               MOV      [SI],BX

               Basic_cleanup

MMBUTTON_EXIT:
               RET      4D
Mmbutton       ENDP

;
;
; BASIC: CALL MMSETRANGE(LFTCOL%,TOPROW%,RGTCOL%,BOTROW%)
;
; FUNCTION=7 & 8
;
;        SET THE MINIMUM AND MAXIMUM VALUES FOR THE MOUSE'S 'X' AND 'Y'
;        AXIS AND ALSO SET THE GAIN VALUE FOR THE MOUSE.
;
;        ENTRY PARAMETERS:
;
;                         AH=7    (SET THE MOUSES X AND Y AXIS)
;                         CX = MINIMUM 'X' COORDINATE (UPPER LEFT COLUMN)
;                         DX = MINIMUM 'Y' COORDINATE (UPPER LEFT ROW)
;
;                         AH=8    (SET THE MOUSES X AND Y AXIS)
;                         CX = MAXIMUM 'X' COORDINATE (LOWER RIGHT COLUMN)
;                         DX = MAXIMUM 'Y' COORDINATE (LOWER RIGHT ROW)
;
;                         BX = MOUSE GAIN VALUE (0-255)
;
;        EXIT PARAMETERS :
;
;
;
;        NOTE: THE 'X' CO-ORDINATE IS A VALUE FROM 0-639 (COLUMN) AND THE
;             'Y' CO-ORDINATE (ROW) IS A VALUE FROM 0-199. TO 'NORMALIZE'
;             THE CO-ORDINATE VALUES FOR A 80X25 TEXT SCREEN, DIVIDE EACH
;             VALUE BY 8. IF YOU ARE IN LOW RES GRAPHICS , DIVIDE BY 2.
;             IF YOU ARE IN HIGH RES GRAPHICS , THE VALUES ARE FINE.
;
;
;        NOTE: IF A LARGE GAIN VALUE IS USED, VERY LITTLE MOVEMENT OF THE
;              MOUSE CAUSES A LARGE 'X' OR 'Y' CHANGE.
;
Mmsetrange     PROC     FAR
               CMP      CS:_mouse,0             ;is a mouse installed and initialized
               JZ       Mmsetrange_exit         ;no

               Basic_setup

;SET HORIZONTAL (X)
               MOV      SI,[BP+0CH]             ;get upper left column co-ordinate - "x"
               MOV      CX,[SI]
               MOV      SI,[BP+08H]             ;get bottom right column co-ordinate - "x"
               MOV      DX,[SI]

               MOV      AX,0007H                ;set horizonmtal (x)
               INT      Mouse

;SET VERTICLE (Y)
               MOV      SI,[BP+0AH]             ;get upper left row co-ordinate - "y"
               MOV      CX,[SI]
               MOV      SI,[BP+06H]             ;get bottom right row co-ordinate - "y"
               MOV      DX,[SI]

               MOV      AX,0008H                ;set verticle (y)
               INT      Mouse

;SET THE GAIN VALUE
;             MOV     SI,[BP+0EH]               ;GET THE GAIN VALUE
;             MOV     BX,[SI]

;             MOV     AX,000FH                  ;SET THE GAIN VALUE
;             INT     MOUSE

               Basic_cleanup

MMSETRANGE_EXIT:
;             RET     10d                       ;IF MOUSE GAIN IMPLEMENTED
               RET      8D

Mmsetrange     ENDP


_mouse         DW       0

;CODE         ENDS
               END
