;
;Title:DIR.ASM          JUNE 1, 1990

Basic_setup    MACRO
               PUSH     BP
               MOV      BP,SP


               PUSH     AX
               PUSH     BX
               PUSH     CX
               PUSH     DX
               PUSH     SI
               PUSH     DI
               PUSH     DS
               PUSH     ES
               ENDM

Basic_cleanup  MACRO
               CLD
               POP      ES
               POP      DS
               POP      DI
               POP      SI
               POP      DX
               POP      CX
               POP      BX
               POP      AX

               POP      BP
               ENDM

Stk            STRUC
Bbp            DW       ?                       ;basic's bp
Retadd         DD       ?                       ;return address
Return_code    DW       ?
Count          DW       ?                       ;basic p3 = count of filenames
File$0         DW       ?                       ;basic p2 = output filenames
Path$          DW       ?                       ;basic p1 = pathname to search
Stk            ENDS

Strdes         STRUC                            ;basic string descriptor structure
Len            DW       ?                       ;word length of string
Strptr         DW       ?                       ;pointer to string space
Strdes         ENDS

;
Code           SEGMENT  BYTE PUBLIC 'CODE'
               ASSUME   CS:Code,DS:Code

               PUBLIC   Dir                     ;let link know about this one

Dir            PROC     FAR                     ;it's a far proc to basic

Basic_setup                                     ;save basic's bp

               MOV      CS:[Filcnt],0           ;initialize file count

               MOV      SI,Path$[BP]            ;get pointer to string descriptor
               MOV      CX,Len[SI]              ;cx = path length
               MOV      SI,Strptr[SI]           ;si -> path string data
               MOV      DI,OFFSET Path          ;di -> place to fill
               PUSH     CS                      ;make es point at our seg
               POP      ES                      ;
               REP      MOVS BYTE PTR [SI],BYTE PTR [DI]
               MOV      BYTE PTR ES:[DI],0      ;make sure it's an asciiz string

               MOV      DI,Count[BP]            ;get pointer to fill flag in di
               MOV      BX,[DI]                 ;bx = fill flag
               PUSH     DS                      ;save basic's ds
               PUSH     CS
               POP      DS                      ;address this segment
               MOV      BYTE PTR [Fillflg],0FFH ;assume we're filling the strings
               TEST     BX,08000H               ;negative?
               JZ       Fillem                  ;no, we *are* filling

               MOV      BYTE PTR[Fillflg],0     ;yes, indicate with flag
FILLEM:
               MOV      [Search_attr],BL        ;save attribute locally
               MOV      DI,File$0[BP]           ;di -> first string descriptor
               MOV      DI,SS:[DI]              ;di = first string descriptor address
               ADD      DI,2                    ;di -> first string data area

               PUSH     ES
               MOV      AH,2FH                  ;get basic's dta
               INT      21H
               MOV      [Dta_ofs],BX
               MOV      [Dta_seg],ES            ;and save it
               POP      ES                      ;restore es = ds = cs
               MOV      DX,OFFSET Dta           ;set dta to our area here
               MOV      AH,1AH
               INT      21H

               MOV      AH,4EH                  ;find first matching file
               XOR      CX,CX                   ;clear attribute
               MOV      CL,[Search_attr]        ;attribute from lobyte of count parm
               MOV      DX,OFFSET Path          ;ds:dx points to search path
               INT      21H
               JNC      Ok                      ;if error, cy set

               CMP      AX,18                   ;no files found?
               JZ       Exit                    ;yes, don't report error

               MOV      [Filcnt],0FFFFH         ;set count to -1 to report path error
               JMP      SHORT Exit              ;and leave

;
OK:
               PUSH     SS
               POP      ES                      ;es -> basic's ds
               INC      [Filcnt]                ;bump file counter for first find
               TEST     BYTE PTR [Fillflg],0FFH ;check "fill array" flag
               JZ       Findnext                ;zero, don't put first name in array

               CALL     Move_filename           ;do the move

FINDNEXT:
               MOV      AH,4FH                  ;find next function
               INT      21H                     ;do it
               JC       Exit                    ;if error, must be no more files

               INC      [Filcnt]                ;no error, we found another file
               TEST     BYTE PTR [Fillflg],0FFH ;are we moving string data?
               JZ       Findnext                ;loop if not

               CALL     Move_filename           ;move it

               JMP      SHORT Findnext          ;and keep hunting

EXIT:
               LDS      DX,DWORD PTR [Dta_ofs]  ;get basic's dta
               MOV      AH,1AH                  ;set dta fn.
               INT      21H
               MOV      DI,Count[BP]            ;di -> count parameter
               MOV      AX,CS:[Filcnt]          ;get file count

               POP      DS                      ;reset to basic's data seg

               MOV      [DI],AX                 ;put file count in count%
               MOV      BX,Return_code[BP]
               MOV      WORD PTR [BX],0

Basic_cleanup                                   ;restore basic's bp

               RET      8                       ;return and pop parameter pointers
Dir            ENDP

;
Move_filename  PROC     NEAR
;
;di points to string descriptor to fill with filename from DTA
;
               PUSH     CX

               PUSH     DI                      ;save pointer to descriptor length part

               MOV      DI,ES:[DI]              ;and point instead to string data
               PUSH     DI                      ;save

               MOV      SI,OFFSET Fname         ;si -> filename (asciiz)
MOVELOOP:
               LODS     BYTE PTR [SI]           ;get filename character
               OR       AL,AL                   ;is it 0? (end of string?)
               JZ       Done_name               ;yes, quit moving data

               STOS     BYTE PTR [DI]           ;no, store
               JMP      SHORT Moveloop          ;and continue
DONE_NAME:
               STOS     BYTE PTR [DI]

               POP      DI

               ADD      DI,13D

               MOV      SI,OFFSET Attrib
               MOV      CX,9D
               CLD

DONE_NAME_CONT:
               LODS     BYTE PTR [SI]           ;get filename character
               STOS     BYTE PTR [DI]           ;no, store
               LOOP     Done_name_cont          ;and continue

               POP      DI                      ;di -> length in s.d. again
               POP      CX

               ADD      DI,4                    ;move to next s.d. pointer

               RET
Move_filename  ENDP

;
Dta_ofs        DW       0                       ;save old dta for basic just in case
Dta_seg        DW       0
Fillflg        DB       0                       ;"fill array" flag
Search_attr    DB       0                       ;files' search attribute
Filcnt         DW       0                       ;count of files found
Path           DB       64 Dup (0)              ;search path, passed from basic

Dta            DB       21 Dup (0)              ;reserved area (used for findnext)
Attrib         DB       0                       ;attribute of file found
Time           DW       0                       ;time of last write
Date           DW       0                       ;date
Fsize          DD       0                       ;filesize (32 bit integer)
Fname          DB       13 Dup (0)              ;asciiz filename, no blanks-name.ext,00

Code           ENDS
               END
