;
;Title:Fastprt          JUNE 1, 1990

Basic_setup    MACRO
               PUSH     BP
               MOV      BP,SP

               PUSH     AX
               PUSH     BX
               PUSH     DX
               PUSH     CX
               PUSH     SI
               PUSH     DI
               PUSH     DS
               PUSH     ES
               ENDM

Basic_cleanup  MACRO
               CLD
               POP      ES
               POP      DS
               POP      DI
               POP      SI
               POP      DX
               POP      CX
               POP      BX
               POP      AX

               POP      BP
               ENDM

Bios_data      SEGMENT  At 40H                  ; set up labels to determine whether
               ORG      10H                     ; to display in color or monochrome
Equip_flag     LABEL    WORD
               ORG      4AH                     ; 40 or 80 column display
Crt_clms       LABEL    WORD
               ORG      63H
Addr_6845      LABEL    WORD                    ; pointer to video card ports
Bios_data      ENDS

Stack          STRUC
Bpsav          DW       ?                       ;saved by us
Retoff         DW       ?                       ;from callf
Retseg         DW       ?                       ;from basic
Return_code    DW       ?                       ;
Video_attr     DW       ?                       ;pointer to video attribute
Column         DW       ?                       ;pointer to screen column
Row            DW       ?                       ;pointer to screen row
String         DW       ?                       ;pointer to string descriptor
Stack          ENDS

;
Code           SEGMENT  BYTE PUBLIC 'CODE'
               ASSUME   CS:Code,DS:Code

               PUBLIC   Fastprt

Fastprt        PROC     FAR
Basic_setup                                     ; save bp for far return

               MOV      BX,[BP].Return_code
               MOV      WORD PTR [BX],0

               MOV      BX,[BP].Column          ; get addr of col% storage
               MOV      DI,[BX]                 ; get the column value
               DEC      DI                      ; adjust for locate format

               MOV      BX,[BP].Row             ; get addr of row% storage
               MOV      AX,[BX]                 ; get the row value
               DEC      AX                      ; adjust for locate format

               MOV      BX,[BP].String          ; set ptr to string descriptor
               MOV      CX,[BX]                 ; get length of string
               JCXZ     Exit                    ; done if null string

               MOV      SI,[BX+2]               ; si = first character of var$
               MOV      BX,Bios_data            ; set ready to determine video card
               MOV      ES,BX                   ; and number of columns
               MUL      ES:Crt_clms             ; ax = col% times words per line
               ADD      DI,AX                   ; di = words from start of screen
               SHL      DI,1                    ; shift for attribute byte

;       CX has the count of characters to write
;       SI points to the string to print
;       DI points to the starting screen position

               MOV      AX,0B000H               ;default to mono card
               MOV      BX,ES:Equip_flag
               AND      BX,30H
               CMP      BX,30H                  ; monochrome?
               JE       Mono                    ; jump if so

               MOV      AX,0B800H               ; set to color card
               MOV      DX,ES:Addr_6845         ; point to 6845 base port
               ADD      DX,6                    ; point to status port
               MOV      BX,[BP].Video_attr      ; get color attribute
               MOV      BX,[BX]
               MOV      ES,AX                   ; point es to video

               CALL     Print_string

               JMP      Exit

MONO:
               MOV      DX,ES:Addr_6845         ; point to 6845 base port
               ADD      DX,6                    ; point to status port
               MOV      BX,[BP].Video_attr      ; get color attribute
               MOV      BX,[BX]
               MOV      ES,AX                   ; point es to video

MOVESTR:
               MOVSB                            ; print a character
               MOV      ES:[DI],BL              ; move attribute
               INC      DI                      ; skip attribute byte
               LOOP     Movestr                 ; repeat until end of string
EXIT:
               Basic_cleanup

               RET      10
Fastprt        ENDP

;
Print_string   PROC     NEAR                    ; wait for horizontal retrace
               CLI                              ; turn off interrupts
TEST_LOW:
               IN       AL,DX                   ; get status
               JMP      SHORT $+2


               TEST     AL,1                    ; is it low?
               JNZ      Test_low                ; if not, try again
TEST_HI:
               IN       AL,DX                   ; get status
               JMP      SHORT $+2
               TEST     AL,1                    ; is it high?
               JZ       Test_hi                 ; if not, try again

               MOVSB                            ; print a character

               STI
               NOP
               CLI

TST_LOW2:
               IN       AL,DX                   ; get status
               JMP      SHORT $+2
               TEST     AL,1                    ; is it low?
               JNZ      Tst_low2                ; if not, try again
TST_HI2:
               IN       AL,DX                   ; get status
               JMP      SHORT $+2
               TEST     AL,1                    ; is it high?
               JZ       Tst_hi2                 ; if not, try again

               MOV      ES:[DI],BL              ; move attribute
               INC      DI                      ; skip attribute byte

               STI                              ; turn interrupts back on
               LOOP     Print_string            ; repeat until end of string

               RET                              ; return to the fastprt procedure
Print_string   ENDP

Code           ENDS
               END
