'
'=============================================================================
'                   DEMO OF BASWIND7 MODULES AND BWTOOLS
'                   ------------------------------------
'
'  MODULE : DEMO2.BAS
'
'  BY : James P. Morgan, 5226 Via Hacienda #115 Orlando FL, 32809  U.S.A.
'
'                      Version 7.0, June 1990
'                 (c) Copyright 1990 by J P Morgan
'=============================================================================

'
'The following CONST may be changed to demonstrate the support of the BASWIND
'module for the QuickBasic 4.5 "DIM" syntax: DIM Array( -x to +y)
'
'      CONST OPTION.BASE=-1                     'test of negative subscript

       CONST OPTION.BASE=1                      'effectively default to OPTION BASE 1

100:
       KEY OFF
       COLOR 7,1
       CLS

       RETURN.CODE%=0                           'with BASWIND7, most all moudule return a result code

'
' arrays dimensioned as OPTION BASE 0 (in DEMO2), BUT QB45 allows Plus OR MINUS
' subscripts when the array is dimensioned, for example:
'
' DIM Array( -10 TO 10)
'
' All BASWIND7 Sub-programs allow for QB45 array dimensioning syntax.
' HOWEVER, ALL Subprograms 'normalize' array element selection return values,
' as if the array had been passed as dimensioned OPTION BASE 1.
'
' This MUST be considered when using value returned for item that was selected
' from a window list. In other words , you are given a return value that says
' that the 'Nth' item in array was selected (ie UBOUND(Array)+(Nth.Element%-1)),
' NOT the actual subscript of the array element selected.

       YES=1
       NO=0

       DIM ITEM$    (option.base TO option.base+100)
       DIM TAG$     (option.base TO option.base+100)
       DIM MSGDAT$  (option.base TO option.base+5)
       DIM ITEMDESC$(option.base TO option.base+10)

       DIM MAXSIZE% (option.base TO option.base+15)
       DIM MAXITEMS%(option.base TO option.base+15)
       DIM ITEMS.ARRAY$(option.base TO option.base+5,option.base TO option.base+15)

REM    $DYNAMIC

       DIM SCRN%(4000)
       DIM TAGGED%(option.base TO option.base+100)

REM    $STATIC

'
       RANDOMIZE TIMER

       FILESIZE&=0&

       GOSUB INTRODUCTION

'
'---------------------------------------------------------------------------------
DEMO:
200:
'      ERASE ITEM$

       I&=FRE("")                               'force string cleanup (G.C.)

       COLOR 7,1
       CLS

       CALL MAKEWIND(5,5,22,55,2,0,7,1,1,"",RETURN.CODE%)

       COLOR 15,0
       LOCATE  5,5:PRINT "               ***    POPMENU   ***                ";
       COLOR 1,7

       LOCATE  7,5:PRINT " -This demo will be used to select the other demos-";
       LOCATE  9,5:PRINT "You will be presented with a number of items from  ";
       LOCATE 10,5:PRINT "which to select one. ALL selection items are shown.";

       GOSUB DISPLAY.HELP

       SECONDS!=3.0
       CALL WAITTIME(SECONDS!,RETURN.CODE%)

       COLOR 7,1

       ITEM.MIN=LBOUND(ITEM$)                   'demonstrate LBOUND

       FOR I=ITEM.MIN TO UBOUND(ITEM$)
           ITEM$(I)=""
       NEXT

       ITEM$(ITEM.MIN+0)= "  Popmenu"
       ITEM$(ITEM.MIN+1)= "  Poplist"
       ITEM$(ITEM.MIN+2)= "  Taglist"
       ITEM$(ITEM.MIN+3)= "  Popdir"
       ITEM$(ITEM.MIN+4)= "  Tagdir"
       ITEM$(ITEM.MIN+5)= "  Barmenu"
       ITEM$(ITEM.MIN+6)= "  Menu123"
       ITEM$(ITEM.MIN+7)= "  Calendar"
       ITEM$(ITEM.MIN+8)= "  Calendr3"
       ITEM$(ITEM.MIN+9)= "  Keycal"
       ITEM$(ITEM.MIN+10)="  Caution"
       ITEM$(ITEM.MIN+11)="  Question"
       ITEM$(ITEM.MIN+12)="  Warning"
       ITEM$(ITEM.MIN+13)="  end demo"

       SELECT.%=7                               'hi-lite the 7th item on the menu at start

       CALL POPMENU("Select Demo ...",14,ITEM$(),4,0,7,15,1,"2:61",0,SELECT.%,RETURN.CODE%)

'      ERASE ITEM$

       FOR I=ITEM.MIN TO UBOUND(ITEM$)
           ITEM$(I)=""
       NEXT
'
250:
       SELECT CASE SELECT.%
              CASE 1
                    GOTO DEMO
              CASE 2
                    GOSUB DOPOPL
              CASE 3
                    GOSUB DOTAGL
              CASE 4
                    GOSUB DOPOPD
              CASE 5
                    GOSUB DOTAGD
              CASE 6
                    GOSUB DOBAR
              CASE 7
                    GOSUB DO123
              CASE 8
                    GOSUB DOCAL
              CASE 9
                    GOSUB DOCAL3
              CASE 10
                    GOSUB DOKEY
              CASE 11
                    GOSUB DOCAU
              CASE 12
                    GOSUB DOQUE
              CASE 13
                    GOSUB DOWARN
              CASE 14
                    GOTO ENDIT
              CASE ELSE
                    GOTO DEMO
              END SELECT

       GOTO DEMO

'
'--------------------------------------------------------------------------------
DOPOPL:
300:
       CALL MAKEWIND(5,5,22,55,2,1,7,1,1,"",RETURN.CODE%)

       COLOR 15,0
       LOCATE  5,5:PRINT "               ***    POPLIST   ***                ";
       COLOR 1,7

       LOCATE  7,5:PRINT "You will be presented with a number of items from  ";
       LOCATE  8,5:PRINT "which to select one. If there are more items than  ";
       LOCATE  9,5:PRINT "will fit in the POPLIST window, you can scroll the ";
       LOCATE 10,5:PRINT "window to view the additional items.               ";

       SECONDS!=15.0
       CALL WAITTIME(SECONDS!,RETURN.CODE%)

       J=1
       FOR I=OPTION.BASE TO OPTION.BASE+100
           ITEM$(I)=SPACE$(18)
           TEMP$="  "+CHR$(J)+"- Item # "+STR$(J)
           MID$(ITEM$(I),1,LEN(TEMP$))=TEMP$
           J=J+1
       NEXT

       QUADRANT=0
       FOR QUADRANT=0 TO 4
           COLOR 7,1
           CLS

'
' hi-lite the following array element, when menu displayed
'
           SELECT CASE QUADRANT
                  CASE 0
                       SELECT.%=1
                  CASE 1
                       SELECT.%=43
                  CASE 2
                       SELECT.%=78
                  CASE 3
                       SELECT.%=95
                  CASE ELSE
                       SELECT.%=51
           END SELECT

           QUADRANT$=RIGHT$(STR$(QUADRANT),1)

           CALL POPLIST("Choose an Item ...",10,100,item$(),0,3,15,5,QUADRANT$,1,SELECT.%,RETURN.CODE%)

           LOCATE 25,10

           IF SELECT.%<1 THEN
               PRINT "The Item Number you selected was ";"NONE";"   ";"NO item selected";
           ELSE

'
' the windowing routines 'normalized' arrays to a pseudo OPTION BASE 1, so
' convert normalized 'select.%' back to ACTUAL array element,based off UBOUND
' for the array
'

               PRINT "The Item Number you selected was ";SELECT.%;"   ";ITEM$(LBOUND(ITEM$)+(SELECT.%-1));
           ENDIF

           SECONDS!=4.0!
           CALL WAITTIME(SECONDS!,RETURN.CODE%)

'          ERASE ITEM$
       NEXT

       RETURN

'
'------------------------------------------------------------------------------
DOTAGL:
400:
       CALL MAKEWIND(5,5,22,55,2,1,7,1,1,"",RETURN.CODE%)

       COLOR 15,0
       LOCATE  5,5:PRINT "               ***    TAGLIST   ***                ";
       COLOR 1,7

       LOCATE  7,5:PRINT "You will be presented with a number of items from  ";
       LOCATE  8,5:PRINT "which to select one or more. To select a group of  ";
       LOCATE  9,5:PRINT "items, 'tag' each one by pressing 'Ins' key next to";
       LOCATE 10,5:PRINT "the item. You may  'untag' an item by pressing the ";
       LOCATE 11,5:PRINT " 'Del' key. To select all taged items press Enter. ";
       LOCATE 13,5:PRINT "If there are more items than will fit in the window";
       LOCATE 14,5:PRINT "you can scroll the window to view the other items. ";

       SECONDS!=15.0
       CALL WAITTIME(SECONDS!,RETURN.CODE%)

       QUADRANT=0
'      FOR QUADRANT=0 TO 4
           COLOR 7,1
           CLS
410:
           J=1
           FOR i=OPTION.BASE TO OPTION.BASE+99
               ITEM$(I)=SPACE$(18)
               TAGGED%(I)=0
               TEMP$="  "+CHR$(J)+ "- Item # "+STR$(J)
               MID$(ITEM$(I),1,LEN(TEMP$))=TEMP$
               J=J+1
           NEXT

           NUMTAGGED%=5                                     'dont allow more than 5

           QUADRANT$=RIGHT$(STR$(QUADRANT),1)
           CALL TAGLIST("Tag or Untag",10,99,NUMTAGGED%,ITEM$(),TAGGED%(),5,0,0,7,QUADRANT$,0,RETURN.CODE%)

           LOCATE 2,3
           IF NUMTAGGED%<1 THEN
                PRINT "The 0 Items you tagged were: NONE "
              GOTO DOTAGL.CONT
           ELSE
                PRINT "The ";NUMTAGGED%;" Items you tagged were: "
           ENDIF

           LOCATE 4,5

475:
           FOR I=OPTION.BASE TO OPTION.BASE+99
               LOCATE ,5
               IF TAGGED%(I)=1 THEN PRINT ITEM$(I)
           NEXT

DOTAGL.CONT:
           SECONDS!=4.0!
           CALL WAITTIME(SECONDS!,RETURN.CODE%)

'          ERASE ITEM$
'          ERASE TAGGED%

'      NEXT

       RETURN

'
'-----------------------------------------------------------------------------
DOPOPD:
500:
       CALL MAKEWIND(5,5,22,55,2,1,7,1,1,"",RETURN.CODE%)

       COLOR 15,0
       LOCATE  5,5:PRINT "               ***    POPDIR    ***                ";
       COLOR 1,7

       LOCATE  7,5:PRINT "This is a special case of the POPLIST routine. Here";
       LOCATE  8,5:PRINT "items to be selected are from the directory of the ";
       LOCATE  9,5:PRINT "disk. You specify the filespec , may include the   ";
       LOCATE 10,5:PRINT "wildcard characters '?' and '*', and a directory   ";
       LOCATE 11,5:PRINT "search is performed on the filespec.               ";
       LOCATE 13,5:PRINT "If there are more items than will fit in the window";
       LOCATE 14,5:PRINT "you can scroll the window to view the other items. ";

       SECONDS!=15.0
       CALL WAITTIME(SECONDS!,RETURN.CODE%)

       QUADRANT=0
'      FOR QUADRANT=0 TO 4
           COLOR 7,1
           CLS
           INPUT "Enter File Spec: ";SEARCH$

           QUADRANT$=RIGHT$(STR$(QUADRANT),1)
           SELECTFILE$=""
           NUMFILES%=0
           CALL POPDIR(SEARCH$,10,0,7,5,7,QUADRANT$,1,NUMFILES%,SELECTFILE$,RETURN.CODE%)

550:
           LOCATE 25,30
           IF SELECTFILE$="" THEN
               PRINT "Returned Value is: (no file selected)";
           ELSE
               LOCATE 25,10
               GOSUB PRINT.FILENAME
           ENDIF

           SECONDS!=15.0!
           CALL WAITTIME(SECONDS!,RETURN.CODE%)

'      NEXT QUADRANT

       RETURN

'
'-----------------------------------------------------------------------------
DOTAGD:
600:
       CALL MAKEWIND(5,5,22,55,2,1,7,1,1,"",RETURN.CODE%)

       COLOR 15,0
       LOCATE  5,5:PRINT "               ***    TAGDIR    ***                ";
       COLOR 1,7

       LOCATE  7,5:PRINT "This is a special case of the POPDIR routine. Here ";
       LOCATE  8,5:PRINT "items to be selected are from the directory of the ";
       LOCATE  9,5:PRINT "disk. You specify the filespec , may include the   ";
       LOCATE 10,5:PRINT "wildcard characters '?' and '*', and a directory   ";
       LOCATE 11,5:PRINT "search is performed on the filespec.               ";
       LOCATE 13,5:PRINT "You will be presented with a number of items from  ";
       LOCATE 14,5:PRINT "which to select one or more. To select a group of  ";
       LOCATE 15,5:PRINT "items,  'tag'  each one by pressing 'Ins' key next ";
       LOCATE 16,5:PRINT "to the item. To  'untag' an item , you press the   ";
       LOCATE 17,5:PRINT " 'Del'  key. To select all taged items press Enter.";
       LOCATE 19,5:PRINT "This would be useful for FILE MANAGER type function";
       LOCATE 21,5:PRINT "If there are more items than will fit in the window";
       LOCATE 22,5:PRINT "you can scroll the window to view the other items. ";

       SECONDS!=15.0
       CALL WAITTIME(SECONDS!,RETURN.CODE%)

       QUADRANT=0
'      FOR QUADRANT=0 TO 4
           COLOR 7,1
           CLS
           INPUT "Enter File Spec: ";SEARCH$

           NUMTAGGED%=0

           QUADRANT$=RIGHT$(STR$(QUADRANT),1)
           CALL TAGDIR(SEARCH$,10,6,0,0,7,QUADRANT$,0,NUMTAGGED%,TAG$(),RETURN.CODE%)

650:
           LOCATE 2,3
           IF NUMTAGGED%<1 THEN
               PRINT "The 0 Items you tagged were: NONE "
           ELSE
               PRINT "The ";NUMTAGGED%;" Items you tagged were: "
           ENDIF

           LOCATE 4,5

'
'  should this be -1 after numtagged
'
           FOR I=OPTION.BASE TO OPTION.BASE+NUMTAGGED%
               LOCATE ,5
               ASCIIZ=INSTR(TAG$(I),CHR$(0))
               IF ASCIIZ>1 THEN
                   PRINT LEFT$(TAG$(I),ASCIIZ)
               ELSE
                   PRINT TAG$(i)
               ENDIF
           NEXT

           SECONDS!=15.0!
           CALL WAITTIME(SECONDS!,RETURN.CODE%)

'          ERASE TAG$

'      NEXT

       RETURN

'
'------------------------------------------------------------------------------
DOBAR:
700:
       CALL MAKEWIND(5,5,22,55,2,1,7,1,1,"",RETURN.CODE%)

       COLOR 15,0
       LOCATE  5,5:PRINT "               ***    BARMENU   ***                ";
       COLOR 1,7

       LOCATE  7,5:PRINT "This is similar to the user interface of QuickBasic";
       LOCATE  8,5:PRINT "2.0. A highlighted menu bar is display, consisting ";
       LOCATE  9,5:PRINT "of various options. When a menu option is selected ";
       LOCATE 10,5:PRINT "on the menu bar, a 'drop-down' menu of additional  ";
       LOCATE 11,5:PRINT "options is also displayed.                         ";

       SECONDS!=15.0
       CALL WAITTIME(SECONDS!,RETURN.CODE%)

       COLOR 7,1
       CLS

       X=1
       FOR I=OPTION.BASE TO OPTION.BASE+5
           Y=0
           FOR j=OPTION.BASE TO OPTION.BASE+10
               ITEMS.ARRAY$(I,J)=CHR$(Y+ASC("A"))+ "-Menu"+STR$(X)+" Item"+STR$(Y+1)+" "
               Y=Y+1
           NEXT

           X=X+1
       NEXT

       FOR I=OPTION.BASE TO OPTION.BASE+5
           MAXSIZE%(I)=15
           MAXITEMS%(I)=10
       NEXT

       MAXITEMS%(OPTION.BASE+0)=2
       MAXITEMS%(OPTION.BASE+1)=3
       MAXITEMS%(OPTION.BASE+2)=5
       MAXITEMS%(OPTION.BASE+3)=3
       MAXITEMS%(OPTION.BASE+4)=1

       MENULINE$="| MENU#1   | MENU#2    | MENU#3    | MENU#4    | MENU#5    |"
       CALL BARMENU(MENULINE$,0,7,12,5,MAXSIZE%(),MAXITEMS%(),ITEMS.ARRAY$(),MENUSLCT%,ITEMSLCT%,RETURN.CODE%)

750:
       LOCATE 25,20
       PRINT "Returned Value is MENU: ";MENUSLCT%;" ITEM: ";ITEMSLCT%;"   ";


       SECONDS!=4.0!
       CALL WAITTIME(SECONDS!,RETURN.CODE%)

'      ERASE MAXSIZE%
'      ERASE MAXITEMS%
'      ERASE ITEMS.ARRAY$

       RETURN

'
'-----------------------------------------------------------------------------
DO123:
800:
       CALL MAKEWIND(5,5,22,55,2,1,7,1,1,"",RETURN.CODE%)

       COLOR 15,0
       LOCATE  5,5:PRINT "               ***    MENU123   ***                ";
       COLOR 1,7

       LOCATE  7,5:PRINT "This is an imitation of the Lotus 1-2-3 user inter-";
       LOCATE  8,5:PRINT "face. A  menu bar of various options is display.   ";
       LOCATE  9,5:PRINT "On the line below the menu bar,a description of the";
       LOCATE 10,5:PRINT "function of the currently highlighted option select";
       LOCATE 11,5:PRINT "-ed is also displayed.                             ";

       SECONDS!=15.0
       CALL WAITTIME(SECONDS!,RETURN.CODE%)

       COLOR 7,1
       CLS

       MENULINE$="Format Copy Rename Delete Erase Move Discard Pop Push BigBadBillybob"
       MENUFG%=7
       MENUBG%=1
       ITEMNUM%=10

       J=1
       FOR I=OPTION.BASE TO OPTION.BASE+ITEMNUM%
         ITEMDESC$(I)="This is Menu Item Number"+STR$(J)
         J=J+1
       NEXT

       LOCATE 3,1
       PRINT STRING$(80,205)

       ITEMSLCT%=0

       CALL MENU123(MENULINE$,1,MENUFG%,MENUBG%,ITEMNUM%,ITEMDESC$(),ITEMSLCT%,RETURN.CODE%)

850:
       LOCATE  25,20
       PRINT "ITEM SELECTED WAS: ";ITEMSLCT%;

       SECONDS!=4.0!
       CALL WAITTIME(SECONDS!,RETURN.CODE%)

'      ERASE ITEMDESC$

       RETURN

'
'-----------------------------------------------------------------------------
DOCAL:
900:
       CALL MAKEWIND(5,5,22,55,2,1,7,1,1,"",RETURN.CODE%)
       COLOR 15,0
       LOCATE  5,5:PRINT "               ***   CALENDAR   ***                ";
       COLOR 1,7

       LOCATE  7,5:PRINT "This routine displays a calendar in a window, for a";
       LOCATE  8,5:PRINT "given month and year.                              ";

       SECONDS!=8.0
       CALL WAITTIME(SECONDS!,RETURN.CODE%)
       QUADRANT=0
'      FOR QUADRANT=0 TO 4
           COLOR 7,1
           CLS
           INPUT "Month (1-12)",MONTH%
           INPUT "Year (4 digit)",YEAR%

           QUADRANT$=RIGHT$(STR$(QUADRANT),1)
           CALL CALENDAR(MONTH%,YEAR%,QUADRANT$,0,7,1,RETURN.CODE%)

950:
           SECONDS!=4.0!
           CALL WAITTIME(SECONDS!,RETURN.CODE%)

'          NEXT QUADRANT

       RETURN

'
'------------------------------------------------------------------------------
DOCAL3:
1000:
       CALL MAKEWIND(5,5,22,55,2,1,7,1,1,"",RETURN.CODE%)

       COLOR 15,0
       LOCATE  5,5:PRINT "               ***   CALENDR3   ***                ";
       COLOR 1,7

       LOCATE  7,5:PRINT "This routine displays a calendar in a window, for a";
       LOCATE  8,5:PRINT "given month and year. In addition, the calendars   ";
       LOCATE  9,5:PRINT "for the previous and following month is displayed. ";

       SECONDS!=10.0
       CALL WAITTIME(SECONDS!,RETURN.CODE%)

       COLOR 7,1
       CLS
       INPUT "Month (1-12)",month%
       INPUT "Year (4 digit)",year%

       CALL CALENDR3(MONTH%,YEAR%,12,0,7,1,RETURN.CODE%)

1050:
       SECONDS!=20.0!
       CALL WAITTIME(SECONDS!,RETURN.CODE%)
       RETURN

'
'----------------------------------------------------------------------------
DOKEY:
1100:
       CALL MAKEWIND(5,5,22,55,2,1,7,1,1,"",RETURN.CODE%)

       COLOR 15,0
       LOCATE  5,5:PRINT "               ***     KEYCAL   ***                ";
       COLOR 1,7

       LOCATE  7,5:PRINT "This routine displays a calendar in a window, for a";
       LOCATE  8,5:PRINT "given month and year.  However, using the cursor   ";
       LOCATE  9,5:PRINT "keys, you can advance or backup months and years.  ";

       SECONDS!=10.0
       CALL  WAITTIME(SECONDS!,RETURN.CODE%)

       QUADRANT=0
'      FOR QUADRANT=0 TO 4
           COLOR 7,1
           CLS
           INPUT "Month (1-12)",month%
           INPUT "Year (4 digit)",year%

           PRINT "Press [ESC] or [RETURN] to exit ..."

           QUADRANT$=RIGHT$(STR$(QUADRANT),1)
           CALL KEYCAL(MONTH%,YEAR%,QUADRANT$,0,7,1,RETURN.CODE%)

1150:
           SECONDS!=4.0!
           CALL WAITTIME(SECONDS!,RETURN.CODE%)

'      NEXT

       RETURN

'
'-----------------------------------------------------------------------------
DOCAU:
1200:
       CALL MAKEWIND(5,5,22,55,2,1,7,1,1,"",RETURN.CODE%)

       COLOR 15,0
       LOCATE  5,5:PRINT "               ***    CAUTION   ***                ";
       COLOR 1,7

       LOCATE  7,5:PRINT "This is an implementation of the new QUERY function";
       LOCATE  8,5:PRINT "The windows from the 'old' BASWIND for the function";
       LOCATE  9,5:PRINT "WARNING/CAUTION/QUESTION all had a common basis, so";
       LOCATE 10,5:PRINT "a general purpose function was created to handle   ";
       LOCATE 11,5:PRINT "this type of requirement.                          ";
       LOCATE 13,5:PRINT " CAUTION displays a 'yellow' caution window and one";
       LOCATE 14,5:PRINT "or more of lines of informative text. You then use ";
       LOCATE 15,5:PRINT "the window to make a 'Cancel' or 'Continue' type of";
       LOCATE 16,5:PRINT "decision.                                          ";

       SECONDS!=15.0
       CALL WAITTIME(SECONDS!,RETURN.CODE%)

       QUADRANT=0

'      FOR QUADRANT=0 TO 4
           COLOR 7,1
           CLS

           MSGDAT$(OPTION.BASE+0)="You are about to convert your COLOR Monitor"
           MSGDAT$(OPTION.BASE+1)="into a Monochrome Monitor."
           MSGDAT$(OPTION.BASE+2)=" "
           MSGDAT$(OPTION.BASE+3)="ARE YOU ABSOLUTELY SURE YOU WANT TO DO THIS?"

           RETURN.CODE%=0

           QUADRANT$=RIGHT$(STR$(QUADRANT),1)

           CALL CAUTION(4,MSGDAT$(),QUADRANT$,RETURN.CODE%)

1250:
           LOCATE 25,38

           SELECT CASE RETURN.CODE%
               CASE 0
                    PRINT "CANCEL";
               CASE 1
                    PRINT "CONTINUE";
               CASE ELSE
                    PRINT "ESC";
           END SELECT

           SECONDS!=4.0!
           CALL WAITTIME(SECONDS!,RETURN.CODE%)

'          ERASE MSGDAT$

'      NEXT

       RETURN

'
'-----------------------------------------------------------------------------
DOQUE:
1300:
       CALL MAKEWIND(5,5,22,55,2,1,7,1,1,"",RETURN.CODE%)

       COLOR 15,0
       LOCATE  5,5:PRINT "               ***   QUESTION   ***                ";
       COLOR 1,7

       LOCATE  7,5:PRINT "This is an implementation of the new QUERY function";
       LOCATE  8,5:PRINT "The windows from the 'old' BASWIND for the function";
       LOCATE  9,5:PRINT "WARNING/CAUTION/QUESTION all had a common basis, so";
       LOCATE 10,5:PRINT "a general purpose function was created to handle   ";
       LOCATE 11,5:PRINT "this type of requirement.                          ";
       LOCATE 13,5:PRINT " QUESTION displays a 'yellow' question window and 1";
       LOCATE 14,5:PRINT "or more of lines of informative text. You then use ";
       LOCATE 15,5:PRINT "the window to make a 'Yes' or 'No' type of decision";

       SECONDS!=15.0
       CALL WAITTIME(SECONDS!,RETURN.CODE%)

       QUADRANT=0

'      FOR QUADRANT=0 TO 4
           COLOR 7,1
           CLS

           MSGDAT$(OPTION.BASE+0)="You are about to convert your COLOR Monitor"
           MSGDAT$(OPTION.BASE+1)="into a Monochrome Monitor."
           MSGDAT$(OPTION.BASE+2)=" "
           MSGDAT$(OPTION.BASE+3)="ARE YOU ABSOLUTELY SURE YOU WANT TO DO THIS?"

           RETURN.CODE%=1

           QUADRANT$=RIGHT$(STR$(QUADRANT),1)

           CALL QUESTION(4,MSGDAT$(),QUADRANT$,RETURN.CODE%)

1350:
           LOCATE 25,38

           SELECT CASE RETURN.CODE%
               CASE 0
                    PRINT "NO ";
               CASE 1
                    PRINT "YES ";
               CASE ELSE
                    PRINT "ESC";
           END SELECT

           SECONDS!=4.0!
           CALL WAITTIME(SECONDS!,RETURN.CODE%)

'          ERASE MSGDAT$

'      NEXT

       RETURN

'
'-----------------------------------------------------------------------------
DOWARN:
1400:
       CALL MAKEWIND(5,5,22,55,2,1,7,1,1,"",RETURN.CODE%)

       COLOR 15,0
       LOCATE  5,5:PRINT "               ***    WARNING   ***                ";
       COLOR 1,7

       LOCATE  7,5:PRINT "This is an implementation of the new QUERY function";
       LOCATE  8,5:PRINT "The windows from the 'old' BASWIND for the function";
       LOCATE  9,5:PRINT "WARNING/CAUTION/QUESTION all had a common basis, so";
       LOCATE 10,5:PRINT "a general purpose function was created to handle   ";
       LOCATE 11,5:PRINT "this type of requirement.                          ";
       LOCATE 13,5:PRINT "  WARNING displays a  'red'  warning window and one";
       LOCATE 14,5:PRINT "or more of lines of informative text. You then use ";
       LOCATE 15,5:PRINT "the window to make a 'Cancel' or 'Continue' type of";
       LOCATE 16,5:PRINT "decision.                                          ";

       SECONDS!=15.0
       CALL WAITTIME(SECONDS!,RETURN.CODE%)

       QUADRANT=0
       FOR QUADRANT=0 TO 4
           COLOR 7,1
           CLS

           MSGDAT$(OPTION.BASE+0)="You are about to convert your house AC voltage"
           MSGDAT$(OPTION.BASE+1)="from 110 volts to 440 volts."
           MSGDAT$(OPTION.BASE+2)=" "
           MSGDAT$(OPTION.BASE+3)="ARE YOU ABSOLUTELY SURE YOU WANT TO DO THIS?"

           RETURN.CODE%=0

           QUADRANT$=RIGHT$(STR$(QUADRANT),1)

           CALL WARNING(4,MSGDAT$(),QUADRANT$,RETURN.CODE%)
1450:
           LOCATE 25,38

           SELECT CASE RETURN.CODE%
               CASE 0
                    PRINT "CANCEL";
               CASE 1
                    PRINT "CONTINUE";
               CASE ELSE
                    PRINT "ESC";
           END SELECT

           SECONDS!=4.0!
           CALL WAITTIME(SECONDS!,RETURN.CODE%)

'          ERASE MSGDAT$

       NEXT

       RETURN

'
DISPLAY.HELP:
1500:
       COLOR 15,7

       LOCATE 12,5
       PRINT " Function        Keyboard      Mouse";

       COLOR 9,7

       LOCATE 14,5
       PRINT " Select item     ";
       COLOR 6,7
       PRINT "Enter         click on item":

       COLOR 9,7
       LOCATE 15,5
       PRINT " Abort function  ";

       COLOR 6,7
       PRINT "ESC           click outside window";

       COLOR 9,7
       LOCATE 16,5
       PRINT " Another item    ";

       COLOR 6,7
       PRINT "Cursor keys   move mouse pointer";
       LOCATE 17,22
       PRINT "First letter

       COLOR 9,7
       LOCATE 19,5
       PRINT " More items      ";
       COLOR 6,7
       PRINT "PgUp/PgDn     click on top/bottom";
       LOCATE 20,5
       PRINT "                               window frame"

       COLOR 9,7
       LOCATE 21,5
       PRINT " First items     ";

       COLOR 6,7
       PRINT "Home";

       COLOR 9,7
       LOCATE 22,5
       PRINT " Last items      ";
       COLOR 6,7
       PRINT "End";

       RETURN

'
SCROLL.WAIT:
1600:
      SECONDS!=0.2
       CALL WAITTIME(SECONDS!,RETURN.CODE%)
       RETURN

'
PRINT.FILENAME:
1700:
       FILENAME$=SELECTFILE$

'
' The following code is commented out, but shows how to access a files
' attributes and convert them to a format that is workable.
'

'      FILE.ATTR$=MID$(SELECTFILE$,14,1)
'      FILE.ATTR=ASC(FILE.ATTR$)
'
'      IF (FILE.ATTR AND &H10)<>0 THEN
'          FILENAME$=FILENAME$+" <DIR> "
'      ENDIF
'
'      IF (FILE.ATTR AND &H01)<>0 THEN
'          FILENAME$=FILENAME$+"  READ ONLY "
'      ENDIF
'
'      IF (FILE.ATTR AND &H02)<>0 THEN
'          FILENAME$=FILENAME$+" + HIDDEN "
'      ENDIF
'
'      IF (FILE.ATTR AND &H04)<>0 THEN
'          FILENAME$=FILENAME$+" + SYSTEM "
'      ENDIF
'
'      IF (FILE.ATTR AND &H08)<>0 THEN
'          FILENAME$=FILENAME$+" + LABEL "
'      ENDIF
'
'      IF (FILE.ATTR AND &H20)<>0 THEN
'          FILENAME$=FILENAME$+" + ARCHIVE "
'      ENDIF
'
'      MONTH$=MID$(SELECTFILE$,17,1)
'      MONTH=ASC(MONTH$) AND &HE0
'      MONTH=MONTH/32
'
'      MONTH$=MID$(SELECTFILE$,18,1)
'      MONTH.TEMP=ASC(MONTH$) AND &H01
'      MONTH.TEMP=MONTH.TEMP*8
'
'      MONTH=MONTH+MONTH.TEMP
'
'      DAY$=MID$(SELECTFILE$,17,1)
'      DAY=ASC(DAY$) AND &H1F
'
'      YEAR$=MID$(SELECTFILE$,18,1)
'      YEAR=ASC(YEAR$) AND &HFE
'      YEAR=YEAR/2
'      YEAR=1980+YEAR
'
'      HOURS$=MID$(SELECTFILE$,16,1)
'      HOURS=ASC(HOURS$) AND &HF8
'      HOURS=HOURS/8
'
'      MINUTES$=MID$(SELECTFILE$,16,1)
'      MINUTES=ASC(MINUTES$) AND &H03
'      MINUTES=MINUTES*8
'
'      MINUTES$=MID$(SELECTFILE$,15,1)
'      MINUTES.TEMP=ASC(MINUTES$) AND &HE0
'      MINUTES.TEMP=MINUTES.TEMP/32
'      MINUTES=MINUTES+MINUTES.TEMP
'
'      SECONDS$=MID$(SELECTFILE$,15,1)
'      SECONDS=ASC(SECONDS$) AND &H1F
'      SECONDS=SECONDS*2
'
'      FILESIZE.ADDR=VARPTR(FILESIZE&)
'      POKE FILESIZE.ADDR,ASC(MID$(SELECTFILE$,19,1))
'
'      FILESIZE.ADDR=VARPTR(FILESIZE&)
'      POKE FILESIZE.ADDR+1,ASC(MID$(SELECTFILE$,20,1))
'
'      FILESIZE.ADDR=VARPTR(FILESIZE&)
'      POKE FILESIZE.ADDR+2,ASC(MID$(SELECTFILE$,21,1))
'
'      FILESIZE.ADDR=VARPTR(FILESIZE&)
'      POKE FILESIZE.ADDR+3,ASC(MID$(SELECTFILE$,22,1))
'
'      FILESIZE$=STR$(FILESIZE&)
'
'      FILEDATE$=STR$(MONTH)+"-"+STR$(DAY)+"-"+STR$(YEAR)
'
'      FILETIME$=STR$(HOURS)+":"+STR$(MINUTES)+":"+STR$(SECONDS)
'
'      FILENAME$=FILENAME$+FILESIZE$+" "+FILEDATE$+" "+FILETIME$

       PRINT FILENAME$;

       RETURN

'
INTRODUCTION:
       FOR I=1 TO 30
          ULR%=RND*17
          WHILE ULR% = 0:ULR%=RND*17:WEND

          LRR%=RND*23
          WHILE LRR% < ULR%:LRR%=RND*23:WEND

          ULC%=RND*60
          WHILE ULC% = 0:ULC%=RND*60:WEND

          LRC%=RND*79
          WHILE LRC% < ULC%:LRC%=RND*79:WEND

          FORE%=RND*15
          BACK%=RND*7

          CALL MAKEWIND(ULR%,ULC%,LRR%,LRC%,2,FORE%,BACK%,0,1,"",RETURN.CODE%)

          SECONDS!=0.2
          CALL WAITTIME(SECONDS!,RETURN.CODE%)

       NEXT

       SECONDS!=3.0
       CALL WAITTIME(SECONDS!,RETURN.CODE%)

       CALL MAKEWIND(9,15,16,65,2,0,7,0,1,"",RETURN.CODE%)

'
        COLOR 0,7
        CALL SCROLL(9,15,16,65,1,1,"     Introducing ...",RETURN.CODE%)
        GOSUB SCROLL.WAIT

        CALL SCROLL(9,15,16,65,1,1," ",RETURN.CODE%)
        GOSUB SCROLL.WAIT

        CALL SCROLL(9,15,16,65,1,1,"                  Window Tools",RETURN.CODE%)
        GOSUB SCROLL.WAIT

        CALL SCROLL(9,15,16,65,1,1," ",RETURN.CODE%)
        GOSUB SCROLL.WAIT

        CALL SCROLL(9,15,16,65,1,1,"     A collection of useful routines based on",RETURN.CODE%)
        GOSUB SCROLL.WAIT

        CALL SCROLL(9,15,16,65,1,1,"     BASWIND7 and designed to perform powerful",RETURN.CODE%)
        GOSUB SCROLL.WAIT

        CALL SCROLL(9,15,16,65,1,1,"     windowing functions in your programs ...",RETURN.CODE%)
        GOSUB SCROLL.WAIT

        CALL SCROLL(9,15,16,65,1,1," ",RETURN.CODE%)

        SECONDS!=10.0
        CALL WAITTIME(SECONDS!,RETURN.CODE%)

        CALL SCROLL(9,15,16,65,1,-1," ",RETURN.CODE%)
        GOSUB SCROLL.WAIT

        CALL SCROLL(9,15,16,65,1,-1," ",RETURN.CODE%)
        GOSUB SCROLL.WAIT

        CALL SCROLL(9,15,16,65,1,-1," ",RETURN.CODE%)
        GOSUB SCROLL.WAIT

        CALL SCROLL(9,15,16,65,1,-1," ",RETURN.CODE%)
        GOSUB SCROLL.WAIT

        CALL SCROLL(9,15,16,65,1,-1,"      ...  Stand by FOR a complete demo ...",RETURN.CODE%)
        GOSUB SCROLL.WAIT

        CALL SCROLL(9,15,16,65,1,-1," ",RETURN.CODE%)
        GOSUB SCROLL.WAIT

        CALL SCROLL(9,15,16,65,1,-1," ",RETURN.CODE%)
        GOSUB SCROLL.WAIT

        CALL SCROLL(9,15,16,65,1,-1," ",RETURN.CODE%)

       SECONDS!=4.0!
       CALL WAITTIME(SECONDS!,RETURN.CODE%)

       RETURN
'
'-----------------------------------------------------------------------------
ENDIT:
1800:
       COLOR 7,1
       CLS

       CALL MAKEWIND(9,15,16,65,2,0,7,0,1,"",RETURN.CODE%)

       COLOR 0,7
       CALL SCROLL(9,15,16,65,1,-1,"         !!  NOW with MS Mouse support !!",RETURN.CODE%)
       GOSUB SCROLL.WAIT

       CALL SCROLL(9,15,16,65,1,-1," ",RETURN.CODE%)
       GOSUB SCROLL.WAIT

       CALL SCROLL(9,15,16,65,1,-1,"                   QuickBasic 4.5",RETURN.CODE%)
       GOSUB SCROLL.WAIT

       CALL SCROLL(9,15,16,65,1,-1," ",RETURN.CODE%)
       GOSUB SCROLL.WAIT

       CALL SCROLL(9,15,16,65,1,-1,"                        for",RETURN.CODE%)
       GOSUB SCROLL.WAIT

       CALL SCROLL(9,15,16,65,1,-1," ",RETURN.CODE%)
       GOSUB SCROLL.WAIT

       CALL SCROLL(9,15,16,65,1,-1,"                *  Window Tools  *",RETURN.CODE%)

       SECONDS!=8.0
       CALL WAITTIME(SECONDS!,RETURN.CODE%)

       CALL SCROLL(9,15,16,65,1,1,"             BY: James P. Morgan",RETURN.CODE%)
       GOSUB SCROLL.WAIT

       CALL SCROLL(9,15,16,65,1,1,"                 5226 Via Hacienda #115",RETURN.CODE%)
       GOSUB SCROLL.WAIT

       CALL SCROLL(9,15,16,65,1,1,"                 Orlando, FL 32809 U.S.A.",RETURN.CODE%)
       GOSUB SCROLL.WAIT

       CALL SCROLL(9,15,16,65,1,1," ",RETURN.CODE%)
       GOSUB SCROLL.WAIT

       CALL SCROLL(9,15,16,65,1,1," ",RETURN.CODE%)
       GOSUB SCROLL.WAIT

       CALL SCROLL(9,15,16,65,1,1,"   * based on original PD works by Dave Evers *",RETURN.CODE%)

       SECONDS!=30.0
       CALL WAITTIME(SECONDS!,RETURN.CODE%)

       COLOR 7,1
       LOCATE 22,9:PRINT "Please see accompanying file WINDTOOL.DOC for more information"

       SYSTEM
