
igroup        group     Newvid_TEXT
              assume    cs: igroup
              public    SCRNSAVE,SCRNREST,SCRNBUFF
Newvid_TEXT   segment   word public 'CODE'

SCRNSAVE      proc      far
              jmp       near ptr codego

              even                            ; Align buffer on word!
SCRNBUFF      dw        2010 dup(0bbh)        ; 10 extra byte guard

codego:       push      bp                    ;Save for BASIC
              mov       bp,sp                 ;
              push      ds
              push      es                    ;
              push      di
              push      si
              call      GET_SET
              push      es                    ;Put ES in DS
              pop       ds                    ; since we are moving from screen
              mov       si, seg Newvid_TEXT   ; Set buffer segment!
              mov       es, si
              xor       si,si                 ;Set source index to 0
              mov       di, offset Newvid_TEXT:SCRNBUFF
              call      GO                    ;do it
              pop       si
              pop       di
              pop       es
              pop       ds
              pop       bp
              ret
SCRNSAVE      endp

SCRNREST      proc      far
              push      bp
              mov       bp,sp
              push      ds
              push      es
              push      di
              push      si
              mov       si, seg Newvid_TEXT   ; Get buffer
              mov       ds, si                ;      segment!
              mov       si, offset Newvid_TEXT:SCRNBUFF
              xor       di,di                 ; Set destination index to 0
              call      GET_SET
              call      GO
              pop       si
              pop       di
              pop       es
              pop       ds
              pop       bp
              ret
SCRNREST      endp

GET_SET       proc      near

              mov  ax,0
              mov  ah,15                      ;Video mode BIOS Call
              int  010H                       ;Do the BIOS Call
              cmp  al,07H                     ;See if it's Monochrome
              jz   is_mono                    ;Yes
              mov  ax,0B800H                  ;Set it up for C/G
              jmp  ok                         ;
is_mono:      mov  ax,0B000H                  ;Set it up for Monochrome

ok:           mov       es,ax
              cld                             ; set up for auto increment
              mov       ah,6                  ; number of blocks to copy
              ret
GET_SET       endp

GO            proc      near

begin:        mov       cx,240                ; number of words to move during VRTCE
              mov       dx,3DAH               ; C/G adapter status port
              cli                             ; disable interrupts

wait_vert_refresh:

              in        al,dx                 ; read status
              test      al,8                  ; test vertical retrace bit
              jnz       wait_vert_refresh     ; loop until in refresh

wait_vert_retrace:

              in        al,dx                 ;read status
              test      al,8                  ;test vertical retrace bit
              jz        wait_vert_retrace     ;loop until retrace starts
              rep       movsw                 ;move a block of words

              mov       cx,188                ;number of bytes to move during
                                              ;horizontal retrace periods
              mov       dx,3DAH

wait_horiz_refresh:

              in        al,dx                 ;read status
              test      al,1                  ;test horizontal retrace bit
              jnz       wait_horiz_refresh    ;loop until in a retrace

wait_horiz_retrace:

              in        al,dx                 ;read status
              test      al,1                  ;test horizontal retrace bit
              jz        wait_horiz_retrace    ;loop until retrace starts
              movsb                           ;copy a byte
              loop      wait_horiz_refresh

              sti
              dec       ah                    ;reduce the block count
              cmp       ah,0                  ;done?
              jnz       short begin

              ret

GO            endp

Newvid_TEXT   ends
              end

