
bios_data         segment     at 40H      ; set up labels to determine whether
                  org         10H         ; to display in color or monochrome
equip_flag        label       word
                  org         4AH         ; 40 or 80 column display
crt_clms          label       word
                  org         63H
addr_6845         label       word        ; pointer to video card ports
bios_data         ends

igroup            group       FASTPRT_text
                  assume      cs:igroup
                  public      FASTPRT
FASTPRT_text      segment     word public 'CODE'
FASTPRT           proc        far
                  push        bp            ; save BP for far return
                  mov         bp,sp         ; point to arguments on stack
                  push        es            ; must save for BASIC
                  push        di
                  push        si 
                  mov         bx,[bp+8]     ; get addr of COL% storage
                  mov         di,[bx]       ; get the column value
                  dec         di            ; adjust for LOCATE format

                  mov         bx,[bp+10]    ; get addr of ROW% storage
                  mov         ax,[bx]       ; get the row value
                  dec         ax            ; adjust for LOCATE format

                  mov         bx,[bp+12]    ; set ptr to string descriptor
                  mov         cx,[bx]       ; get length of string
                  jcxz        exit          ; Done if null string
                  mov         si,[bx+2]     ; SI = first character of VAR$

                  mov         bx,bios_data  ; set ready to determine video card
                  mov         es,bx         ; and number of columns
                  mul         es:crt_clms   ; AX = COL% times words per line
                  add         di,ax         ; DI = words from start of screen
                  shl         di,1          ; shift for attribute byte

;       CX has the count of characters to write
;       SI points to the string to print
;       DI points to the starting screen position

                  mov         ax,0B000H          ;default to mono card
                  mov         bx,es:equip_flag
                  and         bx,30H
                  cmp         bx,30H             ; monochrome?
                  je          mono               ; jump if so
                  mov         ax,0B800h          ; set to color card
                  mov         dx,es:addr_6845    ; point to 6845 base port
                  add         dx,6               ; point to status port
                  mov         bx,[bp+6]          ; get color attribute
                  mov         bx,[bx]
                  mov         es,ax              ; point ES to video

                  call        print_string

                  jmp         exit

mono:             mov         dx,es:addr_6845    ; point to 6845 base port
                  add         dx,6               ; point to status port
                  mov         bx,[bp+6]          ; get color attribute
                  mov         bx,[bx]
                  mov         es,ax              ; point ES to video

movestr:          movsb                          ; print a character
                  mov        es:[di],bl          ; move attribute
                  inc        di                  ; skip attribute byte
                  loop       movestr             ; repeat until end of string
exit:
                  pop         si
                  pop         di
                  pop         es
                  pop         bp
                  ret         8
FASTPRT           endp

Print_string      proc       near                ; wait for horizontal retrace
                  cli                            ; turn off interrupts
test_low:         in         al,dx               ; get status
                  test       al,1                ; is it low?
                  jnz        test_low            ; if not, try again
test_hi:          in         al,dx               ; get status
                  test       al,1                ; is it high?
                  jz         test_hi             ; if not, try again
                  movsb                          ; print a character
tst_low2:         in         al,dx               ; get status
                  test       al,1                ; is it low?
                  jnz        tst_low2            ; if not, try again
tst_hi2:          in         al,dx               ; get status
                  test       al,1                ; is it high?
                  jz         tst_hi2             ; if not, try again
                  mov        es:[di],bl          ; move attribute
                  inc        di                  ; skip attribute byte
                  loop       test_low            ; repeat until end of string
                  sti                            ; turn interrupts back on
                  ret                            ; return to the FASTPRT procedure
Print_string      endp

FASTPRT_text      ends
                  end

