; SPACSUBI - get disk space free & used for interpretive BASIC
; CALL SPACSUBI(STACK$,DRIVE%,BUF$,FREE%,USED%,SIZE%)
; STACK$ - stack area
; DRIVE% = 0 if A:, 1 if B:, etc.
; BUF$ - 512 byte buffer for sector's data
; FREE% - number of free clusters
; USED% - number of used clusters
; SIZE% - cluster size
cseg   segment para public 'code'
public spacsubi
spacsubi proc far
    assume cs:cseg,ds:cseg,ss:cseg,es:nothing
    push bp
    mov bp,sp
    push es          ; save es
    mov si,[bp+16]   ; point to stack$ arg
    mov al,[si]      ; get length
    mov ah,0
    inc si
    add ax,[si]      ; add start addr
    dec ax           ; down by 1
    mov di,sp        ; hold in di
    mov sp,ax        ; new sp
    push di
    mov si,[bp+14]   ; drive no
    mov ax,[si]
    mov cx,1         ; read 1 sector
    mov dx,1         ; rel sector no
    mov si,[bp+12]   ; buffer
    inc si
    mov bx,[si]
    mov es,bp        ; save bp
    int 25h          ; bios absolute read
    mov bp,es        ; restore bp
    mov ah,0
    jc p99 ; error
    mov si,[bp+12]   ; reset buffer
    inc si
    mov bx,[si]
    mov ax,[bx+1]    ; check disk type
    cmp ax,0ffffh
    jz p10           ; proceed
    mov ah,1
    jmp p99          ; unknown type
p10:mov al,[bx]
    cmp al,0ffh      ; double sided?
    jz p20           ; yes
    cmp al,0feh      ; single sided?
    jz p30           ; yes
    mov ah,2
    jmp p99          ; unknown
p20:mov ax,1024      ; size
    mov cx,316/2     ; fat entries/2
    jmp p40
p30:mov ax,512       ; size
    mov cx,314/2     ; fat entries/2
p40:mov si,[bp+6]
    mov [si],ax      ; save size
    mov si,0         ; free counter
    mov di,0         ; used counter
p50:add bx,3         ; point to next clump
    mov ax,[bx]
    and ax,0fffh     ; clear upper 4
    jz p55           ; not used
    inc di
    jmp p60
p55:inc si
p60:cmp cx,1         ; last pass?
    jz p70           ; yes - skip it
    mov ax,[bx+1]
    and ax,0fff0h    ; clear lower 4
    jz p65           ; not used
    inc di
    jmp p70
p65:inc si
p70:loop p50
    mov ax,si
    mov si,[bp+10]   ; point to free
    mov [si],ax
    mov ax,di
    mov si,[bp+8]    ; point to used
    mov [si],ax
    mov ax,0         ; no error - clear ax
p99:popf
    mov si,[bp+14]
    mov [si],ax      ; return error in drive
    pop di           ; restore original stack
    mov sp,di
    pop es           ; restore es
    pop bp
    ret 12
spacsubi endp
cseg ends
    end
