'==============================================================================
'   Quick Basic Program Analyzer
'
'   Author: Clyde F. Coulter, Jr.
'     Date: 9-27-88
'
'       (C) Copr Clyde F. Coulter, jr.
'       All Rights Reserved.
'       (606) 744-1911
'
'   If No Parameters are passed, Program asks user for each parameter
'   value.
'
'   May be invoked from DOS command line as follows:
'       >BASFLOW source.bas [outfile.flo] [/switches]
'
'   Default Output Device is SCRN:
'   Switches are:
'       /L   Produce Program Source Listing Including Line Numbers.
'       /X   Produce Label and Variable Crossreference
'       /Tn  Produce Program Tree, where n = 1 to 9
'       /R   Produce Reserved Word Usage List
'       /S   Produce String Data Reference
'       /Q4  Source is QB Version 4.0 (Default is v3.0)
'
'   Example:
'       >BASFLOW basflow.bas basflow.flo /L /X /T2 /R /Q4
'==============================================================================

       DEFINT  a-z
       CONST   False = 0, True = NOT False

       DIM     Switch(10),Label$(2000),StrData$(1500),StrLine(1500)
       DIM     Tree$(1000),RsvCnt(260),TStack(20),TStack$(20)

       DEF fnTrim$(a$)
       STATIC i
               i = INSTR(a$,CHR$(9))
               WHILE i
                       MID$(a$,i,1) = " "
                       i = INSTR(a$,CHR$(9))
               WEND
               WHILE LEFT$(a$,1) = " "
                       a$ = MID$(a$,2)
               WEND
               WHILE RIGHT$(a$,1) = " "
                       a$ = LEFT$(a$,LEN(a$)-1)
               WEND
               i = INSTR(a$,"  ")
               WHILE i
                       a$ = LEFT$(a$,i-1) + MID$(a$,i+1)
                       i = INSTR(a$,"  ")
               WEND
       fnTrim$ = a$
       END DEF

       DEF fnUpCase$(a$)
       STATIC i,c$,Quote
               Quote = 0
               FOR i = 1 TO LEN(a$)
                       c$ = MID$(a$,i,1)
                       IF c$ = CHR$(34) THEN
                               Quote = NOT Quote
                       END IF
                       IF NOT Quote THEN
                               IF c$ >= "a" AND c$ <= "z" THEN
                                       MID$(a$,i,1) = CHR$(ASC(c$)-32)
                               END IF
                       END IF
               NEXT i
       FnUpCase$ = a$
       END DEF

'-----------------------------------------------------------------------------
'
'-----------------------------------------------------------------------------

       Switches$ = "XSLTRQ"
       Xref = 1: StrData = 2: SrcLst = 3: Tree = 4: RsvCnt = 5: Ver4 = 6
       FOR i = 1 to LEN(Switches$)
               Switch(i) = False
       NEXT i

       AllDelim$ = " <=+->(*/,){;:_^}" + CHR$(34) + CHR$(9)

InputData:
       DATA    8
       DATA   -1,"         Source Filename: ","",""
       DATA    0,"         Output Filename: ","","SCRN:"
       DATA    0,"    Source Listing (y/n): ","YN","/L"
       DATA    0,"    Print Pgm Tree (0-8): ","08","/T"
       DATA    0,"Label/Varible Xref (y/n): ","YN","/X"
       DATA    0," Reserved Word Use (y/n): ","YN","/R"
       DATA    0,"   String Data Ref (y/n): ","YN","/S"
       DATA    0,"  Qbasic Version (2/3/4): ","04","/Q"

       RDef$ = "DEFINT/DEFSNG/DEFDBL/DEFSTR"

       RESTORE ResData
       Reserved$ = CHR$(13)
       READ a$
       i = 1
       WHILE a$ <> "*"
               IF a$ = "END" THEN EndPtr = i
               Reserved$ = Reserved$ + a$ + CHR$(13)
               READ a$
               i = i + 1
       WEND

ResData:
       DATA    ABS, ACCESS, AND, APPEND, AS, ASC, ATN, AUTO
       DATA    BASE, BEEP, BLOAD, BSAVE
       DATA    CALL, CALLS, CASE, CDBL, CHAIN, CHDIR, CHR$, CINT, CIRCLE
       DATA    CLEAR, CLOSE, CLS, COLOR, COM, COMMAND$, COMMON, CONST
       DATA    COS, CSNG, CSRLIN, CVD, CVI, CVS
       DATA    DATA, DATE$, DEF, DEFDBL, DEFINT, DEFSNG, DEFSTR
       DATA    DELETE, DIM, DO, DRAW
       DATA    EDIT, ELSE, ELSEIF, END, "END DEF", "END IF", "END SELECT"
       DATA    "END SUB", ENVIRON, ENVIRON$
       DATA    EOF, EQV, ERASE, ERDEV, ERDEV$, ERL, ERR, ERROR, EXIT, EXP
       DATA    FIELD, FILES, FIX, FOR, FRE
       DATA    GET, GO, GOTO, GOSUB
       DATA    HEX$, IF, IMP, INKEY$, INP, INPUT, INPUT$, INSTR, INT
       DATA    IOCTL, IOCTL$, IS
       DATA    KEY, KILL, LBOUND, LEFT$, LEN, LET, LINE, LIST, LLIST, LOAD
       DATA    LOC, LOCAL, LOCATE, LOCK, LOF, LOG, LOOP, LPOS, LPRINT, LSET
       DATA    MERGE, MID$, MKD$, MKDIR, MKI$, MKS$, MOD, MOTOR
       DATA    NAME, NEW, NEXT, NOISE, NOT, NULL
       DATA    OCT$, OFF, ON, OPEN, OPTION, OR, OUT, OUTPUT
       DATA    PAINT, PALETTE, PEEK, PEN, PLAY, PMAP, POINT
       DATA    POKE, POS, PRESET, PRINT, PSET, PUT, RANDOM
       DATA    RANDOMIZE, READ, REDIM, REM, RENUM, RESET, RESTORE, RESUME
       DATA    RETURN, RIGHT$, RMDIR, RND, RSET, RUN
       DATA    SADD, SAVE, SCREEN, SEG, SELECT, SGN, SHARED, SHELL, SIN
       DATA    SOUND, SPACE, SPACE$, SPC, SQR, STATIC, STEP, STICK
       DATA    STOP, STR$, STRIG$, STRING, STRING$, SUB, SWAP, SYSTEM
       DATA    TAB, TAN, THEN, TIME$, TIMER, TO, TROFF, TRON
       DATA    UBOUND, UNLOCK, UNTIL, USING, USR
       DATA    VAL, VARPTR, VARPTR$, VARSEG, VIEW
       DATA    WAIT, WEND, WHILE, WIDTH, WINDOW, WRITE, XOR
       DATA    "*"

Resv40:
       DATA    ALIAS, ANY, BINARY, BYVAL, CASE, CDECL, CLNG
       DATA    CVDMBF, CVL, CVSMBF, DECLARE, DEFLNG, DOUBLE
       DATA    "END FUNCTION"
       DATA    FILEATTR, FREEFILE, FUNCTION, INTEGER, LCASE$
       DATA    LONG, LTRIM$, MKDMBF$, MKL$, MKSMBF$, PCOPY
       DATA    RTRIM$, SEEK, SETMEM, SIGNAL, SINGLE, SLEEP
       DATA    TYPE, UCASE$
       DATA    "*"

'-----------------------------------------------------------------------------
'
'-----------------------------------------------------------------------------

Main:
       Eoj = False
       Lndx = 0: Tndx = 0

       PRINT ""
       PRINT "               Basic Program Statistics"
       PRINT ""
       PRINT "          (C) Copr Clyde F. Coulter, Jr. 1988"
       PRINT ""
       LOCATE ,,1

       Cmd$ = COMMAND$
       IF Cmd$ = "" THEN
               LOCATE ,,1
               RESTORE InputData
               READ Np
               FOR x = 1 TO Np
                       READ Required,LPrompt$,Valid$,Switch$
                       Redo = True
                       WHILE Redo
                               PRINT LPrompt$;
                               LINE INPUT a$
                               a$ = fnUpCase$(fnTrim$(a$))
                               IF Required AND a$ = "" THEN
                                       Redo = True
                               ELSE
                                       IF Valid$ = "YN" THEN
                                               Valid = INSTR(Valid$,a$)
                                               IF Valid AND a$ <> "" THEN
                                                       Yes = Valid - 2
                                                       Redo = False
                                               ELSE
                                                       IF a$ = "" THEN
                                                               Yes = False
                                                               Redo = False
                                                       END IF
                                               END IF
                                       ELSEIF LEFT$(Valid$,1) = "0" THEN
                                               IF a$ >= "0" and a$ <= MID$(Valid
,2,1) THEN
                                                       Switch$ = Switch$ + a$
                                                       Redo = False
                                                       Yes = True
                                               ELSEIF a$ = "" THEN
                                                       Redo = False
                                                       Yes = False
                                               ELSE
                                                       Redo = True
                                               END IF
                                       ELSE
                                               Yes = True
                                               Redo = False
                                               Switch$ = a$
                                       END IF
                                       IF (NOT Redo) AND Yes THEN
                                               IF Switch$ <> "" THEN a$ = Switch

                                       ELSE
                                               a$ = ""
                                       END IF
                               END IF
                               IF Redo AND x = 1 THEN END
                       WEND
                       Cmd$ = Cmd$ + a$ + " "
               NEXT x
       END IF
       Cmd$ = FnTrim$(Cmd$)

       GOSUB GetParm: InFname$ = Switch$
       IF InFname$ = "" THEN Eoj = True
       GOSUB GetParm: OutFname$ = Switch$
       IF LEFT$(OutFname$,1) = "/" THEN
               Switch$ = OutFname$
               OutFname$ = "SCRN:"
               GOSUB SetSwitch
       ELSE
               t$ = LEFT$(OutFname$,3)
               IF t$ <> "LPT" AND t$ <> "PRN" AND t$ <> "CON" THEN
                       i = INSTR(OutFname$,".")
                       IF i = 0 THEN OutFname$ = OutFname$ + ".FLO"
               END IF
       END IF
       WHILE Cmd$ <> ""
               GOSUB GetParm
               GOSUB SetSwitch
       WEND

       IF Switch(Ver4) < 4 THEN
               Switch(Ver4) = 0
       ELSE
               RESTORE Resv40
               READ a$
               WHILE a$ <> "*"
                       Reserved$ = Reserved$ + a$ + CHR$(13)
                       READ a$
               WEND
       END IF

       i = INSTR(InFname$,".")
       IF i = 0 THEN
               InFname$ = InFname$ + ".BAS"
       END IF
       IF OutFname$ = "SCRN:" THEN MaxLines = 23 Else MaxLines = 62

       stime! = TIMER

       IF NOT Eoj THEN
               OPEN "I",#1,InFname$
               CurLine = 0
               WHILE NOT EOF(1) AND NOT Eoj
                       CurLine = CurLine + 1
                       LINE INPUT #1,PgmLine$
                       GOSUB PassOne
                       IF INKEY$ = CHR$(27) THEN Eoj = True
               WEND
               NumLines = CurLine
               CLOSE #1
               IF NOT Eoj THEN
                       OPEN "O",#2,OutFname$
                       CurLine = 0
                       Pline = 0
                       GOSUB PrtTof
                       IF Switch(SrcLst) THEN
                               OPEN "I",#1,InFname$
                               WHILE NOT EOF(1) AND NOT Eoj
                                       CurLine = CurLine + 1
                                       LINE INPUT #1,PgmLine$
                                       GOSUB PassTwo
                               WEND
                       END IF
                       IF Pline > 2 THEN GOSUB PrtTof
                       IF Switch(Tree) THEN GOSUB PrtTree
                       IF Pline > 2 THEN GOSUB PrtTof
                       IF Switch(Xref) THEN GOSUB XrefLabels
                       IF Pline > 2 THEN GOSUB PrtTof
                       IF Switch(RsvCnt) THEN GOSUB PrtRsvCnt
                       IF Pline > 2 THEN GOSUB PrtTof
                       IF Switch(StrData) THEN GOSUB PrtStrData
               END IF
       END IF

       etime! = TIMER
       ttime! = etime! - stime!
       IF Pline >= MaxLines - 4 THEN GOSUB PrtTof
       PRINT #2,""
       PRINT #2,"Program Lines: ";NumLines
       PRINT #2,""
       PRINT #2,"Total Time:";ttime!
       Eoj = True
       GOSUB PrtTof
       CLOSE
       END

'-----------------------------------------------------------------------------
'
'-----------------------------------------------------------------------------

GetParm:
       i = INSTR(Cmd$,",")
       IF i = 0 THEN i = INSTR(Cmd$," ")
       IF i = 0 THEN i = INSTR(2,Cmd$,"/")
       IF i = 0 THEN i = LEN(Cmd$) + 1
       Switch$ = LEFT$(Cmd$,i-1)
       Cmd$ = fnTrim$(MID$(Cmd$,i))
       IF LEFT$(Cmd$,1) = "," THEN Cmd$ = fnTrim$(MID$(Cmd$,2))
       RETURN

'-----------------------------------------------------------------------------
'
'-----------------------------------------------------------------------------

SetSwitch:
       IF LEFT$(Switch$,1) <> "/" THEN
               PRINT "Invalid Parameter - ";Switch$
               Eoj = True
       ELSE
               SwVal$ = ""
               IF LEN(Switch$) > 2 THEN SwVal$ = MID$(Switch$,3)
               Switch$ = MID$(Switch$,2,1)
               IF VAL(Switch$) = 0 THEN
                       i = INSTR(Switches$,Switch$)
                       IF i THEN
                               SwVal = VAL(SwVal$)
                               IF Swval$ = "" THEN SwVal = 1
                               IF SwVal > 9 THEN SwVal = 9
                               Switch(i) = SwVal
                       ELSE
                               PRINT "Invalid Parameter - /";Switch$
                               Eoj = True
                       END IF
               ELSE
                       FOR i = 1 to 10
                               Switch(i) = VAL(Switch$)
                       NEXT i
               END IF
       END IF
       RETURN

'-----------------------------------------------------------------------------
'
'-----------------------------------------------------------------------------

PassOne:
       Ndx = 0: Eol = False
       PrevGo = False: PrevDef = False: PrevEnd = False
       PL$ = fnUpCase$(fnTrim$(PgmLine$))
       IF INSTR(PL$,"'") THEN
               Quote = False
               For i = LEN(PL$) TO 1 STEP -1
                       IF MID$(PL$,i,1) = CHR$(34) THEN Quote = NOT Quote
                       IF NOT Quote THEN
                               IF MID$(PL$,i,1) = "'" THEN PL$ = LEFT$(PL$,i-1)
                       END IF
               NEXT i
       END IF
       Label = False
       IF LEFT$(PgmLine$,1) <> " " AND LEFT$(PgmLine$,1) <> CHR$(9) THEN
               Label = True
               GOSUB GetWord
               Label = False
               IF Delim$ = ":" THEN Label = True
               IF MID$(STR$(VAL(Word$)),2) = Word$ THEN Label = True
       END IF
       Ndx = 0: Eol = False
       WHILE NOT Eol
               GOSUB GetWord
               IF Word$ <> "" THEN
                       GOSUB ChkWord
                       Label = False
               END IF
       WEND
       RETURN

'-----------------------------------------------------------------------------
'
'-----------------------------------------------------------------------------

PassTwo:
       Ndx = 0: Eol = False
       PRINT #2,Left$(MID$(STR$(CurLine),2)+"     ",6);PgmLine$
       Pline = Pline + 1
       IF Pline >= MaxLines THEN GOSUB PrtTof
       RETURN

'-----------------------------------------------------------------------------
'
'-----------------------------------------------------------------------------

GetWord:
       Word$ = ""
       IF LEFT$(PL$,1) = "'" OR LEFT$(PL$,4) = "DATA" THEN
               Eol = TRUE
               RETURN
       END IF
       WHILE NOT Eol AND Word$ = ""
               i = NDX + 1: Delim = False
               WHILE Delim = 0 AND i <= LEN(PL$)
                       c$ = MID$(PL$,i,1)
                       Delim = INSTR(AllDelim$,c$)
                       IF Delim = 0 THEN i = i + 1
               WEND
               IF Delim THEN
                       Delim$ = MID$(AllDelim$,Delim,1)
                       Delim = True
                       IF Delim$ = ":" THEN PrevGo = False
               ELSE
                       i = 0: Delim$ = ""
               END IF

               IF Delim$ = CHR$(34) THEN
                       Qpos = i
                       i = INSTR(i+1,PL$,Delim$)
                       IF i THEN
                               Ndx = i
                       ELSE
                               Ndx = LEN(PL$)
                               Eol = True
                       END IF
                       IF Switch(StrData) THEN
                               a$ = MID$(PL$,Qpos,Ndx+1-Qpos)
                               IF a$ <> CHR$(34) + CHR$(34) THEN
                                       Sndx = Sndx + 1
                                       StrData$(Sndx) = a$
                                       StrLine(Sndx) = CurLine
                               END IF
                       END IF
                       i = 0
               ELSEIF i > 0 AND i < 999 THEN
                       Word$ = FnTrim$(MID$(PL$,Ndx+1,i-Ndx-1))
                       Ndx = i
               ELSE
                       Word$ = FnTrim$(MID$(PL$,Ndx+1))
                       Eol = True
               END IF
               IF NOT PrevGo AND NOT Label THEN
                       IF LEFT$(Word$,1) >= "0" AND LEFT$(Word$,1) <= "9" THEN
                               Word$ = ""
                       END IF
               END IF
       WEND
       RETURN

'-----------------------------------------------------------------------------
'
'-----------------------------------------------------------------------------

ChkWord:
       i = INSTR(Reserved$,Word$)
       Ok = False
       WHILE i AND NOT Ok
               IF MID$(Reserved$,i-1,1) <> CHR$(13) OR _
               MID$(Reserved$,i+LEN(Word$),1) <> CHR$(13) THEN
                       i = INSTR(i+1,Reserved$,Word$)
               ELSE
                       Ok = True
               END IF
       WEND
       IF i = 0 THEN
               Defined = False
               FOR i = 1 to Lndx
                       j = INSTR(2,Label$(i),"/")
                       IF Word$ = MID$(Label$(i),2,j-2) THEN
                               Defined = True
                               EXIT FOR
                       END IF
               NEXT i
               IF Defined THEN
                       IF Label THEN
                               MID$(Label$(i),1,1) = "L"
                               j = INSTR(Label$(i),"/")
                               Label$(i) = LEFT$(Label$(i),j) + MKI$(CurLine) + 

                               MID$(Label$(i),j+1)
                       ELSE
                               Label$(i) = Label$(i) + MKI$(CurLine)
                       END IF
               ELSE
                       Lndx = Lndx + 1
                       Type$ = "V"
                       IF Label THEN Type$ = "L"
                       Label$(Lndx) = Type$ + Word$ + "/" + MKI$(CurLine)
               END IF

               IF Switch(Tree) THEN
                       IF Label THEN
                               Tndx = Tndx + 1
                               Tree$(Tndx) = Word$ + "/"
                       ELSEIF PrevGo THEN
                               Tree$(Tndx) = Tree$(Tndx) + PrevGo$ + " " + Word$
+ "/"
                       END IF
               END IF

       ELSE
               IF INSTR(RDef$,Word$) THEN
                       PrevDef = True
               ELSE
                       PrevDef = False
               END IF
               IF LEFT$(Word$,2) = "GO" THEN
                       PrevGo = True
                       PrevGo$ = Word$
               ELSE
                       PrevGo = False
               END IF
               IF Switch(RsvCnt) THEN
                       Tmp$ = Word$
                       IF PrevEnd THEN
                               IF Word$ = "IF" THEN
                                       Tmp$ = "END IF"
                                       RsvCnt(EndPtr) = RsvCnt(EndPtr) - 1
                               ELSEIF Word$ = "SUB" THEN
                                       Tmp$ = "END SUB"
                                       RsvCnt(EndPtr) = RsvCnt(EndPtr) - 1
                               ELSEIF Word$ = "SELECT" THEN
                                       Tmp$ = "END SELECT"
                                       RsvCnt(EndPtr) = RsvCnt(EndPtr) - 1
                               ELSEIF Word$ = "DEF" THEN
                                       Tmp$ = "END DEF"
                                       RsvCnt(EndPtr) = RsvCnt(EndPtr) - 1
                               ELSEIF Switch(Ver4) THEN
                                       IF Word$ = "FUNCTION" THEN
                                               Tmp$ = "END FUNCTION"
                                               RsvCnt(EndPtr) = RsvCnt(EndPtr) -
1
                                       END IF
                               END IF
                               IF RsvCnt(EndPtr) < 0 THEN RsvCnt(EndPtr) = 0
                       END IF
                       m = 1:j = 1: Tmp$ = Tmp$ + CHR$(13)
                       WHILE Tmp$ <> MID$(Reserved$,j,LEN(Tmp$))
                               j = INSTR(j,Reserved$,CHR$(13)) + 1
                               m = m + 1
                       WEND
                       RsvCnt(m) = RsvCnt(m) + 1
               END IF
               IF Word$ = "END" THEN
                       PrevEnd = True
               ELSE
                       PrevEnd = False
               END IF
       END IF
       RETURN

'-----------------------------------------------------------------------------
'
'-----------------------------------------------------------------------------

SortLabels:
       Max = Lndx - 1
       DO
               Swaped = False
               FOR i = 1 TO Max
                       IF Label$(i) > Label$(i+1) THEN
                               Swap Label$(i), Label$(i+1)
                               Swaped = i
                       END IF
               NEXT i
               IF Swaped THEN Max = Swaped
       LOOP WHILE Swaped <> 0
       RETURN

'-----------------------------------------------------------------------------
'
'-----------------------------------------------------------------------------

SortStrData:
       Max = Sndx - 1
       DO
               Swaped = False
               FOR i = 1 TO Max
                       IF LEN(StrData$(i)) > LEN(StrData$(i+1)) THEN
                               Swap StrData$(i),StrData$(i+1)
                               Swap StrLine(i),StrLine(i+1)
                               Swaped = i
                       END IF
               NEXT i
               IF Swaped THEN Max = Swaped
       LOOP WHILE Swaped <> 0
       RETURN

'-----------------------------------------------------------------------------
'
'-----------------------------------------------------------------------------

PrtStrData:
       IF Pline > 2 THEN GOSUB PrtTof
       PRINT #2,"String Data Reference"
       PRINT #2,""
       PRINT #2," Line Rpt String.............."
       PRINT #2,""
       Pline = Pline + 4
       GOSUB SortStrData
       StrSize = 0: StrSizeAll = 0
       si = 1
       WHILE si <= Sndx
               cnt = 1
               FOR i = si+1 to Sndx
                       IF StrData$(si) = StrData$(i) THEN
                               StrSizeAll = StrSizeAll + LEN(StrData$(i))
                               StrData$(i) = ""
                               Cnt = Cnt + 1
                       END IF
               NEXT i
               PRINT #2,LEFT$(STR$(StrLine(si)) + "     ",5);
               PRINT #2,LEFT$(STR$(Cnt) + "     ",5);
               IF LEN(StrData$) <= 68 THEN
                       PRINT #2,StrData$(si)
               ELSE
                       PRINT #2,LEFT$(StrData$(si),68)
                       PRINT #2,SPACE$(12);MID$(StrData$(si),69)
                       Pline = Pline + 1
               END IF
               StrSize = StrSize + LEN(StrData$(si))
               StrSizeAll = StrSizeAll + LEN(StrData$(si))
               Pline = Pline + 1
               IF Pline >= MaxLines THEN
                       GOSUB PrtTof
               END IF
               si = si + 1
               WHILE si <= Sndx and StrData$(si) = ""
                       si = si + 1
               WEND
       WEND
       IF Pline > MaxLines - 3 THEN GOSUB PrtTof
       PRINT #2,""
       PRINT #2,"String Data Size wo/Minimize: ";StrSizeAll
       PRINT #2," String Data Size w/Minimize: ";StrSize
       Pline = Pline + 3
       RETURN

'-----------------------------------------------------------------------------
'
'-----------------------------------------------------------------------------

PrtTof:
       IF OutFname$ = "SCRN:" AND Pline > 2 THEN
               r = CSRLIN: c = POS(x)
               LOCATE 25,1: PRINT " press any key . . . ";
               WHILE INKEY$ = "": WEND
               LOCATE 25,1: PRINT SPACE$(60);
               LOCATE r,c
       END IF
       PRINT #2,CHR$(12);
       IF NOT Eoj THEN
               PRINT #2,InFname$;TAB(30);"Program Statistics";TAB(60);DATE$;" ";
IME$
               PRINT #2,""
               Pline = 2
       END IF
       RETURN

'-----------------------------------------------------------------------------
'
'-----------------------------------------------------------------------------

XrefLabels:
       IF Switch(Xref) THEN
               GOSUB SortLabels
               IF Pline > 2 THEN GOSUB PrtTof
               PRINT #2,"Program Labels"
               PRINT #2,""
               Pline = Pline + 2
               Type$ = "L"
               CurAlpha$ = MID$(Label$(1),2,1)
               NumLabels = 0: NumVars = 0

               FOR i = 1 to Lndx
                       NewAlpha$ = MID$(Label$(i),2,1)
                       IF NewAlpha$ <> CurAlpha$ THEN
                               PRINT #2,""
                               Pline = Pline + 1
                               IF Pline >= MaxLines THEN GOSUB PrtTof
                               CurAlpha$ = NewAlpha$
                       END IF
                       j = INSTR(2,Label$(i),"/")
                       m = j - 2: IF m > 20 THEN m = 20
                       pl$ = SPACE$(8)+MID$(Label$(i),2,m)
                       IF LEFT$(Label$(i),1) <> Type$ THEN
                               IF Pline >= MaxLines THEN GOSUB PrtTof
                               Type$ = LEFT$(Label$(i),1)
                               IF Type$ = "V" THEN
                                       PRINT #2,LEFT$(STR$(NumLabels)+"     ",5)
" Labels"
                                       PRINT #2,""
                                       Pline = Pline + 2
                                       IF Pline >= MaxLines-8 THEN GOSUB PrtTof
                                       PRINT #2,""
                                       PRINT #2,"Program Variables"
                                       PRINT #2,""
                                       Pline = Pline + 3
                               END IF
                       END IF
                       IF LEFT$(Label$(i),1) = "L" THEN
                               pl$ = pl$ + ":"
                       END IF
                       pl$ = pl$ + STRING$(29-LEN(pl$),".")
                       ll = LEN(Label$(i))
                       FOR n = j+1 to ll Step 2
                               a$ = STR$(CVI(MID$(Label$(i),n,2)))
                               IF (LEN(pl$) + LEN(a$)) > 79 THEN
                                       PRINT #2,pl$
                                       Pline = Pline + 1
                                       IF Pline >= MaxLines THEN GOSUB PrtTof
                                       pl$ = SPACE$(8) + SPACE$(21)
                               END IF
                               pl$ = pl$ + a$
                       NEXT n
                       IF Type$ = "L" THEN
                               NumLabels = NumLabels + 1
                       ELSEIF Type$ = "V" THEN
                               NumVars = NumVars + 1
                       END IF
                       PRINT #2,pl$
                       Pline = Pline + 1
                       IF Pline >= MaxLines THEN GOSUB PrtTof
               NEXT i

               PRINT #2,""
               Pline = Pline + 1
               IF Pline >= MaxLines-1 THEN GOSUB PrtTof
               PRINT #2,LEFT$(STR$(NumVars)+"     ",5);" Variables"
               Pline = Pline + 1
               IF Pline >= MaxLines THEN GOSUB PrtTof
       END IF
       RETURN

'-----------------------------------------------------------------------------
'
'-----------------------------------------------------------------------------

PrtTree:
       IF Pline > 2 THEN GOSUB PrtTof
       PRINT #2,"Program Tree"
       PRINT #2,""
       Pline = Pline + 2
       MaxLevel = Switch(Tree) - 1

       For n = 1 TO Tndx
               Level = 0
               Tree$ = Tree$(n)
               t$ = SPACE$(8)
               ti = 0
               Colon$ = ":"
               PRINT #2,t$;
               WHILE ti < LEN(Tree$)
                       i = INSTR(ti+1,Tree$,"/")
                       IF i > 0 THEN
                               pt$ = MID$(Tree$,ti+1,i-ti-1)
                               PRINT #2,pt$;Colon$
                               Colon$ = ""
                               Pline = Pline + 1
                               IF Pline >= Maxlines THEN GOSUB PrtTof
                               IF ti > 0 THEN
                                       IF MaxLevel > 0 THEN GOSUB TreeSub
                               END IF
                               ti = i
                               IF ti < LEN(Tree$) THEN
                                       PRINT #2,t$;"  ";
                               END IF
                       ELSE
                               ti = LEN(Tree$)
                       END IF
               WEND
               PRINT #2,""
               Pline = Pline + 1
               IF Pline >= Maxlines THEN GOSUB PrtTof
       NEXT n
       RETURN

TreeSub:
       Level = Level + 1
       sp = sp + 2

       TStack(sp-1) = ki
       TStack(sp) = i
       TStack$(sp-1) = Tree$
       TStack$(sp) = pt$

       IF i < LEN(Tree$) THEN
               t$ = t$ + "   "
       ELSE
               t$ = t$ + "    "
       END IF

       i = INSTR(pt$," ")
       Tmp$ = MID$(pt$,i+1) + "/"

       FOR k = 1 TO Tndx
               IF Tmp$ = LEFT$(Tree$(k),LEN(Tmp$)) THEN
                       Tree$ = Tree$(k)
                       ki = INSTR(Tree$,"/")
                       pt$ = LEFT$(Tree$,ki-1)
                       WHILE ki < LEN(Tree$)
                               i = INSTR(ki+1,Tree$,"/")
                               IF i THEN
                                       pt$ = MID$(Tree$,ki+1,i-ki-1)
                                       PRINT #2,t$;"  ";pt$
                                       Pline = Pline + 1
                                       IF Pline >= Maxlines THEN GOSUB PrtTof
                                       ki = i
                                       IF Level < MaxLevel THEN
                                               GOSUB TreeSub
                                       END IF
                               ELSE
                                       ki = LEN(Tree$)
                               END IF
                       WEND
                       EXIT FOR
               END IF
       NEXT k

       pt$ = TStack$(sp)
       Tree$ = TStack$(sp-1)
       i = TStack(sp)
       ki = TStack(sp-1)

       sp = sp - 2
       Level = Level - 1
       t$ = LEFT$(t$,LEN(t$)-4)
       RETURN

'-----------------------------------------------------------------------------
'
'-----------------------------------------------------------------------------

PrtRsvCnt:
       PRINT #2,"Basic Reserved Word Usage"
       PRINT #2,""
       Pline = Pline + 2
       ti = 0: Rndx = 1
       k = 0: NewAlpha$ = " "
       WHILE ti < LEN(Reserved$)
               i = INSTR(ti+1,Reserved$,CHR$(13))
               IF i THEN
                       IF RsvCnt(Rndx) > 0 THEN
                               t$ = MID$(Reserved$,ti+1,i-ti-1)
                               IF Switch(Ver4) THEN
                                       NewAlpha$ = LEFT$(t$,1)
                                       IF NewAlpha$ < CurAlpha$ THEN
                                               IF k <> 0 THEN PRINT #2,"": Pline
= Pline + 1
                                               PRINT #2,""
                                               Pline = Pline + 1
                                               IF Pline >= MaxLines THEN GOSUB P
tTof
                                               k = 0
                                               CurAlpha$ = NewAlpha$
                                       END IF
                               END IF
                               r$ = STR$(RsvCnt(Rndx))
                               r$ = r$ + SPACE$(8 - LEN(r$))
                               PRINT #2,SPACE$(6);SPACE$(10-LEN(t$));t$;r$;
                               k = k + 1
                               IF k >= 3 THEN
                                       k = 0
                                       PRINT #2,""
                                       Pline = Pline + 1
                                       IF Pline >= MaxLines THEN GOSUB PrtTof
                               END IF
                       END IF
                       Rndx = Rndx + 1
                       ti = i
               ELSE
                       ti = LEN(Reserved$)
               END IF
       WEND
       IF k <> 0 THEN PRINT #2,""
       Pline = Pline + 1
       RETURN
