'$linesize:132
'$title:           'READDIR - reads a DOS directory into a string array'
'$subtitle:        'Copyright 1986 Editing Services Co.'
'$page
'
'         Written by Jim Mack and released PD 1/89
'         Comments/suggestions welcome on CompuServe MSSYS [76630,2012]
'
'CALL ReadDir( pathspec$, DirArray$(1), Hits%, ErrCode%)
'
'where:   PathSpec$ is as complete a path and file spec as you care to pass.
'           Example: "*.*" or "thisdir\*.bat" or "c:\pat1\pat2\a??.b??"
'
'         DirArray$() is a one-dimension string array which will contain
'           full file names found in the directory.  Element 0, if it exists,
'           is not used.  For QB4+, UBOUND could replace the following...
'
'         Hits% contains the upper bound (size) of the array DirArray% on
'           entry, and is returned containing the number of filled-in entries
'           in DirArray upon exit.
'
'         ErrCode% is returned non-zero if some abnormal condition exists.
'           It's TRUE (-1) if there were more files than could fit, and > 0
'           for DOS or disk errors, for example "path unavailable" or "drive
'           not ready".
'
'         Two ASM proc are called, FirstHit and NextHit.  They use the default
'           DOS DTA.  If that's a problem (it usually isn't), don't do this.
'
'CALL FirstHit( specz$, FilenameBuffer$, ErrCode%)
'CALL NextHit( FilenameBuffer$, ErrCode%)
'
'where:   Specz$ is the path$ from above, terminated with a chr$( 0).
'           It's only needed the first time (that's why two routines).
'           Note that "normal" files are found, not hidden files or DIRs
'
'         FilenameBuffer$ is a field of 12 spaces into which the name found
'           is left-justified (LSET).  A typical name would be "FILNAM.TXT  "
'           Trailing spaces can be removed inside this routine if desired,
'           but if left in place can help with screen formatting.
'
'         ErrCode% is the DOS return code.  Either code 2 or code 18 must
'           eventually be returned, and mean "no (more) matching files".
'           Other codes are considered actual errors.
'$page
'			DECLARE SUB FirstHit( specz$, buff$, ercod%)		'for QB4+
'			DECLARE SUB NextHit( buff$, ercod%)

      DEFINT A-Z

SUB ReadDir( pathspec$, DirArray$(1), Hits, ErrCode) STATIC

      maxfiles = hits
      hits = 0
      buf$ = space$( 12)
      namebuff$ = buf$
      call FirstHit( pathspec$ + chr$( 0), namebuff$, ErrCode)
      if ErrCode = 0 then
         hits = hits + 1
         DirArray$( hits) = namebuff$
         while ErrCode = 0                      'use DO..LOOP for QB3+
            namebuff$ = buf$
            call NextHit( namebuff$, ErrCode)
            if ErrCode = 0 then
               if hits = maxfiles then
                  ErrCode = -1
               else
                  hits = hits + 1
                  DirArray$( hits) = namebuff$
               end if
            end if
         wend
      end if
      if ErrCode then
         if ErrCode = 2 or ErrCode = 18 then    'normal termination
            ErrCode = 0
         end if
      end if

      namebuff$ = ""     'these not needed if SUB isn't STATIC (QB4+)
      buf$ = ""

END SUB 'readdir

