page 60,132

comment	|
	Copyright 1986, 1989 Editing Services Co. Released PD 1/89

	Written by Jim Mack

	Comments/suggestions welcome on CompuServe MSSYS [76630,2012]

	Contains MASM 5.1 routines to manage drive / directory information

	These are companions to the Basic "ReadDir" procedure which should
	have been attached to this in an ARC file.  See that procedure for
	examples of usage.
	|

	.model medium, basic
	.code
				page +

FirstHit	PROC uses es di si, spec, buff, ercod

comment |
	FirstHit needs SPECZ$, which points to an ASCIIZ string holding a
	 valid path + file spec (including wildcards).  It returns a string
	 with a 12-char file name and an integer result code.  If no matching
	 files are found, the error returned is either 2, for "file not found"
	 or 18, "no more files".  Namebuff$ MUST BE at least 12 bytes long!

	BASIC call:

	CALL FirstHit( specz$, namebuff$, errcode%)
	|

	cld
	mov	bx, spec
	mov	dx, 2[bx]
	xor	cx, cx			;only 'normal files' attribute
	mov	ah, 4eH
	int	21H
	mov	bx, ercod		;put away the return code
	mov	[bx], ax
	or	ax, ax			;test for error
	jnz	@f			;done if any return code
	mov	bx, buff		;get QB string descriptor address
	mov	di, 2[bx]		;address from descriptor
	call	CommonDir		;process DTA into our string
@@:
	ret

FirstHit	ENDP
				page +
CommonDir	PROC NEAR

;	DI has the address of our NameBuff string.  This local PROC
;	locates the DTA name area, and copies bytes into our string.
	
	mov	ah, 2fH			;DOS Get DTA Address call
	int	21H
	mov	si, bx			;ES:BX = DTA address
	add	si, 30			;point SI at filename area of DTA
	mov	cx, 12			;move max 12 bytes from DTA to string
@@:
	mov	al, es:[si]		;read byte from DTA
	or	al, al			;test for end of string
	jz	@f			;quit when Z terminator
	mov	[di], al		;otherwise put into name string
	inc	si
	inc	di
	loop	@b
@@:
	ret

CommonDir	ENDP

NextHit		PROC uses es di si, buff, ercod

comment	|
	NextHit continues the search for files started by FirstHit.
	 It returns a string with a 12-char file name and an integer result
	 code.  If no matching files are found, the code returned is either
	 2 or 18.  Namebuff$ MUST BE at least 12 bytes long!

	BASIC call:

	CALL NextHit( namebuff$, ErrCode%)
	|

	cld
	mov	ah, 4fH
	int	21H
	mov	bx, ercod
	mov	[bx], ax
	or	ax, ax
	jnz	@f
	mov	bx, buff
	mov	di, 2[bx]
	call	CommonDir
@@:
	ret

NextHit		ENDP
				page +
GetDrv		PROC drive

comment	|
	GetDrv returns an integer which indicates the current drive.

	BASIC Call:  Call GetDrv( drive%)

	 Where drive% is 0 for A, 1 for B, etc.
	 No errors can be returned.
	|

	mov	ah, 19H			;get current drive number
	INT	21H
	mov	bx, drive
	cbw
	mov	[bx], ax
	ret

GetDrv		ENDP
				page +
NumDrives	PROC floppies, logical

comment	|
	Returns two values, which can help to determine whether DOS drive B:
	  is a logical or a physical drive, and so help to avoid the DOS
	  message "Insert disk for drive B: ..."

	BASIC Call:	Call NumDrives( floppies%, logical%)

	 floppies% = # of drives as set in the switches
	 logical%  = "lastdrive" as reported by DOS
	|

	int	11H		;BIOS equipment check
	mov	cl, 6		;put bits 6-7 into bits 0-1
	shr	ax, cl
	and	ax, 3		;isolate bits
	inc	ax		;range 0-3 into 1-4
	mov	bx, floppies
	mov	[bx], ax	;report floppies set into switches
	mov	ah, 19H		;get current drive number
	int	21H
	mov	dl, al
	mov	ah, 0eH		;select again and get total
	int	21H
	mov	bx, logical
	cbw
	mov	[bx], ax	;report logical drives available
	ret

NumDrives	ENDP

	END
