'*****************************************************************************
'*                                                                           *
'*                                                                           *
'*                           A R C R E A D . B A S                           *
'*                                                                           *
'*      An example of how to access information stored in .ARC Files         *
'*      Using Microsoft QuickBASIC 4.0                                       *
'*                                                                           *
'*                                                                           *
'*                                    by                                     *
'*                                                                           *
'*                                 Dave Evers                                *
'*                             2500 Larch Rd. #58                            *
'*                             Quincy, IL   62301                            *
'*                                                                           *
'*                                                                           *
'*                                                                           *
'*                                                                           *
'*****************************************************************************

'First define a user defined type (here called ARCHDR) to define the structure
'of the archive header.  The header of .ARC files is standard, as follows:
'
'Byte (within header)       Values                         Meaning
'---------------------------------------------------------------------------
'         1                   1Ah               Archive Header Flag
'         2                   0-9               Type of storage used
'
'                                                 0 -
'                                                 1 - Uncompressed
'                                                 2 - Stored
'                                                 3 - Packed
'                                                 4 - Crunched
'                                                 5 -
'                                                 6 -
'                                                 7 -
'                                                 8 -
'                                                 9 -
'
'         3-15                ---                ASCIIZ Filename
'
'         16-19               ---                Size of file in archive;
'                                                in Long Integer format
'
'         20-21               ---                Date stamp of archived file;
'                                                in DOS format
'
'         22-23               ---                Time Stamp of archived file;
'                                                in DOS format
'
'         24-25               ---                CRC-16 of uncompressed file
'
'         26-29               ---                Original uncompressed file
'                                                size in DOS format
'
'
'                                                Note: Storage Type 1 files
'                                                are not compressed, so this
'                                                number is left off those
'                                                headers; making the header
'                                                only 25 bytes long.  File
'                                                size can be determined by
'                                                bytes 16-19.


                TYPE archdr

                        flag AS STRING * 1       :'String is used since QB 4.0
                        stortype AS STRING * 1   :'has no BYTE variable type.
                        filename AS STRING * 13
                        arcsize AS LONG
                        date AS INTEGER
                        time AS INTEGER
                        crc AS INTEGER
                        fullsize AS LONG
               
                END TYPE

                CLS
                DIM arcrec as archdr
                defint a-z

arcsub:         
                OPEN [arcname$] FOR BINARY AS #1   :'replace [ARCNAME$] with name
                filepos! = 1                       :' of archive file
                WHILE NOT EOF(1)

                        GET #1, , arcrec

                        IF arcrec.stortype = CHR$(0) THEN GOTO endread
                        IF arcrec.stortype = CHR$(1) then hdrsize%=25 else hdrsize%=29
'
'
' The body of your program to process the files in the archive would go here
'
'
'
                        filepos! = filepos! + hdrsize%  :'skip over header

                        filepos! = filepos! + arcrec.arcsize :'using size of
                                                             :'archived file,
                                                             :'skip to next
                                                             :'header
                        SEEK #1, (filepos)

another:        WEND

endread:        close
