     ' Demonstration of one method of creating, storing, and animating an
     ' image.

     DEFINT A-Z

     REDIM OFS&(0 TO 1)
     OFS&(0) = 0                                                 ' offset of video page 0
     OFS&(1) = 32768                                             ' offset of video page 1

     ULC = 10
     ULR = 10
     LRC = 63
     LRR = (LRC - ULC + 1) / 1.37 + ULR - 1
     PLANES = 4
     CALL IMAGESIZE(ULC, ULR, LRC, LRR, PLANES, ELEMENTS&)
     REDIM IMAGE(1 TO ELEMENTS&)                                 ' dimension image array

     DSEG = VARSEG(IMAGE(1))
     DOFS = VARPTR(IMAGE(1))
     PMASK = 15                                                  ' use all four planes
     CALL SETIMAGEHEAD(DSEG, DOFS, ULC, ULR, LRC, LRR, PMASK)    ' set image header

     SCREEN 9,,0,1

     RAD = (LRC - ULC) \ 2
     XC = RAD + ULC
     YC = (LRR - ULR) \ 2 + ULR
     CIRCLE(XC, YC), RAD, 15
     PAINT(XC, YC), 15, 15
     CIRCLE(XC, YC), RAD - 16, 0
     PAINT(XC, YC), 0, 0
     CALL GETMASK(DSEG, DOFS, ULC, ULR, LRC, LRR)                ' store image mask

     BACK = 15
     HFRAME = 0
     VFRAME = 0
     CALL BOXDRAWP(ULC, ULR, LRC, LRR, FORE, BACK, HFRAME, VFRAME)
     CIRCLE(XC, YC), RAD, 1
     PAINT(XC, YC), 1, 1
     CIRCLE(XC, YC), RAD - 4, 2
     PAINT(XC, YC), 2, 2
     CIRCLE(XC, YC), RAD - 8, 12
     PAINT(XC, YC), 12, 12
     CIRCLE(XC, YC), RAD - 12, 15
     PAINT(XC, YC), 15, 15
     CIRCLE(XC, YC), RAD - 16, 15
     PAINT(XC, YC), 15, 15
     CALL GETIMAGE(DSEG, DOFS, ULC, ULR, LRC, LRR)               ' store image data

     CLS
     SCREEN ,,0,0

     CALL BKGRNDSIZE(DSEG, DOFS, ELEMENTS&)
     REDIM BGRND(1 TO ELEMENTS&, 0 TO 1)                         ' dimension the background buffers

     CALL SHOWVIDOFS(OFS&(1))                                    ' display page 1; write to page 0
     Y1 = 0
     Y2 = 349
     COLOUR = 0
     FOR X = 0 TO 639 STEP 10
        CALL ELINE(X, Y1, X, Y2, COLOUR)
        COLOUR = COLOUR + 1
     NEXT X
     BSEG = VARSEG(BGRND(1, 0))
     BOFS = VARPTR(BGRND(1, 0))
     CALL GETBKGRNDM(BSEG, BOFS, DSEG, DOFS, ULC, ULR)           ' initialize page 0 buffer

     CALL SHOWVIDOFS(OFS&(0))                                    ' display page 0
     CALL SETVIDOFS(OFS&(1))                                     ' write to page 1
     COLOUR = 0
     FOR X = 0 TO 639 STEP 10
        CALL ELINE(X, Y1, X, Y2, COLOUR)
        COLOUR = COLOUR + 1
     NEXT X
     BSEG = VARSEG(BGRND(1, 1))
     BOFS = VARPTR(BGRND(1, 1))
     CALL GETBKGRNDM(BSEG, BOFS, DSEG, DOFS, ULC, ULR)           ' initialize page 1 buffer

     ACTIVEPAGE = 1                                              ' write to page 1 first
     ULC = 0
     ULR = 0

     FOR I = 1 TO 300

        BSEG = VARSEG(BGRND(1, ACTIVEPAGE))
        BOFS = VARPTR(BGRND(1, ACTIVEPAGE))
        CALL PUTBKGRND(BSEG, BOFS)                               ' restore background

        CALL GETBKGRNDM(BSEG, BOFS, DSEG, DOFS, ULC, ULR)        ' save background

        CALL PUTIMAGEM(DSEG, DOFS, ULC, ULR)                     ' display image

        ULC = ULC + 1
        ULR = ULR + 1

        CALL SHOWVIDOFS(OFS&(ACTIVEPAGE))                        ' display active page
        ACTIVEPAGE = ACTIVEPAGE XOR 1                            ' toggle active page
        CALL SETVIDOFS(OFS&(ACTIVEPAGE))                         ' set new active page

     NEXT I

     WHILE INKEY$ = "" : WEND
