;************************************************************************
;  The following Library of procedures are:
;
;     Copyrighted (c) 1993 Micro-Phyla Systems  All Rights Reserved
;
;    This code file is copyrighted material. The user is free to use this
;    code and utility in all applications, subject to the inclusion of this
;    copyright notice.
;
;**************************************************************************
;
;  Configuration table
;
;      Field #   Name                         Type   Key
;     
;         1      Module                       A5      *
;         2      Master                       A15     *
;         3      Lookup                       A15     *
;         4      Embedded                     A15     *
;         5      Lookfield                    A20     *
;         6      Field1                       A20
;         7      Field2                       A20
;         8      Field3                       A20
;         9      Field4                       A20
;        10      Originrow                    S
;        11      Origincol                    S
;        12      Searchfield                  A15
;        13      Returnfield                  A15
;        14      Hilitecolor                  S
;        15      Colorbgrd                    S
;        16      Colortrim                    S
;        17      Width                        S
;        18      Height                       S
;        19      Editform                     S
;        20      Formrow                      S
;        21      Formcol                      S
;        22      Formwidth                    S
;        23      Formheight                   S
;        24      Formedit                     A5
;        25      Index                        A15
;
;
;    Details explaination of the code and this utility is explained in the
;    conference paper.
;
;    How to setup a lookup.
;
;    1) Create a formview of the lookup table.
;
;    2) Place the table and this form on the workspace.
;
;    3) On the tableview rotate the fields to the order you want
;       presented to the user.
;
;    4) Using the utility "Tools.sc"  move and resize both windows to the
;       desired size and location.
;
;    5) Using the utility "Tools.sc"  print the window attributes for each
;       window.
;
;    6) Fill in the configuration table.
;
;    7) In your code place the preload procedure:
;
;            ZipLookupPrep_u(configtable_a,module_a)
;
;            Where configtable_a is the name and path to the above
;            configration table and module_a is the module name you
;            have given this group of lookups.
;
;    8) Attach this procedure to the desired key.
;
;                     ZipLookupCall_n()
;
;    9) Somewhere in your data entry code, define the var "prompt_a"
;       IF you want the utility to restore your prompt upon exiting.
;
;     If you have any problems and need advice or assistance I can
;     be contacted through Compuserve at 71333,1775
;
;            Enjoy,
;
;                              John B. Moore
;=====================================================================

; ===========================================================================
; Main callin proc
; ---------------------------------------------------------------------------
PROC ZipLookupCall_n()
        PRIVATE Procname_a,
                keychoice_a,
                keychoice_n,
                keychoice_bag,
                keys_bag,
                oldsearch_a,
                lookfield_a,
                current_r,
                current_h,
                looktable_a,
                lookhandle_w,
                currec_n,
                totalrec_n,
                lookup_a,
                n,
                x,
                buffer_r,
                lastfield_a,
                locate_l
        Procname_a = "ZipLookupCall_n"
        IF ISASSIGNED(g_edit_a) THEN
           IF g_edit_a = "View" THEN
              GeneralMessage_u("You can not use the lookup function  /"+
                               "while in View mode.  Return to Master/"+
                               "and toggle to Edit mode <F9>...      /"+
                               "Anykey returns... /")
              RETURN 1
            ENDIF
        ENDIF
        IF NOT ISBLANK([]) THEN
           GeneralMessage_u("Sorry, you can not use the lookup function/"+
                            "if the current field is filled.  Backspace/"+
                            "the field value and try again..  Anykey.. /")
           RETURN 1
        ENDIF
        ECHO OFF
        ;---verify that this is a lookup field
        lookup_a = UPPER(TABLE()+FIELD())
        lookfield_a = UPPER(FIELD())
        COPYTOARRAY current_r
        WINDOW HANDLE FORM TO current_h
        IF current_h <> 0 THEN
           WINDOW ECHO current_h false
        ELSE
           WINDOW HANDLE IMAGE IMAGENO() TO currenttab_h
        ENDIF
        IF NOT ISASSIGNED(g_lookup_bag[lookup_a]) THEN
           SWITCH
             CASE FIELDTYPE() = "D" :
                RETURN Calendar_n()
             CASE SEARCH(FIELDTYPE(),"NS$")>0 :
                RETURN DT_UTILS_CALCULATOR()
             OTHERWISE:
                  BEEP BEEP
                  MESSAGE "Not a lookup field"
                  SLEEP 1000
          ENDSWITCH
        ELSE
          IF NOT ISWINDOW(g_lookup_bag[g_lookup_bag[lookup_a]]) THEN
               BEEP BEEP MESSAGE "Window handle not valid" SLEEP 2000
               RETURN 1
          ENDIF
          IF RECORDSTATUS("New") THEN
             COPYTOARRAY buffer_r
             DEL
             ;--if record is the only rec in table then you will
             ;  still be on an empty "new" record so you need to
             ;  post that..
             singleblank_l = false
             IF RECORDSTATUS("New") THEN
                 POSTRECORD
                 singleblank_l = true
                 UNLOCKRECORD
             ENDIF
          ELSE
            singleblank_l = false
            POSTRECORD NOPOST LEAVELOCKED
            IF NOT RETVAL THEN
               BEEP BEEP
               MESSAGE "Keyviolation exists, can't load lookup utility"
               RETURN 1
            ENDIF
            UNLOCKRECORD
          ENDIF
           lookhandle_w = g_lookup_bag[g_lookup_bag[lookup_a]]
           looktable_a = g_lookup_bag[lookup_a]

           WINDOW MOVE  lookhandle_w
                TO  g_lookup_bag[looktable_a+"ROW"],
                    g_lookup_bag[looktable_a+"COL"]
           LOCKRECORD UNLOCKRECORD
           WINDOW SELECT  lookhandle_w
           WINDOW SELECT  lookhandle_w
           ;- move any floating windows that might be in the way..
;;;            IF WillwindowCoverButtons_l(lookhandle_w,currentpage_n) THEN
;;;               WaitMouseButtonPutaway_u(currentpage_n)
;;;               replacebutton_l = true
;;;            ELSE
;;;               replacebutton_l = false
;;;            ENDIF
           SETCANVAS lookhandle_w
           WINDOW SCROLL lookhandle_w TO 0,1
           PGUP ;--make sure first record is showing
        ;---set search var...
         oldsearch_a = ""
        ;--paint window
               CANVAS OFF
               WINDOW ECHO lookhandle_w TRUE
               WINDOW ECHO lookhandle_w FALSE
               ZipLookupPaintwindow_u(lookhandle_w,
                                       g_lookup_bag[looktable_a+"HEIGHT"],
                                       g_lookup_bag[looktable_a+"WIDTH"],
                                       g_lookup_bag[looktable_a+"COLOR"],
                                       g_lookup_bag[looktable_a+"TRIM"],
                                      " F9 - FormEdit  Press <Enter> to Select")
              ;-----finally expose the canvas work_.<G>
               CANVAS ON
        ;===============================================================
        ;Begin main loop
        ;---------------------------------------------------------------
           WHILE TRUE
        ;--call key movement control proc
             keychoice_n = ZipLookupEventControl_n(lookhandle_w,
                              g_lookup_bag[looktable_a+"HEIGHT"],
                              g_lookup_bag[looktable_a+"WIDTH"],
                              g_lookup_bag[looktable_a+"COLOR"],
                              g_lookup_bag[looktable_a+"TRIM"],
                              g_lookup_bag[TABLE()+"HILITE"],
                              " F9 - FormEdit  Press <Enter> to Select")
             ;--returns any keypress that requires location of a new
             ;  record and reseting the window
                MOVETO FIELD g_lookup_bag[TABLE()+lookfield_a+"SEARCH"]
                SWITCH
                   CASE keychoice_n = 8:
                            oldsearch_a = ""
                            LOOP
                   CASE keychoice_n = 13 OR    ;Enter to select
                        keychoice_n = 27  :    ;Escape
                             QUITLOOP
                   CASE keychoice_n = 32 OR    ;Spacebar
                        keychoice_n = -81 :    ;Pagedown
                             PGDN
                             oldsearch_a = ""
                   CASE keychoice_n = -73 :    ;Pageup
                             PGUP
                             oldsearch_a = ""
                   CASE keychoice_n = -67 :    ;EDIT RECORD
                        WHILE CHARWAITING()
                           X = GETCHAR()
                        ENDWHILE
                        ;currec_n = RECNO()
                        ZipLookupGetForm_u()
                        IF g_lookup_bag[looktable_a+lookfield_a+"FORMEDIT"] = "false" THEN
                           IMAGERIGHTS READONLY
                        ENDIF
                        ZipLookupFormWait_u()
                        ;MOVETO RECORD currec_n
                        LOOP
                   OTHERWISE:
                     keychoice_a = CHR(keychoice_n)
                     HOME ;--not sure this is needed - test on large table
                     oldsearch_a = oldsearch_a + keychoice_a
                     LOCATE INDEXORDER BESTMATCH oldsearch_a
                ENDSWITCH
           ENDWHILE
           ;====end main loop====================
           MOVETO FIELD g_lookup_bag[looktable_a+lookfield_a+"RETURN"]
           SWITCH
               CASE keychoice_n = 13 AND     ;Enter to select
                    [] <> "<New>" :
                    COPYTOARRAY g_zipselect_r
                     ZipLookupPutAway_u(lookhandle_w)
                     IF current_h = 0 THEN
                        WINDOW SELECT currenttab_h
                     ELSE
                        WINDOW SELECT current_h
                     ENDIF
                     MOVETO current_r[1]
                     IF ISASSIGNED(buffer_r[1]) THEN
                         IF NOT singleblank_l THEN
                             INS
                         ENDIF
                        IMAGERIGHTS
                        COPYFROMARRAY buffer_r
                        MOVETO FIELD lookfield_a
                        [] = g_zipselect_r[g_lookup_bag[looktable_a+lookfield_a+"RETURN"]]
                     ELSE
                        IF RemoteLocate_l(current_r) THEN
                           IMAGERIGHTS
                           MOVETO FIELD lookfield_a
                           [] = g_zipselect_r[g_lookup_bag[looktable_a+lookfield_a+"RETURN"]]
                        ELSE
                           GeneralMessage_u("ERROR !! Locating of current record failed/")
                        ENDIF
                     ENDIF
                     IF ISASSIGNED(pasteselectproc_a) THEN
                        EXECPROC pasteselectproc_a
                     ENDIF
               OTHERWISE:   ;Escape
                     ZipLookupPutAway_u(lookhandle_w)
                     IF current_h <> 0 THEN
                        WINDOW SELECT current_h
                     ELSE
                        WINDOW SELECT currenttab_h
                     ENDIF
                     MOVETO current_r[1]
                     IF ISASSIGNED(buffer_r[1]) THEN
                         IF NOT singleblank_l THEN
                             INS
                         ENDIF
                        COPYFROMARRAY buffer_r
                        MOVETO FIELD lookfield_a
                     ELSE
                        IF RemoteLocate_l(current_r) THEN
                           IMAGERIGHTS
                           MOVETO FIELD lookfield_a
                        ELSE
                           GeneralMessage_u("ERROR !! Locating of current record failed/")
                        ENDIF
                        MOVETO FIELD lookfield_a
                     ENDIF
           ENDSWITCH
        ENDIF
        ;--if you had floating windows to replace you would do it here..
        ;IF replacebutton_l THEN
        ;    WaitMouseButtonsPlace_u(currentpage_n)
        ;ENDIF
        IF ISASSIGNED(prompt_a) THEN
           PROMPT prompt_a
        ENDIF
        IF current_h <> 0 THEN
           WINDOW ECHO current_h true
        ENDIF
        ECHO NORMAL
        RETURN 1
ENDPROC

; ============================================================
; 05-08-93
;  General locate for multi field remote from field locate
; ------------------------------------------------------------
PROC RemoteLocate_l(current_r)
   PRIVATE Procname.a,
           locatevalue_a,
           keys_n,
           n
   Procname.a = "RemoteLocate_l"
   retval = false
   locatevalue_a = ""
   keys_n = NKEYFIELDS(TABLE())
   FOR n FROM 1 TO keys_n
      IF n > 1 THEN
         locatevalue_a = locatevalue_a + ", "
      ENDIF
      locatevalue_a = locatevalue_a + "current_r["+STRVAL(n+1)+"]"
   ENDFOR
   IF keys_n = 1 AND ARRAYSIZE(current_r) > 2 THEN
      locatevalue_a = locatevalue_a + ", current_r[3]"
   ENDIF
   EXECUTE "LOCATE " +locatevalue_a
   RETURN retval
ENDPROC


; ===========================================================================
; A small wait for editing the form
;   This assumes that the var prompt_a exists so it can
;   restore the prompt of your regular edit module
; ---------------------------------------------------------------------------
PROC ZipLookupFormWait_u()
   PRIVATE  Procname_a,
            X
   Procname_a = "ZipLookupFormWait_u"
   CTRLHOME
   PROMPT  "  <INS> - To insert new record  <Esc> - Close   <F1> - HelpFill"
   WAIT RECORD
      PROC "ZipFormWaitproc_u"
      KEY "ALL"
      MOUSE "DOWN"
   ENDWAIT
   IF ISASSIGNED(prompt_a) THEN
      PROMPT prompt_a
   ENDIF
   WHILE CHARWAITING()
      X = GETCHAR()
   ENDWHILE
ENDPROC

; ===========================================================================
; Waitproc for from wait
; ---------------------------------------------------------------------------
PROC ZipFormWaitproc_u(eventype_a,event_bag,cyclenumber_n)
   PRIVATE  Procname_a,
            g_edit_a,
            cfield_a
   Procname_a = "ZipFormWaitproc_u"
   SWITCH
      ;---process events - three types
      CASE eventype_a = "EVENT":
         SWITCH
            CASE event_bag["TYPE"] = "IDLE" : RETURN 0
            CASE event_bag["TYPE"] = "MOUSE" :
                   RETURN ZipMouseFormhandler_n(g_lookup_bag[TABLE()+"FORM"])
            CASE event_bag["TYPE"] = "KEY":
                 SWITCH
                  CASE event_bag["KEYCODE"] = -83 AND
                       ISASSIGNED(g_code_bag[TABLE()+"SOURCE"]) :
                       cfield_a = FIELD()
                       MOVETO FIELD g_code_bag[TABLE()+"TARGET"]
                       IF ISBLANK([]) THEN
                          DEL
                       ELSE
                          MOVETO FIELD cfield_a
                          BEEP BEEP
                       ENDIF
                       RETURN 1
                  CASE event_bag["KEYCODE"] = -59 AND
                     ISASSIGNED(g_action_bag[master_a+module_a+"-59"]):
                     ECHO OFF
                     EXECPROC  g_action_bag[master_a+module_a+"-59"]
                     ECHO NORMAL
                        RETURN retval
                  CASE event_bag["KEYCODE"] = 6 :
                       IF g_lookup_bag[looktable_a+lookfield_a+"FORMEDIT"] = "false" THEN
                          g_edit_a = "View"
                       ELSE
                          g_edit_a = "Edit"
                       ENDIF
                       RETURN WaitFieldViewHandler_n()
                  CASE event_bag["KEYCODE"] = -82 :
                       INS
                       RETURN 1
                  CASE event_bag["KEYCODE"] = -60 OR ;F2 OR ESC
                       event_bag["KEYCODE"] =  27 :
                       IF RECORDSTATUS("New") OR RECORDSTATUS("Modified") THEN
                          POSTRECORD NOPOST LEAVELOCKED
                          IF NOT retval THEN
                             BEEP BEEP
                             MESSAGE "Keyviolation exists, correct before leaving"
                             SLEEP 2000
                             RETURN 1
                          ENDIF
                       ENDIF
                       ZipLookupPutAway_u(g_lookup_bag[TABLE()+"FORM"])
                       WINDOW SELECT  lookhandle_w
                       RETURN 2
                  CASE event_bag["KEYCODE"] >= 40 AND
                       event_bag["KEYCODE"] <= 123:
                       RETURN 0
                  CASE event_bag["KEYCODE"] =  13  AND
                       ISASSIGNED(g_code_bag[TABLE()+"SOURCE"]) :
                       RETURN CodeMaker_n()
                  CASE event_bag["KEYCODE"] =   8 OR
                       event_bag["KEYCODE"] = -80 OR
                       event_bag["KEYCODE"] = -72 OR
                       event_bag["KEYCODE"] =  13 OR
                       event_bag["KEYCODE"] =  32 : RETURN 0
                  OTHERWISE: RETURN 1
                ENDSWITCH
            CASE event_bag["TYPE"] = "MESSAGE": RETURN 1
            OTHERWISE: RETURN 1
         ENDSWITCH
      CASE eventype_a = "DEPARTFIELD" : RETURN 0
      CASE eventype_a = "ARRIVEFIELD" : RETURN 0
      OTHERWISE : RETURN 1
   ENDSWITCH

ENDPROC


; ============================================================
; 11-18-92
; Handles Mouse events in form
; ------------------------------------------------------------
PROC ZipMouseFormhandler_n(handle_w)
   PRIVATE Procname.a,
           orgrow_n,
           orgcol_n
   Procname.a = "ZipMouseFormhandler_n"
    orgrow_n = event_bag["ROW"]
    orgcol_n = event_bag["COL"]
   LOCALIZEEVENT event_bag
      IF ISASSIGNED(handle_w) AND
         event_bag["WINDOW"] = handle_w THEN
         SWITCH
            CASE event_bag["ACTION"] = "DOWN" AND
                  event_bag["ROW"] = 0 :
                     MouseDragWindow_u(handle_w,event_bag["COL"])
                     RETURN 1
            OTHERWISE :
            event_bag["ROW"] = orgrow_n
            event_bag["COL"] = orgcol_n
            RETURN 0
         ENDSWITCH
     ENDIF
     RETURN 1
ENDPROC





; ===========================================================================
; Paints the current window  --leaves canvas off, to be turned on when needed
; ---------------------------------------------------------------------------
PROC ZipLookupPaintwindow_u(winhandle_w,height_n,width_n,
                            color_n,topbottom_n,prompt_a)
   PRIVATE  Procname_a
   Procname_a = "ZipLookupPaintwindow_u"
   SETCANVAS winhandle_w
   ;----paint entire area of window plus row on bottom for info
   PAINTCANVAS ATTRIBUTE color_n
       0,0,height_n-1,width_n-1
   ;----paint top bar for field names
   PAINTCANVAS ATTRIBUTE topbottom_n
       0,0,0,width_n-1
   ;----paint bottom row
   PAINTCANVAS FILL " " ATTRIBUTE topbottom_n
       height_n-1,0,height_n-1,width_n-1
   ;----place help keys
   STYLE ATTRIBUTE topbottom_n
        ;--place text
        ;  search string will be placed at width_n-10 for a max of 10 characters
            @ height_n-1,0
              ;         10        20        30
              ; 1...5....0....5....0....5....0
            ??" PGUP  PGDN         <"+SUBSTR(oldsearch_a,1,7)+">"
    STYLE
  PROMPT prompt_a
ENDPROC



; ===========================================================================
; Moves current lookup window to neverland
; ---------------------------------------------------------------------------
PROC ZipLookupPutAway_u(handle_w)
   PRIVATE  Procname_a
   Procname_a = "ZipLookupPutAway_u"
   WINDOW MOVE handle_w TO -500, -500
ENDPROC




; ===========================================================================
; Closes current lookup windows and releases global vars_.
; ---------------------------------------------------------------------------
PROC ZipLookupClose_u()
   PRIVATE  Procname_a,
            n
   Procname_a = "ZipLookupClose_u"
   IF ISASSIGNED(g_ziphandle_bag) THEN
     FOREACH n IN g_ziphandle_bag
       IF ISWINDOW(g_ziphandle_bag[n]) THEN
          WINDOW SELECT g_ziphandle_bag[n]
          WINDOW CLOSE
        ENDIF
     ENDFOREACH
     RELEASE VARS g_ziphandle_bag,g_lookup_bag
  ENDIF
ENDPROC



; ===========================================================================
; controls interaction with lookup window movement keys
; -------------------------------------------------------------------------
PROC ZipLookupEventControl_n(handle_w,height_n,width_n,
                             color_n,trim_n,hilite_n,prompt_a)
   PRIVATE  Procname_a,
            current_n,
            keys_bag,
            recordrows_n,
            rec_n,
            wincheck_bag,
            tablerec_n,
            keychoice_bag,
            choice_v
   Procname_a = "ZipLookupKeyControl_n"
   ;--place the current record in the top row, first field
   CURSOR OFF
   WINDOW SCROLL handle_w TO RECNO()-1,1
   ;--verify height of window LESS frame
      WINDOW GETATTRIBUTES handle_w TO wincheck_bag
      IF  wincheck_bag["HASFRAME"] THEN
          recordrows_n = wincheck_bag["HEIGHT"] -4
      ELSE
          recordrows_n = wincheck_bag["HEIGHT"] -2
      ENDIF
   current_n = 1
   WHILE TRUE
      ECHO OFF
      CANVAS OFF
      WINDOW ECHO handle_w TRUE
      WINDOW ECHO handle_w FALSE
      ZipLookupPaintwindow_u(handle_w,height_n,width_n,color_n,trim_n,prompt_a)
      ZipLookupHiliteCurrent_u(hilite_n,current_n,width_n)
      ;-----finally expose the canvas work_.<G>
      CANVAS ON
      ECHO NORMAL
      ;--trap any stray keyboard input...
      WHILE CHARWAITING()
         X = GETCHAR()
      ENDWHILE
      GETEVENT KEY "ALL"
               MOUSE "DOWN" TO  keychoice_bag
      CANVAS OFF
      ZipLookupHiliteCurrent_u(color_n,current_n,width_n)
      totalrec_n = NRECORDS(TABLE())
      SWITCH
         CASE keychoice_bag["TYPE"] = "MOUSE":
           choice_v = ZipMousehandler_v()
         OTHERWISE:
           choice_v = ZipKeyhandler_v()
       ENDSWITCH
       ;--evaluate choice value
       IF choice_v <> true THEN QUITLOOP ENDIF
   ENDWHILE
   RETURN choice_v
ENDPROC


; ============================================================
; 11-17-92
;  Mouse key handler
;   -- returns a reassigned key event or true
; ------------------------------------------------------------
PROC ZipMousehandler_v()
   PRIVATE Procname.a,
           orgrow_n,
           orgcol_n
   Procname.a = "ZipMousehandler_v"
    orgrow_n = keychoice_bag["ROW"]
    orgcol_n = keychoice_bag["COL"]
   LOCALIZEEVENT keychoice_bag
      IF ISASSIGNED(handle_w) AND
         keychoice_bag["WINDOW"] = handle_w THEN
         SWITCH
            CASE keychoice_bag["ACTION"] = "DOWN" AND
                  keychoice_bag["ROW"] <> 0 :
                 IF keychoice_bag["ROW"] = height_n - 1 THEN
                    ;--mouse action is on the speedbar
                     SWITCH
                        ;--page up
                        CASE (keychoice_bag["COL"] >= 0 AND
                              keychoice_bag["COL"] <= 5) :
                              keychoice_bag["TYPE"] = "KEY"
                              keychoice_bag["KEYCODE"] = -73
                              RETURN keychoice_bag["KEYCODE"]
                        ;--page down
                        CASE (keychoice_bag["COL"] >= 6 AND
                              keychoice_bag["COL"] <= 12):
                              keychoice_bag["TYPE"] = "KEY"
                              keychoice_bag["KEYCODE"] = -81
                              RETURN keychoice_bag["KEYCODE"]
                        ;--enter select
                        CASE (keychoice_bag["COL"] >= 14 AND
                              keychoice_bag["COL"] <= 17) :
                              keychoice_bag["TYPE"] = "KEY"
                              keychoice_bag["KEYCODE"] = 13
                              RETURN keychoice_bag["KEYCODE"]
                        ;---up arrow key
                        CASE (keychoice_bag["COL"] >= 18 AND
                              keychoice_bag["COL"] <= 21):
                              keychoice_bag["TYPE"] = "KEY"
                              keychoice_bag["KEYCODE"] = -72
                              rec_n = RECNO()
                              IF current_n = 1 THEN
                                 IF totalrec_n - rec_n < recordrows_n THEN
                                    MOVETO RECORD totalrec_n
                                    current_n = totalrec_n - rec_n + 1
                                 ELSE
                                    MOVETO RECORD rec_n + recordrows_n - 1
                                    current_n = recordrows_n
                                 ENDIF
                              ELSE
                                 current_n = current_n - 1
                                 EXECEVENT keychoice_bag
                              ENDIF
                              RETURN true
                        ;---down arrow key
                        CASE (keychoice_bag["COL"] >= 22 AND
                              keychoice_bag["COL"] <= 26) :
                              keychoice_bag["TYPE"] = "KEY"
                              keychoice_bag["KEYCODE"] =  -80  ; DOWN KEYPRESS
                              rec_n = RECNO()
                              IF current_n = recordrows_n
                                 OR ATLAST() THEN
                                 MOVETO RECORD rec_n -(recordrows_n - 1)
                                 current_n = 1
                              ELSE
                                 current_n = current_n + 1
                                 EXECEVENT keychoice_bag
                              ENDIF
                              RETURN true
                        OTHERWISE:  RETURN true
                     ENDSWITCH
                  ELSE RETURN true
                  ENDIF
            CASE keychoice_bag["ACTION"] = "DOWN" AND
                  keychoice_bag["ROW"] = 0 :
                     MouseDragWindow_u(handle_w,keychoice_bag["COL"])
                     RETURN true
            OTHERWISE : RETURN true
         ENDSWITCH
     ENDIF
     RETURN true
ENDPROC


; ============================================================
; 11-17-92
; Controls the draging of a window with the mouse
;
; ------------------------------------------------------------
PROC MouseDragWindow_u(handle_w,startlocalcol_n)
   PRIVATE Procname.a,
           drag_bag,
           orgrow_n,
           orgcol_n
   Procname.a = "MouseDragWindow_u"
   WHILE TRUE
      GETEVENT  MOUSE "MOVE",  "UP" TO  drag_bag
      ;--grab absolute coordinates
      orgrow_n = drag_bag["ROW"]
      orgcol_n = drag_bag["COL"]
      LOCALIZEEVENT drag_bag
      SWITCH
        CASE drag_bag["ACTION"] = "UP" :
           ;--cancel drag
           QUITLOOP
        CASE drag_bag["ACTION"] = "MOVE" :
           ;---move relative to current location
           WINDOW MOVE handle_w TO orgrow_n, orgcol_n - startlocalcol_n
           ;--reset relative global mouse coordinates..
           ;drag_bag["ROW"] = orgrow_n
           ;drag_bag["COL"] = orgcol_n
        OTHERWISE:
         LOOP
      ENDSWITCH
  ENDWHILE
ENDPROC

; ============================================================
; 11-17-92
; CONTROLS KEY EVENTS
;   --returns keycode or true
; ------------------------------------------------------------
PROC ZipKeyhandler_v()
   PRIVATE Procname.a
   Procname.a = "ZipKeyhandler_v"
   SWITCH
      ;---these first two cases only pass the keycode back to the
      ;   calling proc to be delt with there, because they will
      ;   involve changing the window records.
      CASE keychoice_bag["KEYCODE"]   > 40 AND
         keychoice_bag["KEYCODE"]   < 123:
                  RETURN keychoice_bag["KEYCODE"]
      CASE keychoice_bag["KEYCODE"] =   32 OR
         keychoice_bag["KEYCODE"] =   -81 OR
         keychoice_bag["KEYCODE"] =   -73 OR
         keychoice_bag["KEYCODE"] =   -67 OR
         keychoice_bag["KEYCODE"] =   13 OR
         keychoice_bag["KEYCODE"] =   8 OR
         keychoice_bag["KEYCODE"] =   27:
                  RETURN keychoice_bag["KEYCODE"]
      ;---the next group of cases control the arrow, home/end keys
      ;   within a single group of records in the current window
      CASE keychoice_bag["KEYCODE"] =  -72 : ; UP KEYPRESS
         rec_n = RECNO()
         IF current_n = 1 THEN
            IF totalrec_n - rec_n < recordrows_n THEN
               MOVETO RECORD totalrec_n
               current_n = totalrec_n - rec_n + 1
            ELSE
               MOVETO RECORD rec_n + recordrows_n - 1
               current_n = recordrows_n
            ENDIF
         ELSE
            current_n = current_n - 1
            EXECEVENT keychoice_bag
         ENDIF
         RETURN true
      CASE keychoice_bag["KEYCODE"] =  -80 : ; DOWN KEYPRESS
         rec_n = RECNO()
         IF current_n = recordrows_n
            OR ATLAST() THEN
            MOVETO RECORD rec_n -(recordrows_n - 1)
            current_n = 1
         ELSE
            current_n = current_n + 1
            EXECEVENT keychoice_bag
         ENDIF
         RETURN true
      CASE keychoice_bag["KEYCODE"] =  -71 : ; HOME KEYPRESS
         rec_n = RECNO()
         IF current_n = 1 THEN
            BEEP
         ELSE
            MOVETO RECORD rec_n -(current_n - 1)
            current_n = 1
         ENDIF
         RETURN true
      CASE keychoice_bag["KEYCODE"] =  -79 : ; END KEYPRESS
         rec_n = RECNO()
         IF current_n = recordrows_n THEN
            BEEP
         ELSE
            MOVETO RECORD rec_n + (recordrows_n - current_n)
            current_n = recordrows_n         ENDIF
         RETURN true
      OTHERWISE : BEEP
      RETURN true
   ENDSWITCH
ENDPROC

; ===========================================================================
; Hilights the current record
; ---------------------------------------------------------------------------
PROC ZipLookupHiliteCurrent_u(color_n,currentrow_n,width_n)
   PRIVATE  Procname_a
   Procname_a = "ZipLookupHiliteCurrent_u"
   PAINTCANVAS ATTRIBUTE color_n
      currentrow_n,1,currentrow_n,width_n-2
ENDPROC




; ===========================================================================
; Sets up lookup tables
; ---------------------------------------------------------------------------
PROC ZipLookupPrep_u(configtable_a,module_a)
        PRIVATE Procname_a,
                zwin_r,
                zipattr_bag,
                form_bag,
                confighandle_a,
                lastlookup_a,
                lastembedded_a
        Procname_a = "ZipLookupPrep_u"
        VIEW configtable_a
        WINDOW HANDLE IMAGE IMAGENO() TO confighandle_a
        MOVETO [Module]
        LOCATE module_a
        IF retval  THEN
           ;-create dynarray to hold window handles
           DYNARRAY g_ziphandle_bag[]
           ;-create dynarray to hold window attributes
           DYNARRAY g_lookup_bag[]
           WHILE [] = module_a
               COPYTOARRAY zwin_r
               VIEW zwin_r["Lookup"]
               IF ISASSIGNED(g_errorflag_l) AND
                   g_errorflag_l  THEN
                  ;---resource conflict occured cancel opperation
                  GeneralMessage_u("A lookup table was NOT availible to load/"+
                                   "it will NOT be available for this module/"+
                                   "Exit module and reload to reactivate    /"+
                                   "lookup table in this module.            /"+
                                   "AnyKey continues.../")
                  IF ATLAST() THEN QUITLOOP ELSE LOOP ENDIF
               ENDIF
               ;--put handle into dynarray, using table name as tag
               WINDOW HANDLE IMAGE IMAGENO() TO g_ziphandle_bag[UPPER(TABLE())]
               WINDOW HANDLE IMAGE IMAGENO() TO g_lookup_bag[UPPER(TABLE())]
               ;--first  we'll pull all the fields together in the
               ;  proper order
               CTRLHOME
               IF FIELD() = "#" THEN RIGHT ENDIF
               IF zwin_r["Field1"] <> "" THEN
                  WHILE FIELD() <>  zwin_r["Field1"] ROTATE ENDWHILE
                  RIGHT
               ENDIF
               IF zwin_r["Field2"] <> "" THEN
                  WHILE FIELD() <>  zwin_r["Field2"] ROTATE ENDWHILE
                  RIGHT
               ENDIF
               IF zwin_r["Field3"] <> "" THEN
                  WHILE FIELD() <>  zwin_r["Field3"] ROTATE ENDWHILE
                  RIGHT
               ENDIF
               IF zwin_r["Field4"] <> "" THEN
                  WHILE FIELD() <>  zwin_r["Field4"] ROTATE ENDWHILE
                  RIGHT
               ENDIF
               ;-- set the window attributes
               DYNARRAY zipattr_bag[]
                 zipattr_bag["CANRESIZE"]  = FALSE
                 zipattr_bag["CANCLOSE"]   = FALSE
                 zipattr_bag["CANMAXIMIZE"]= FALSE
                 zipattr_bag["HASFRAME"]   = FALSE
                 zipattr_bag["HEIGHT"]     = zwin_r["Height"]
                 zipattr_bag["WIDTH"]      = zwin_r["Width"]
               ;---set window attributes
               WINDOW SETATTRIBUTES g_lookup_bag[UPPER(zwin_r["Lookup"])] FROM zipattr_bag
               WINDOW MOVE g_lookup_bag[zwin_r["Lookup"]] TO -500,-500
               ;---set first field as the first column of window
               WINDOW SCROLL g_lookup_bag[UPPER(zwin_r["Lookup"])] to 0,1
               ;---assign window parameters to global dynarray
               g_lookup_bag[zwin_r["Lookup"]+"ROW"] = zwin_r["Originrow"]
               g_lookup_bag[zwin_r["Lookup"]+"COL"] = zwin_r["Origincol"]
               g_lookup_bag[zwin_r["Lookup"]+zwin_r["Lookfield"]+"SEARCH"] = zwin_r["Searchfield"]
               g_lookup_bag[zwin_r["Lookup"]+zwin_r["Lookfield"]+"RETURN"] = zwin_r["Returnfield"]
               g_lookup_bag[zwin_r["Lookup"]+"HILITE"] = zwin_r["Hilitecolor"]
               g_lookup_bag[zwin_r["Lookup"]+"COLOR"] = zwin_r["Colorbgrd"]
               g_lookup_bag[zwin_r["Lookup"]+"TRIM"] = zwin_r["Colortrim"]
               g_lookup_bag[zwin_r["Lookup"]+zwin_r["Lookfield"]+"FIELD"] = zwin_r["Lookfield"]
               g_lookup_bag[zwin_r["Lookup"]+"WIDTH"] = zwin_r["Width"]
               g_lookup_bag[zwin_r["Lookup"]+"HEIGHT"] = zwin_r["Height"]
               g_lookup_bag[zwin_r["Embedded"]+zwin_r["Lookfield"]] = zwin_r["Lookup"]
               ;--set default form for edit
                  Pickform zwin_r["Editform"]
                     WINDOW HANDLE FORM TO g_lookup_bag[zwin_r["Lookup"]+"FORM"]
                     WINDOW HANDLE FORM TO g_ziphandle_bag[TABLE()+"FORM"]
                     DYNARRAY form_bag[]
                        form_bag["ORIGINROW"] = zwin_r["Formrow"]
                        form_bag["ORIGINCOL"] = zwin_r["Formcol"]
                        form_bag["WIDTH"] = zwin_r["Formwidth"]
                        form_bag["HEIGHT"] = zwin_r["Formheight"]
                        form_bag["HASFRAME"] = false
                ;---now move table to neverland
                WINDOW MOVE g_lookup_bag[zwin_r["Lookup"]+"FORM"] TO -500,-500

               WINDOW SETATTRIBUTES g_ziphandle_bag[TABLE()+"FORM"] FROM form_bag
               ;---transfer row and col settings to global bag
               g_lookup_bag[zwin_r["Lookup"]+"FORMROW"] = form_bag["ORIGINROW"]
               g_lookup_bag[zwin_r["Lookup"]+"FORMCOL"] = form_bag["ORIGINCOL"]
               g_lookup_bag[zwin_r["Lookup"]+zwin_r["Lookfield"]+"FORMEDIT"] = zwin_r["Formedit"]

               WINDOW SELECT confighandle_a
               ;---move down to next
               IF ATLAST() THEN QUITLOOP ENDIF
               lastlookup_a = [Lookup]
               DOWN
               WHILE [] = module_a AND
                     [Lookup] = lastlookup_a
                  g_lookup_bag[[Lookup]+[Lookfield]+"SEARCH"] = [Searchfield]
                  g_lookup_bag[[Lookup]+[Lookfield]+"RETURN"] = [Returnfield]
                  g_lookup_bag[[Lookup]+[Lookfield]+"FIELD"] = [Lookfield]
                  g_lookup_bag[[Lookup]+[Lookfield]+"FORMEDIT"] = [Formedit]
                  g_lookup_bag[[Embedded]+[Lookfield]] = [Lookup]
                  IF ATLAST() THEN QUITLOOP ENDIF
                  DOWN
               ENDWHILE
            ENDWHILE
       ELSE
         MESSAGE "NO TABLES TO CONFIGURE"
         SLEEP 2000
         MESSAGE ""
       ENDIF
       WINDOW SELECT confighandle_a
       WINDOW CLOSE
       ;--load any expand windows
       ZipExpandfieldPrep_u("C\\expndcfg",module_a)
ENDPROC

; ===========================================================================
; Retreives form for current table
; ---------------------------------------------------------------------------
PROC ZipLookupGetForm_u()
   PRIVATE  Procname_a
   Procname_a = "ZipLookupGetForm_u"
     WINDOW MOVE g_lookup_bag[TABLE()+"FORM"] TO
                 g_lookup_bag[TABLE()+"FORMROW"],
                 g_lookup_bag[TABLE()+"FORMCOL"]
     WINDOW SELECT g_lookup_bag[TABLE()+"FORM"]
ENDPROC

; ============================================================
; 09-07-92
; General message utility
;  -each "line" must be followed by a "/"
; ------------------------------------------------------------
PROC GeneralMessage_u(text_a)
   PRIVATE Procname_a,
           dialog_w,
           lines_n,
           maxline_n,
           row_n,
           column_n,
           oldcolor_bag,
           newcolor_bag,
           oldcanvas_h
   Procname.a = "GeneralMessage_u"
     DYNARRAY message_bag[]
     lines_n = 1
     maxline_n = 0
     WHILE MATCH(text_a,"../..",message_bag[STRVAL(lines_n)],text_a)
          maxline_n = MAX(LEN(message_bag[STRVAL(lines_n)]),maxline_n)
          lines_n = lines_n +1
     ENDWHILE
     IF lines_n = 0 THEN
        maxline_n = LEN(text_a)
     ENDIF
     row_n = INT((23 -lines_n+4)/2)
     column_n = INT((79-maxline_n+4)/2)
      GETCOLORS TO oldcolor_bag
        DYNARRAY newcolor_bag[]
           newcolor_bag[1032] = 32
           newcolor_bag[1031] = 32
           newcolor_bag[1045] = 32
           newcolor_bag[1036] = 32
           newcolor_bag[1042] = 78
        SETCOLORS FROM newcolor_bag
        BEEP BEEP SLEEP 100 BEEP BEEP SLEEP 100 BEEP BEEP

  SHOWDIALOG "Message"
      PROC "InsertMessage_u" TRIGGER "OPEN"
     @row_n,column_n HEIGHT lines_n + 4 WIDTH maxline_n +4

     PUSHBUTTON @lines_n,INT((maxline_n/2)-6) WIDTH 12
        "Continue"
        OK
        DEFAULT
        VALUE true
        TAG "continue"
        TO okkey_l
  ENDDIALOG
  SETCOLORS FROM oldcolor_bag
  SETCANVAS DEFAULT
ENDPROC

; ============================================================
; 09-07-92
; A dialog proc for inserting message into GeneralMessage_u
;  --the vars a,b,c,d are dummy place holders
; ------------------------------------------------------------
PROC InsertMessage_u(a,b,c,d)
   PRIVATE Procname.a,
           n
   Procname.a = "InsertMessage_u"
      WINDOW HANDLE DIALOG TO dialog_w
      SETCANVAS dialog_w
      FOR n FROM 1 TO lines_n - 1
       @ n-1 ,1
         ?? FORMAT("W"+STRVAL(maxline_n)+",AC",message_bag[STRVAL(n)])
      ENDFOR
      PAINTCANVAS ATTRIBUTE 32 0,1,lines_n+1,maxline_n+1
ENDPROC

