
; WINDOW TOOLS

; ===========================================================================
; Toggles frame off and on
; ---------------------------------------------------------------------------
PROC ToggleFrame_u()
        PRIVATE Procname_a,
                win_bag
        Procname_a = "ToggleFrame_u"
        IF GETWINDOW() = 0 THEN
           BEEP MESSAGE "Hey dude, Where's the window..??"
                SLEEP 2000
                RETURN
        ENDIF
        WINDOW GETATTRIBUTES GETWINDOW() TO win_bag
        SWITCH
           CASE win_bag["HASFRAME"] = TRUE :
                win_bag["HASFRAME"] = FALSE
           CASE win_bag["HASFRAME"] = FALSE :
                win_bag["HASFRAME"] = TRUE
        ENDSWITCH
        WINDOW SETATTRIBUTES GETWINDOW() FROM win_bag
ENDPROC

; ===========================================================================
; Places window attribute in canvas window.   Adapted from manual
; ---------------------------------------------------------------------------
PROC ShowWindowAttr_u()
        PRIVATE Procname_a,
                n,
                display_h,
                win_bag,
                X
        Procname_a = "ShowWindowAttr_u"
        IF GETWINDOW() = 0 THEN
           BEEP MESSAGE "Hey dude, Where's the window..??"
                SLEEP 2000
                RETURN
        ENDIF
        WINDOW GETATTRIBUTES GETWINDOW() TO win_bag
        WINDOW CREATE @1,25 HEIGHT 23 WIDTH 25 TO display_h
        FOREACH n IN win_bag
              ? n," = ", win_bag[n]
        ENDFOREACH
        X = GETCHAR()
        WINCLOSE
ENDPROC

; ===========================================================================
; Prints current window Attributes
; ---------------------------------------------------------------------------
PROC PrintWindowAttr_u()
        PRIVATE Procname_a,
                win_bag,
                n
        Procname_a = "PrintWindowAttr_u"
        IF GETWINDOW() = 0 THEN
           BEEP MESSAGE "Hey dude, Where's the window..??"
                SLEEP 2000
                RETURN
        ENDIF
        WINDOW GETATTRIBUTES GETWINDOW() TO win_bag
        OPEN PRINTER
        PRINT FORMAT("W80,AC","WINDOW ATTRIBUTES FOR CURRENT WINDOW"),
              FORMAT("W80,AC",FILL("*",30)),"\n\n\n"
        FOREACH n IN win_bag
              PRINT SPACES(5),
                  FORMAT("W15,AL", n), " = ",
                  FORMAT("W25,AL",win_bag[n]),"\n"
        ENDFOREACH
        PRINT "\f"
        CLOSE PRINTER
ENDPROC

; ===========================================================================
; Drops the frame, shadow and maximizes the size of the window
; ---------------------------------------------------------------------------
PROC ToggleNoframeMaxsize_u()
        PRIVATE Procname_a,
                win_bag
        Procname_a = "ToggleNoframeMaxsize_u"
        IF GETWINDOW() = 0 THEN
           BEEP MESSAGE "Hey dude, Where's the window..??"
                SLEEP 2000
                RETURN
        ENDIF
        WINDOW GETATTRIBUTES GETWINDOW() TO win_bag
        SWITCH
           CASE win_bag["HASFRAME"] = TRUE :
                win_bag["HASFRAME"] = FALSE
                win_bag["HASSHADOW"] = FALSE
                win_bag["MAXIMIZED"] = TRUE
           CASE win_bag["HASFRAME"] = FALSE :
                win_bag["HASFRAME"] = TRUE
                win_bag["HASSHADOW"] = TRUE
                win_bag["MAXIMIZED"] = FALSE
        ENDSWITCH
        WINDOW SETATTRIBUTES GETWINDOW() FROM win_bag
ENDPROC


; ===========================================================================
; Resize window
; ---------------------------------------------------------------------------
PROC SizeMoveWindow_u()
   PRIVATE  Procname_a
   Procname_a = "SizeMoveWindow_u"
        IF GETWINDOW() = 0 THEN
           BEEP MESSAGE "Hey dude, Where's the window..??"
                SLEEP 2000
                RETURN
        ENDIF
        WINRESIZE
ENDPROC


; ===========================================================================
; Moves to next window if present
; ---------------------------------------------------------------------------
PROC WindowNext_u()
   PRIVATE  Procname.a
   Procname.a = "WindowNext_u"
        IF GETWINDOW() < 2 THEN
           BEEP MESSAGE "Hey dude, Where's the other window..??"
                SLEEP 2000
                RETURN
        ENDIF
        WINNEXT

ENDPROC


; ===========================================================================
; Prints all Attributes for desktop  windows
; ---------------------------------------------------------------------------
PROC PrintAllWindowAttr_u()
        PRIVATE Procname_a,
                win_bag,
                n,
                W
        Procname_a = "PrintAllWindowAttr_u"
        IF GETWINDOW() = 0 THEN
           BEEP MESSAGE "Hey dude, Where's the window..??"
                SLEEP 2000
                RETURN
        ENDIF
        OPEN PRINTER
        WINDOW LIST TO winlist_r
        FOR W FROM 1 TO ARRAYSIZE(winlist_r)
            WINDOW SELECT winlist_r[W]
            WINDOW GETATTRIBUTES GETWINDOW() TO win_bag
            PRINT FORMAT("W80,AC","WINDOW ATTRIBUTES FOR CURRENT WINDOW"),
                  FORMAT("W80,AC",FILL("*",30)),"\n\n\n"
            FOREACH n IN win_bag
                  PRINT SPACES(5),
                        FORMAT("W15,AL", n), " = ",
                        FORMAT("W25,AL",win_bag[n]),"\n"
            ENDFOREACH
            PRINT "\f"
        ENDFOR
            CLOSE PRINTER
ENDPROC

; ===========================================================================
; gets and lists the handles/titles/origin location/size of all current
; windows on the desktop  and sends info to printer so as to not distrub
; the current environment
; ---------------------------------------------------------------------------
PROC GetWindowInfo_u(break_a)
   PRIVATE  Procname.a,
            currentstuff,
            N,
            windowhandlelist_r,
            X,
            wininfo_bag
   Procname.a = "GetWindowInfo_u"
   OPEN PRINTER
     PRINT  FORMAT("W80,AC","* * * CURRENT WORKSPACE STATUS PRINTOUT * * *"),"\n\n",
            "BREAK POINT DISCRIPTION: ", break_a, "\n\n",
             FORMAT("W80,AC",FILL("",60)),"\n\n"
   DYNARRAY  currentstuff[]
   ;--find current status of windows
     ;current window
        currentstuff["CURRENT_WINDOW_HANDLE_GETWINDOW"] = GETWINDOW()
        WINDOW HANDLE CURRENT TO currentstuff["CURRENT_WINDOW_HANDLE_CURRENT"]
        WINDOW HANDLE FORM TO currentstuff["CURRENT_WINDOW_HANDLE_FORM"]
        WINDOW HANDLE DIALOG TO currentstuff["CURRENT_WINDOW_HANDLE_DIALOG"]
     ;current image
        WINDOW HANDLE IMAGE IMAGENO() TO currentstuff["CURRENT_IMAGE_HANDLE"]
     ;current canvas
        currentstuff["CURRENT_CANVAS_HANDLE"] = GETCANVAS()
     ;current image number
        currentstuff["CURRENT_IMAGE_NUMBER"] = IMAGENO()
     ;current image type
        currentstuff["CURRENT_IMAGETYPE_WHERE_CURSOR_IS"] = IMAGETYPE()
     ;number of current images
        currentstuff["CURRENT_NUMBER_OF_IMAGES"] = NIMAGES()
     ;---------print current status
        PRINT  FORMAT("W80,AC",">> Current positions <<"),"\n",
               FORMAT("W80,AC",FILL("",25)),"\n"
               FOREACH N IN currentstuff
                  PRINT SPACES(5),
                        FORMAT("W35,AL",N), " = ",
                        FORMAT("W20,AL",currentstuff[N]),"\n"
               ENDFOREACH
     ;---------window analysis
        PRINT  FORMAT("W80,AC",">> Window Info in Z order, Highest first <<"),"\n",
               FORMAT("W80,AC",FILL("",40)),"\n\n"
     ;number of current window handles
        WINDOW LIST TO windowhandlelist_r
        FOR X FROM 1 TO ARRAYSIZE(windowhandlelist_r)
             WINDOW GETATTRIBUTES windowhandlelist_r[X] TO wininfo_bag
               IF wininfo_bag["FLOATING"] THEN
                  PRINT FILL("*",5),
                        FORMAT("W15,AL","Window handle" ), " = ",
                        FORMAT("W20,AL",windowhandlelist_r[X]),
                        "  THIS WINDOW IS ABOVE THE GLOBAL ECHO LAYER","\n"
               ELSE
                  PRINT FILL(".",5),
                        FORMAT("W15,AL","Window handle" ), " = ",
                        FORMAT("W20,AL",windowhandlelist_r[X]),"\n"
               ENDIF
               FOREACH N IN wininfo_bag
                  PRINT SPACES(10),
                        FORMAT("W20,AL",N), " = ",
                        FORMAT("W20,AL",wininfo_bag[N]),"\n"
               ENDFOREACH
                   PRINT "\n\n"
        ENDFOR
        PRINT "\f"
     CLOSE PRINTER
ENDPROC
;Endproc.u("GetWindowInfo_u")



; ============================================================
; 09-09-92
; Grabs screen into an array
; ------------------------------------------------------------
PROC FormGrabScreen_u()
   PRIVATE Procname_a
   Procname_a = "FormGrabScreen_u"
   IF SYSMODE() = "Form" THEN
      ARRAY formline_r[22]
      CTRLHOME HOME
      FOR n FROM 1 TO 22
         formline_r[n] = CURSORLINE()
         DOWN
      ENDFOR
   ELSE BEEP BEEP
   ENDIF
ENDPROC


; ============================================================
; 09-09-92
; Pastes array formline_r to formm
; ------------------------------------------------------------
PROC FormPasteScreen_u()
   PRIVATE Procname.a
   Procname.a = "FormPasteScreen_u"
   IF SYSMODE() = "Form" AND
      ISASSIGNED(formline_r[1]) THEN
      CTRLHOME HOME
      FOR n FROM 1 TO 22
         TYPEIN formline_r[n]
         DOWN
      ENDFOR
   ELSE BEEP BEEP
   ENDIF
ENDPROC






; ===========================================================================
; Popup menu for window tools
; ---------------------------------------------------------------------------
PROC WinToolsMenu_u()
        PRIVATE Procname_a,
                choice_a
        Procname_a = "WinToolsMenu_u"
    ECHO NORMAL
    WHILE TRUE
        SHOWPOPUP " Window Tools " @2,2
           "Toggle~F~rame" : "Toggles window frame on/off" : "frame",
           "Show Attributes" : "Shows Window Attributes on Screen" : "show",
           "Print Attributes" : "Print Window Attributes" : "print",
           "ToggleSize" : "Toggles max to min size of window" : "size",
           "Size~M~ove" : "Use Arrowkeys and Shift-Arrow to move and resize":"resize",
           "RotateWindows": "Rotate through desktop windows":"next",
           "Print~A~ll Attributes": "Print all window Attributes":"printall",
           "Window Info/Print" : "Prints all window information on the workspace":"wininfo",
           SEPARATOR,
           "FormTools": "Copy/Paste form screens" : ""
             SUBMENU
               "CopyForm": "Copy form literals to buffer":"copyform",
               "PasteForm":"Paste form literals from buffer" : "pasteform"
             ENDSUBMENU,
           SEPARATOR,
           "Quit" : "Cancel window tools" : "quit"
        ENDMENU TO choice_a
        SWITCH
           CASE choice_a = "frame" :
               ToggleFrame_u()
           CASE choice_a = "show" :
               ShowWindowAttr_u()
           CASE choice_a = "print":
               PrintWindowAttr_u()
           CASE choice_a = "size" :
               ToggleNoframeMaxsize_u()
           CASE choice_a = "resize" :
               SizeMoveWindow_u()
           CASE choice_a = "next" :
               WindowNext_u()
           CASE choice_a = "printall":
               PrintAllWindowAttr_u()
           CASE choice_a = "wininfo":
               GetWindowInfo_u("Utility")
           CASE choice_a = "copyform":
               FormGrabScreen_u()
           CASE choice_a = "pasteform":
               FormPasteScreen_u()
           CASE choice_a = "quit" :  QUITLOOP
        ENDSWITCH
    ENDWHILE
ENDPROC











    WinToolsMenu_u()








