; ---------------------------------------------------------------------------
; ================================= WordWrapThis4() =============================
; ---------------------------------------------------------------------------
Proc WordWrapThis4(text.a ;text var to wordwrap
                     ,lns.n ; Max lines to word wrap on to
                            ;if you want it to wrap until
                            ;finished make this a large number
                     ,wid.n  ; Max width (can't exceed 255) of a line
                     ,ww.y)  ;Dynarray to place word wrap lines into
  ;This4 procedure wordwraps a sting to Dynarray
  ;with elements "1" - number of lines
  ;works only with version 4.0 last revised 12/24/92
  private ret,procname.a,
              cntr,        ;counter for FOR loop
              startchr.n,  ;starting character of a wrap line
              takeChrs.n,  ;number of characters to put into a wrap line
              spacePos.n,  ;keeps track of space possition
              trimChr.n    ;number of characters to trim from the end of a line
  procname.a = "WordWrapThis4"
     text.a = ""+text.a ;if this is a memo var this line will reset its
                        ;character index is a problem in low memory
                        ;situations after a RUN command
     startchr.n = 1         ;starting character possition
     wid.n = Min(wid.n,255) ;width can not exceed 255
  For cntr from 1 To lns.n
    ww.y[cntr] = ""     ;init dynarray element
    takeChrs.n = 0      ;Initialize at 0
    trimChr.n = 0       ;Initialize at 0
    Switch
      Case SearchFrom("\n",text.a,startchr.n) > 0 And ;look for carrige return
           SearchFrom("\n",text.a,startchr.n) < (startChr.n+wid.n):
           takeChrs.n = SearchFrom("\n",text.a,startchr.n)- (startchr.n-1)
           trimChr.n =  1
      Case (startChr.n + wid.n) > Len(text.a): ;no more word wrap needed
           takeChrs.n = wid.n
      OtherWise:  ;need to find next space to break at
        While true
          spacePos.n =  SearchFrom(" ",text.a,startChr.n+takeChrs.n)
          Switch
            Case (spacePos.n - (startchr.n-1)) > wid.n  or spacePos.n = 0:
              If takeChrs.n = 0 then
                 takeChrs.n = wid.n ;this section can not be broken at a space
              Endif
            Quitloop
          OtherWise:
            takeChrs.n = spacePos.n - (startchr.n-1)
          EndSwitch
        EndWhile
    EndSwitch
          ww.y[cntr] = Substr(text.a,startChr.n,takeChrs.n-trimChr.n)
          startChr.n = startChr.n +takeChrs.n   ;rest var
          If startChr.n > Len(text.a) then Quitloop Endif  ;all wrap lines set
  Endfor
  Return cntr
EndProc


;Sample usage
;assumes your in a table and the current field is the field to wordwrap
;
dynarray test.y[] ;Declair dynarray to hold Wrap lines
; get number of lines that will be word wraped to in variable x
x =  WordWrapThis4([] ;Text to Wrap, can be memo field, memoVar, or string
                  ,100 ; Max lines to word wrap on to
                  ,40  ; Max width of a line (can't exceed 255) of a line
                  ,test.y)  ;Dynarray to place word wrap lines into
For cntr from 1 to  x
      Print ""+test.y[cntr]+"\n"
Endfor
