PROC WPBeginMacro( MacroFileName, WPMTablePath )
   VIEW WPMTablePath
   WPMacroFileName = MacroFileName
   WPMHeader = WPGetCode("<WPM Header>")
   IF ISBLANK(WPMHeader)
   THEN
      RETURN FALSE
   ELSE
      ;
      ; Write the macro header
      ;
      FILEWRITE BINARY WPMacroFileName FROM WPMHeader
      RELEASE VARS WPMHeader
      RETURN TRUE
   ENDIF
ENDPROC


PROC WPEndMacro( )
   ;
   ; Write the macro footer
   ; Assumes the macrofilename is in the Global WPMacroFileName
   ; this is set up in the WPBeginMacro PROC
   ;
   WPCode("<WPM Footer>")
   CLEARIMAGE
   RELEASE VARS WPMacroFileName
   IF ISASSIGNED(NullChar)
   THEN
      RELEASE VARS NullChar
   ENDIF
ENDPROC


PROC WPString( InputString )
   ;
   ; Prints an input string to a WP Macro File
   ; (add a NUL after each character, indicate character set 0)
   ; Assumes the macrofilename is in the Global WPMacroFileName
   ; this is set up in the WPBeginMacro PROC
   ;
   PRIVATE OutputString
   ;
   ; Check for blank input string
   ;
   IF ISBLANK( InputString )
   THEN
      OutputString = InputString
   ELSE
      OutputString = ""
      FOR Location FROM 1 TO LEN(InputString)
         IF ISASSIGNED(NullChar) = FALSE
         THEN
            NullChar = WPGetCode("<NULL>")
         ENDIF
         OutputString = OutputString + SUBSTR(InputString, Location, 1) + NullChar
      ENDFOR
   ENDIF

   FILEWRITE BINARY APPEND WPMacroFileName FROM OutputString

ENDPROC

PROC WPCode( Tag )
   ;
   ; Prints an WP Macro Command to the WPMacroFileName file
   ; Assumes the macrofilename is in the Global WPMacroFileName
   ; this is set up in the WPBeginMacro PROC
   ;
   ; Position to the codes table WPM
   ; Assumes this table is already on the workspace
   ;
   MOVETO [WPM->Macro Command]
   ;
   ; Try to find the tag
   ;
   LOCATE Tag
   IF Retval = TRUE
   THEN
      FILEWRITE BINARY APPEND WPMacroFileName FROM [Command Codes]
      RETURN TRUE
   ELSE
      RETURN FALSE
   ENDIF
ENDPROC


PROC WPGetCode( Tag )
   ;
   ; Assumes the WPM table is already on the workspace
   ;
   MOVETO [WPM->Macro Command]
   ;
   ; Try to find the Tag
   ;
   LOCATE Tag
   IF Retval = TRUE
   THEN
      ;
      ; Return the Code
      ;
      RETURN [Command Codes]
   ELSE
      RETURN ""
   ENDIF
ENDPROC


LetterDate = FORMAT("D2", TODAY())
LetterName = "Michael Bonner"
LetterAddress1 = "2131 Tammy Lane"
LetterAddress2 = ""
LetterAddress3 = "Selma, CA  93662"
NoshowCount = 3
LetterStartDate = "August 12, 1992"
NoshowDates = "July 1, 1992 @ 15:45, August 12, 1992 @ 10:15"

TestDocName = "TESTDOC.WP5"
TestMacroName = "TESTMAC.WPM"
WPMTablePath = "WPM"

;
; Initialize the macro file
;
WPBeginMacro( TestMacroName, WPMTablePath )
;
; Replace the letter date
;
WPCode("<Home Home Up>")
WPCode("Search/replace")
WPString("N")
WPString("@Letter Date@")
WPCode("Forward search")
WPString(LetterDate)
WPCode("Forward search")
;
; Replace the start date
;
WPCode("<Home Home Up>")
WPCode("Search/replace")
WPString("N")
WPString("@Start Date@")
WPCode("Forward search")
WPString(LetterStartDate)
WPCode("Forward search")
;
; Replace the name
;
WPCode("<Home Home Up>")
WPCode("Search/replace")
WPString("N")
WPString("@Full Name@")
WPCode("Forward search")
WPString(LetterName)
WPCode("Forward search")
;
; Replace the address
;
WPCode("<Home Home Up>")
WPCode("Search/replace")
WPString("N")
WPString("@Mailing Address@")
WPCode("Forward search")
IF ISBLANK(LetterAddress1) = FALSE
THEN
   WPString(LetterAddress1)
   WPCode("^J - Enter")
ENDIF
IF ISBLANK(LetterAddress2) = FALSE
THEN
   WPString(LetterAddress2)
   WPCode("^J - Enter")
ENDIF
IF ISBLANK(LetterAddress3) = FALSE
THEN
   WPString(LetterAddress3)
   WPCode("^J - Enter")
ENDIF
WPCode("Forward search")
;
; Replace the Noshow Count
;
WPCode("<Home Home Up>")
WPCode("Search/replace")
WPString("N")
WPString("@Noshow Count@")
WPCode("Forward search")
WPString(STRVAL(NoshowCount))
WPCode("Forward search")
WPCode("<Home Home Up>")
;
; Replace the noshow dates
;
WPCode("Search/replace")
WPString("N")
WPString("@Noshow Dates@")
WPCode("Forward search")
WPString(NoshowDates)
WPCode("Forward search")
;********************
; Uncomment the following commands to print and save the file
;********************
;
; Print the file
;
;WPCode("Print")
;
; Full Document
;
;WPString("F")
;
; Wait for the printing to finish
;
;WPCode("<Wait for Print Done>")
;
; Exit Word Perfect
;
;WPCode("Exit")
;
; Save File? Yes
;
;WPString("Y")
;
; File Name? Enter
;
;WPCode("^J - Enter")
;
; Replace? Yes
;
;WPString("Y")
;
; Exit WP? Yes
;
;WPString("Y")
;
; Finish the macro
;
WPEndMacro()

;
; Wordperfect the test file to test the macro
; Assumes WP is in the current path
; Use DIRECTORY() to tell WP where to locate the Macro
;
RUN BIG "WP " + TestDocName + "/M-" + DIRECTORY() + TestMacroName
