

PROC CreateWindow()

PROMPT "Press [F2] to return to the main Dialog"
WINDOW CREATE ATTRIBUTES WinAttr TO Created
ECHO NORMAL
GETEVENT KEY "F2" MESSAGE "CLOSE" TO Result
PROMPT ""
WINDOW CLOSE

ENDPROC

PROC ShowDynArray()
WINDOW SELECT ShowWindowHandle
SETCANVAS ShowWindowHandle
ECHO OFF
CURSOR OFF
PROMPT "Press any key or click with mouse to return to main Dialog"
WINDOW MOVE ShowWindowHandle TO 1,0
WINDOW SELECT ShowWindowHandle
SETCANVAS ShowWindowHandle
SETMARGIN 29
@0,29 CLEAR EOS
@0,29 ?? WinAttr["Title"]
? WinAttr["CanMove"]       
? WinAttr["CanClose"]     
? WinAttr["CanResize"]   
? WinAttr["CanMaximize"]  
? WinAttr["HasShadow"]   
? WinAttr["HasFrame"]    
? WinAttr["Maximized"]    
? WinAttr["Echo"]        
? WinAttr["Canvas"]       
? WinAttr["Floating"]    
? WinAttr["OriginRow"]   
? WinAttr["OriginCol"]   
? WinAttr["Height"]      
? WinAttr["Width"]        
? WinAttr["Margin"]      
? WinAttr["CanvasHeight"]
? WinAttr["CanvasWidth"] 
? WinAttr["Style"]       
? WinAttr["ScrollRow"]    
? WinAttr["ScrollCol"]   

ECHO NORMAL
GETEVENT KEY "ALL" MOUSE "DOWN" TO Retval

WINDOW MOVE ShowWindowHandle TO -100,-100
PROMPT ""
CURSOR NORMAL
ENDPROC


PROC SetWinAttr()
DYNARRAY WinAttr[]
WinAttr["CANMOVE"] = True
WinAttr["CANCLOSE"] = True
WinAttr["CANRESIZE"] = True
WinAttr["CANMAXIMIZE"] = True
WinAttr["HASSHADOW"] = True
WinAttr["HASFRAME"] = True
WinAttr["MAXIMIZED"] = False
WinAttr["ECHO"] = True
WinAttr["CANVAS"] = True
WinAttr["FLOATING"] = False
WinAttr["Title"] = ""
WinAttr["OriginRow"] = 1
WinAttr["OriginCol"] = 0
WinAttr["Height"] = 18
WinAttr["Width"] = 73
WinAttr["Margin"] = "OFF"
WinAttr["CanvasHeight"] = 21
WinAttr["CanvasWidth"] = 78
WinAttr["Style"] = 31
WinAttr["ScrollRow"] = 0
WinAttr["ScrollCol"] = 0
ENDPROC





PROC StripDynarray()
DYNARRAY CompareAttr[]
CompareAttr["CANMOVE"] = True
CompareAttr["CANCLOSE"] = True
CompareAttr["CANRESIZE"] = True
CompareAttr["CANMAXIMIZE"] = True
CompareAttr["HASSHADOW"] = True
CompareAttr["HASFRAME"] = True
CompareAttr["MAXIMIZED"] = False
CompareAttr["ECHO"] = True
CompareAttr["CANVAS"] = True
CompareAttr["FLOATING"] = False
CompareAttr["Title"] = ""
CompareAttr["OriginRow"] = 1
CompareAttr["OriginCol"] = 0
CompareAttr["Height"] = 18
CompareAttr["Width"] = 73
CompareAttr["Margin"] = "OFF"
CompareAttr["CanvasHeight"] = 21
CompareAttr["CanvasWidth"] = 78
CompareAttr["Style"] = 31
CompareAttr["ScrollRow"] = 0
CompareAttr["ScrollCol"] = 0
 
FOREACH Element in  WinAttr
  IF WinAttr[Element] = CompareAttr[Element] THEN
    RELEASE VARS WinAttr[Element]
  ENDIF
ENDFOREACH      

ENDPROC

PROC SaveDynarrayProc(Trigger, Tag, Event, Element)
IF Trigger = "UPDATE" THEN
  IF Tag = "EDITOR" THEN
    IF EditorWrite = True THEN
      RETURN 
    ELSE
      MESSAGE "Not currently in an Editor session"
      RETURN False
    ENDIF    
  ENDIF
ENDIF

IF Trigger = "ACCEPT" AND TargetDA = "" THEN
  MESSAGE "Not a valid Dynarray Name"
  SELECTCONTROL "TARGETDA"
  RETURN False
ENDIF  
ENDPROC


PROC SaveDynarray()
SHOWDIALOG "Write Dynarray"
PROC "SaveDynarrayProc" TRIGGER "UPDATE", "ACCEPT"
@5,14 HEIGHT 13 WIDTH 52
@ 1,10 ?? "Type in Target Dynarray Name."

@ 3,10 ?? "Name:"
@ 5,10 ?? "Elements to include:"
FRAME DOUBLE FROM 0,8 TO 8, 40

PAINTCANVAS ATTRIBUTE 48 
0,8,0,39
PAINTCANVAS ATTRIBUTE 48
1,8,8,8

ACCEPT @3,16 WIDTH 23
"A35"
TAG "TARGETDA"
TO TARGETDA

RADIOBUTTONS @ 6,10
HEIGHT 2 WIDTH 29
"All Elements",
"Only Modified Elements"
TAG "Contents"
TO Contents


  PUSHBUTTON
    @9,1 WIDTH 15
    "TO ~E~DITOR" OK
    VALUE "EDITOR"   
    TAG "EDITOR"
    TO PB

  PUSHBUTTON
    @9,17 WIDTH 15
    "TO ~S~AVEVARS" OK
    VALUE "SAVEVARS"   
    TAG "SAVEVARS"
    TO PB

  PUSHBUTTON
    @9,33 WIDTH 15
    "~C~ANCEL" 
    CANCEL
    VALUE "CANCEL"   
    TAG "CANCEL"
    TO PB



ENDDIALOG

IF NOT Retval THEN
  RETURN
ENDIF

IF Contents = 2 THEN
  StripDynarray()
ENDIF

IF DYNARRAYSIZE(WinAttr) = 0 THEN 
  MESSAGE "No elements modified"
  RETURN
ENDIF  

EXECUTE "DYNARRAY " + TargetDA + "[]"
FOREACH Element IN WinAttr
    EXECUTE TargetDA + "[Element] = WinAttr[Element]"
ENDFOREACH

IF PB = "EDITOR" THEN
  TargetDA = UPPER(TargetDA)
  WINDOW SELECT EditorHandle
  TYPEIN "DYNARRAY " + TargetDA + "[]"
  ENTER
  FOREACH Element IN WinAttr
    TYPEIN TargetDA + "[\"" + Element + "\"] = " 
    SWITCH
      CASE Element = "MARGIN" AND WinAttr[Element] = "OFF":
        TYPEIN "\"" + WinAttr[Element] + "\""
      CASE Element = "TITLE":
        TYPEIN "\"" + WinAttr[Element] + "\""
      OTHERWISE: TYPEIN WinAttr[Element]    
    ENDSWITCH
    ENTER 
  ENDFOREACH
  ECHO NORMAL ECHO OFF
ELSE    
  EXECUTE "SAVEVARS " + TargetDA
  MESSAGE "Dynamic Array " + UPPER(TargetDA) + " successfully written to SaveVars.Sc."
ENDIF


ENDPROC


PROC StyleHelpProc(Trigger, Tag, Event, Element)
IF Tag = "SHOW" THEN
  Attribute = CONTROLVALUE("Forground") - 1 + (CONTROLVALUE("Background") - 1) * 16
  IF CONTROLVALUE("BlinkSetting", "Add Blinking") THEN
    Attribute = Attribute + 128
  ENDIF 
  ShowAttr()
ENDIF
ENDPROC  

PROC StyleHelp()

SHOWDIALOG "Style Color Settings"
PROC "StyleHelpProc" TRIGGER "UPDATE"
@ 4,8 HEIGHT 16 WIDTH 65

@ 1,3 ?? "Forground:"
@ 1,44 ?? "BackGround:"
FRAME DOUBLE FROM 0,1 TO 10,39
FRAME DOUBLE FROM 0,42 TO 10,61
FRAME FROM 11,1 TO 13,22

PAINTCANVAS ATTRIBUTE 48
0,1,0,38
PAINTCANVAS ATTRIBUTE 48
1,1,10,1

PAINTCANVAS ATTRIBUTE 48
0,42,0,60
PAINTCANVAS ATTRIBUTE 48
1,42,10,42


PAINTCANVAS ATTRIBUTE 48
11,1,11,21
PAINTCANVAS ATTRIBUTE 48
12,1,13,1


RADIOBUTTONS @ 2,3 HEIGHT 8 WIDTH 35
"Black", "Blue", "Green", "Cyan", "Red", "Magenta", "Brown", "Light Gray",
"Dark Gray", "Light Blue", "Light Green", "Light Cyan", "Light Red", 
"Light Magenta", "Yellow", "White"
TAG "ForGround"
TO ForGround

RADIOBUTTONS @ 2, 44 HEIGHT 8 WIDTH 16
"Black", "Blue", "Green", "Cyan", "Red", "Magenta", "Brown", "Light Gray"
TAG "BackGround"
TO BackGround

CHECKBOXES @ 12,3
HEIGHT 1 WIDTH 18
TAG "BlinkSetting"
 "Add Blinking" TO BlinkSetting


  PUSHBUTTON
    @12,24 WIDTH 12
    "~O~K" OK
    VALUE "OK"
    TAG "OK"
    TO OK

  PUSHBUTTON
    @12,37 WIDTH 12
    "~S~HOW" 
    VALUE "SHOW"
    TAG "SHOW"
    TO SHOW

  PUSHBUTTON
    @12,50 WIDTH 12
    "~C~ANCEL" CANCEL
    VALUE "CANCEL"
    TAG "CANCEL"
    TO CANCEL
    
ENDDIALOG    

IF Retval THEN
  Attribute = Forground - 1 + (Background - 1) * 16
  IF BlinkSetting THEN
    Attribute = Attribute + 128
  ENDIF 
  RETURN Attribute
ELSE
  RETURN False
ENDIF    

ENDPROC

PROC ShowAttr()
SHOWDIALOG "Show Attribute"
@6,27 HEIGHT 9 WIDTH 26

FRAME DOUBLE FROM 1,2 TO 3, 21

@2,4 ?? "Attribute #: ", Attribute
PAINTCANVAS ATTRIBUTE Attribute
1,1,3,22
PUSHBUTTON @5,5
WIDTH 14
"RETURN" CANCEL
DEFAULT
VALUE "OK"
TAG "OK"
TO OK

ENDDIALOG
ENDPROC



PROC DialogProc(Trigger, Tag, Event, Element)
SWITCH

  CASE TRIGGER = "OPEN":
    PROMPT ""
    RETURN

  CASE TRIGGER = "UPDATE" AND Tag = "WRITE": SaveDynarray()
  
  CASE TRIGGER = "UPDATE" AND Tag = "StyleHelp" : StyleHelp()
    IF Retval <> False THEN
      WinAttr["Style"] = Retval
      RESYNCCONTROL "Style"
      SELECTCONTROL "Style"
    ENDIF  

  CASE TRIGGER = "EVENT": 
    SWITCH
      CASE Event["KEYCODE"] = 27:
        QuitFlag = True
        CANCELDIALOG

      CASE Event["KEYCODE"] = -72:
        Event["KEYCODE"] = -15
        RELEASE VARS Event["SCANCODE"]
        RETURN True
        
      CASE Event["KEYCODE"] = -80:
        Event["KEYCODE"] = 9
        RELEASE VARS Event["SCANCODE"]
        RETURN True
    ENDSWITCH

ENDSWITCH
ENDPROC

PROC CLOSED WinToolsMain()
IF SYSMODE() = "File Editor" OR SYSMODE() = "Script" THEN
  EditorWrite = True
  EditorHandle = GETWINDOW()
ELSE
  EditorWrite = False
ENDIF    


SetWinAttr()
DYNARRAY DialogAttr[]
DialogAttr["1032"] = 15     ;Frame
DialogAttr["1036"] = 59     ;Backgroud Text
DialogAttr["1040"] = 112    ;Pushbutton Deselected
DialogAttr["1041"] = 127    ;Pushbutton default
DialogAttr["1042"] = 127    ;Pushbutton Selected
DialogAttr["1044"] = 127    ;Pushbutton Highlight letter
DialogAttr["1045"] = 56     ;Pushbutton Button Shadow 
DialogAttr["1046"] = 112
DialogAttr["1047"] = 15
DialogAttr["1049"] = 112    ;Typein Box
DialogAttr["1050"] = 15
SETCOLORS FROM DialogAttr






DYNARRAY ShowWindow[]
ShowWindow["Height"] = 25
ShowWindow["Width"] = 80
ShowWindow["CanvasHeight"] = 21
ShowWindow["CanvasWidth"] = 78
ShowWindow["OriginCol"]= 0
ShowWindow["OriginRow"] = 26
ShowWindow["CanResize"] = False
ShowWindow["CanMove"] = False
ShowWindow["CanClose"] = False
ShowWindow["CanMaximize"] = False
ShowWindow["Title"] = "Dynarray Settings for Created Window"
WINDOW CREATE ATTRIBUTES ShowWindow TO ShowWindowHandle

SETMARGIN 3
TEXT
WinAttr["Title"]        =
WinAttr["CanMove"]      =
WinAttr["CanClose"]     = 
WinAttr["CanResize"]    =
WinAttr["CanMaximize"]  = 
WinAttr["HasShadow"]    =
WinAttr["HasFrame"]     =
WinAttr["Maximized"]    = 
WinAttr["Echo"]         =
WinAttr["Canvas"]       = 
WinAttr["Floating"]     =
WinAttr["OriginRow"]    =
WinAttr["OriginCol"]    =
WinAttr["Height"]       =
WinAttr["Width"]        = 
WinAttr["Margin"]       =
WinAttr["CanvasHeight"] =
WinAttr["CanvasWidth"]  =
WinAttr["Style"]        =
WinAttr["ScrollRow"]    = 
WinAttr["ScrollCol"]    =
ENDTEXT

QUITFLAG = False
PROMPT ""
SHOWPULLDOWN
FORMAT("W79, AC","WinTools 1.0 - Paradox Window Design Tools") : "" : ""
ENDMENU

WHILE True
SHOWDIALOG "Window Attributes"
PROC "DialogProc" 
  KEY 
    27,    ;Escape
    -80,   ;Down
    -72    ;Up
  TRIGGER 
    "OPEN",
    "UPDATE"

@2,14  HEIGHT 20  WIDTH 52
FRAME DOUBLE FROM 0,1 TO 13,48 
FRAME FROM 0,1 TO 2,48
FRAME FROM 2,1 TO 13, 27
PAINTCANVAS ATTRIBUTE 48
0,1,0,47
PAINTCANVAS ATTRIBUTE 48
1,1,13,1


  @1,3 ?? "Window Title: "
  ACCEPT
    @1,17 WIDTH 30
    "A30"
    TAG "WindowTitle"
    TO WinAttr["TITLE"]

;  STYLE ATTRIBUTE 15
  @3,2 ?? " OriginRow    : "
  ACCEPT 
    @3,18 WIDTH 8
    "S"
    MIN -10000 MAX 10000
    REQUIRED  
    TAG "StartRow"
    TO WinAttr["ORIGINROW"]

  @4,2 ?? " OriginCol    : "
  ACCEPT
    @4,18 WIDTH 8
    "S"
    MIN -10000 MAX 10000
    REQUIRED
    TAG "StartCol"
    TO WinAttr["ORIGINCOL"]

  @5,2 ?? " Height       : "
  ACCEPT
    @5,18 WIDTH 8  
    "S"
    MIN 0 MAX 200
    REQUIRED
    TAG "Height"
    TO WinAttr["HEIGHT"]
  
  @6,2 ?? " Width        : "
  ACCEPT
    @6,18 WIDTH 8
    "S"
    MIN 0 MAX 132
    REQUIRED
    TAG "Width"
    TO WINATTR["WIDTH"]

  @7,2 ?? " Margin       : "
  ACCEPT
    @7,18 WIDTH 8
    "A3"
;    MIN 0 MAX 132
    REQUIRED
    TAG "Margin"
    TO WinAttr["MARGIN"]

  @8,2 ?? " ScrollRow    : "  
  ACCEPT 
    @8,18 WIDTH 8
    "S"
    MIN 0 MAX 200
    REQUIRED
    TAG "ScrollRow"
    TO WinAttr["SCROLLROW"]        

  @9,2 ?? " ScrollCol    : "  
  ACCEPT 
    @9,18 WIDTH 8
    "S"
    MIN 0 MAX 132
    REQUIRED
    TAG "ScrollCol"
    TO WinAttr["SCROLLCOL"]        


;  STYLE ATTRIBUTE 15

  @10,2 ?? " CanvasHeight : "  
  ACCEPT 
    @10,18 WIDTH 8
    "S"
    MIN 0 MAX 200
    REQUIRED
    TAG "CanvasHeight"
    TO WinAttr["CANVASHEIGHT"]
    
  @11,2 ?? " CanvasWidth  : "  
  ACCEPT 
    @11,18 WIDTH 8
    "S"
    MIN 0 MAX 132
    REQUIRED
    TAG "CanvasWidth"
    TO WinAttr["CANVASWIDTH"]
        
  @12,2 ?? " Style        : "  
  ACCEPT 
    @12,18 WIDTH 8
    "S"
    MIN 0 MAX 255
    REQUIRED
    TAG "Style"
    TO WinAttr["STYLE"]        

  CHECKBOXES
    @3,29 HEIGHT 1 WIDTH 18
    TAG "DisplayCheckBox"
    "CanMove" TO WinAttr["CANMOVE"]

  CHECKBOXES
    @4,29 HEIGHT 1 WIDTH 18
    TAG "DisplayCheckBox"
    "CanClose" TO WinAttr["CANCLOSE"]

  CHECKBOXES
    @5,29 HEIGHT 1 WIDTH 18
    TAG "DisplayCheckBox"
    "CanResize" TO WinAttr["CANRESIZE"]

  CHECKBOXES
    @6,29 HEIGHT 1 WIDTH 18
    TAG "DisplayCheckBox"
    "CanMaximize" TO WinAttr["CANMAXIMIZE"]

  CHECKBOXES
    @7,29 HEIGHT 1 WIDTH 18
    TAG "DisplayCheckBox"
    "HasShadow" TO WinAttr["HASSHADOW"]

  CHECKBOXES
    @8,29 HEIGHT 1 WIDTH 18
    TAG "DisplayCheckBox"
    "HasFrame" TO WinAttr["HASFRAME"]
    
  CHECKBOXES
    @9,29 HEIGHT 1 WIDTH 18
    TAG "DisplayCheckBox"
    "Maximized" TO WinAttr["MAXIMIZED"]
    
  CHECKBOXES
    @10,29 HEIGHT 1 WIDTH 18
    TAG "DisplayCheckBox"
    "Echo" TO WinAttr["ECHO"]
    
  CHECKBOXES
    @11,29 HEIGHT 1 WIDTH 18
    TAG "DisplayCheckBox"
    "Canvas" TO WinAttr["CANVAS"]
    
  CHECKBOXES
    @12,29 HEIGHT 1 WIDTH 18
    TAG "DisplayCheckBox"
    "Floating" TO WinAttr["FLOATING"]


  PUSHBUTTON
    @14,1 WIDTH 15
    "~C~REATE" OK
    default
    VALUE "OK"   
    TAG "PBOK"
    TO Leave
  
  PUSHBUTTON
    @14,17 WIDTH 15
    "~S~HOW" OK
    VALUE "SHOW"   
    TAG "SHOW"
    TO Leave

  PUSHBUTTON
    @14,33 WIDTH 15
    "~W~RITE" 
    VALUE "WRITE"   
    TAG "WRITE"
    TO Leave

  PUSHBUTTON
    @16,1 WIDTH 15
    "STYLE ~H~ELP" 
    VALUE "STYLEHELP"   
    TAG "StyleHelp"
    TO Leave



  PUSHBUTTON
    @16,17 WIDTH 15
    "~R~ESET" OK
    VALUE "RESET"   
    TAG "RESET"
    TO Leave

  PUSHBUTTON
    @16,33 WIDTH 15
    "~E~XIT" OK
    VALUE "EXIT"
    TAG "EXIT"
    TO Leave
    
ENDDIALOG    


   
SWITCH

CASE QuitFlag = True: QUITLOOP
CASE Leave = "EXIT": QUITLOOP
CASE Leave =  "OK": CreateWindow()
CASE Leave = "RESET": SetWinAttr()
CASE Leave = "SHOW": ShowDynArray()

ENDSWITCH
ENDWHILE

IF ISWINDOW(ShowWindowHandle) THEN
  WINDOW SELECT ShowWindowHandle
  WINDOW CLOSE
ENDIF  

SETCOLORS DEFAULT
ENDPROC

WinToolsMain()