PROC ZRLock3(MsgType)

; ZRLock3 - Lock record, for newly-entered records, to check for key violation.

; Copyright 1990, 1992, 1992 by WHITE HEAT, Inc.  All Rights Reserved.

; NOTE: MsgType must equal numberical value of 1 or 0.  1 = Don't give
;       "DupMessage," and 0 = Do give "DupMessage."
;
;       This proc matches ZRLock2.sc except LEAVELOCKED command is omitted.

PRIVATE
   DupMessage

; Assign variable.

DupMessage = "One or more duplicate \"key\" fields; change one of first " +
             STRVAL(NKEYFIELDS(TABLE())) + " field(s) - Press a key..."

; Check for key violation.

POSTRECORD NOPOST 

IF retval THEN
   RETURN ""
ENDIF

DEL
UNDO

IF MsgType = 0 THEN
   ScreenMessage = DupMessage
ENDIF

RETURN "No"

ENDPROC ; ZRLock3(MsgType)

WRITELIB G.AppLib ZRLock3
RELEASE PROCS ZRLock3