PROC ZDelWait(WaitTrig,WaitEvent,WaitCycle)

; ZDelWait - Generic record deletion menu/event action procedure.

; Copyright 1992 by WHITE HEAT, Inc.  All Rights Reserved.

PRIVATE
   WaitVal,
   WhatKind

; Initialize variables.

WaitVal = 1 ; Most common possibility.
WhatKind = ""

; Go through this process only in the case of events.

IF WaitTrig = "EVENT" THEN

   ; Check for event type of keypresses rather than mouse clicks. 

   IF WaitEvent["TYPE"] = "KEY" THEN
      SWITCH
         CASE WaitEvent["KEYCODE"] = -60 : WhatKind = "Yes" ;"F2"
         CASE WaitEvent["KEYCODE"] =  89 : WhatKind = "Yes" ;"Y"
         CASE WaitEvent["KEYCODE"] = 121 : WhatKind = "Yes" ;"y"
         CASE WaitEvent["KEYCODE"] =  78 : WhatKind = "No"  ;"N"
         CASE WaitEvent["KEYCODE"] = 110 : WhatKind = "No"  ;"n"
         CASE WaitEvent["KEYCODE"] =  27 : WhatKind = "No"  ;"Esc"
         OTHERWISE                       : BEEP
                                           RETURN WaitVal
      ENDSWITCH
   ENDIF

   ; If event type is "MESSAGE" (MOUSE clicks), then assign
   ;    "WhatKind" according to any valid MOUSE actions. 

   IF WaitEvent["TYPE"] = "MESSAGE" THEN
      IF WaitEvent["MESSAGE"] = "CLOSE" THEN
         BEEP
         RETURN WaitVal
      ELSE
         SWITCH
            CASE WaitEvent["MENUTAG"] = "Yes" OR
                 WaitEvent["MENUTAG"] = "No"     :
                 
                    WhatKind = WaitEvent["MENUTAG"]
         ENDSWITCH
      ENDIF
   ENDIF

   ; Act on valid events.

   WaitVal = 3 ; Set to new default.

   SWITCH
      CASE WhatKind = "Yes" : DelFlag = TRUE
      CASE WhatKind = "No"  : ; Falls through and continues.
      OTHERWISE             : WaitVal = 1
   ENDSWITCH
ENDIF

RETURN WaitVal

ENDPROC ; ZDelWait(WaitTrig,WaitEvent,WaitCycle)

WRITELIB G.AppLib ZDelWait
RELEASE PROCS ZDelWait