PROC ZDelete(ArrProc,DepProc)

; ZDelete - Generic record deletion procedure.

; Copyright 1992 by WHITE HEAT, Inc.  All Rights Reserved.

PRIVATE
   Result,
   EditLockString,
   HoldTable,
   FormFlag,
   MasterDelete,
   MultiMaster,
   HoldRecord,
   DelFlag,
   OnceNote,
   Found,
   Head,
   Tail

; Check for no records in current table.

IF ISEMPTY(TABLE()) THEN
   BEEP
   RETURN
ENDIF

; Assign initial and current environment variables, determine locking needs.

FormFlag = FALSE
MultiMaster = ""
DelFlag = FALSE
Found = TRUE
MasterDelete = TRUE
OnceNote = "Confirm before deletion!"
HoldTable = TABLE()
FormFlag = ISFORMVIEW()

IF InfoDyn["MultiLock"] AND FormFlag THEN
   MOVETO InfoDyn["TableName"]
   MultiMaster = TABLE()

   IF MultiMaster <> HoldTable THEN
      MasterDelete = FALSE
   ENDIF
ENDIF   

; Construct locking string.

IF InfoDyn["DoLock"] THEN
   EditLockString = LockString ; "LockString" assigned from "ZView" procedure.

   WHILE (Found)
      Found = MATCH(EditLockString,"..PFL..",Head,Tail)

      IF Found THEN
         EditLockString = Head + "PWL" + Tail
      ENDIF
   ENDWHILE

   ; Handle necessary locking.

   Result = ZTLock(EditLockString,0,0)

   MOVETO HoldTable

   IF Result = "No" THEN
      RETURN
   ENDIF
ENDIF   

; Check for attempted deletion of master record while detail records exist.

IF InfoDyn["MultiLock"] AND (InfoDyn["FormName"] <> "") THEN
   IF (NOT FormFlag) THEN
      MOVETO MultiMaster
      FORMKEY
   ENDIF
   
   IF MasterDelete THEN   
      DOWNIMAGE
   
      IF NIMAGERECORDS() > 0 THEN
         ScreenMessage = "Can't delete master record while detail records exist."

         IF InfoDyn["DoLock"] THEN
            EXECUTE "UNLOCK " + EditLockString
         ENDIF

         MOVETO HoldTable
         RETURN
      ENDIF
   ENDIF
ENDIF

; Handle record locking.

MOVETO HoldTable
COEDITKEY

IF InfoDyn["RecordLock"] THEN

   Result = ZRLock1(0,0)

   IF Result = "No" THEN
      DO_IT!
      
      IF InfoDyn["DoLock"] THEN
         EXECUTE "UNLOCK " + EditLockString
      ENDIF
       
      MOVETO HoldTable
      RETURN
   ENDIF
ENDIF   

MOVETO HoldTable

; Call arrival procedure if applicable.

IF (ArrProc <> "") THEN

   EXECPROC ArrProc

ENDIF

; Set up control loop and get confirmation for correct record.

REFRESH
BEEP SLEEP 15 BEEP
IMAGERIGHTS READONLY
PROMPT " Verify that this is the record you wish to delete..."

WHILE (TRUE)

SHOWPULLDOWN
   " ~F2~ / ~Y~ = Yes, Delete.           " : "" : "Yes",
   "~Esc~ / ~N~ = Do Not Delete."          : "" : "No"
ENDMENU 

ECHO NORMAL
MESSAGE OnceNote

WAIT RECORD PROC "ZDelWait"
   KEY 78,89,110,121,"F2","ESC",15,-18,-24,-31,-37,-38,-45,-98,-100
   MESSAGE "CLOSE","MENUSELECT"
ENDWAIT

IF retval = 2005 THEN
   QUITLOOP
ENDIF

ENDWHILE

; Delete or skip deletion as applicable.

ECHO OFF
CLEARPULLDOWN
PROMPT

IF DelFlag THEN
   IMAGERIGHTS
   DEL
ENDIF

IF (InfoDyn["KeyAccess"]) THEN
   IMAGERIGHTS UPDATE
ENDIF

DO_IT!
MOVETO HoldTable

; Call departure procedure if applicable.

IF (DepProc <> "") THEN

   EXECPROC DepProc

ENDIF

IF InfoDyn["DoLock"] THEN
   EXECUTE "UNLOCK " + EditLockString
ENDIF   

ENDPROC ; ZDelete(ArrProc,DelProc)

WRITELIB G.AppLib ZDelete
RELEASE PROCS ZDelete