PROC ZAddWait(WaitTrig,WaitEvent,WaitCycle)

; ZAddWait - Generic record add/entry menu/event action procedure.

; Copyright 1992 by WHITE HEAT, Inc.  All Rights Reserved.

PRIVATE
   WaitVal,
   WhatKind,
   NumberHold

; Initialize/reset variables.

WaitVal = 1 ; Most common possibility.
WhatKind = ""
ScreenMessage = ""

; Go through this process only in the case of events.

IF WaitTrig = "EVENT" THEN

   ; Check for FIELDVIEW mode.
   
   IF ISFIELDVIEW() THEN
      IF SUBSTR(FIELDTYPE(),1,1) = "M" THEN
         IF WaitEvent["TYPE"] = "KEY" THEN
            IF WaitEvent["KEYCODE"] = -60 THEN ; F2
               WaitVal = 0
               RETURN WaitVal
            ENDIF
         ELSE
            DO_IT!
         ENDIF
      ELSE
         ENTER
      ENDIF
   ENDIF

   ; Check for event type of keypress rather than mouse click(s). 

   IF WaitEvent["TYPE"] = "KEY" THEN
      SWITCH
         CASE WaitEvent["KEYCODE"] =   4 : WhatKind = "DITTO"
         CASE WaitEvent["KEYCODE"] = -60 : WhatKind = "F2"
         CASE WaitEvent["KEYCODE"] = -63 : WhatKind = "F5"
         CASE WaitEvent["KEYCODE"] = -82 : WhatKind = "INS"
         OTHERWISE                       : BEEP
                                           RETURN WaitVal
      ENDSWITCH
   ENDIF

   ; If event type is "MESSAGE" - MOUSE clicks - then assign
   ;    "WhatKind" according to any valid MOUSE actions. 

   IF WaitEvent["TYPE"] = "MESSAGE" THEN
      IF WaitEvent["MESSAGE"] = "CLOSE" THEN
         BEEP
         RETURN WaitVal
      ELSE
         SWITCH
            CASE WaitEvent["MENUTAG"] = "DITTO" OR
                 WaitEvent["MENUTAG"] = "F2"    OR
                 WaitEvent["MENUTAG"] = "F5"    OR
                 WaitEvent["MENUTAG"] = "INS"      : 

                    WhatKind = WaitEvent["MENUTAG"]
         ENDSWITCH
      ENDIF
   ENDIF

   ; Act on valid events.

   SWITCH
      CASE WhatKind = "DITTO" : ; "Ditto" function.

                                IF FIELD() = "#" THEN
                                   BEEP
                                   RETURN WaitVal
                                ENDIF
      
                                [] = HoldRecord[FIELD()]

                                IF ErrorFlag THEN
                                   ErrorFlag = FALSE
                                   BEEP
                                   WaitVal = 2
                                   RETURN WaitVal
                                ENDIF

                                IF FIELDTYPE() = "$" AND
                                   (NOT ISBLANK([])) THEN

                                   [] = ROUND([],2)
                                   
                                   IF ErrorFlag THEN
                                      ErrorFlag = FALSE
                                      WaitVal = 2
                                      RETURN WaitVal
                                   ENDIF
                                ENDIF

      CASE WhatKind = "F2" OR
           WhatKind = "INS"   : ECHO OFF
                                WaitVal = 2 ; Reassign default setting.
           
                                ; Check for invalid ValCheck field problems.
           
                                MOVETO FIELD HoldLast
                                
                                IF ErrorFlag THEN
                                   ErrorFlag = FALSE
                                   RETURN WaitVal
                                ENDIF
           
                                ; Check first field/eliminate blank records.

                                HoldFlag = TRUE
                                CTRLHOME

                                IF FIELD() = "#" THEN
                                   RIGHT
                                ENDIF
  
                                WHILE (TRUE)
                                   IF NOT ISBLANK([]) THEN
                                      HoldFlag = FALSE
                                      QUITLOOP
                                   ENDIF
                                   
                                   IF FIELD() = HoldLast THEN
                                      QUITLOOP
                                   ENDIF
                                   
                                   RIGHT
                                ENDWHILE

                                IF HoldFlag THEN
                                   IF WhatKind = "INS" THEN
                                      ScreenMessage = "Can't save a " + 
                                                      "blank record."
                                      CTRLHOME
                                      RETURN WaitVal
                                   ENDIF
                                   
                                   IF (NOT InfoDyn["KeyAccess"]) THEN
                                      IMAGERIGHTS
                                   ENDIF
                                   
                                   DEL
                                   
                                   IF (NOT InfoDyn["KeyAccess"]) THEN
                                      IMAGERIGHTS UPDATE
                                   ENDIF
                                   
                                   WaitVal = 3
                                   RETURN WaitVal
                                ELSE
                                   IF F5Flag THEN
                                   
                                      ; Fill in [Number], [Date], & [Time] fields as applicable.
                                      
                                      IF (FIELDNO("Number",TABLE()) <> "Error") THEN
                                         [Number] = NumberHold
                                      ENDIF

                                      IF (FIELDNO("Date",TABLE()) <> "Error") THEN
                                         [Date] = TODAY()
                                      ENDIF

                                      IF (FIELDNO("Time",TABLE()) <> "Error") THEN
                                         [Time] = SUBSTR(TIME(),1,5)
                                      ENDIF

                                      F5Flag = FALSE
                                   ENDIF
                                
                                   CTRLHOME
                                   
                                   IF FIELD() = "#" THEN
                                      RIGHT
                                   ENDIF
                                     
                                   IF ISBLANK([]) THEN
                                      ScreenMessage = "First field must " +
                                                      "contain and entry " +
                                                      "(or use \"F5\" to " +
                                                      "cancel)."
                                      RETURN WaitVal
                                   ENDIF
                                ENDIF
  
                                ; Handle any key violations.
  
                                IF (InfoDyn["FieldName"] <> "") AND TABLE() = TableVar THEN
                                   ScreenMessage = "(New record occupying secondary index position for this view.)"
                                   
                                   Result = ZRLock3(0)
                                
                                ELSE                                  

                                   Result = ZRLock2(0)
                                      
                                ENDIF
  
                                IF Result = "No" THEN
                                   RETURN WaitVal
                                ENDIF

                                IF WhatKind = "F2" THEN
                                   UNLOCKRECORD
                                   WaitVal = 3
                                   RETURN WaitVal
                                ENDIF
  
                                ; Assign array for "Ditto" function.
  
                                COPYTOARRAY HoldRecord
                                UNLOCKRECORD
                                END

                                IF (NOT InfoDyn["KeyAccess"]) THEN
                                   IMAGERIGHTS
                                ENDIF
                                
                                ; Fill in [Number] field if applicable.
                                
                                IF FormFlag AND (FIELDNO("Number",TABLE()) <> "Error") THEN
                                   NumberHolder = [Number]
                                   CTRLEND
                                   DOWN
                                   [Number] = NumberHolder + 1
                                ELSE
                                   INS
                                ENDIF

                                ; Fill in [Date] and [Time] fields if applicable.

                                IF FormFlag THEN
                                   IF (FIELDNO("Date",TABLE()) <> "Error") THEN
                                      [Date] = TODAY()
                                   ENDIF

                                   IF (FIELDNO("Time",TABLE()) <> "Error") THEN
                                      [Time] = SUBSTR(TIME(),1,5)
                                   ENDIF
                                ENDIF

                                IF (NOT InfoDyn["KeyAccess"]) THEN
                                   IMAGERIGHTS UPDATE
                                ENDIF
  
      CASE WhatKind = "F5"    : ECHO OFF
                                F5Flag = TRUE
                                                                 
                                IF (FIELDNO("Number",TABLE()) <> "Error") THEN
                                   NumberHold = [Number]
                                ENDIF

                                IF (NOT InfoDyn["KeyAccess"]) THEN
                                   IMAGERIGHTS
                                ENDIF

                                DEL
                                
                                IF ErrorFlag THEN
                                   ErrorFlag = FALSE
                                   MOVETO FIELD ErrorField
                                   
                                   IF (NOT InfoDyn["KeyAccess"]) THEN
                                      IMAGERIGHTS UPDATE
                                   ENDIF
                                   
                                   F5Flag = FALSE
                                   RETURN WaitVal
                                ENDIF
                                
                                INS
                                
                                IF (NOT InfoDyn["KeyAccess"]) THEN
                                   IMAGERIGHTS UPDATE
                                ENDIF
   ENDSWITCH
ENDIF

RETURN WaitVal

ENDPROC ; ZAddWait(WaitTrig,WaitEvent,WaitCycle)

WRITELIB G.AppLib ZAddWait
RELEASE PROCS ZAddWait