PROC ZAdd(ArrProc,DepProc)

; ZAdd - Generic routine to add new record(s).

; Copyright 1991, 1992 by WHITE HEAT, Inc.  All Rights Reserved.

PRIVATE
   Result,
   EditLockString,
   EditForm,
   FormFlag,
   HoldForm,
   HoldTable,
   MultiMaster,
   HoldLast,
   HoldFlag,
   HoldRecord,
   F5Flag,
   Found,
   Head,
   Tail,
   I

; Assign initial and current environment variables, determine locking needs.

EditForm = ""
HoldForm = ""
MultiMaster = ""
FormFlag = FALSE
F5Flag = FALSE
Found = TRUE
ScreenMessage = ""

IF (NOT ISASSIGNED(Linked)) THEN
   Linked = FALSE
ENDIF   

IF ISFORMVIEW() THEN
   FormFlag = TRUE
ENDIF

HoldTable = TABLE()

IF InfoDyn["MultiLock"] AND FormFlag THEN
   MOVETO InfoDyn["TableName"]
ENDIF

MultiMaster = TABLE()

IF FormFlag THEN
   HoldForm = FORM()
ENDIF

; Construct locking string.

IF InfoDyn["DoLock"] THEN
   EditLockString = LockString ; "LockString" assigned from "ZView" procedure.

   WHILE (Found)
      Found = MATCH(EditLockString,"..PFL..",Head,Tail)

      IF Found THEN
         EditLockString = Head + "PWL" + Tail
      ENDIF
   ENDWHILE

   ; Handle necessary locking.

   Result = ZTLock(EditLockString,0,0)

   MOVETO HoldTable

   IF Result = "No" THEN
      RETURN
   ENDIF
ENDIF   

; Check for user on linked detail table but with empty master table.

IF Infodyn["MultiLock"] AND (MultiMaster <> HoldTable) THEN
   IF ISEMPTY(MultiMaster) THEN
      ScreenMessage = "Master record must exist before detail records can be added."

      IF InfoDyn["DoLock"] THEN
         EXECUTE "UNLOCK " + EditLockString
      ENDIF
      
      RETURN
   ENDIF
ENDIF

; Pick appropriate editing form if called for.

IMAGERIGHTS
COEDITKEY

IF Linked THEN
   IF (InfoDyn["LinkEditForm"] <> "") THEN
      IF FormFlag AND (ISMULTIFORM(TABLE(),FORM()) OR (LINKTYPE() <> "None")) THEN
         MOVETO MultiMaster
      ENDIF

      PICKFORM InfoDyn["LinkEditForm"]
      EditForm = InfoDyn["LinkEditForm"]
   ENDIF
ELSE
   IF (InfoDyn["EditForm"] <> "") THEN
      IF FormFlag AND (ISMULTIFORM(TABLE(),FORM()) OR (LINKTYPE() <> "None")) THEN
         MOVETO MultiMaster
      ENDIF

      PICKFORM InfoDyn["EditForm"]
      EditForm = InfoDyn["EditForm"]
   ENDIF
ENDIF
   
MOVETO HoldTable
CTRLEND
HoldLast = FIELD()
CTRLHOME
END

; Fill in [Number] field if applicable.

IF FormFlag AND (FIELDNO("Number",TABLE()) <> "Error") THEN
   IF ISBLANK([Number]) THEN
      [Number] = 1
   ELSE   
      END
      NumberHolder = [Number]
      CTRLEND
      DOWN
      [Number] = NumberHolder + 1
   ENDIF
ELSE
   INS
ENDIF   

; Fill in [Date] and [Time] fields if applicable.

IF FormFlag THEN
   IF (FIELDNO("Date",TABLE()) <> "Error") THEN
      [Date] = TODAY()
   ENDIF   

   IF (FIELDNO("Time",TABLE()) <> "Error") THEN
      [Time] = SUBSTR(TIME(),1,5)
   ENDIF   
ENDIF

COPYTOARRAY HoldRecord

; Call arrival procedure if applicable.

IF (ArrProc <> "") THEN

   EXECPROC ArrProc

ENDIF

IF (NOT InfoDyn["KeyAccess"]) THEN
   IMAGERIGHTS UPDATE ; Protect key field(s).
ENDIF

; Establish an overall pulldown menu loop for control of user action.

WHILE (TRUE)

SHOWPULLDOWN
   " (F1 = Lookups)   "   : "" : "",
   "~F2~ = Save/Done   "  : "" : "F2",
   "~F5~ = ClearEntry   " : "" : "F5",
   "~Ins~ = Save/Next"    : "" : "INS"
ENDMENU 

; Add remainder of screen guidance.

IF ScreenMessage <> "" THEN
   BEEP SLEEP 25 BEEP
ENDIF

ECHO NORMAL
MESSAGE ScreenMessage

PROMPT " - - - - - - - - - - - -  ENTER NEW RECORDS AS DESIRED  - - - - - - - - - - - -"

; Assign error handler to deal with invalid field entries.

ERRORPROC = "ZEditErr"

; Start the WAIT loop.

WAIT RECORD PROC "ZAddWait"
   KEY "INS","DITTO","F2","F5",15,-18,-24,-31,-37,-38,-45,-98,-100
   MESSAGE "CLOSE","MENUSELECT"
ENDWAIT

IF retval = 2005 THEN
   QUITLOOP
ENDIF

ENDWHILE

RELEASE VARS 
   ERRORPROC
ECHO OFF
CLEARPULLDOWN
PROMPT

IF (NOT InfoDyn["KeyAccess"]) THEN
   IMAGERIGHTS
ENDIF   

DO_IT!

; Call departure procedure if applicable.

IF (DepProc <> "") THEN

   EXECPROC DepProc

ENDIF

; Return to former conditions.

IF NIMAGES() > 0 THEN
   IF (EditForm <> "") THEN
      IF FormFlag AND (ISMULTIFORM(TABLE(),FORM()) OR (LINKTYPE() <> "None")) THEN
         MOVETO MultiMaster
      ENDIF
   
      IF NOT ISEMPTY(TABLE()) THEN
         PICKFORM HoldForm
      ENDIF
   ENDIF

   IF (NOT FormFlag) AND ISFORMVIEW() THEN
      FORMKEY
   ENDIF
ENDIF

MOVETO HoldTable
ErrorFlag = FALSE ; In case not reset elsewhere.

IF InfoDyn["DoLock"] THEN
   EXECUTE "UNLOCK " + EditLockString
ENDIF   

ENDPROC ; ZAdd(ArrProc,DepProc)

WRITELIB G.AppLib ZAdd
RELEASE PROCS ZAdd