PROC ZWait(WaitTrig,WaitEvent,WaitCycle)

; ZWait - Generic table viewing menu/event action procedure.

; Copyright 1992 by WHITE HEAT, Inc.  All Rights Reserved.

PRIVATE
   WhatKind,
   WaitVal,
   NoBeep

; Initialize variables.

ScreenMessage = "" ; No matter what it might have been, always gets reset.
WhatKind = ""      ; Used by final SWITCH statement.
WaitVal = 2        ; Most common response - others set below as applicable.
NoBeep = FALSE     ; When TRUE, keeps keypress from returning to WAIT
                   ;    loop and causing an extraneous beep.

; Go through this process only in the case of events.

IF WaitTrig = "EVENT" THEN

   ; Check for return from ZOOM action - keep this the first thing in proc.

   IF ZoomFlag THEN
      ZoomFlag = FALSE

      NEWWAITSPEC 
         KEY "F2","F3","F4","F7","F9","F10","ESC","DEL","INS",15,-18,-24,26,-31,-37,-38,-44,-45,-98,-100
         MESSAGE "CLOSE","MENUSELECT"
      WaitVal = 0
      RETURN WaitVal
   ENDIF

   ; Check for FIELDVIEW mode to avoid breaks.
   
   IF ISFIELDVIEW() THEN
      IF SUBSTR(FIELDTYPE(),1,1) = "M" THEN
         IF WaitEvent["TYPE"] = "KEY" THEN
            IF WaitEvent["KEYCODE"] = -60 THEN ; If in FIELDVIEW mode and
               WaitVal = 0                     ;    user already pressed
               RETURN WaitVal                  ;    F2, just execute it.
            ENDIF
         ELSE
            DO_IT! ; Exits memo field editing mode.
         ENDIF
      ELSE
         ENTER ; Exits FIELDVIEW mode.
      ENDIF
   ENDIF

   ; Check for event type of keypress rather than mouse click(s). 

   IF WaitEvent["TYPE"] = "KEY" THEN

      ; If the keypress is "F10," then get user input from pulldown menu.

      IF WaitEvent["KEYCODE"] = -68 THEN 
         GETMENUSELECTION TO WhatKind    
         WaitEvent["MENUTAG"] = WhatKind
      ELSE ; Otherwise, assign "WhatKind" according to keypress.
         SWITCH
            CASE WaitEvent["KEYCODE"] =  26 : WhatKind = "Search" ; CTL-Z
            CASE WaitEvent["KEYCODE"] = -44 : WhatKind = "Next"   ; ALT-Z
            CASE WaitEvent["KEYCODE"] =  27 : WhatKind = "Quit"   ; ESC
            CASE WaitEvent["KEYCODE"] = -60 : WhatKind = "Quit"   ; F2
            CASE WaitEvent["KEYCODE"] = -61 : WhatKind = "Upper"  ; F3
            CASE WaitEvent["KEYCODE"] = -62 : WhatKind = "Lower"  ; F4
            CASE WaitEvent["KEYCODE"] = -65 : WhatKind = "Toggle" ; F7
                                              NoBeep = TRUE
            CASE WaitEvent["KEYCODE"] = -67 : WhatKind = "Edit"   ; F9         
            CASE WaitEvent["KEYCODE"] = -83 : WhatKind = "Delete" ; DEL
            CASE WaitEvent["KEYCODE"] = -82 : WhatKind = "Add"    ; INS    
            OTHERWISE                       : WaitVal = 1
                                              BEEP
                                              RETURN WaitVal
         ENDSWITCH
      ENDIF
   ENDIF

   ; If event type is "MESSAGE" - MOUSE click(s) - then assign
   ;    "WhatKind" according to any valid MOUSE actions. 

   IF WaitEvent["TYPE"] = "MESSAGE" THEN
      IF WaitEvent["MESSAGE"] = "CLOSE" THEN ; Bypass "CLOSE" mouse actions.
         WaitVal = 0
         WhatKind = ""
      ELSE
         SWITCH
            CASE WaitEvent["MENUTAG"] = "Search" OR
                 WaitEvent["MENUTAG"] = "Next"   OR
                 WaitEvent["MENUTAG"] = "Upper"  OR
                 WaitEvent["MENUTAG"] = "Lower"  OR
                 WaitEvent["MENUTAG"] = "Toggle" OR
                 WaitEvent["MENUTAG"] = "Link"   OR
                 WaitEvent["MENUTAG"] = "Master" OR
                 WaitEvent["MENUTAG"] = "Quit"   OR
                 WaitEvent["MENUTAG"] = "Edit"   OR
                 WaitEvent["MENUTAG"] = "Delete" OR
                 WaitEvent["MENUTAG"] = "Add"      : 

                    WhatKind = WaitEvent["MENUTAG"]
         ENDSWITCH
      ENDIF
   ENDIF

   ; Act on valid events, after checking "Access" authorization.

   SWITCH
      CASE WhatKind = "Search" : ; Create ZOOM interaction.
      
                                 WaitEvent["TYPE"] = "KEY"
                                 WaitEvent["KEYCODE"] = 26
                                 ZoomFlag = TRUE
                                 WaitVal = 0
                                 NEWWAITSPEC 
                                    MOUSE "DOWN"
                                    KEY "ESC","ENTER",15,-18,-24,-31,-37,-38,-45,-98,-100
                                    MESSAGE "CLOSE"
                                 EXECEVENT WaitEvent

      CASE WhatKind = "Next"   : ; Create ZOOMNEXT action.
      
                                 WaitEvent["TYPE"] = "KEY"
                                 WaitEvent["KEYCODE"] = -44
                                 WaitVal = 0
                                 EXECEVENT WaitEvent

      CASE WhatKind = "Toggle" : WaitVal = 0
      
                                 IF NoBeep THEN
                                    WaitVal = 2
                                 ENDIF
      
                                 IF NoForm OR InfoDyn["MultiLock"] OR InfoDyn["HideTable"] THEN
                                    BEEP
                                 ELSE
                                    ECHO OFF
                                    FORMKEY
                                 ENDIF      
                                 
      CASE WhatKind = "Link"   : ECHO OFF
      
                                 IF (IMAGENO() <> 1) THEN
                                    MOVETO 1
                                 ENDIF
                                 
                                 IF ISEMPTY(TABLE()) THEN
                                    BEEP
                                    WaitVal = 0
                                    RETURN WaitVal
                                 ENDIF
      
                                 PICKFORM InfoDyn["LinkForm"]
                                 
                                 IF ISMULTIFORM(TABLE(),FORM()) THEN
                                    InfoDyn["MultiLock"] = TRUE
                                 ELSE
                                    InfoDyn["MultiLock"] = FALSE
                                 ENDIF
                                 
                                 CurrAccess = InfoDyn["Access"]
                                 Linked = TRUE
                                 
      CASE WhatKind = "Master" : ECHO OFF
      
                                 IF (IMAGENO() <> 1) THEN
                                    MOVETO 1
                                 ENDIF
      
                                 IF ISEMPTY(TABLE()) THEN
                                    BEEP
                                    WaitVal = 0
                                    RETURN WaitVal
                                 ENDIF
                                       
                                 IF (InfoDyn["FormName"] <> "") THEN
                                    PICKFORM InfoDyn["FormName"]
                                 ELSE
                                    FORMKEY
                                 ENDIF
                                 
                                 InfoDyn["MultiLock"] = FALSE
                                 CurrAccess = InfoDyn["Access"]
                                 Linked = FALSE
                                 
      CASE WhatKind = "Upper"  : ECHO OFF
       
                                 IF ISFORMVIEW() AND InfoDyn["MultiLock"] THEN
                                    UPIMAGE
                                 ELSE
                                    IF Linkage AND ISFORMVIEW() AND InfoDyn["MultiLock"] THEN
                                       UPIMAGE
                                    ELSE
                                       WaitVal = 0
                                    ENDIF
                                 ENDIF

                                 IF TABLE() = TableVar THEN
                                    CurrAccess = InfoDyn["Access"]
                                 ELSE
                                    IF Linked THEN
                                       CurrAccess = InfoDyn["LinkAccess"]
                                    ENDIF
                                 ENDIF

      CASE WhatKind = "Lower"  : ECHO OFF
      
                                 IF ISFORMVIEW() AND InfoDyn["MultiLock"] THEN
                                    DOWNIMAGE
                                 ELSE
                                    IF Linkage AND ISFORMVIEW() AND InfoDyn["MultiLock"] THEN
                                       DOWNIMAGE
                                    ELSE
                                       WaitVal= 0
                                    ENDIF
                                 ENDIF
                                 
                                 IF TABLE() = TableVar THEN
                                    CurrAccess = InfoDyn["Access"]
                                 ELSE
                                    IF Linked THEN
                                       CurrAccess = InfoDyn["LinkAccess"]
                                    ENDIF
                                 ENDIF

      CASE WhatKind = "Edit"   : IF CurrAccess > 1 THEN
                                    ECHO OFF
                                    
                                    IF (InfoDyn["FieldName"] <> "") AND TABLE() = TableVar AND 
                                       (ISFORMVIEW() AND ISMULTIFORM(TABLE(),FORM()))      THEN
                                       
                                       DOWNIMAGE
                                       
                                       IF SUBSTR(LINKTYPE(),1,1) = "1" THEN
                                          ScreenMessage = "Can't change master record in secondary index view."
                                          UPIMAGE
                                          RETURN WaitVal
                                       ENDIF
                                       
                                       UPIMAGE
                                    ENDIF
      
                                    ZModify(InfoDyn["ZModArr"],InfoDyn["ZModDep"])

                                 ELSE
                                    BEEP
                                    WaitVal = 0
                                    RETURN WaitVal
                                 ENDIF
                                    
      CASE WhatKind = "Delete" : IF CurrAccess > 2 THEN
                                    ECHO OFF

                                    ZDelete(InfoDyn["ZDelArr"],InfoDyn["ZDelDep"])
                                    
                                 ELSE
                                    BEEP
                                    WaitVal = 0
                                    RETURN WaitVal
                                 ENDIF
            
      CASE WhatKind = "Add"    : IF CurrAccess > 0 THEN
                                    ECHO OFF
                   
                                    IF (InfoDyn["FieldName"] <> "") AND TABLE() = TableVar AND 
                                       (ISFORMVIEW() AND ISMULTIFORM(TABLE(),FORM()))      THEN
                                       
                                       DOWNIMAGE
                                       
                                       IF SUBSTR(LINKTYPE(),1,1) = "1" THEN
                                          ScreenMessage = "Can't add master records in secondary index view."
                                          UPIMAGE
                                          RETURN WaitVal
                                       ENDIF
                                       
                                       UPIMAGE
                                    ENDIF
                                    
                                    ZAdd(InfoDyn["ZAddArr"],InfoDyn["ZAddDep"])
                                    
                                 ELSE
                                    BEEP
                                    WaitVal = 0
                                    RETURN WaitVal
                                 ENDIF
                                    
      CASE WhatKind = "Quit"   : WaitVal = 3 ; Will cause "Quit" action.
   ENDSWITCH
ENDIF

RETURN WaitVal

ENDPROC ; ZWait(WaitTrig,WaitEvent,WaitCycle)

WRITELIB G.AppLib ZWait
RELEASE PROCS ZWait