PROC ZRLock2(MsgType)

; ZRLock2 - Lock record, for newly-entered records, to check for key violation.

; Copyright 1990, 1992, 1992 by WHITE HEAT, Inc.  All Rights Reserved.

; NOTE: MsgType must equal numberical value of 1 or 0.  1 = Don't give
;       "DupMessage," and 0 = Do give "DupMessage."

PRIVATE
   DupMessage

; Assign variable.

DupMessage = "One or more duplicate \"key\" fields; change one of first " +
             STRVAL(NKEYFIELDS(TABLE())) + " field(s) - Press a key..."

; Check for key violation.

POSTRECORD NOPOST LEAVELOCKED

IF retval THEN
   RETURN ""
ENDIF

DEL
UNDO

IF MsgType = 0 THEN
   ScreenMessage = DupMessage
ENDIF

RETURN "No"

ENDPROC ; ZRLock2(MsgType)

WRITELIB G.AppLib ZRLock2
RELEASE PROCS ZRLock2