PROC ZModWait(WaitTrig,WaitEvent,WaitCycle)

; ZModWait - Generic table editing menu/event action procedure.

; Copyright 1992 by WHITE HEAT, Inc.  All Rights Reserved.

PRIVATE
   WaitVal,
   NKeyHold,
   WhatKind

; Initialize/reset variables.

WaitVal = 1 ; Most common possibility.
NKeyHold = NKEYFIELDS(TABLE())
WhatKind = ""
ScreenMessage = ""

; Go through this process only in the case of events.

IF WaitTrig = "EVENT" THEN

   ; Check for FIELDVIEW mode.
   
   IF ISFIELDVIEW() THEN
      IF SUBSTR(FIELDTYPE(),1,1) = "M" THEN
         IF WaitEvent["TYPE"] = "KEY" THEN
            IF WaitEvent["KEYCODE"] = -60 THEN ; F2
               WaitVal = 0
               RETURN WaitVal
            ENDIF
         ELSE
            DO_IT!
         ENDIF
      ELSE
         ENTER
      ENDIF
   ENDIF

   ; Check for event type of keypress rather than mouse click(s). 

   IF WaitEvent["TYPE"] = "KEY" THEN
      SWITCH
         CASE WaitEvent["KEYCODE"] = -60 : WhatKind = "F2"
         CASE WaitEvent["KEYCODE"] = -63 : WhatKind = "F5"
         OTHERWISE                       : BEEP
                                           RETURN WaitVal
      ENDSWITCH
   ENDIF

   ; If event type is "MESSAGE" - MOUSE click(s) - then assign
   ;    "WhatKind" according to any valid MOUSE actions. 

   IF WaitEvent["TYPE"] = "MESSAGE" THEN
      IF WaitEvent["MESSAGE"] = "CLOSE" THEN
         BEEP
         RETURN WaitVal
      ELSE
         SWITCH
            CASE WaitEvent["MENUTAG"] = "F2" OR
                 WaitEvent["MENUTAG"] = "F5"    : 
                 
                    WhatKind = WaitEvent["MENUTAG"]
         ENDSWITCH
      ENDIF
   ENDIF

   ; Act on valid events.

   SWITCH
      CASE WhatKind = "F2" : ECHO OFF
                             WaitVal = 2
      
                             ; Check for invalid ValCheck field problems.
                             
                             MOVETO FIELD HoldLast
                                
                             IF ErrorFlag THEN
                                ErrorFlag = FALSE
                                RETURN WaitVal
                             ENDIF

                             IF NKeyHold > 0 THEN

                                ; Check for empty first field.

                                CTRLHOME
                                
                                IF FIELD() = "#" THEN
                                   RIGHT
                                ENDIF

                                IF ISBLANK([]) THEN
                                   ScreenMessage = "First field must contain"
                                                   + " an entry (else delete"
                                                   + " record)."
                                   ECHO NORMAL
                                   RETURN WaitVal
                                ENDIF

                                ; Check for key violation.

                                IF (InfoDyn["FieldName"] <> "") AND TABLE() = TableVar THEN
                                   ScreenMessage = "(Edited record occupying secondary index position for this view.)"
                                   POSTRECORD NOPOST
                                ELSE
                                   POSTRECORD NOPOST LEAVELOCKED
                                ENDIF
                                
                                IF NOT retval THEN
                                   ScreenMessage = "Key violation - change "
                                                   + "something in first " +
                                                   STRVAL(NHold) + 
                                                   " field(s)."
                                   ECHO NORMAL
                                   RETURN WaitVal
                                ENDIF
                             ELSE
                                LOCKRECORD
                             ENDIF
                        
                             UNLOCKRECORD
                             
                             WaitVal = 3
                                                   
      CASE WhatKind = "F5" : IF (NOT InfoDyn["KeyAccess"]) THEN
                                IMAGERIGHTS 
                             ENDIF
            
                             COPYFROMARRAY HoldRecord
      
                             IF ErrorFlag THEN
                                ErrorFlag = FALSE
                                WaitVal = 2
                             ENDIF
                             
                             IF (NOT InfoDyn["KeyAccess"]) THEN
                                IMAGERIGHTS UPDATE ; Protect key field(s).
                             ENDIF
   ENDSWITCH
ENDIF

RETURN WaitVal

ENDPROC ; ZModWait(WaitTrig,WaitEvent,WaitCycle)

WRITELIB G.AppLib ZModWait
RELEASE PROCS ZModWait