PROC ZModify(ArrProc,DepProc)

; ZModify - Generic record update procedure.

; Copyright 1992 by WHITE HEAT, Inc.  All Rights Reserved.

PRIVATE
   Result,
   EditLockString,
   EditForm,
   FormFlag,
   HoldForm,
   HoldTable,
   HoldLast,
   MultiMaster,
   EmptyFlag,
   HoldRecord,
   Found,
   Head,
   Tail

; Assign initial and current environment variables, determine locking needs.

EditForm = ""
HoldForm = ""
MultiMaster = ""
FormFlag = FALSE
EmptyFlag = FALSE
Found = TRUE

IF (NOT ISASSIGNED(Linked)) THEN
   Linked = FALSE
ENDIF   

IF ISFORMVIEW() THEN
   FormFlag = TRUE
ENDIF

HoldTable = TABLE()

IF InfoDyn["MultiLock"] AND FormFlag THEN
   MOVETO InfoDyn["TableName"]
ENDIF   

MultiMaster = TABLE()

IF FormFlag THEN
   HoldForm = FORM()
ENDIF

; Check for empty table.

IF ISEMPTY(HoldTable) THEN
   EmptyFlag = TRUE
ENDIF

IF InfoDyn["MultiLock"] THEN
   IF ISEMPTY(MultiMaster) THEN
      EmptyFlag = TRUE      
   ENDIF
ENDIF

IF EmptyFlag THEN
   MOVETO HoldTable
   ScreenMessage = "There are no records to modify."
   RETURN
ENDIF

; Construct locking string.

IF InfoDyn["DoLock"] THEN
   EditLockString = LockString ; "LockString" assigned from "ZView" procedure.

   WHILE (Found)
      Found = MATCH(EditLockString,"..PFL..",Head,Tail)

      IF Found THEN
         EditLockString = Head + "PWL" + Tail
      ENDIF
   ENDWHILE

   ; Handle necessary locking.

   Result = ZTLock(EditLockString,0,0)

   MOVETO HoldTable

   IF Result = "No" THEN
      RETURN
   ENDIF
ENDIF   

; Pick appropriate editing form if called for.

IF Linked THEN
   IF (InfoDyn["LinkEditForm"] <> "") THEN
      IF FormFlag AND (ISMULTIFORM(TABLE(),FORM()) OR (LINKTYPE() <> "None")) THEN
         MOVETO MultiMaster
      ENDIF
   
      PICKFORM InfoDyn["LinkEditForm"]
      EditForm = InfoDyn["LinkEditForm"]
   ENDIF
ELSE
   IF (InfoDyn["EditForm"] <> "") THEN
      IF FormFlag AND (ISMULTIFORM(TABLE(),FORM()) OR (LINKTYPE() <> "None")) THEN
         MOVETO MultiMaster
      ENDIF
   
      PICKFORM InfoDyn["EditForm"]
      EditForm = InfoDyn["EditForm"]
   ENDIF
ENDIF   
   
; Handle record locking.

COEDITKEY

IF InfoDyn["RecordLock"] THEN

   Result = ZRLock1(0,0)

   IF Result = "No" THEN
      DO_IT!

      IF InfoDyn["DoLock"] THEN
         EXECUTE "UNLOCK " + EditLockString
      ENDIF

      IF (EditForm <> "") THEN
         IF FormFlag AND (ISMULTIFORM(TABLE(),FORM()) OR (LINKTYPE() <> "None")) THEN
            MOVETO MultiMaster
         ENDIF
      
         PICKFORM HoldForm
      ENDIF

      IF (NOT FormFlag) and ISFORMVIEW() THEN
         FORMKEY
      ENDIF
   
      MOVETO HoldTable
      RETURN
   ENDIF
ENDIF   

ScreenMessage = "Please verify that you are editing the correct record..."
MOVETO HoldTable
COPYTOARRAY HoldRecord
Result = FIELD()
CTRLEND
HoldLast = FIELD()
MOVETO FIELD Result

; Call arrival procedure if applicable.

IF (ArrProc <> "") THEN

   EXECPROC ArrProc

ENDIF

IF InfoDyn["KeyAccess"] THEN
   IMAGERIGHTS
ELSE
   IMAGERIGHTS UPDATE ; Protect key field(s).
ENDIF

; Establish an overall loop for control of user action.

WHILE (TRUE)

REFRESH

; Set up overall pulldown menu.

SHOWPULLDOWN
   " (F1 = Lookups)     "    : "" : "" ,
   "~F2~ = Finished     "    : "" : "F2",
   "~F5~ = UndoChanges     " : "" : "F5"
ENDMENU 

; Add remainder of screen guidance.

IF ScreenMessage <> "" THEN
   BEEP SLEEP 25 BEEP
ENDIF

ECHO NORMAL
MESSAGE ScreenMessage

PROMPT "      - - - - - - - - - - - MAKE CHANGES AS DESIRED - - - - - - - - - - -"

; Assign error handler to deal with invalid field entries.

ERRORPROC = "ZEditErr"

; Start the WAIT loop.

WAIT RECORD PROC "ZModWait"
   KEY "F2","F5",15,-18,-24,-31,-37,-38,-45,-98,-100
   MESSAGE "CLOSE","MENUSELECT"
ENDWAIT

IF retval = 2005 THEN
   QUITLOOP
ENDIF

ENDWHILE

RELEASE VARS
   ERRORPROC
ECHO OFF
CLEARPULLDOWN
PROMPT
DO_IT!

IF (NOT InfoDyn["KeyAccess"]) THEN
   IMAGERIGHTS
ENDIF

; Call departure procedure if applicable.

IF (DepProc <> "") THEN

   EXECPROC DepProc

ENDIF

; Return to previous conditions.

IF NIMAGES() > 0 THEN
   IF (EditForm <> "") THEN
      IF FormFlag AND (ISMULTIFORM(TABLE(),FORM()) OR (LINKTYPE() <> "None")) THEN
         MOVETO MultiMaster
      ENDIF
   
      PICKFORM HoldForm
   ENDIF

   IF (NOT FormFlag) AND ISFORMVIEW() THEN
      FORMKEY
   ENDIF
ENDIF

MOVETO HoldTable
ErrorFlag = FALSE ; In case not reset elsewhere.

IF InfoDyn["DoLock"] THEN
   EXECUTE "UNLOCK " + EditLockString
ENDIF   

ENDPROC ; ZModify(ArrProc,DepProc)

WRITELIB G.AppLib ZModify
RELEASE PROCS ZModify