PROC ZEditErr()

; ZEditErr - Deal with error due to ValCheck field entry errors.

; Copyright 1992 by WHITE HEAT, Inc.  All Rights Reserved.

; NOTE: This proc assigned only by ZModify and ZAdd procedures.

PRIVATE
   EFile,
   EDyn,
   Element

; Check for most obvious errors first.

IF ERRORCODE() = 25 THEN
   ErrorFlag = TRUE

   ZResetEC() ; Reset ERRORCODE()

   RETURN 1
ENDIF

IF ERRORCODE() = 23 THEN
   ErrorFlag = TRUE
   CTRLBACKSPACE
   
   ZResetEC() ; Reset ERRORCODE()
   
   ScreenMessage = "Entry was not one of the possible values for this field..." 
   RETURN 1
ENDIF

; De-assign, assign variables.

RELEASE VARS
   ERRORPROC
Efile = PRIVDIR() + "EFile"
ERRORINFO TO EDyn

; Handle system functions.

IF SYSMODE() <> "Main" THEN
   DO_IT!
ENDIF   

IF ISFILE(EFile + "sc") THEN
   MENU
      {Tools}
      {Delete}
      {Script}
      SELECT EFile
      {Ok}
ENDIF

EFile = EFile + ".sc"

FOREACH Element in EDyn
   PRINT FILE EFile STRVAL(EDyn[Element]) + " - ","\n"
ENDFOREACH

PRINT FILE EFile "Date/",TODAY()," - ","\n"
PRINT FILE EFile "Time/",TIME(),"\n"

SAVEVARS ALL

RETURN 2

ENDPROC ; ZEditErr()

WRITELIB G.AppLib ZEditErr
RELEASE PROCS ZEditErr