SHOWPULLDOWN ENDMENU
Prompt Spaces(80)
   DynArray y[]
      y["CanClose"] = False
      y["CanMaximize"] = False
      y["CanMove"] = False
      y["CanResize"] = False
      y["HasFrame"] = False    ; If Framed, window is *5* rows!!!
      y["Style"] = 112

   Window Create  Floating @ 24,0
                  Height 1 Width 80
                  Attributes y To g.message.w
; ===========================================================================
;      MODULE: Dialog-based Vertical Menus
;      AUTHOR: (c) 1993 - Daniel J. Paolini II - DataStar International
;     CREATED: 01-21-93 11:57pm
; DESCRIPTION: These routines establish and support a dialog box-based
;              vertical menu:
;                 mnVerticalDialog.n      ; Core dialog box routine
;                 mnVerticalDialogEH.l    ; Default event handler
;                 mnVerticalDialogHelp.u  ; Default help dialog box
;                 inAttributeConvert.n    ; Returns highlight/lowlight colors
; ---------------------------------------------------------------------------
;       TITLE: mnVerticalDialog.n
;     RETURNS: Number of menu item selected, or zero if canceled
; DESCRIPTION: Displays a vertical menu in a dialog box
; ---------------------------------------------------------------------------
PROC mnVerticalDialog.n(         ; Displays a vertical menu in dialog box
         menuitems.r,            ; Array of menu items
         menuprompts.r,          ; Array of menu prompts
         menutitle.a,            ; Title for menu
         user.a,                 ; User name to display on menu
         menucolors.y,           ; Optional alternate window colors
         eventhandler.a)         ; Optional alternate event handler
Private  n,                      ; Transient loop counter
         row.n,                  ; Top row for dialog box
         column.n,               ; Left column for dialog box
         menutag.n,              ; Menu item selected
         width.n,                ; Width of menu item picklist
         frameleft.n,            ; Left column for menu item frame
         framebottom.n,          ; Bottom row for menu item frame
         frameright.n,           ; Right column for menu item frame
         searchstring.a,         ; String of 1st characters of each item
         items.n,                ; Number of items in menu
         textcolor.n,            ; Window text color
         height.n                ; Menu dialog box height
;Global  g.sysinfo.y             ; Stores SysInfo elements

   IF NOT IsAssigned(g.sysinfo.y) THEN
      SysInfo To g.sysinfo.y              ; Capture SysInfor for screen size
   ENDIF

   IF IsBlank(eventhandler.a) THEN        ; Substitute default event handler
      eventhandler.a = "mnVerticalDialogEH.l"
   ENDIF

   items.n = ArraySize(menuitems.r)       ; How many items?
   width.n = 0
   searchstring.a = ""                    ; String of item hotkeys
   FOR n From 1 To items.n                ; Calculate max width and hotkeys
      width.n = Max(width.n,Len(menuitems.r[n])+2)
      searchstring.a = searchstring.a + SubStr(menuitems.r[n],1,1)
   ENDFOR
   width.n = Min(54,width.n)              ; Maximum width is 54

   frameleft.n = Int((56 - width.n)/2)    ; Calculate menu item frame
   framebottom.n = 2 + Min(items.n,10)    ;  coordinates
   frameright.n = frameleft.n + width.n + 3

   height.n = 9 + framebottom.n           ; Calculate dialog box dimensions
   row.n = Int((g.sysinfo.y["ScreenHeight"]- height.n - 1)/2)
   column.n = Int((g.sysinfo.y["ScreenWidth"]-58)/2)
   menutag.n = 0                          ; Initialize menu choice variable
                                          ; Determine text color
   textcolor.n = IIF(Type(menucolors.y) = "DY" AND
                      IsAssigned(menucolors.y["5"]),
                      menucolors.y["5"], SysColor(1036))

   SHOWDIALOG ""
      PROC eventhandler.a ALL
      @ -200, -200 Height height.n Width 62
                                          ; Menu items frame
      Frame Single From 1,frameleft.n To framebottom.n,frameright.n
         PaintCanvas Border
                     Attribute inAttributeConvert.n(textcolor.n,false)
                     1,frameleft.n,framebottom.n,frameright.n
         PaintCanvas Border
                     Attribute inAttributeConvert.n(textcolor.n,true)
                     framebottom.n,frameleft.n+1,framebottom.n,frameright.n
         PaintCanvas Border
                     Attribute inAttributeConvert.n(textcolor.n,true)
                     1,frameright.n,framebottom.n,frameright.n
                                          ; Menu prompt frame
      Frame Single From framebottom.n+1,1 To framebottom.n+3,58
         PaintCanvas Border
                     Attribute inAttributeConvert.n(textcolor.n,true)
                     framebottom.n+1,1,framebottom.n+3,58
         PaintCanvas Border
                     Attribute inAttributeConvert.n(textcolor.n,false)
                     framebottom.n+3,2,framebottom.n+3,58
         PaintCanvas Border
                     Attribute inAttributeConvert.n(textcolor.n,false)
                     framebottom.n+1,58,framebottom.n+3,58
                                          ; Date/user/time frame
      Frame Single From framebottom.n+4,12 To framebottom.n+6,47
         PaintCanvas Border
                     Attribute inAttributeConvert.n(textcolor.n,true)
                     framebottom.n+4,12,framebottom.n+6,47
         PaintCanvas Border
                     Attribute inAttributeConvert.n(textcolor.n,false)
                     framebottom.n+6,13,framebottom.n+6,47
         PaintCanvas Border
                     Attribute inAttributeConvert.n(textcolor.n,false)
                     framebottom.n+4,47,framebottom.n+6,47
                                          ; Menu title placement
      PaintCanvas Fill Format("w58,ac",menutitle.a)
                  Attribute (Int(textcolor.n/16) * 16) + 15
                  0,1,0,58
                                          ; Date/user/time placement
      PaintCanvas Fill Format("w8,d1",Today()) +
                       Format("w16,ac",user.a) + Time()
                  Attribute (Int(textcolor.n/16) * 16) + 15
                  framebottom.n+5,14,framebottom.n+5,45
                                          ; Menu prompt placement
      PaintCanvas Fill Format("W54,ac",menuprompts.r[menutag.n])
                  Attribute textcolor.n
                  framebottom.n+2,3,framebottom.n+2,54
                                          ; Menu item placement
      PickArray @ 2,frameleft.n+2 Height framebottom.n-2 Width width.n
         Columns 1 menuitems.r Tag "MENULIST"
      To menutag.n
                                          ; help/exit buttons placement
      PushButton @ framebottom.n+5,2 Width 8
         "~H~elp" Value "HELP" Tag "HELP"
      To button.a

      PushButton @ framebottom.n+5,50 Width 8
         "~E~xit" Cancel Value "EXIT" Tag "EXIT"
      To button.a
   ENDDIALOG
   Return menutag.n                       ; Number of item selected, or zero
ENDPROC
; ---------------------------------------------------------------------------
;       TITLE: mnVerticalDialogEH.l
;     RETURNS: Logical true/false if event is accepted
; DESCRIPTION: Default event handler for vertical menu dialog box
; ---------------------------------------------------------------------------
PROC mnVerticalDialogEH.l(       ; Event handler for dbox vertical menu
         type.a,                 ; EVENT or trigger name
         tag.a,                  ; Current control tag
         event.v,                ; Dynarray of EVENT; UPDATE value; next
                                 ;  control from DEPART; or null string
         checkbox.a)             ; Checkbox label; or null string
Private  oldtag.n,               ; Current menutag.n
         retval.l,               ; Value to return
         h, y                    ; Transient window and dynarray variables
;Global  menutag.n,              ; Current item from mnVerticalDialog.n
;        searchstring.n          ; First character of each menu item
;        row.n                   ; Menu origin row
;        column.n                ; Menu origin column
;        height.n                ; Height of menu dialog box
;        items.n                 ; Number of menu items
   retval.l = false
   IF type.a = "EVENT" THEN      ; Not a trigger
      SWITCH
         CASE event.v["TYPE"] = "KEY"  :
            IF tag.a = "MENULIST" THEN
               SWITCH
                  CASE event.v["KEYCODE"] = 13 :
                     AcceptDialog
                  CASE event.v["KEYCODE"] = -72 :
                     menutag.n = menutag.n - 1
                     IF menutag.n < 1 THEN
                        menutag.n = items.n
                     ENDIF
                  CASE event.v["KEYCODE"] = -80  :
                     menutag.n = menutag.n + 1
                     IF menutag.n > items.n THEN
                        menutag.n = 1
                     ENDIF
                  CASE event.v["KEYCODE"] = -71  :
                     menutag.n = 1
                  CASE event.v["KEYCODE"] = -79  :
                     menutag.n = items.n
                  CASE event.v["KEYCODE"] > 31 AND event.v["KEYCODE"] < 127 :
                     oldtag.n = menutag.n
                     menutag.n = Search(Chr(event.v["KeyCode"]),searchstring.a)
                     IF menutag.n = 0 THEN
                        menutag.n = oldtag.n
                     ELSE
                        AcceptDialog
                     ENDIF
                  CASE event.v["KEYCODE"] = 9 OR
                       event.v["KEYCODE"] = -15 OR
                       event.v["KEYCODE"] = 27 OR
                       event.v["KEYCODE"] = -35 OR
                       event.v["KEYCODE"] = -18 :
                     retval.l = true
                  OTHERWISE               : Beep
               ENDSWITCH
               IF NOT retval.l THEN
                  ResyncControl "MENULIST"
               ENDIF
            ELSE
               retval.l = true
            ENDIF
         OTHERWISE   :
            retval.l = true
      ENDSWITCH
      RepaintDialog
   ELSE
      SWITCH
         CASE type.a = "OPEN" :
            Window Handle Dialog To h
            IF Type(menucolors.y) = "DY" THEN
               Window SetColors h From menucolors.y
            ENDIF
            RepaintDialog
            Window GetColors h To menucolors.y
            DynArray y[]
               y["HASFRAME"] = false
               y["OriginCol"] = column.n
               y["OriginRow"] = row.n
            Window SetAttributes h From y
         CASE type.a = "UPDATE" AND tag.a = "HELP" :
            mnVerticalDialogHelp.u(row.n,column.n,row.n+height.n-5)
         CASE type.a = "UPDATE" AND tag.a = "EXIT" :
            CancelDialog
         CASE type.a = "UPDATE" AND tag.a = "MENULIST" :
            AcceptDialog
      ENDSWITCH
      retval.l = true
   ENDIF
   Return retval.l
ENDPROC
; ---------------------------------------------------------------------------
;       TITLE: mnVerticalDialogHelp.u
;     RETURNS: No value
; DESCRIPTION: Default help dialog box for vertical menu dialog box
; ---------------------------------------------------------------------------
PROC mnVerticalDialogHelp.u(     ; Default help for vertical menu dialog box
         toprow.n,               ; Origin row for menu dialog box
         leftcolumn.n,           ; Origin column of menu dialog box
         helprow.n)              ; origin row for help dialog box
Private  button.l                ; Value of continue pushbutton
   SHOWDIALOG ""
      @ Min(helprow.n,g.sysinfo.y["ScreenHeight"]-7), leftcolumn.n + 10
      Height 5 Width 40
      PaintCanvas Fill Format("w36,ac","Use the Cursor \018 Keys to Scroll") +
                       Format("w36,ac","<Tab> to Buttons - <Enter> to Select")
                  Attribute SysColor(1036) 1, 1, 2, 36
      PushButton @ -1,13
         Width 12 "~C~ontinue"
         OK Default Value true Tag "OK"
      To button.l
   ENDDIALOG
   Return
ENDPROC
; ----------------------------------------------------------------------------
;       TITLE: inAttributeConvert.n
;     RETURNS: Either highlight or lowlight color of input color
; DESCRIPTION: Highlight is the intense shade of the background of the input
;              color.  Lowlight is black on the background of the input color.
;              Examples:      INPUT          HIGHLIGHT         LOWLIGHT
;                              112              127              112
;                               31               25               16
;                               49               59               48
; ----------------------------------------------------------------------------
PROC inAttributeConvert.n(       ; Converts input into highlight or lowlight
         color.n,                ; Input color - for background
         highlight.l)            ; True returns highlight, false lowlight
   Return (Int(color.n/16)*16) + IIF(highlight.l,Int(color.n/16)+8,0)
ENDPROC
; ----------------------------------------------------------------------------
; Example setup
   DynArray menucolors.y[]       ; Custom menu window colors
      menucolors.y["25"] = 113
      menucolors.y["26"] = 31
      menucolors.y["27"] = 27

   Array menuitems.r[6]          ; Array of menu choices
      menuitems.r[1] = "1 - This is the first menu selection"
      menuitems.r[2] = "2 - This is the second menu selection"
      menuitems.r[3] = "3 - This is the third menu selection"
      menuitems.r[4] = "4 - This is the fourth menu selection"
      menuitems.r[5] = "5 - This is the fifth menu selection"
      menuitems.r[6] = "6 - This is the last one"

   Array menuprompts.r[6]        ; Array of menu prompts
      menuprompts.r[1] = "Example of a menu prompt for item #1"
      menuprompts.r[2] = "Example of a menu prompt for item #2"
      menuprompts.r[3] = "Example of a menu prompt for item #3"
      menuprompts.r[4] = "Example of a menu prompt for item #4"
      menuprompts.r[5] = "Example of a menu prompt for item #5"
      menuprompts.r[6] = "Example of a menu prompt for item #6"

   WHILE true
      choice.n = mnVerticalDialog.n(menuitems.r, menuprompts.r,
                             "Demonstration of Dialog Box-based Vertical Menu",
                              UserName(),menucolors.y, "")
      SWITCH
         CASE choice.n = 0 : QUITLOOP
         OTHERWISE         : Message choice.n
      ENDSWITCH
   ENDWHILE
