; VERB.SC
; 08-30-88 WRITTEN BY RUSS WALTER      TO CONVERT A DOLLAR AMOUNT INTO WORDS
;                     1175 HUNTER DR
;                     ELGIN, IL  60120
; Pass procedure the number to convert to words in the variable X
; procedure will return the strings in X1,X2,X3,X4 split at a space
; strings are adjusted so that blank strings will be printed first
;
; example:      X=2.21
;
;               X1=""
;               X2=""
;               X3=""
;               X4="***TWO DOLLARS AND TWENTY ONE CENTS***"
;
; or            X=110.45
;
;               X1=""
;               X2=""
;               X3="***ONE HUNDRED TEN DOLLARS AND FORTY FIVE"
;               X4="CENTS***"
;
; largest number the procedure can handle is 999999999.99
; the number field should be formated as a dollar type for program to work
; correctly, or remark the dollar type and use the other format
;====================================================================================
;
Proc GetVerbage(X)

Private A,X1,A1,T
; this is for field formated as N types
; A=strval(X*100)    ; removes decimal
;
; this is for field formated as dollar types
A=Substr(Strval(X),1,Search(".",Strval(X))-1)+Substr(strval(X),len(strval(X))-1,2)  ; turn dollar into string

X1=Substr("00000000000"+A,Len(a)+1,11)             ; pad to 11 places
X1=Substr(X1,1,9)+" "+Substr(X1,10,2)              ; separate cents with space
X9=""

For A1 From 1 To 4
    B=Substr(X1,(A1-1)*3+1,3)                         ; get chunk of the number
    GiveVerbage()                                     ; convert it to words
    If X8="" AND A1=4 THEN X8="NO " Endif             ; check to see if nothing there
    If X8="" AND (X9="" OR A1=2) THEN Loop Endif
    T=0
    If X8="ONE " And (A1=3 Or A1=4) Then T=2 Endif    ; Dollar/Cents
    X9=X9+X8+Substr(Z3,((A1-1+T)*11+1),ZN3[A1+T])+" " ; add million,thousand,Dollar,cent
Endfor

Endproc
;
;==============================================================================
;
Proc GiveVerbage()            ; routine to give verbage

Private Y1,Y2,Y3,Y4

       Y1=Substr(B,1,1)       ; digit 1
       Y2=Substr(B,2,1)       ; digit 2
       Y3=Substr(B,3,1)       ; digit 3
       X8=""

       If Numval(Y1)>0 Then   ; do hundred
          X8=Substr(Z1,((Numval(Y1))-1)*11+1,Zn1[Numval(Y1)])+" HUNDRED "
       Endif

       If Y2>="2" Then                             ; Do 20 - 90
          X8=X8+Substr(Z2,(Numval(Y2)-2)*11+1,ZN2[Numval(Y2)-1])+" "
          Y2=" " ;DO 20-90
       Endif

       If y2="1" Then                              ; Do 1 - 19
          Y4=Y2+Y3
       Else
          y4=y3
       Endif

       If Numval(Y4)<>0 Then                       ; convert 1-19 to words
          X8=X8+Substr(Z1,(Numval(Y4)-1)*11+1,ZN1[Numval(Y4)])+" "
       Endif

Endproc
;
;==============================================================================
;
Proc ReadData()

; create data strings each entry must be 11 characters long
;   string              actual length of entry

      Z1="ONE        "  ZN1[1]=3
   Z1=Z1+"TWO        "  ZN1[2]=3
   Z1=Z1+"THREE      "  ZN1[3]=5
   Z1=Z1+"FOUR       "  ZN1[4]=4
   Z1=Z1+"FIVE       "  ZN1[5]=4
   Z1=Z1+"SIX        "  ZN1[6]=3
   Z1=Z1+"SEVEN      "  ZN1[7]=5
   Z1=Z1+"EIGHT      "  ZN1[8]=5
   Z1=Z1+"NINE       "  ZN1[9]=4
   Z1=Z1+"TEN        "  ZN1[10]=3
   Z1=Z1+"ELEVEN     "  ZN1[11]=6
   Z1=Z1+"TWELVE     "  ZN1[12]=6
   Z1=Z1+"THIRTEEN   "  ZN1[13]=8
   Z1=Z1+"FOURTEEN   "  ZN1[14]=8
   Z1=Z1+"FIFTEEN    "  ZN1[15]=7
   Z1=Z1+"SIXTEEN    "  ZN1[16]=7
   Z1=Z1+"SEVENTEEN  "  ZN1[17]=9
   Z1=Z1+"EIGHTEEN   "  ZN1[18]=8
   Z1=Z1+"NINETEEN   "  ZN1[19]=8

      Z2="TWENTY     "  ZN2[1]=6
   Z2=Z2+"THIRTY     "  ZN2[2]=6
   Z2=Z2+"FORTY      "  ZN2[3]=5
   Z2=Z2+"FIFTY      "  ZN2[4]=5
   Z2=Z2+"SIXTY      "  ZN2[5]=5
   Z2=Z2+"SEVENTY    "  ZN2[6]=7
   Z2=Z2+"EIGHTY     "  ZN2[7]=6
   Z2=Z2+"NINETY     "  ZN2[8]=6

      Z3="MILLION    "  ZN3[1]=7
   Z3=Z3+"THOUSAND   "  ZN3[2]=8
   Z3=Z3+"DOLLARS AND"  ZN3[3]=11
   Z3=Z3+"CENTS      "  ZN3[4]=5
   Z3=Z3+"DOLLAR AND "  ZN3[5]=10
   Z3=Z3+"CENT       "  ZN3[6]=4

Endproc
;
;==============================================================================
;
Proc BreakLine()

    ; break up line to print on check, if you want different length lines then
    ; change the number 45 to what ever you want

     X1="***"+Substr(X9,1,Len(X9)-1)+"***"

     If Len(X1)>45 Then                       ; search backward from position
        For J From 45 To 1 Step -1            ; 45 for first space
            If Substr(X1,J,1)=" " Then
               X2=Substr(X1,J+1,LEN(X1)-J)    ; line 2
               X1=Substr(X1,1,J-1)            ; line 1
               J=1
            Endif
        Endfor
     Endif

     If Len(X2)>45 Then                       ; search backward from position
        For J From 45 To 1 Step -1            ; 45 for first space
            If Substr(X2,J,1)=" " Then
               X3=Substr(X2,J+1,Len(X2)-J)    ; line 3
               X2=Substr(X2,1,J-1)            ; line 2
               J=1
            Endif
        Endfor
     Endif

     If Len(X3)>45 Then                       ; search backward from position
        For J From 45 TO 1 Step -1            ; 45 for first space
            If Substr(X3,J,1)=" " Then
               X4=Substr(X3,J+1,Len(X3)-J)    ; line 4
               X3=Substr(X3,1,Len(X3)-1)      ; line 3
               J=1
            Endif
       Endfor
    Endif

BottomFill()

Endproc
;
;==============================================================================
;
Proc BottomFill()

 ; ADJUST TO PRINT AT BOTTOM
   If X4="" Then X4=X3 X3=X2 X2=X1 X1="" Endif
   If X4="" Then X4=X3 X3=X2 X2=X1 X1="" Endif
   If X4="" Then X4=X3 X3=X2 X2=X1 X1="" Endif
   If X4="" Then X4=X3 X3=X2 X2=X1 X1="" Endif

Endproc
;====================================================================================
;
; program starts here
;

Clear ClearAll

; all these are string variables
; arrays ZN1,ZN2,ZN3 contain the lengths of the actual words in the string

X1="" X2="" X3="" X4="" X8="" X9=""
Array ZN1[19]        ; number of entries in string z1
Array ZN2[8]         ; number of entries in string z2
Array ZN3[6]         ; number of entries in string z3

Z1=Spaces(209)       ; initialize string for words ONE - NINETEEN
Z2=Spaces(88)        ; initialize string for words TWENTY - NINETY
Z3=Spaces(66)        ; initialize string for misc. words for DOLLARS, CENTS etc

ReadData()           ; read data for words

; add your program work after here

EDIT "DOLLAR"                  ; sample table used only for demo

SCAN
   GetVerbage([AMOUNT])        ; convert the number
   BreakLine()                 ; split the line

   [LINE1]=X1 X1=""            ; add lines to table to print in report
   [LINE2]=X2 X2=""            ;
   [LINE3]=X3 X3=""            ;
   [LINE4]=X4 X4=""            ;
ENDSCAN
do_it!
clearall
