;********************************;
; PARADOX Script: TabLkUp        ;
;                                ;
; ValCheck, Version 1.1          ;
; 15 Jan 92                      ;
; Informant Communications Group ;
;                                ;
; Required Scripts:              ;
;   GetValCk                     ;
;   ValCheck                     ;
;   PicLkUp                      ;
;   TabLkUp                      ;
;                                ;
; Required Tables:               ;
;   PicTab                       ;
;********************************;

CREATELIB "TabLkUp"

;**************************************************;
; LookUpTab() provides a "lookup" of tables in the ;
; current directory; it calls TabLkUpScr() to open ;
; a window, then displays the list of tables and   ;
; manages user input.                              ;
;**************************************************;
PROC LookUpTab()
  PRIVATE CurrRec,LineCount,CurrLine,NextLine,
          TopRec,RecCount,TotalRecs,c
  ;
  ; get name of current Table in order to manage
  ; movement between images, and place "lookup
  ; list" Table on the workspace
  ;
  CURSOR OFF
  DO_IT!
  IF NOT ISTABLE("List")
    THEN MESSAGE "Creating list of tables..."
         CANVAS OFF
         MENU {Tools} {Info} {Inventory}
              {Tables} ENTER
         MOVETO [Name]
         EDITKEY
         ;
         ; delete program tables from list
         ;
         LOCATE "List"
         DEL
         LOCATE "PicTab"
         DEL
         LOCATE WorkTab
         DEL
         DO_IT!
    ELSE CANVAS OFF
         VIEW "List"
  ENDIF
  HOME
  ;
  ; initialize variables
  ;
  CurrRec  =1
  LineCount=1
  CurrLine =1
  NextLine =2
  TopRec   =1
  RecCount =0
  TotalRecs=NRECORDS("List")
  ;
  ; open window
  ;
  TabLkUpScr()

  WHILE True
    RecCount=TopRec
    MOVETO RECORD TopRec
    STYLE ATTRIBUTE 32
    @6,0
    ;
    ; write table names and file dates
    ; to the window
    ;
    WHILE RecCount<=TotalRecs AND LineCount<9
      ?"  "+FORMAT("w16,al",[Name])+
       STRVAL([Date])+"  "
      RecCount=RecCount+1
      LineCount=LineCount+1
      DOWN
    ENDWHILE
    ;
    ; if more than one screen (8 records), display
    ; markers indicating scroll directions
    ;
    IF TotalRecs>8
      THEN IF TopRec>1
             THEN @7,6 ??CHR(30)
           ENDIF
           IF LineCount=9
             THEN IF RecCount<=TotalRecs
                    THEN @14,6 ??CHR(31)
                  ENDIF
             ELSE @5+LineCount,6
           ENDIF
    ENDIF
    ;
    ; if less than one full screen, clear remaining
    ; display of unwanted lines
    ;
    WHILE LineCount<9
      ?SPACES(28)
      LineCount=LineCount+1
    ENDWHILE
    LineCount=1

    WHILE True
      ;
      ; highlight current selection
      ;
      PAINTCANVAS ATTRIBUTE 127
        6+CurrLine,7,6+CurrLine,32
      CANVAS ON
      ;
      ; get user input
      ;
      c=GETCHAR()

      SWITCH
        CASE c=-80:                     ;Down
          IF CurrRec<TotalRecs
            THEN CurrRec=CurrRec+1
                 NextLine=CurrLine+1
            ELSE BEEP
                 LOOP
          ENDIF
        CASE c=-72:                     ;Up
          IF CurrRec>1
            THEN CurrRec=CurrRec-1
                 NextLine=CurrLine-1
            ELSE BEEP
                 LOOP
          ENDIF
        CASE c=-81:                     ;PgDn
          IF TotalRecs>TopRec+7
            THEN TopRec=TopRec+7
            ELSE BEEP
                 LOOP
          ENDIF
          CurrRec=TopRec
          CurrLine=1
          QUITLOOP
        CASE c=-73:                     ;PgUp
          IF TopRec>8
            THEN TopRec=TopRec-7
            ELSE IF TopRec=1
                   THEN BEEP
                        LOOP
                   ELSE TopRec=1
                 ENDIF
          ENDIF
          CurrRec=TopRec
          CurrLine=1
          QUITLOOP
        CASE c=-71:                     ;Home
          IF TopRec>1
            THEN TopRec=1
            ELSE BEEP
                 LOOP
          ENDIF
          CurrRec=TopRec
          CurrLine=1
          QUITLOOP
        CASE c=-79:                     ;End
          IF TopRec<TotalRecs-7
            THEN TopRec=TotalRecs-7
            ELSE BEEP
                 LOOP
          ENDIF
          CurrRec=TotalRecs
          CurrLine=TotalRecs-TopRec+1
          QUITLOOP
        CASE c=13:                      ;Enter
          ;
          ; check validity of TableLookup
          ;
          IF FldTypeErr()
            THEN LOOP
          ENDIF
          ;
          ; if no submenu choice, redraw
          ; screen components and stay in
          ; LOOKUP TABLE menu
          ;
          IF NOT LookUpSpec("List")
            THEN CANVAS OFF
                 CLEARIMAGE
                 ValCheckScr()
                 DisplayValCk()
                 TabLkUpScr()
                 VIEW "List"
                 QUITLOOP
          ENDIF
          SETMARGIN OFF
          CLEARIMAGE
          MOVETO WorkTab
          EDITKEY
          RETURN True
        CASE c=27:                      ;Esc
          ;
          ; clear List table from workspace
          ; and return with no change
          ;
          SETMARGIN OFF
          CLEARIMAGE
          MOVETO WorkTab
          EDITKEY
          RETURN False
        OTHERWISE:
          BEEP
          LOOP
      ENDSWITCH
      IF NextLine<1
        THEN TopRec=TopRec-1
             CurrLine=1
             QUITLOOP
        ELSE IF NextLine>8
               THEN TopRec=TopRec+1
                    CurrLine=8
                    QUITLOOP
             ENDIF
      ENDIF
      CANVAS OFF
      ;
      ; clear highlight
      ;
      PAINTCANVAS
        ATTRIBUTE 32
        CurrLine+6,7,CurrLine+6,32
      CurrLine=NextLine
    ENDWHILE
    CANVAS OFF
  ENDWHILE
ENDPROC


;***********************************************;
; TabLkUpScr() is called by LookUpTab() to open ;
; the window used to list the Tables available  ;
; in the current directory.                     ;
;***********************************************;
PROC TabLkUpScr()
  ;
  ; paint shadow
  ;
  PAINTCANVAS
    ATTRIBUTE 8
    5,6,18,35

  STYLE ATTRIBUTE 32
  @4,5
  SETMARGIN 5

TEXT
Ŀ
  L O O K U P    T A B L E  
Ĵ
                            
                            
                            
                            
                            
                            
                            
                            
Ĵ
 [] Select   [Esc] Cancel 

ENDTEXT

  SETMARGIN 6
ENDPROC


;************************************************;
; FldTypeErr() is called from LookUpTab() when a ;
; choice is made designating a given Table as a  ;
; "Look Up" table.  This procedure checks field  ;
; compatibility and, if necessary, responds with ;
; an error message.  ValidEntry() and ValErr()   ;
; are used for this purpose when the lookup name ;
; is entered directly (see AddValCheck()).       ;
;************************************************;
PROC FldTypeErr()
  PRIVATE FldErr,TempTab

  FldErr=False

  MOVETO RECORD CurrRec
  TempTab=[Name]
  VIEW TempTab
  RIGHT
  IF FIELDTYPE()<>FldType
    THEN BEEP
         MESSAGE "First field of the lookup table "+
                 "is not of the appropriate type..."
         SLEEP 1500
         FldErr=True
    ELSE Val[5]=TempTab
  ENDIF
  CLEARIMAGE
  MOVETO "List"

  RETURN FldErr
ENDPROC


;*************************************************;
; LookUpSpec() is used to complete the definition ;
; of a "LookUp" Table.  It opens the window and   ;
; manages user selection of specifications (e.g.  ;
; Help and Fill) whether the table is chosen from ;
; the Table List or its name is entered directly. ;
;*************************************************;
PROC LookUpSpec(FromTab)
  PRIVATE c,Choice,CurrLine,NextLine,
          TempLine,Item1,Item2

  Choice=1
  CurrLine=1
  NextLine=1
  Item1=1
  Item2=2

  CANVAS OFF
  ;
  ; paint shadow
  ;
  PAINTCANVAS
    ATTRIBUTE 8
    6,26,14,55

  STYLE ATTRIBUTE 32
  @5,25
  SETMARGIN 25

TEXT
Ŀ
  L O O K U P    S P E C S  
Ĵ
                            
                            
Ĵ
                            
                            

ENDTEXT

  CURSOR OFF

  WHILE True
    @8,28 ??LkUpMu[Item1]
    @9,28 ??LkUpMu[Item2]

    PAINTCANVAS ATTRIBUTE 127
      7+CurrLine,27,7+CurrLine,52

    @11,26 ??LkUpLn1[Choice]
    @12,26 ??LkUpLn2[Choice]

    CANVAS ON
    c=GETCHAR()
    SWITCH
      CASE c=-72:    ;Up
        IF CurrLine=1
          THEN NextLine=2
               Choice=Choice+1
          ELSE NextLine=1
               Choice=Choice-1
        ENDIF
      CASE c=-80:    ;Down
        IF CurrLine=2
          THEN NextLine=1
               Choice=Choice-1
          ELSE NextLine=2
               Choice=Choice+1
        ENDIF
      CASE c=13:     ;Enter
        TempLine=CurrLine
        SWITCH
          CASE Choice=1:
            Choice=3
            Item1=3
            Item2=4
          CASE Choice=2:
            Choice=5
            Item1=5
            Item2=6
          OTHERWISE:
            MOVETO WorkTab
            EDITKEY
            MENU {ValCheck} {Define} ENTER
                 {TableLookup}
            SELECT Val[5]
            SWITCH
              CASE Choice=3:
                {JustCurrentField}
                {PrivateLookUp}
              CASE Choice=4:
                {JustCurrentField}
                {HelpAndFill}
              CASE Choice=5:
                {AllCorrespondingFields}
                {FillNoHelp}
              CASE Choice=6:
                {AllCorrespondingFields}
                {HelpAndFill}
            ENDSWITCH
            DO_IT!
            MOVETO FromTab
            RETURN True
        ENDSWITCH
        NextLine=1
      CASE c=27:     ;Esc
        IF Item1>1
          THEN Choice=TempLine
               NextLine=TempLine
               Item1=1
               Item2=2
          ELSE Val[5]=TempVal
               RETURN False
        ENDIF
      OTHERWISE:
        BEEP
        CANVAS OFF
        LOOP
    ENDSWITCH
    CANVAS OFF
    PAINTCANVAS ATTRIBUTE 32
      7+CurrLine,27,7+CurrLine,52
    CurrLine=NextLine
  ENDWHILE
ENDPROC


WRITELIB "TabLkUp" LookUpTab,TabLkUpScr,FldTypeErr,
                   LookUpSpec
RELEASE PROCS LookUpTab,TabLkUpScr,FldTypeErr,
              LookUpSpec
