; SetVals.sc
; PURPOSE:
; Upload field valchecks from Valcheck table to target table.
; Used in conjunction with compaanion script "Getvals".
;
; Author: Wayne Slepecky
;         Uplink Computer Services
;         PO Box 251
;         Medina, OH 44256
;         800-UPLINK4
;
Release Procs All
Release Vars All

Errorproc = "ErrProc.n"
If not istable("Valcheck") Then              ;check for Valcheck table
   Beep
   Return "Valcheck table not found"
Endif

Clearall
Message.a = "Setting Valcheck info"
Message Message.a
Echo off
Cursor off

;Error proc
PROC ErrProc.n()                 ; Generic information message window
   Private Errorproc

   ;create a window for error message
   DynArray y[]
     y["CanClose"] = False
     y["CanMaximize"] = False
     y["CanMove"] = False
     y["CanResize"] = False
     y["HasFrame"] = False
     y["Style"] = 79
     y["HasShadow"] = False
   ErrorInfo to Error.y     ;get error info

   Ht.n=10
   Wd.n=70
   Window Create  Floating @ 1,0
                  Height Ht.n Width Wd.n
                  Attributes y To MsgBox.h
   Window Setattributes MsgBox.h From y
   Frame Double From 0,0 to ht.n-1,wd.n-1
   @0,25 ??   "Error Information"
   @1,2 ??   "Script : "+Error.y["SCRIPT"]
   @2,2 ??   "Line   : " +strval(Error.y["LINE"])
   @3,2 ??   "Table  : " +Tbl.a
   @4,2 ??   "Field  : " +Fld.a
   @5,2 ??   "Type   : " +Fields.y[Fld.a]
   @6,2 ??   "ErrCode: "+strval(Error.y["CODE"])
   @7,2 ??   "ErrMsg : "+Error.y["MESSAGE"]
   BEEP Sleep 50 BEEP Sleep 50 BEEP
   CancelEdit
   Return 2       ;std debug and halt
EndProc

;Declare dys used to hold Valcheck data
Dynarray Table.y[]           ;holds Tables
Dynarray Fields.y[]          ;holds fieldtype
Dynarray Picture.y[]         ;holds Pictures
Dynarray LookTbl.y[]         ;holds LookupTbl
Dynarray LookFld.y[]         ;holds Lookupfield choice
Dynarray LookHelp.y[]        ;holds LookupHelpFill choice
Dynarray LowVal.y[]          ;holds Low Value
Dynarray HiVal.y[]           ;holds High Value
Dynarray Default.y[]         ;holds Default value
Dynarray Required.y[]        ;holds Required info
Dynarray AutoFilled.y[]      ;holds Auto Filled choice
Dynarray AutoPicture.y[]     ;holds Auto Picture choice
Dynarray AutoLookup.y[]      ;holds Auto Lookup choice
Dynarray LookHelp.y[]        ;holds LookupHelpFill choice


;Load Dys with data from Valchecks table
Copy "Valcheck" "$$$$temp"            ;make a working copy
Sort "$$$$temp" ON "DataTbl"          ;sort by Table
View "$$$$temp"
  Scan
    Fld.a                     =  [FldName]
    Tbl.a                     =  [DataTbl]
    Fields.y[Fld.a]           =  [FldType]
    Table.y[Tbl.a]            =  Fld.a
    LowVal.y[Tbl.a+Fld.a]         =  [LoVal]
    HiVal.y[Tbl.a+Fld.a]          =  [HiVal]
    Default.y[Tbl.a+Fld.a]        =  [Default]
    LookTbl.y[Tbl.a+Fld.a]        =  [LookTbl]
    LookFld.y[Tbl.a+Fld.a]        =  [Lookfld]
    LookHelp.y[Tbl.a+Fld.a]       =  [Lookhelp]
    Picture.y[Tbl.a+Fld.a]        =  [Picture]
    Required.y[Tbl.a+Fld.a]       =  [Reqd]
    AutoFilled.y[Tbl.a+Fld.a]     =  [AutoFill]
    AutoPicture.y[Tbl.a+Fld.a]    =  [AutoPic]
    AutoLookup.y[Tbl.a+Fld.a]     =  [AutoLook]
  Endscan
Delete "$$$$temp"                          ;clean up

;load the field data into the data table
Foreach Tbl.a in Table.y
   Edit Tbl.a
   Message.a = "Setting valchecks in "+Tbl.a+" table"
   Foreach Fld.a in Fields.y
      Message.a = Message.a+""                ;give a sign we're still alive
      Message Message.a
      MOVETO Field Fld.a
      If LowVal.y[Tbl.a+Fld.a] <> "" Then
         Menu{ValCheck}{Define}Enter{LowValue}          ;set Low value
          Select LowVal.y[Tbl.a+Fld.a]
      Endif

      If HiVal.y[Tbl.a+Fld.a] <> "" Then
         Menu{ValCheck}{Define}Enter{HighValue}         ;set Hi value
          Select HiVal.y[Tbl.a+Fld.a]
      Endif

      If Default.y[Tbl.a+Fld.a] <> "" Then
         Menu{ValCheck}{Define}Enter{Default}           ;set Default value
          Select Default.y[Tbl.a+Fld.a]
      Endif

      If LookTbl.y[Tbl.a+Fld.a] <> "" Then
         Menu{ValCheck}{Define}Enter{TableLookup}       ;set Lookup table
         Select LookTbl.y[Tbl.a+Fld.a]
         Select LookFld.y[Tbl.a+Fld.a]     ;just this fld/all corresponding
         Select LookHelp.y[Tbl.a+Fld.a]    ;private or help/fill
      Endif

      If Picture.y[Tbl.a+Fld.a] <> "" Then
         Menu{ValCheck}{Define}Enter{Picture}           ;set picture
         Select Picture.y[Tbl.a+Fld.a]
      Endif

      If Required.y[Tbl.a+Fld.a] <> "" Then
         Menu{ValCheck}{Define}Enter{Required}          ;set Required
         Select Required.y[Tbl.a+Fld.a]
      Endif

      If AutoFilled.y[Tbl.a+Fld.a] <> "" Then
         Menu{ValCheck}{Define}Enter{Auto}{Filled}      ;set AutoFilled
         Select AutoFilled.y[Tbl.a+Fld.a]
      Endif

      If AutoPicture.y[Tbl.a+Fld.a] <> "" Then
         Menu{ValCheck}{Define}Enter{Auto}{Picture}     ;set AutoPicture
         Select AutoPicture.y[Tbl.a+Fld.a]
      Endif

      If AutoLookup.y[Tbl.a+Fld.a] <> "" Then
         Menu{ValCheck}{Define}Enter{Auto}{Lookup}      ;set AutoLookup
         Select AutoLookup.y[Tbl.a+Fld.a]
      Endif
   Endforeach
   Menu
   Do_It!         ;end edit
   Clearimage
Endforeach

Sound 440 80
Sound 880 80

Echo normal
Cursor normal
Release Vars All
Return "Complete"



