; GetVals.sc
; PURPOSE:
; Download field valchecks from target table to Valcheck table. Edit
; valchecks, then use companion script "SetVals" to upload back to target
; table. Print report out of Valchecks.R.
;
; Author: Wayne Slepecky
;         Uplink Computer Services
;         PO Box 251
;         Medina, OH 44256
;         800-UPLINK4

Release Procs All
Release Vars All

If NImages() = 0 Then                        ; If a table is not present
     BEEP                                    ; notify the user
     Message "Nothing on workspace" Sleep 2000
     Return
EndIf

;copy Valcheck to application dir if necessary
If not istable("Valcheck") Then
   Copy sdir()+"Valcheck" "Valcheck"
Endif
Empty "Valcheck"
Message.a = "Getting Valcheck info"
Message Message.a
Echo off
Cursor off

Dynarray Table.y[]           ;holds tables
;make a dy containg table names as index
For n from 1 to Nimages()
   Moveto n
   Tbl.a = Table()
   If Imagetype() <> "Display" Then ClearImage Loop Endif ;assure it's a table
   If Tbl.a = "Valcheck" Then Loop Endif     ;skip the Valcheck tbl
   Table.y[Tbl.a] = ""      ;load table name into dy index
Endfor

;Now move to each data table and load the Valcheck info
Foreach Tbl.a in Table.y
   Message.a = "Getting valchecks in "+Tbl.a+" table"
   Message Message.a

   ;Declare dys used to hold Valcheck data
   Dynarray Picture.y[]         ;holds Pictures
   Dynarray Fields.y[]          ;holds fieldtype
   Dynarray LookTbl.y[]         ;holds LookupTbl
   Dynarray LookFld.y[]         ;holds Lookupfield choice
   Dynarray LookHelp.y[]        ;holds LookupHelpFill choice
   Dynarray LowVal.y[]          ;holds Low Value
   Dynarray HiVal.y[]           ;holds High Value
   Dynarray Default.y[]         ;holds Default value
   Dynarray Required.y[]        ;holds Required info
   Dynarray AutoFilled.y[]      ;holds Auto Filled choice
   Dynarray AutoPicture.y[]     ;holds Auto Picture choice
   Dynarray AutoLookup.y[]      ;holds Auto Lookup choice
   Dynarray LookHelp.y[]        ;holds LookupHelpFill choice

   ;get fieldnames and field types of current table
   Menu{Tools}{Info}{Structure}SELECT Tbl.a   ; Make "STRUCT" table
                                                  ; of current table
   ;store fieldname by fieldtype using Struct table
   Scan
      Fields.y[[Field Name]] = [Field type]     ;field list
   Endscan
   ClearImage                                  ;kill structure table
   Moveto Tbl.a                            ;move to soruce table

   ;go to edit to get valcheck info for current table
   EditKey                                     ; Go to Edit mode
   Foreach Fld.a in Fields.y                 ;load array with info
      Message.a = Message.a+""                ;give a sign we're still alive
      Message Message.a
      MOVETO Field Fld.a
      If match(Fields.y[Fld.a],"M..") OR     ;If a memo field,
         match(Fields.y[Fld.a],"B..") Then   ;store blanks
            Picture.y[Tbl.a+Fld.a]     = ""   ;index is packed tbl/fld combo
            LookTbl.y[Tbl.a+Fld.a]     = ""
            LookFld.y[Tbl.a+Fld.a]     = ""
            LookHelp.y[Tbl.a+Fld.a]    = ""
            LowVal.y[Tbl.a+Fld.a]      = ""
            HiVal.y[Tbl.a+Fld.a]       = ""
            Default.y[Tbl.a+Fld.a]     = ""
            AutoFilled.y[Tbl.a+Fld.a]  = ""
            AutoPicture.y[Tbl.a+Fld.a] = ""
            AutoLookup.y[Tbl.a+Fld.a]  = ""
            LookHelp.y[Tbl.a+Fld.a]    = ""
            If Substr(Fields.y[Fld.a],1,1) = "M" Then   ; Only for Memo field
              Menu {ValCheck}{Define}Enter{Required}    ; Skip Blob field
              Required.y[Tbl.a+Fld.a]    = MenuChoice()
            Endif
         Else
            Menu{ValCheck}{Define}Enter{LowValue}          ;get Low value
            LowVal.y[Tbl.a+Fld.a] = Menuchoice()
            Menu{ValCheck}{Define}Enter{HighValue}         ;get Hi value
            HiVal.y[Tbl.a+Fld.a] = Menuchoice()
            Menu{ValCheck}{Define}Enter{Default}           ;get Default value
            Default.y[Tbl.a+Fld.a] = Menuchoice()
            Menu{ValCheck}{Define}Enter{TableLookup}       ;get Lookup table
               If MenuChoice() = "" Then
                  LookTbl.y[Tbl.a+Fld.a]  = ""           ;if no lookup table
                  LookFld.y[Tbl.a+Fld.a]  = ""
                  LookHelp.y[Tbl.a+Fld.a] = ""
               Else
                  LookTbl.y[Tbl.a+Fld.a] = MenuChoice() ;lookup table name
                  Enter
                  LookFld.y[Tbl.a+Fld.a]  = Menuchoice()         ;just this fld/all corresponding
                  Enter
                  LookHelp.y[Tbl.a+Fld.a] = Menuchoice()         ;private or help/fill
               Endif
            Menu{ValCheck}{Define}Enter{Picture}           ;get picture
            Picture.y[Tbl.a+Fld.a] = MenuChoice()
            Menu{ValCheck}{Define}Enter{Required}          ;get Required
            Required.y[Tbl.a+Fld.a]    = MenuChoice()
            Menu{ValCheck}{Define}Enter{Auto}{Filled}      ;get AutoFilled
            AutoFilled.y[Tbl.a+Fld.a]  = Menuchoice()
            Menu{ValCheck}{Define}Enter{Auto}{Picture}     ;get AutoPicture
            AutoPicture.y[Tbl.a+Fld.a]  = Menuchoice()
            Menu{ValCheck}{Define}Enter{Auto}{Lookup}      ;get AutoLookup
            AutoLookup.y[Tbl.a+Fld.a]  = Menuchoice()
      Endif
      Menu                      ;back out
   Endforeach
   Menu
   CancelEdit        ;end edit

   ;reverse array order so Valcheck table will be in order. (The Foreach command
   ;starts at the end of the dy)

   Dynarray FlipFields.y[]
   Foreach Fld.a in Fields.y
      FlipFields.y[Fld.a] = Fields.y[Fld.a]
   Endforeach

   ;load values to Valcheck table
   Edit "Valcheck"
   End
   If recno() >1 Then Down Endif
   Foreach Fld.a in FlipFields.y
      [DataTbl] = Tbl.a
      [FldName] = Fld.a
      [FldType] = FlipFields.y[Fld.a]
      [LoVal]   = LowVal.y[Tbl.a+Fld.a]
      [HiVal]   = HiVal.y[Tbl.a+Fld.a]
      [Default] = Default.y[Tbl.a+Fld.a]
      [LookTbl] = LookTbl.y[Tbl.a+Fld.a]
      [LookFld] = LookFld.y[Tbl.a+Fld.a]
      [LookHelp]= LookHelp.y[Tbl.a+Fld.a]
      [Picture] = Picture.y[Tbl.a+Fld.a]
      If isassigned(Required.y[Tbl.a+Fld.a]) Then    ;Blob field not assigned
         [Reqd] = Required.y[Tbl.a+Fld.a]
      Endif
      [AutoFill]= AutoFilled.y[Tbl.a+Fld.a]
      [AutoPic] = AutoPicture.y[Tbl.a+Fld.a]
      [AutoLook]= AutoLookup.y[Tbl.a+Fld.a]
      Down
   Endforeach
   Home
   Do_It!       ;end Edit
Endforeach
Sound 440 80
Sound 880 80

Echo normal
Cursor normal
Release Vars All
Return "Complete"
