createlib "updatew"
proc refresh_window()                        ; loads the current form with data
  moveto [Answer->]                          ; from the related table.
  if t_row<old_t_row then                    ; Has index been lowered?
    for c1 from 1 to rows                    ; for every row
      if t_row+c1-1<=number_of_items then    ;   if there is an row to load
        Moveto record t_row+c1-1             ;   then go to that row
        for c2 from 1 to number_of_fields    ; for every field in that row
          Execute "["+table_name+"->"+       ;   get that field
            field_names[c2]+strval(c1)+"]=["+
            field_names[c2]+"]"
        endfor
      endif
    endfor                                   ; else if index has increased
  else                                       ; or remained constant
    for c1 from 1 to rows                    ; for every row
      if t_row+c1-1<=number_of_items then    ;   if there is a row to load
        Moveto record t_row+c1-1             ;   then go to that row
        for c2 from 1 to number_of_fields    ; for every field in that row
          Execute "["+table_name+"->"+       ;   get that field
            field_names[c2]+strval(c1)+
            "]=["+field_names[c2]+"]"
        endfor
      else                                   ; if no row to load
        for c2 from 1 to number_of_fields    ; for every field in row
          Execute "Moveto ["+table_name+"->"+;   go to it
            field_names[c2]+strval(c1)+"]"
          if not isblank([]) then            ; if it has something in it
            CtrlBackspace                    ;   then wipe it out
          endif
        endfor
      endif
    endfor   ; end of every row
  endif    ; end of index check
  old_t_row=t_row                            ; reset old index to current
  Moveto [Answer->]                          ; go to related table
  Moveto record t_row+s_row-1                ; moveto current row in it
  Execute "Moveto ["+table_name+"->"+        ; moveto current field in the
    field_names[s_col]+strval(s_row)+"]"     ;   main table
  formkey                                    ; show current form
endproc


;  The purpose of this procedure is to enable editing of related items based
;  on a predefined key WITHIN A STANDARD PARADOX FORM.
;  Batches are used so that the programmer can allow the user to CANCEL the
;  edits made to the related table...No matter how many were made.
;  The purpose of passing a boolean to no_select is so that the programmer
;  can disable the querying of the related database again.  In other words,
;  if related items are changed once then it is necessary that those changed
;  items are used the next time the user wishes to modify that window, since
;  ANY CHANGES MIGHT ULTIMATELY BE CANCELED AND NOT UPDATED TO THE RELATED
;  TABLE.  This option allows any changes to be CANCELed no matter how many
;  times the user edits the window.
;  IN ORDER TO SAVE THE MODIFICATIONS TO THE RELATED TABLE,
;      first SUBTRACT delete_batch_filename filename
;      then  ADD      add_batch_filename    filename
;
;  example: (will automatically make any changes from a window permanent)
;
;    update_window("RELATED","TEMPDEL","TEMPADD","NAMES",3,"Top",false)
;    SUBTRACT "TEMPDEL" "RELATED"
;    ADD "TEMPADD" "RELATED"
;
;
;
;  IN ORDER TO EDIT THE WINDOW AGAIN BEFORE CHANGES HAVE BEEN MADE PERMANENT,
;      pass add_batch_filename for filename parameter
;      pass true for no_select parameter
;      pass a null string ("") for delete_batch_filename parameter
;      pass add_batch_filename for add_batch_filename parameter
;  example:
;     update_window("TEMPADD","","TEMPADD","NAMES",3,"","Top",true)
;
;
;  A starting position allows the programmer to define the relationship
;  between the related items and the window..  ie. Choosing "Top" would
;  have the first item shown in the first row, whereas "Bottom" would
;  display the last item in the last row.  Of course this can only be seen
;  if there are more items than rows.
;
;  IT IS ASSUMED THAT a table is being edited using a form that has already
;    "picked".  If a form hasn't been picked then the standard form will be
;    used.
;
;
;

proc update_window(filename,delete_batch_filename,add_batch_filename,
                   table_of_fieldnames,rows,lookupfield,start_at_position,
                   no_select)
  private s_col,s_row,t_row,table_name,lookupvalue,number_of_fields,
          field_names,number_of_items,old_t_row,c1,c2

  Do_It!                                 ; Get out of Edit mode
  table_name=table()                     ; Store the current table's name
  Execute "lookupvalue=["+lookupfield+"]"; Store the related items value
  if no_select=true then                 ; if a re-edit
    copy filename "Answer"               ; Make an answer from the related
    view "Answer"                        ;   table
  else                                   ; if a first time edit
    Menu {Ask} Execute "{"+filename+"}"  ; Get a query form for current table
    checkplus                            ; Check all fields
    Execute "Moveto ["+lookupfield+"]"   ; Go to the Key Field in Query
    Typein lookupvalue                   ; Enter the Key into it
    Message "Searching...."              ; Say "Searching"
    Do_It!                               ; Execute Query
    Execute "Moveto ["+filename+"(Q)->]" ; Move back up to Query Form
    clearimage                           ;  remove it
    copy "answer" delete_batch_filename  ; save the "unchanged items"
  endif                                  ;
  Number_of_fields=Nrecords(table_of_fieldnames) ; Store number of fields
  array field_names[number_of_fields]    ; make an array to contain fieldnames
  view table_of_fieldnames               ; view the fieldnames database
  scan                                   ;   load fieldnames into array
    field_names[[#]]=[Field Name]        ;
  endscan                                ;
  clearimage                             ; clear off fieldnames database
  number_of_items=Nrecords("Answer")     ; store number of items
  if start_at_position="Top" then        ; if position is "Top"
    s_col=1                              ; init    screen col to 1
    s_row=1                              ;           "    row to 1
    t_row=1                              ; related table  row to 1
  else                                   ; if position is "Bottom"
    s_col=1                              ;   init  screen col to 1
    if number_of_items>=rows then        ; if window can be filled
      s_row=rows                         ;   init screen row to bottom
      t_row=number_of_items-rows+1       ;        table  row to bottom
    else                                 ; if window can't be filled
      s_row=number_of_items              ; init screen row to bottom
      t_row=1                            ;      table row to top
    endif                                ;
  endif                                  ;
  if isempty("Answer") then              ; if no items found
    editkey                              ;   then create one
    typein lookupvalue                   ;   enter Key in new record
    number_of_items=1                    ;   init item count to 1
  else                                   ; if items found
    editkey                              ;   go into edit mode
  endif                                  ;
  Moveto [Answer->]                      ; Go to related items
  Moveto record t_row+s_row-1            ; and go to the current row
  Execute "moveto ["+table_name+"->]"    ; Return to the main table
  formkey                                ; show the form
  old_t_row=t_row                        ; simulate a former position
  refresh_window()                       ; put table items into screen
  while (true)                           ; endless loop started
    execute "Moveto ["+field_names[s_col]+ ; moveto current screen position
      strval(s_row)+"]"
                                                                   ;  wait for something special
    wait field prompt "Press [F1] to leave window, [F9] to Edit current field"
     until "Up","Down","Right","Left","Home","End","PgDn","PgUp",
           "F1","Ins","Del","F9","Enter",15
    execute "[Answer->"+field_names[s_col]+                        ; send field changes to table
            "]=["+field()+"]"
    switch
                                                                   ; user wishes to edit a field
      case retval="F9"    : Fieldview
                            wait field prompt "Hit Return to end Field Edit"
                              until "Enter",15
                            Enter

                                                                   ; user presses "UP"
      case retval="Up"    : if s_row>1 then                        ; if not at top of screen
                              s_row=s_row-1                        ; then move one row up
                              moveto [Answer->]                    ; Move to related table
                              moveto record t_row+s_row-1          ; Move to current row
                              execute "Moveto ["+table_name+"->]"  ; Move to main table
                              formkey                              ; show form
                            else                                   ; if at top of screen
                              if t_row>1 then                      ;   if not at top of related table
                                t_row=t_row-1                      ;   move up one in related table
                                refresh_window()                   ;   put related items into screen
                              else                                 ; if at top of related table
                                beep                               ; then beep --can't move up if a top already
                              endif
                            endif
                                                                   ; User presses "DOWN"
      case retval="Down"  : if  s_row<rows and                     ; if not at screen bottom
                                s_row+t_row-1<number_of_items      ; and if there are more items
                            then
                              s_row=s_row+1                        ; move down one screen row
                              moveto [Answer->]                    ; moveto current table row
                              moveto record t_row+s_row-1          ;
                              execute "Moveto ["+table_name+"->]"  ;
                              formkey
                            else
                              if s_row=rows then                    ; if at bottom of screen
                                if t_row+s_row-1<number_of_items    ;   if not at bottom of table
                                then
                                  t_row=t_row+1                     ;      move down one table row
                                  refresh_window()                  ;      put related items into screen
                                else                                ;   if at bottom of table
                                  number_of_items=number_of_items+1 ;     increase number of items
                                  t_row=t_row+1                     ;     increase table row
                                  moveto [Answer->]                 ;     move to related table
                                  down                              ;     add a new record
                                  Execute "Moveto ["+lookupfield+"]"  ;   move to key field
                                  Typein lookupvalue                ;     enter key into it
                                  refresh_window()                  ;     put related items into screen
                                endif
                              else                                  ; if no more items and not at bottom of screen
                                number_of_items=number_of_items+1   ;    increase number of items
                                moveto [Answer->]                   ;    move to related table
                                down                                ;    add a new record
                                Execute "Moveto ["+lookupfield+"]"  ;    move to key field
                                Typein lookupvalue                  ;    enter key into it
                                s_row=s_row+1                       ;    move down on screen row   (actual moves occur at
                                Execute "Moveto ["+table_name+"->]" ;    move to main table         the top of the while loop)
                                formkey                             ;    show form
                              endif
                            endif
                                                                    ; User pressed "LEFT"
      case retval="Left"  : if s_col>1 then                         ; if not in first Column
                              s_col=s_col-1                         ; decrease screen column
                            else                                    ; if in first Column
                              if s_row>1 then                       ; if not in first screen row
                                s_row=s_row-1                       ; decrease screen row
                                moveto [Answer->]                   ; moveto the related table
                                moveto record t_row+s_row-1         ; moveto current row
                                Execute "moveto ["+table_name+"->]" ; moveto main table
                                formkey                             ; show form
                                s_col=number_of_fields              ; set to last column
                              endif
                            endif
      case (retval="Right"                                           ; User presses "Right"
         or retval="Enter")                                          ; OR "Enter"
                          : if s_col<number_of_fields then           ; if not in last column
                              s_col=s_col+1                          ; increase screen column
                            else                                     ; if in last column
                              if s_row+t_row-1<number_of_items then  ; if not at bottom of related table
                                if s_row<rows then                   ; if not at bottom of screen
                                  s_row=s_row+1                      ; increase screen row
                                  s_col=1                            ; set to first column
                                  moveto [Answer->]                  ; moveto the related table
                                  moveto record t_row+s_row-1        ; moveto current row
                                  Execute "moveto ["+table_name+"->]"; moveto main table
                                  formkey                            ; show fowm
                                endif                                ;
                              else                                   ; if at bottom of related table
                                if s_row=rows then                   ; if at bottom of screen
                                  number_of_items=number_of_items+1  ; increase number of items
                                  t_row=t_row+1                      ; increase table row position
                                  moveto [Answer->]                  ; moveto the related table
                                  down                               ; add a new record
                                  execute "Moveto ["+lookupfield+"]" ; move to key field
                                  typein lookupvalue                 ; enter key into it
                                  refresh_window()                   ; put related items into screen
                                else                                 ; if not at bottom of screen
                                  number_of_items=number_of_items+1  ; increase number of items
                                  moveto [Answer->]                  ; moveto the related table
                                  down                               ; add a new record
                                  execute "Moveto ["+lookupfield+"]" ; move to key field
                                  typein lookupvalue                 ; enter key into it
                                  s_row=s_row+1                      ; increase screen row
                                  execute "Moveto ["+table_name+"->]"; moveto main table
                                  formkey                            ; show form
                                endif
                              endif
                            endif
                                                                     ; User presses "Home"
      case retval="Home"  : s_row=1                                  ; set screen   row  to 1
                            s_col=1                                  ;     screen column to 1
                            if t_row>1 then                          ; if not at top of related table
                              t_row=1                                ;   then set row to 1
                              refresh_window()                       ;   put related items into screen
                            endif
                            moveto [Answer->]                        ; moveto the related table
                            moveto record t_row+s_row-1              ; moveto current row
                            Execute "moveto ["+table_name+"->]"      ; moveto main table
                            formkey                                  ; showform

                                                                     ; User presses "End"
      case retval="End"   : if t_row+s_row-1<number_of_items then    ; if not at bottom of related table
                              s_col=1                                ; set screen col to 1
                              if number_of_items>rows then           ; if more items that screen rows
                                s_row=rows                           ; go to bottom of screen
                                t_row=number_of_items-rows+1         ; go to bottom of related table
                                moveto [Answer->]                    ; moveto the related table
                                moveto record t_row+s_row-1          ; moveto current row
                                Execute "moveto ["+table_name+"->]"  ; moveto main table
                                refresh_window()                     ; put related items into screen
                              else                                   ; if same or more rows than items
                                s_row=number_of_items                ; set screen row to bottom
                                t_row=1                              ; set table row to top
                                Moveto [Answer->]                    ; moveto the related table
                                Moveto record t_row+s_row-1          ; moveto current row
                                Execute "moveto ["+table_name+"->]"  ; moveto main table
                                formkey                              ; show form
                              endif
                            endif
                                                                     ; User chooses "F1" ie Done...
      case retval="F1"    : if start_at_position="Top" then          ; if position is "Top"
                              s_col=1                                ; set screen column to first
                              s_row=1                                ;     screen row to top
                              t_row=1                                ;     table row to top
                              old_t_row=1                            ;     old_t_row to top
                            else                                     ; if position is "Bottom"
                              s_col=1                                ; set screen column to first
                              if number_of_items>rows then           ; if more items than rows
                                s_row=rows                           ; set screen row to bottom
                                t_row=number_of_items-rows+1         ;     table row to bottom
                              else                                   ; if same or more rows than items
                                s_row=number_of_items                ; set screen row to bottom
                                t_row=1                              ;     table row to top
                              endif                                  ;
                            endif                                    ;
                            refresh_window()                         ; put related items into screen
                            Do_It!                                   ; save the screen
                            Rename "Answer" add_batch_filename       ; send 'Changed' items to add batch
                            clearimage                               ; clear the add batch from screen
                            editkey                                  ; go back into edit mode
                            formkey                                  ; show form
                            quitloop                                 ; get out of infinite loop

                                                                     ; User presses "Insert"
      case retval="Ins"   : number_of_items=number_of_items+1        ; increase number of items
                            Moveto [Answer->]                        ; move to related table
                            Ins                                      ; insert a row
                            Execute "Moveto ["+lookupfield+"]"       ; move to key field
                            Typein lookupvalue                       ; enter key in it
                            refresh_window()                         ; put related items into screen

                                                                     ; User presses "Delete"
      case retval="Del"   : Moveto [Answer->]
                            if t_row+s_row-1=number_of_items then    ; if at bottom
                              if t_row>1 then                        ; if not first item at top of screen
                                t_row=t_row-1                        ; move up in related table
                                Del
                              else                                   ; if first item is at top of screen
                                if s_row>1 then                      ; if not at top of screen
                                  s_row=s_row-1                      ; move up row in screen
                                  Del
                                else                                 ; if first item and at top of screen
                                  Del
                                  Execute "Moveto ["+lookupfield+"]"
                                  Typein lookupvalue
                                endif                                ;
                              endif
                            else
                              Del
                            endif                                    ;
                            if number_of_items>1 then                ; if more than one item
                              number_of_items=number_of_items-1      ;    then lower number of items
                            endif                                    ;
                            refresh_window()                         ; put related items into screen

      case retval="PgDn"  : if t_row+rows+rows-1<=number_of_items    ; if bottom of next screen<=number of items
                             then
                               t_row=t_row+rows
                               moveto [Answer->]
                               moveto record t_row+s_row-1
                               Execute "moveto ["+table_name+"->]"
                               refresh_window()
                             else                                    ; if bottom of next screen>number of items
                               if t_row=number_of_items-rows+1 then
                                 beep
                                 message "Bottom of window"
                               else
                                 t_row=number_of_items-rows+1
                                 moveto [Answer->]
                                 moveto record t_row+s_row-1
                                 Execute "moveto ["+table_name+"->]"
                                 refresh_window()
                               endif
                             endif

    endswitch
  endwhile
endproc

writelib "updatew" update_window,refresh_window

                                        