;****************************************************************************
; 
; Script Name:  Timeq.sc   ( Time Query )
; Written By :  Glenn Pence - using Paradox 4.5 for DOS
; Written On :  June 27, 1994
;
; Description:  This script queries the database for all entries between
;               two given dates. 
;
;****************************************************************************
CLEARALL
CLEAR
SHOWPULLDOWN ENDMENU
WHILE TRUE
 WHILE TRUE
  DATEONE = TODAY() 
  DATETWO = TODAY() 
  ;===== GET STARTING DATE (dateone) ======================================
  SHOWDIALOG " TIME QUERY MODE " @ 3,15 HEIGHT 17 WIDTH 50
  @ 2,4 ?? "ENTER THE STARTING DATE: "
  @ 3,4 ?? "    (09/12/61 format)"
  ACCEPT @ 2,30 WIDTH 11 "D" TAG "T1" TO DATEONE
  PUSHBUTTON @ 9,6 WIDTH 16
  " THIS ~W~EEK " OK                            ; These 4 buttons are added
  VALUE "TWEEK" TAG "OkTag1" TO BUTTONVALUE     ; for user convenience.
  PUSHBUTTON @ 11,6 WIDTH 16
  " THIS ~M~ONTH " OK
  VALUE "TMONTH" TAG "OkTag2" TO BUTTONVALUE
  PUSHBUTTON @ 9,25 WIDTH 16
  " NEXT WEE~K~ " OK
  VALUE "NWEEK" TAG "OkTag3" TO BUTTONVALUE
  PUSHBUTTON @ 11,25 WIDTH 16
  " NEXT MONT~H~ " OK
  VALUE "NMONTH" TAG "OkTag4" TO BUTTONVALUE
  PUSHBUTTON @ 13,12 WIDTH 10                   ; These 2 buttons are the 
  "~O~K" OK DEFAULT                             ; default buttons.
  VALUE "SAY YES" TAG "OkTag5" TO BUTTONVALUE
  PUSHBUTTON @ 13,25 WIDTH 10
  "~C~ANCEL" CANCEL
  VALUE "SAY NO" TAG "Canceltag" TO BUTTONVALUE
  ENDDIALOG
  IF (RETVAL = FALSE) THEN                      ; Cancel was pressed
   CLEARALL
   RETURN 
  ELSE                                          ; if OK, then continue to
   IF BUTTONVALUE = "SAY YES" THEN              ; to next dialog box.
   ;========= GET ENDING DATE (datetwo) =====================================
   DATETWO = DATEONE
;
; ************ Note: if you are manually entering this code, copy the 
; dialog box above and paste it in below, then modify the 4 lines of code
; which require changes (in the next seven lines below)...
;
   SHOWDIALOG " TIME QUERY MODE " @ 3,15 HEIGHT 17 WIDTH 50
   @ 2,4 ?? "ENTER THE STARTING DATE:   ",DATEONE
   @ 3,4 ?? "    (09/12/61 format)"
   @ 5,6 ?? "ENTER THE ENDING DATE: "
   @ 6,6 ?? "  (02/21/73 format)"
   ACCEPT @ 5,30 WIDTH 11 "D" REQUIRED TAG "T2" TO DATETWO
   PUSHBUTTON @ 9,6 WIDTH 16
   " THIS ~W~EEK " OK
   VALUE "TWEEK" TAG "OkTag1" TO BUTTONVALUE
   PUSHBUTTON @ 11,6 WIDTH 16
   " THIS ~M~ONTH " OK
   VALUE "TMONTH" TAG "OkTag2" TO BUTTONVALUE
   PUSHBUTTON @ 9,25 WIDTH 16
   " NEXT WEE~K~ " OK
   VALUE "NWEEK" TAG "OkTag3" TO BUTTONVALUE
   PUSHBUTTON @ 11,25 WIDTH 16
   " NEXT MONT~H~ " OK
   VALUE "NMONTH" TAG "OkTag4" TO BUTTONVALUE
   PUSHBUTTON @ 13,12 WIDTH 10
   "~O~K" OK DEFAULT
   VALUE "SAY YES" TAG "OkTag3" TO BUTTONVALUE
   PUSHBUTTON @ 13,25 WIDTH 10
   "~C~ANCEL" CANCEL
   VALUE "SAY NO" TAG "Canceltag" TO BUTTONVALUE
   ENDDIALOG 
;=============== CHECK USER RESPONSE ========================================
   IF (RETVAL = FALSE) THEN     ; exit if Cancel was pressed
    CLEARALL
    RETURN 
   ELSE                         ; check for input error
    IF DATETWO < DATEONE THEN   ; yes, input error was made
     BEEP
     MESSAGE " Ending date cannot be before starting date. Try again... "
     SLEEP 3000
     LOOP
   ENDIF  
  ENDIF
 ENDIF
ENDIF 
;======== BEGIN CALCULATIONS ================================================
; Check to see if This Week was pressed... a week is Mon -> Sun
  IF BUTTONVALUE = "TWEEK" THEN   ; get this Monday's date based on dateone
   WHILE DOW(DATEONE) <> "Mon"
    DATEONE = (DATEONE - 1)
   ENDWHILE 
   DATETWO = (DATEONE + 7)
  ENDIF
; Check to see if Next Week was pressed... a week is Mon -> Sun
  IF BUTTONVALUE = "NWEEK" THEN   ; get next Monday's date based on dateone
   DATEONE = DATEONE + 7
   WHILE DOW(DATEONE) <> "Mon"
    DATEONE = (DATEONE - 1)
   ENDWHILE 
   DATETWO = (DATEONE + 7)
  ENDIF
; Check to see if This Month was pressed...
  IF BUTTONVALUE = "TMONTH" THEN  ; get this month's date based on dateone
   IF MONTH(DATEONE) = 2 THEN     ; if February...
    IF (MOD(YEAR(DATEONE),4) = 0) AND   ; Yes, leap year...
    ((MOD(YEAR(DATEONE),100) <> 0 OR MOD(YEAR(DATEONE),400)=0)) THEN 
     DATEONE = (DATEONE - (DAY(DATEONE) - 1))
     DATETWO = (DATEONE + 28)
    ELSE                                ; No, not a leap year
     DATEONE = (DATEONE - (DAY(DATEONE) - 1))
     DATETWO = (DATEONE + 27)
    ENDIF
   ELSE                                 ; add 30 or 31 days...
     IF MONTH(DATEONE) = 1 OR MONTH(DATEONE) = 3 OR MONTH(DATEONE) = 5 OR
     MONTH(DATEONE) = 7 OR MONTH(DATEONE) = 8 OR MONTH(DATEONE) = 10 OR
     MONTH(DATEONE) = 12 THEN 
       DATEONE = (DATEONE - (DAY(DATEONE) - 1))
       DATETWO = (DATEONE + 30)         ; for months with 31 days
     ELSE
       DATEONE = (DATEONE - (DAY(DATEONE) - 1))
       DATETWO = (DATEONE + 29)         ; for months with 30 days
     ENDIF
   ENDIF   
  ENDIF
; Check to see if Next Month was pressed...
  IF BUTTONVALUE = "NMONTH" THEN  ; get next month's date based on dateone
   IF MONTH(DATEONE) = 1 THEN     ; if February...
    IF (MOD(YEAR(DATEONE),4) = 0) AND   ; Yes, leap year...
    ((MOD(YEAR(DATEONE),100) <> 0 OR MOD(YEAR(DATEONE),400)=0)) THEN 
     DATEONE = DATEVAL("2/1/" + STRVAL(YEAR(DATEONE)))
     DATETWO = DATEVAL("2/29/" + STRVAL(YEAR(DATEONE)))
    ELSE                                ; not a leap year
     DATEONE = DATEVAL("2/1/" + STRVAL(YEAR(DATEONE)))
     DATETWO = DATEVAL("2/28/" + STRVAL(YEAR(DATEONE)))
    ENDIF 
   ENDIF 
   IF MONTH(DATEONE) = 12               ; if Jan, roll year + 1
    THEN
     DATEONE = DATEVAL("1/1/" + STRVAL(YEAR(DATEONE) + 1))
     DATETWO = DATEVAL("1/30/" + STRVAL(YEAR(DATEONE)))
   ENDIF
   IF (MONTH(DATEONE) >1 AND MONTH(DATEONE) <12) 
   AND DAY(DATETWO) <> 28 THEN          ; if not Jan or Feb then ending date = 30
     DATEONE = DATEVAL(STRVAL(MONTH(DATEONE) + 1) + "/1/" + STRVAL(YEAR(DATEONE)))
     DATETWO = DATEVAL(STRVAL(MONTH(DATEONE)) + "/30/" + STRVAL(YEAR(DATEONE)))
   ENDIF
   IF MONTH(DATEONE) = 1 OR MONTH(DATEONE) = 3 OR MONTH(DATEONE) = 5 OR
   MONTH(DATEONE) = 7 OR MONTH(DATEONE) = 8 OR MONTH(DATEONE) = 10 
   OR MONTH(DATEONE) = 12 THEN          ; add another day if 31 days needs
     DATETWO = (DATETWO + 1)
   ENDIF
  ENDIF   
  IF NOT RETVAL THEN        ; check retval to see if [esc] was pressed
   CLEARALL                 ; yes, [esc] was pressed
   RETURN
  ENDIF
;========= QUERY PHASE ======================================================
  CLEAR
  CURSOR OFF                    
  STYLE ATTRIBUTE 31 @ 10,30 ?? "One moment, please"
  STYLE ATTRIBUTE 159 @ 10,48 ?? "..."
  IF DATEONE = DATETWO THEN  ; show message of search pattern
   MESSAGE "Searching for records from ",(DATEONE)"... "
  ELSE 
   MESSAGE "Searching for records from ",(DATEONE)," to ",(DATETWO),"... "
  ENDIF
  SLEEP 1500 
  Query

  Testdata |             Date                   | Account Name | 
           | Check >(~DATEONE-1), <(~DATETWO+1) | Check        | 

  Testdata | Address | City  | State | Zip   | Country |
           | Check   | Check | Check | Check | Check   |

  Endquery
  DO_IT!
  MESSAGE ""
  IF ISEMPTY("ANSWER") THEN 
   BEEP
   MESSAGE " No entries found using those search dates... "
   WINCLOSE
   CLEAR
   CLEARALL
   RETURN 
  ENDIF 
  QUITLOOP
ENDWHILE
WHILE TRUE
 WINCLOSE
 CLEARALL
 CLEAR
 VIEW "ANSWER"
; use the original table's form to view answer table
 COPYFORM "testdata" "F" "ANSWER" "1"
 PICKFORM "1"
 WINMAX
 SHOWPULLDOWN ENDMENU
 WAIT TABLE
  PROMPT " [F2]=RETURN   [F6]=PRINT "
 UNTIL "F2","F6","ESC"
 IF RETVAL = "F2" OR RETVAL = "ESC" THEN        ; exit the script
  WINCLOSE
  CLEARALL
  CLEAR
  RETURN
 ENDIF
;============================ PRINT LIST ====================================
 IF RETVAL = "F6" THEN
  IF PRINTERSTATUS() = TRUE THEN
   COPYREPORT "Testdata" "R" "ANSWER" "R"
   INSTANTREPORT
   MESSAGE " Sending your report to printer. "
   SLEEP 1000
   MESSAGE ""
  ELSE
   BEEP
   MESSAGE " Printer is not ready... is it connected to the network? "
   LOOP
  ENDIF  
 ENDIF
 DELETE "ANSWER"
 CLEAR
 WINCLOSE
ENDWHILE
ENDWHILE


; ====== COMMENTS =========================================================
;
;
; The 4 buttons are added to the dialog box for user convenience.  In my
; case, users are looking up to-do tasks and either viewing the list of
; tasks or printing them.  I've included simple button for this week, next
; week, this month and next month in order for the user to be able to 
; quickly access this common information.  In the event the users needs 
; another time parameter they can simply enter the dates needed.  Today's
; date is the default data -- all the user needs to do is press Enter 2
; times to get the results for today. As an added bonus, the user can 
; adapt any of these buttons by entering a new date in the first field --
; all 4 calculations are based on the dateone variable, so changing it
; changes the This week, Next week, etc functions as well.
;
; I have assumed that the table (testdata) has a form to use (we copy it
; from testdata to the answer table and a report as well.  
;
; Error checking includes leap years/centuries and advancing the dates for
; next month calculations (add a year if looking at Jan next month), etc.
;
;
; Enjoy!  It's FreeWare!  by Glenn Pence
; Will upload to Pdox DOS forum on CIS -- PAL using forum.
 
