;-------------------------------------------------------------------------
;                           DATE TIME CHECK PROC
;Written by Steve Caple, Sacramento Paradox Users Roundtable CIS:76711,520
;-------------------------------------------------------------------------
proc DateTimeSet()
  private CurrentProc,     ;string - for debugging purposes

          NormalText,      ;
          IntenseText,     ;
          HiLiteText,      ; numeric - color attribute variables
          ReverseText,     ;
          MessageText,     ;
          BoxShadow,       ;

          Dummy,           ;numeric - bit bucket
          Choice,          ;string - showmenu output
          NewDate,         ;date - user date input

          MM,              ;
          DD,              ;string - match function pattern output vars
          YY,              ;

          NewTime          ;string - user time input

  CurrentProc = "DateTimeSet"

  NormalText   = 112  ;black on gray       ;initialize color attributes
  IntenseText  = 127  ;white on gray
  HiLiteText   = 126  ;yellow on gray
  ReverseText  =  31  ;white on blue
  MessageText  =  79  ;white on red
  BoxShadow    =   8  ;dark gray on black

  cursor off                          ;just in case you left it on

  ; -----------------------------------------------------------------------
  ; paint date/time display box
  ; -----------------------------------------------------------------------
  paintcanvas  attribute BoxShadow  3,7,14,55    ;shadow dk gray on black
  @ 2, 9
  style attribute NormalText          ;black on gray
  setmargin 9
  text
Ŀ
       SYSTEM CALENDAR DATE & TIME CHECK       
                                               
         Current system date:                  
                        time:                  
                                               
  Note: If the date and time are not correct,  
  you may need to either replace the battery   
  in your computer or run your computer's      
  SETUP utility to permanently set the clock   
  and calendar.  Contact your dealer.          

  endtext
  setmargin off

  paintcanvas  border  attribute IntenseText  2,9,13,57  ;white on gray border
  paintcanvas  attribute HiLiteText  3,10,3,56           ;yellow on gray title

  ; -----------------------------------------------------------------------
  ; menu loop
  ; -----------------------------------------------------------------------
  while true

    ;simulate the appearance of the showmenu that will be called below
    ;use syscolor() values to be sure it matches
    paintcanvas  fill format("w80","Date  Time  Quit")
                 attribute syscolor(0)     0,  0, 0, 79
    paintcanvas  attribute syscolor(2)     0, 12, 0, 15
    paintcanvas  fill format("w80","Accept date & time shown")
                 attribute syscolor(4)     1,  0, 1, 79

    while charwaiting()               ;if any keys in kybd buffer,
      Dummy = getchar()               ;dump 'em in bit bucket
    endwhile

    while not charwaiting()           ;as long as no new keypresses
      style attribute ReverseText
      @ 5,40 ?? format("w8,ar",strval(today()))  ;keep re-displaying
      @ 6,40 ?? format("w8,ar",strval(time()))   ;date and time
      style
    endwhile                          ;if a key is pressed, leave loop
                                      ;with key still in the buffer

    showmenu
      "Date" : "Set a new system date",
      "Time" : "Set a new system time",
      "Quit" : "Accept date & time shown"
      default "Quit"
    to Choice

    switch

      case Choice = "Date":
        while true
          @ 0,0 clear eol
          Msg("Enter new system date in DD/MM/YY format (example: 10/12/93)",
               1,true,MRev,0,false)
          style attribute 79

          cursor normal               ;turn cursor on only for accepts
              @ 5,40 accept "D" min 01/01/80 to NewDate  ;1/1/80 is DOS min
          cursor off                  ;and turn off right afterward

          canvas off                  ;freeze display update
            style attribute NormalText
            @ 5,40 ?? spaces(12)
            style

            if not retval or isblank(NewDate) then

              style attribute ReverseText
              @ 5,40 ?? format("w8,ar",strval(today()))
              style                   ;clear attributes, back to defaults
              canvas on               ;update display
              quitloop

            else

              ;use match to parse apart the date input
              if match(NewDate,"../../..",DD,MM,YY) then
                NewDate = DD+"-"+MM+"-"+YY
              endif

              ;clear out old file - no echo
              run norefresh "del datefeed.wsc"

              ;send date value plus a linefeed to a new file
              print file "datefeed.wsc" NewDate + "\n"

              ;call DOS Date command with input from the new file
              run norefresh "date < datefeed.wsc"

              style attribute ReverseText
              @ 5,40 ?? format("w8,ar",strval(today()))
              style

            endif

          canvas on

          quitloop
        endwhile

      case Choice = "Time":
        while true
          @ 0,0 clear eol
          Msg("Enter new system time in HH/MM/SS 24-hour format"
            + " (example: 14:33:08)",1,true,MRev,0,false)
          style attribute 79

          cursor normal
              @ 6,40 accept "A8" picture "#{:,[#]:}##[:##]" to NewTime
          cursor off

          canvas off
            style
            if not retval or isblank(NewTime) then
              style attribute ReverseText
              @ 6,40 ?? format("w8,ar",strval(time()))
              style
              canvas on
              quitloop
            else
              run norefresh "del timefeed.wsc"
              print file "timefeed.wsc" NewTime + "\n"
              run norefresh "time < timefeed.wsc"
              style attribute ReverseText
              @ 6,40 ?? format("w8,ar",strval(time()))
              style
            endif
          canvas on

          quitloop
        endwhile

      case Choice = "Quit"
        or Choice = "Esc" : return true

    endswitch

  endwhile

endproc



; ---------------------------------------------------------------------------
;                             DEMONSTRATION
; ---------------------------------------------------------------------------

cursor off
clear
paintcanvas fill "" attribute 23  2,0,23,79    ;put up a splash background
DateTimeSet()

style attribute 79 
@ 12,0 ?? format("w80,ac","Bdyaaa, bdyaaa, bdyaaaa - That's All Folks!")
retval = getchar()


; ---------------------------------------------------------------------------
;                bdyaaa, bdyaaa, bdyaaaa - that's all folks!
; ---------------------------------------------------------------------------



