; This program was inspired by Ben Gaman's TIMAKE.SC whose inspiration is
; gratefully acknowledged.
;
;                                 Introduction
;
; The purpose of TECHINFO.SC is to build a data base of Borland Technical  ; Information Sheets and to provide access to them using Version 4.0       ; approaches.
;
; All sheets can be browsed online using the form provided and FieldView.
;
; Two Query and Print routines provide output to either the screen or 
; the printer. You can also control whether or not original
; pagination is used. 
;    QueryAndPrint requests the title of the dialog through a pick list
;    GeneralQueryAndPrint sets up a query to select one or more to print
; These two routines have identical parameters:
;    TIDB.a - the name of the table storing the data base
;    OriginalBoundaries.b - true if you want original pagination
;    Device.a - "Screen" or "Printer"
; These might be assigned to hotkeys. For example,
; SETKEY 2 AUTOLIB=. . . QueryAndPrint("C:\\. . .\\TechInfo",True,"Screen") 
; would assign CTRL-B to use the TechInfo data base in the specified
; directory, with original pagination, and with output to the screen.
;
;                         General method
;
;    1. Produce a list of availabile TI*.ASC files in the default          ;       directory. These contain the sheets.
;    2. Convert the table LIST into a new table containing various
;       additional fields parsed out of the input file's page header.
;    3. Populate the fields by reading the TI*.ASC files into a memovar
;       and extracting the information from them.
;    4. Strip the page headers and footers from the TI*.ASC file;
;       Optionally, shorten each remaining line to no more than a
;       given number of characters (77 is recommended);
;       Store results in table as field [Text].
;    5. Create a form and a report
;    6. Create a library to provide support routines
;
;    Removal of the TI*.ASC files from the directory is left to the user.
;    GetFiles has Renameit.b as a parameter. Set this false for runs
;    after the first.
;
;                    Interesting Problems Encountered
;
; The conversion of the date in the document: 
; This was solved by generalizing Mr. Gaman's technique so that I did not 
; have to use trim. For the sample  of 1992 Sheets that I downloaded, the  
; DOS file date reported by list agrees with the date on the sheet so the  
; extraction/conversion might be considered superflous.
;
; Viewing text of sheets on line:
; The original sheets have a header and footer which clutters online views. 
; This was solved by removing them, but marking their original location    
; with chr(155). This makes it possible to develop routines to print the   
; text with the original pagination and any desired header and footer.     
; Chr(255) was used because PARADOX converts it to chr(0) on output, and    
; because a form feed ("\f") causes grief for PARADOX's automatic printing 
; routines.
;     The only remaining problem with this whole approach is when a 
; paragraph is split across a page, it will be displayed with a blank line
; in the middle. Removing the blank line in this case also removes it
; between two paragraphs where the Tech Info Sheet style requires one.
; Solving this problem requires a method to detect/mark the end of 
; paragraphs.
;
; Displaying/printing individual lines of text correctly:
; Truncating the line to 77 char was a partial answer. In my sample, the   
; only lost text was unneeded parts of screen displays. Trunctation gave  
; correct displays in Field Views in Forms. 
;     However, when viewing or printing a report alignment occasionally was
; lost caused by the presence chr(255)'s in the original TI*.ASC files.    
; Since they had no apparent use, a routine was developed to remove them. 
; This cured the alignment problems. 
;
; Print with original pagination:
; The easiest way is to parse the [Text] into pages and store the pages as 
; individual records in an auxiliary table. The auxiliarry table can then  
; be printed using standard PARADOX techniques. The text could be stored   
; this way permanently. This solution was rejected because it makes online 
; viewing of the text difficult.
;
; Performance:
; This can be a problem when manipulating large memovar's. The
; introduction of the trimming process was a gotcha. It almost quadrupled
; the running time! On an 486-33Mhz with disk cacheing the trimming
; version processed about 5000 bytes per second, while the nontrimming
; version processed about 20000 bytes per second.
;   The method used here illustrates the need for memo manipulation        
; routines that pass the memo by reference instead of by value. It really   
; is senseless to constantly recopy memos when calling the string routines!
;
; Disk space:
; The .DB file is relatively compact, but the .MB file is large. Because of 
; the removal of the text header and the effects of clustering, the .DB/.MB 
; combination may be marginally better than the individual files at using  
; space.
;
; Your comments and suggestions are welcomed. However, I don't log onto
; CIS regularly, so I may not respond on a timely basis.
;
; Al Christoph, Ferndale, MI CIS  76530,67 
;
; ---------------------------------------------------------------------
 
LbNm="TechInfo"
CREATELIB LbNm SIZE 50

; ---------------------------------------------------------------------
; Report writing routines begin here
;
PROC DivideAnswer()
;  Take [text] in each record of answer and parse it out into pages
;  Put each page on a new record of answer and delete the record just
;  processed.
   PRIVATE F.m, Cur.n, Len.n, DittoFlds.n, i, J, R.n, Base.n
   Edit "Answer"
   DittoFlds.n=NFIELDS("Answer")-1
   HOME
   WHILE [Ext Name]<>""
      J=0
      R.n=[Number]
      Base.n=RECNO()
      F.m=[Text]
      Cur.n=1
      Len.n=LEN(F.m)
      WHILE Cur.n<Len.n
         DOWN 
         INS 
         CTRLHOME RIGHT ; make first field [Number] Page#
         []=FORMAT("W5,AR",R.n)+FORMAT("W5,AR",J)  
         RIGHT
         J=J+1
         FOR I FROM 2 TO DittoFlds.n ; Ditto most remaining fields
            Ditto RIGHT
         ENDFOR
         Nxt.n=SEARCHFROM(chr(255),F.m,Cur.n) ; get next hunk of [Text]
         IF Nxt.n=0 THEN Nxt.n=Len.n+1 ENDIF
         [Text]=SUBSTR(F.m,Cur.n,Nxt.n-Cur.n) ; and save it
         Cur.n=Nxt.n+1
      ENDWHILE
      MOVETO RECORD Base.n    ; done with [Text] blast its record away
      DEL
      SKIP J ; is there another original answer record to process
   ENDWHILE
   DO_IT!
   CLEARIMAGE ; "Answer"
ENDPROC
WRITELIB LbNm DivideAnswer
RELEASE PROCS DivideAnswer

PROC ArrayDialog(tit,out,nam,da,wi)
;  display a dynamic array da  with entries a maximum length of wi
;  use tit for the window title
;  return the result in out[nam]
   PRIVATE h,h2,h1,w2,w1,c1,c2,sysi,wo,w22
   DYNARRAY sysi[]
   SYSINFO TO sysi
   c1=round((sysi["SCREENHEIGHT"]-1)/2,0)
   c2=round(sysi["SCREENWIDTH"]/2,0)-1
   h=min(sysi["ScreenHeight"]-3,DYNARRAYSIZE(da)+6)
   h2=round(h/2,0)
   h1=min(h-6,DYNARRAYSIZE(da))
   wi=wi+2
   wi=min(wi,2*c2-10)  ; Make sure there is space for pick list
   w22=round(wi/2,0)
   wo=wi
   w=wo+9
   w=max(w,30)
   w2=round(w/2,0)-1
   w1=10
   SHOWDIALOG tit @c1-h2,c2-w2 HEIGHT h WIDTH w
      PICKDYNARRAY
         @1,w2-w22
         HEIGHT h1
         WIDTH wi
         COLUMNS 1
         da
         TAG "PickTag"
         TO out[nam]
      PUSHBUTTON @h-4,w2-w1 WIDTH w1
         "~O~K"
         OK
         DEFAULT
         VALUE TRUE
         TAG "OkTag"
         TO ok
      PUSHBUTTON @h-4,w2 WIDTH w1
         "~C~ancel"
         CANCEL
         VALUE TRUE
         TAG "CancelTag"
         TO ok
   ENDDIALOG
   RETURN RETVAL
ENDPROC
WRITELIB LbNm ArrayDialog
RELEASE PROCS ArrayDialog

PROC QueryAndPrint(TIDB.a,OriginalBoundaries.b,Device.a)
;   Form an array of Sheet titles from TIDB.A and allow the user to
;   choose one.
;   Use Query to isolate that one
;   Use Tools to copy the report to answer
;   IF OriginalBoundaries.b THEN paginate according to original pages
;   Print the report on Device.a (Either "Printer" or "Screen")
    PRIVATE Max.n, Titles.a, i, Query.a
    DYNARRAY Titles.a[]
    VIEW TIDB.a
    Max.n=0
    i=0    
    SCAN            ; build array of titles
       i= i+1
       Titles.a[i] = [Title]
       Max.n=MAX(Max.n,LEN(Titles.a[i]))
    ENDSCAN
    CLEARIMAGE ; TIDB.a
    IF NOT ArrayDialog("Borland Info Sheets",Titles.a,0,Titles.a,max.n)
    THEN
       RETURN
    ENDIF
    
    Message "Printing . . ."
    ; Do the query
    Query.a=Titles.a[Titles.a[0]]
    MENU {Ask} Select TIDB.a 
    CHECK
    [Title]="~Query.a"
    DO_IT!
    CLEARIMAGE   ; Answer
    CLEARIMAGE   ; Query
    
    IF OriginalBoundaries.B THEN DivideAnswer() ENDIF
    
    ;Copy the report we need for answer
    COPYREPORT TIDB.a "R" "Answer" "R"
    MENU {Report} {Output} SELECT "Answer" SELECT "R" SELECT Device.a
    Message ""
ENDPROC
WRITELIB LbNm QueryAndPrint
RELEASE PROCS QueryAndPrint

PROC GeneralQueryAndPrint(TIDB.a,OriginalBoundaries.b,Device.a)
;   Allow user to specify query to select TechInfo Sheets
;   Use Query to isolate one or more requests
;   Use Tools to copy the report to answer
;   IF OriginalBoundaries.b THEN paginate according to original pages
;   Print the report on Device.a (Either "Printer" or "Screen")
    
    ; Do the query
    MENU {Ask} Select TIDB.a 
    CHECK
    ECHO NORMAL
    WAIT TABLE
        PROMPT "Press <F2> when complete OR <Esc> to quit"
        Message "Please complete Query"
    UNTIL "F2", "Esc"
    IF RETVAL="Esc" THEN CLEARIMAGE RETURN "" ENDIF
    DO_IT!
    CLEARIMAGE   ; Answer
    CLEARIMAGE   ; Query
    ECHO OFF
    Message "Printing . . ."
    IF OriginalBoundaries.B THEN DivideAnswer() ENDIF
    ;Copy the report we need for answer
    COPYREPORT TIDB.a "R" "Answer" "R"
    MENU {Report} {Output} SELECT "Answer" SELECT "R" SELECT Device.a
    
    Message ""
ENDPROC
WRITELIB LbNm GeneralQueryAndPrint
RELEASE PROCS GeneralQueryAndPrint

; ------------------------------------------------------------------
; Routines to build the data base begin here
;
PROC ReplaceFF(F.m)
;   replace any occurance of chr(255) with a blank character. Not
;   clear why they are in orignal file BUT the mess up the printed
;   output something fierce.
    PRIVATE Cur.n, Nxt.n, Len.n, S.m
    Len.n = LEN(F.m)
    S.m=""
    Cur.n=1
    WHILE Cur.n<=Len.n
       Nxt.n = SEARCHFROM(chr(255),F.m,cur.n)
       IF Nxt.n=0 THEN Nxt.n = Len.n+1 ENDIF
       IF S.m<>"" THEN
          S.m=S.m+" "+SUBSTR(F.m,Cur.n,Nxt.n-Cur.n)
       ELSE
          S.m=SUBSTR(F.m,Cur.n,Nxt.n-Cur.n)
       ENDIF
       Cur.n=Nxt.n+1
    ENDWHILE
    RETURN S.m
ENDPROC
WRITELIB LbNm ReplaceFF
RELEASE PROCS ReplaceFF

PROC TrimLines.a(F.m,maxl.n)
;  Trim trailing characters beyond max.l from every line of F.m
   PRIVATE Cur.n, Nxt.n, S.m
   Cur.n=1
   S.m=""
   WHILE Cur.N<LEN(F.m)
      Nxt.n=SEARCHFROM("\n",F.m,Cur.n)          ; find next \n
      IF Nxt.n=0 THEN Nxt.n=LEN(F.m)+1 ENDIF    ; there might not be one
      S.m= S.m+SUBSTR(F.m,Cur.n,MIN(Nxt.n-Cur.n,maxl.n))+"\n" 
      Cur.n=Nxt.n+1   ; omit any piece between Cur.n+maxl.n and Nxt.n
   ENDWHILE
   Return S.m
ENDPROC
WRITELIB LbNm Trimlines.a
RELEASE PROCS Trimlines.a
 
PROC DelHeader.a(F)
;  Remove extraneous text at top and bottom of every page
   PRIVATE Cur.n,Nxt.n,ff
   ff=""                                 ; form feed is null for first page
   Cur.n=SEARCH("PRODUCT  :",F)          ; first line of header is PRODUCT
   Nxt.n=SEARCHFROM("TITLE  :",F,Cur.n)  ; last line of header is TITLE
   while (Cur.n>0) and (Nxt.n>0)
      ;Search forward past TITLE  :  and backward from PRODUCT  :  for
      ;non-blank lines
      Nxt.n = SEARCHFROM("\n",F,Nxt.n) 
      WHILE SUBSTR(F,Nxt.n+1,1)="\n" Nxt.n=Nxt.n+1 ENDWHILE
      WHILE (Cur.n>1) and SUBSTR(F,Cur.n-1,1)=" "   Cur.n=Cur.n-1  ENDWHILE
      WHILE (Cur.n>1) and SUBSTR(F,Cur.n-1,1)="\n"  Cur.n=Cur.n-1  ENDWHILE
      ; Make a new F leaving out the footer/header piece. 
      F=SUBSTR(F,1,Cur.n-1)+ff+SUBSTR(F,Nxt.n+1,LEN(F)-Nxt.n)
      ff="\n"+chr(255)+"\n"
      ; Determine if there is more to do
      Cur.n=SEARCHFROM("PRODUCT  :",F,Cur.n)
      Nxt.n=SEARCHFROM("TITLE  :",F,Cur.n)
   ENDWHILE
   ; Remove trailng \n
   Nxt.n=LEN(F)
   WHILE SUBSTR(F,Nxt.n,1)="\n" Nxt.n=Nxt.n-1 ENDWHILE
   RETURN SUBSTR(F,1,Nxt.n)
ENDPROC
WRITELIB LbNm DelHeader.a
RELEASE PROCS DelHeader.a

PROC D2Val.d(Date.a)
;  Convert the output of FORMAT("D2",date) back to date
;  The code is a generalization of that in TIMAKE.SC by Ben Gaman 
;  CIS 76164,716
;  Does not require any trimming at either end!
   PRIVATE Da,Mo,Data.d,v,w,x,y,z,a,b
   Switch         ; long form date to MM/DD/YYYY
      Case Match(Date.a,"..Jan.. .., @@@@..",a,b,Da,v,w,x,y,z) : Mo = "01"
      Case Match(Date.a,"..Feb.. .., @@@@..",a,b,Da,v,w,x,y,z) : Mo = "02"
      Case Match(Date.a,"..Mar.. .., @@@@..",a,b,Da,v,w,x,y,z) : Mo = "03"
      Case Match(Date.a,"..Apr.. .., @@@@..",a,b,Da,v,w,x,y,z) : Mo = "04"
      Case Match(Date.a,"..May.. .., @@@@..",a,b,Da,v,w,x,y,z) : Mo = "05"
      Case Match(Date.a,"..Jun.. .., @@@@..",a,b,Da,v,w,x,y,z) : Mo = "06"
      Case Match(Date.a,"..Jul.. .., @@@@..",a,b,Da,v,w,x,y,z) : Mo = "07"
      Case Match(Date.a,"..Aug.. .., @@@@..",a,b,Da,v,w,x,y,z) : Mo = "08"
      Case Match(Date.a,"..Sep.. .., @@@@..",a,b,Da,v,w,x,y,z) : Mo = "09"
      Case Match(Date.a,"..Oct.. .., @@@@..",a,b,Da,v,w,x,y,z) : Mo = "10"
      Case Match(Date.a,"..Nov.. .., @@@@..",a,b,Da,v,w,x,y,z) : Mo = "11"
      Case Match(Date.a,"..Dec.. .., @@@@..",a,b,Da,v,w,x,y,z) : Mo = "12"
   EndSwitch
   Date.d = DateVal(Mo+"/"+Da+"/"+v+w+x+y)     ; convert ascii date to Pdox date
   RETURN Date.d
ENDPROC
WRITELIB LbNm D2Val.d
RELEASE PROCS D2Val.d

PROC Extract.a(sub.a,s.a)
;   locate sub.a in s and return the text on the line
;   MATCH won't work because we are dealing with more than 255 characters
    PRIVATE start.n,sto.np
    start.n=SEARCH(sub.a,s.a)
    IF start.n>0 THEN
        stop.n=SEARCHFROM("\n",s.a,start.n)
        IF stop.n=0 THEN stop.n=LEN(s.a)+1 ENDIF
        start.n=start.n + LEN(sub.a)
        RETURN SUBSTR(s.a,start.n,stop.n-start.n)
    ELSE
       RETURN ""
    ENDIF
ENDPROC
WRITELIB LbNm Extract.a
RELEASE PROCS Extract.a

PROC GetFiles(TIDB.a,RenameIt.b,TrimLeng.n)
;   Create or add to table TIDB.a. 
;     If RenameIt.b is true then  Rename "List" to TIDB.a  otherwise
;     add a restructured "List" to TIDB.a which is assumed! to exist.
;     If TrimLeng.n>0 then trim all lines of text in TIDB.a to that
;     length + 1 for "\n"
;
    Private F.m         ; store input file here
    MESSAGE "Getting Tech Info Sheet files . . ."
    MENU {Tools} {Info} {Inventory} {Files} SELECT "*.ASC"
    MENU {Modify} {Restructure} 
       SELECT "List" 
       RIGHT CTRLBACKSPACE "Ext Name" RIGHT CTRLBACKSPACE "A12" DOWN LEFT
       CTRLBACKSPACE "Ext Date"     DOWN
       "Number" RIGHT "S"           DOWN  
       "Product" RIGHT "A15"        DOWN          
       "Version" RIGHT "A15"        DOWN         
       "OS" RIGHT "A12"             DOWN          
       "Title" RIGHT "A73"          DOWN        
       "Date" RIGHT "D"             DOWN         
       "Text" RIGHT "M78"
       DO_IT!
       {Trimming}

    IF RenameIt.b
    THEN
       RENAME "List" TIDB.a
    ELSE
       ADD "List" TIDB.a
    ENDIF
    CLEARIMAGE
    
    ; Proces those files that appear not to have been added before
    ; if they exist
    EDIT TIDB.a
    SCAN FOR [Title]=""     
        Message "Processing ",[Ext Name]
        IF ISFILE([Ext Name])
        THEN
           FILEREAD [Ext Name] TO F.m
           ; first remove any chr(255)'s that might be lurking
           IF SEARCH(chr(255),F.m)<>0 THEN F.m=ReplaceFF(F.m) ENDIF
           [Product] =extract.a("PRODUCT  :  ",F.m)
           [Number] =NUMVAL(extract.a("NUMBER  :  ",F.m))
           [Version]=extract.a("VERSION  :  ",F.m)
           [OS]     =extract.a("OS  :  ",F.m)
           [Title]  =extract.a("TITLE  :  ",F.m)
           [Date]   =D2Val.D(extract.a("DATE  :  ",F.m))
           IF TrimLeng.n>0
           THEN
              [Text]   =TrimLines.a(DelHeader.a(F.m),TrimLeng.n)
           ELSE
              [Text]   =DelHeader.a(F.m)
           ENDIF
        ENDIF
    ENDSCAN
    DO_IT!
ENDPROC
WRITELIB LbNm GetFiles
RELEASE PROCS GetFiles

; -----------------------------------------------------------------------
; Routines to make form and report begin here
;
PROC MakeForm(TIDB.a)
   MESSAGE "Making form for ",TIDB.a
   ; Eliminate existing form if any
   IF ISFILE(TIDB.a+".F")
   THEN
	  MENU {Tools} {Delete} {Form} SELECT TIDB ENTER
   ENDIF
   MENU {Forms} {Design} SELECT TIDB.A {F} {Borland Tech Info Sheets}

   ; First line is [Number] [Title]
   MENU {Field} {Place} {Regular} {Number}        ENTER Left Left ENTER
   RIGHT
   MENU {Field} {Place} {Regular} {Title}         ENTER ENTER
   ENTER

   ; Second line is [Product] Versions: [Version]  OS: [OS]  [Date]
   RIGHT RIGHT RIGHT RIGHT RIGHT
   MENU {Field} {Place} {Regular} {Product}       ENTER ENTER
   RIGHT "Verions: "
   MENU {Field} {Place} {Regular} {Version} Right ENTER ENTER
   RIGHT RIGHT "OS: "
   MENU {Field} {Place} {Regular} {OS}            ENTER ENTER
   RIGHT RIGHT
   MENU {Field} {Place} {Regular} {Date}          ENTER ENTER

   ; Next line is blank
   ENTER
   ENTER
   ; Next line is dimmed help text and Rec #
   "          Field View text below to scroll through entire document     "
   "# "
   MENU {Field} {Place} {#Record} Enter Left Left Left Enter
   ; Go to front of line
   CTRLHOME
   MENU {Style} {Color} {Area}
   ; Select current location for first corner
   ENTER
   ; Highlight just this line
   DOWN LEFT UP
   ; Select it
   ENTER
   ; Select color eight over from current
   RIGHT RIGHT RIGHT RIGHT RIGHT RIGHT RIGHT RIGHT
   ENTER

   ; Next line is blank
   ENTER
   ENTER
   ; Next line is Word wrapped [Text]
   MENU {Field} {Place} {Regular} {Text} ENTER ENTER
   MENU {Field} {WordWrap} Left ENTER {16}
   Do_It!
ENDPROC
WRITELIB LbNm MakeForm
RELEASE PROCS MakeForm

PROC MakeReport(TIDB.a)
;  make a standard report for TIDB.a
;  use [Number], [Title] et al for header
;  use [Text]  for only field in form band
;  start a new page with each record
;  This cannot possibly pageinate like the original since we have removed
;  the original headers and footers. This means some page oriented formatting
;  will be lost. If you want original pagination, write your own routine
;  using location CHR(255) in [Text] as page markers.
;
   Message "Making report for ",TIDB.a
   IF ISFILE(TIDB.A+".R")
   THEN
	  MENU {Tools} {Delete} {Report} SELECT TIDB.a {R}
   ENDIF
   {Report} {Design} SELECT TIDB.a {R} {Borland Tech Info Sheets}
   {Free-form} 
   ; Skip down to title line and remove the print date - it's distracting
   Down Down Down Down Down 
   MENU {Field} {Erase} ENTER 
   ; Now move title and page number over a little
   Del Del Del Del Del
   CTRLHOME
   Down Down
   ; Group on [Number]
   Menu {Group} {Insert} {Field} {Ext Name} Enter
   Down Down
   ; Group header
   ; First line [Number] [Title]
   Menu {Field} {Place} {Regular} {Number} Enter Left Left Enter
   Enter Right Right
   Menu {Field} {Place} {Regular} {Title} Enter Enter
   ; Go to insert mode and start a new line
   Ins
   CTRLEND
   Enter
   ; Second line is [Product] Versions: [Version]  OS: [OS]  [Date]
   "     "
   Menu {Field} {Place} {Regular} {Product} Enter Enter Right Right
   "Versions: "
   Menu {Field} {Place} {Regular} {Version} Enter Enter Right Right Right
   "OS: "
   Menu {Field} {Place} {Regular} {OS} Enter Enter Right Right Right
   Menu {Field} {Place} {Regular} {Date} {1) mm/dd/yy} Enter Enter
   ; Move to form band
   DOWN DOWN
   ; Delete existing form band lines
   DeleteLine DeleteLine DeleteLine DeleteLine DeleteLine DeleteLine
   DeleteLine DeleteLine DeleteLine DeleteLine
   ; Place [Text] as full width field
   Menu {Field} {Place} {Regular} {Text} Enter Enter
   ; Make text variable word wrape
   Menu {Field} {WordWrap} Enter {v}

   ; Go to goup footer and add PAGEBREAK
   CtrlHome Down Down
   "PAGEBREAK"
   Do_It!
ENDPROC
WRITELIB LbNm MakeReport
RELEASE PROCS MakeReport

; MAIN - check version and then do the work
IF VERSION()<4 THEN
    BEEP
    MESSAGE "Version 4 required (for MEMO fields)"
    WHILE GETCHAR()<>27 BEEP MESSAGE "Press <Esc> to Continue . . ." ENDWHILE
    QUIT
ENDIF

; ----------------------------------------------------------------------
; Main program begins here
;
AUTOLIB = LbNm
TIDB.a="TechInfo"
Start.n=ticks()
; invoke GetFiles with trimming
IF ISTABLE(TIDB.A) THEN
   DELETE TIDB.a
ENDIF
GetFiles(TIDB.a,true,77)
Stop.n=ticks()

MakeForm(TIDB.a)
MakeReport(TIDB.a)
FORMKEY
Message "Time for GetFiles was ", (stop.n-start.n)/1000," secs"
WHILE GETCHAR()<>27 BEEP Message "Press <Esc> to continue . . ." ENDWHILE
RELEASE VARS AUTOLIB,Start.n,Stop.n