;prepared by John B Patterson
;76330,3607
;My first upload and I'm more interactive than PAL.
;quick tax liability test
@3,15 
?? "Your Quick Check of Your Federal Tax Liability "
style reverse
@7,6
?? "Enter Total Income (line 23 of 1040) $ "
accept "$" to totinc
@9,6
?? "Enter Adjustments to Income (line 30) $ "
accept "$" to adjtoinc
@11,6
?? "Enter Total Number of Exemptions (line 6E)  "
accept "S"  to exps
@13,6
?? "Enter Total Itemized Deductions (line 26 sch A) $ "
accept "$" to Idded
@15,6
?? "If You are filing SINGLE enter $3600, if Head of Household enter 5250 "
@16,6
?? "Married enter $6000.  Enter Your Amount. $ "
accept "$" picture "{3600,5250,6000}" to stded
@19,6
?? "Enter Tax Withheld $ "
accept "$" to withld
@21,15
style
?? " We will calculated the taxes now - Hang in there !"
sleep 250

ex = exps * 2300             ; computes exemption deduction $2300 new rate
adj = Totinc - Adjtoinc
If Idded > stded             ; compare std deduction to itemized deduction 
   then ded = Idded          ; and take greater amount in tax computation. 
   else ded = stded 
endif                        ; I'm sure this switching could be cndensed
taxinc = adj - (ded + ex)    ; but I'm more interactive than PAL
switch
case  stded = 6000 : Married = stded   ;left out married filing separately 
case  stded = 5250 : HdofHold = stded  
case  stded = 3600 : Single = stded
endswitch
tax = 0
Married = 6000   
if Married = 6000 then
switch
  case taxinc <35800              : tax =  (taxinc * .15) 
  case taxinc >=35800 and taxinc <86500 : tax = 5537 + ((taxinc - 35800) * .28)
 otherwise            : tax = (19566 + ((taxinc - 86500) * .31))
endswitch  
endif
HdofHold = 5250
if HdofHold = 5250 then
switch
  case taxinc <28750              : tax =  (taxinc * .15) 
  case taxinc >=28750 and taxinc <74150 : tax = 4313 + ((taxinc - 28750) * .28)
 otherwise            : tax = (17025+ ((taxinc - 74150) * .31))
endswitch  
endif
Single = 3600
if Single = 3600 then
switch
  case taxinc <21450              : tax =  (taxinc * .15) 
  case taxinc >=21450 and taxinc <51900 : tax = 3218 + ((taxinc - 21450) * .28)
 otherwise            : tax = (11744 + ((taxinc - 51900) * .31))
endswitch  
endif

clear clearall
style reverse
@3,15
?? "Your Estimated Tax Liability based on the Following Input. "
@5,7
?? "Your Total Income of $ "+strval(totinc)
@7,7
?? "Based on "+strval(exps)+ " exemptions at $ 2300 each. "
@9,7 
?? "Based on Filing "+strval(stded)+ " (3600=single, 5250=HoHH, 6000=Single)" 
@11,7
?? "Your taxable income is "+strval(taxinc)
@13,7
?? "Your tax is "+strval(tax)
@15,7
?? "Your Withholding were "+strval(withld)
@17,7
style intense
?? "The difference paid and due is "+strval(tax-withld)+ " ( - Means $$ due YOU )"
@19,7
style 
?? "Your Adjusted Gross is "+strval(adj)+ " if over $ 78,950 your "
@20,7
?? "exemption deduction will be reduced. See line 36 of 1040. " 
style   
message "Press any key to continue "
a = getchar()
clear clearall
release vars all
quit "Return to Paradox... Press Alt M for Menu.."