;This file is copyright (c) 1991, 1992 Informant Communications Group and the
;article author. The material here may be used in an application provided
;that this copyright/disclaimer information is kept in the original source
;file. The material presented here is provided "as is" and with no guarantee.
;Informant Communications Group/Paradox Informant assume no responsibility
;for the use or misuse of the material contained within.
;
;Contents        : procedure Proc EventMan.GetTargetWindow() 
;Source File     : TARGET.SC
;Author          : Henrik Bechmann
;                  Elect Software International
;                  Toronto, ONT Canada
;                  (416) 534-8176
;
;Informant Issue : October 1992
;
;Description     : Paradox 4.0 Event tracker
;
;
; Paradox Informant
; 10519 E. Stockton Blvd.
; Suite 142
; Elk Grove, CA  95624-9743
; Phone: (916) 686-6610
; Fax  : (916) 686-8497
; BBS  : (916) 686-4740

;----------------------------------------------------------------------------
; Assumes ECHO NORMAL
;----------------------------------------------------------------------------
Proc EventMan.GetTargetWindow(TriggerTag,EventBag)
  Private TargetWindow,
          WindowBag,
          EventType,
          ZOrderGroupChange,
          IsEditor,
          Keycode,
          WindowList,
          i,
          Found
;---------------------------------------------------------------------
; If the trigger is not an event then analyze trigger...
;---------------------------------------------------------------------
If TriggerTag <> "EVENT" Then ; must be a TRIGGER type event
  ;------------------------------------------------------------------
  ; If the trigger is not an ARRIVEWINDOW, then it relates to the
  ; current image.
  ;------------------------------------------------------------------
  If TriggerTag = "ARRIVEWINDOW" Then
    TargetWindow = GetWindow()
  Else
    Window Handle Form to TargetWindow
    If Not isWindow(TargetWindow) Then
      Window Handle Image ImageNo() To TargetWindow
    Endif
  Endif
  ;---------------------------------------------------------------------
  ; ...else this must be an event of type MOUSE, KEY, MESSAGE, or IDLE...
  ;---------------------------------------------------------------------
Else
  If Not IsWindow(GetWindow()) Then ; There are no windows
    TargetWindow = GetWindow()
  Else
    EventType = EventBag["Type"]
    Switch
      Case EventType = "MOUSE":
        ;----------------------------------------------------------------
        ; If this is a mouse event, then if it is a DOWN or no-button
        ; event then it belongs to the window over which the mouse
        ; event takes place, otherwise it is a modal event which
        ; belongs to the current window.
        ;----------------------------------------------------------------
        If (EventBag["Action"] = "DOWN") or
           ((EventBag["Buttons"] = "NONE") And
           (EventBag["Action"] <> "UP")) Then
          TargetWindow = WindowAt(EventBag["Row"],EventBag["Col"])
        Else
          TargetWindow = GetWindow()
        Endif
        ;----------------------------------------------------------------
        ; Except for one special case when the mouse action is DOWN:
        ; If the current window is floating and the target window is not
        ; then expect to select the topmost desktop window as the target
        ; in the course of changing z-orders from floating to desktop,
        ; if the mouse event took place somewhere other than on the menu
        ; bar or the status bar.
        ;----------------------------------------------------------------
        If EventBag["Action"] = "DOWN" Then
          Window GetAttributes GetWindow() To WindowBag
          If WindowBag["Floating"] Then
            If IsWindow(TargetWindow) Then
              Window GetAttributes Targetwindow To WindowBag
              ZOrderGroupChange = (Not WindowBag["Floating"])
            Else ; see if the mouse hit the prompt/speedbar area...
              SysInfo To SysInfoBag
              ZOrderGroupChange =
              ((SysInfoBag["ScreenHeight"] - 1 <> EventBag["Row"]) And
              (EventBag["Row"] <> 0))
            Endif ; The target window exists
            If ZOrderGroupChange Then
              Window List To WindowList
              Found = False
              For i From 1 To Arraysize(WindowList)
                Window GetAttributes WindowList[i] To WindowBag
                If Not WindowBag["Floating"] Then
                  Found = True
                  Quitloop
                Endif
              EndFor
              TargetWindow = IIf(Found,WindowList[i],0)
            Endif
          Endif ; The current window is a floating window
        Endif ; If this is a DOWN action
      Case EventType = "KEY":
        Keycode = EventBag["KeyCode"]
        Switch
          Case KeyCode = Asc("WinResize") or
               KeyCode = Asc("WinMax") or
               KeyCode = Asc("WinNext") or
               KeyCode = Asc("WinClose"):
            TargetWindow = GetWindow()
          Case (Keycode = Asc("ClearImage") or
               Keycode = Asc("ClearAll") or
               Keycode = Asc("EditKey") or
               Keycode = Asc("CoEditKey")):
               If nImages() > 0 Then
                 Window Handle Form to TargetWindow
                 If Not IsWindow(TargetWindow) Then
                   Window Handle Image ImageNo() To TargetWindow
                 Endif
               Else
                 TargetWindow = 0
               Endif
          Otherwise:
            ;----------------------------------------------------------
            ; Check to see if the keystrokes belong to a current file or
            ; memo editor...
            ;----------------------------------------------------------
            IsEditor = (IsFieldView() and Substr(FieldType(),1,1) = "M")
            or SysMode() = "File Editor" or SysMode() = "Script"
            ;----------------------------------------------------------
            ; If it does belong to an editor, then find the first non-
            ; floating window on the desktop. That will be the editor.
            ;----------------------------------------------------------
            If IsEditor Then
              Window List To WindowList
              For i From 1 to ArraySize(WindowList)
                Window GetAttributes WindowList[i] To WindowBag
                If Not WindowBag["Floating"] Then
                  TargetWindow = WindowList[i]
                  QuitLoop
                Endif
              EndFor
            Else ; Canvas or image is top window
              ;-------------------------------------------------------
              ; if there is an image then it will get the keystroke...
              ;-------------------------------------------------------
              If nImages() > 0 Then
                Window Handle Form To TargetWindow
                If Not IsWindow(TargetWindow) Then
                  Window Handle Image ImageNo() To TargetWindow
                Endif
              Else
                ;----------------------------------------------------
                ; ...otherwise the desktop will get the keystroke
                ;----------------------------------------------------
                TargetWindow = 0
              Endif
            Endif
        EndSwitch
      Otherwise:                     ; MESSAGE or IDLE
        TargetWindow = GetWindow()
    EndSwitch
  Endif                              ; There is no window
Endif                                ; Trigger

Return TargetWindow
EndProc                              ; EventMan.GetTargetWindow

