/* STRUCT.C

   Rick Kligman                             Started: 11/8/88

   This program will get the structure of a Pdx Table and show it to
   the user in a window
*/

#include <conio.h>
#include <table.h>
#include <stdio.h>

TABLE  *tabname;
FILE   *strfile;

void   get_struct(char *);

/*-------------------------------------------------------------------*/

main()
{
 char  rktable[50];

 clrscr();                             /* clear the screen */
 cprintf("View A Paradox Table Structure from inside BRIEF\r\n");
 cprintf("Developed by Rick Kligman   CIS 72220,1131\r\n\r\n");
 cprintf("WARNING: Locked files cannot be accessed. If you have a\r\n");
 cprintf("         solution then let me know.\r\n\r\n");
 cprintf("Enter the name of the Table whose structure you want to view.\r\n\r\n");
 cprintf("If the table is in the current directory then NO PATH is needed.\r\n\r\n");
 cprintf("When specifying the PATH, use only 1 backslash (\"\\\").\r\n\r\n");
 cprintf("You don't have to specify the full path if you want a table that\r\n");
 cprintf("is a subdirectory of your current PATH.\r\n\r\n");
 cprintf("ie. You are in C:\\Test and your table is C:\\Test\\D\\Tester.db\r\n");
 cprintf("Enter \"D\\Tester\" and it will find the correct table.\r\n\r\n\r\n");
 cprintf("Enter Table Name: ");
 gets(rktable);                        /* get table name */
 get_struct(rktable);                  /* get all the info for structure */
}

/*-------------------------------------------------------------------*/

void get_struct(char *rktable)
{
 int nflds, i, nolock;
 long count;
 char fldname[50], fldtype[5];

 tabname = tOpen(rktable);
 if (tabname == NULL) {
   cprintf("\r\n     File could not be opened\r\n");
   sound(300);
   delay(500);
   nosound();
   sleep(2);
   return;
   }
 nflds = tNumFlds(tabname);            /* how many fields in this table  */
 unlink("C:\\Brief\\Macros\\Struct.viw");             /* delete write file if there     */
 strfile = fopen("C:\\Brief\\Macros\\Struct.viw","w+");/* open up file to write to       */
 fprintf(strfile,"%s contains %d Fields\n\n",rktable,nflds);
 fprintf(strfile," #       Field Name                  Type\n");
 fprintf(strfile,"---  ------------------------------  ----\n");
 clrscr();

 for (i=1; i <= nflds; i++) {          /* get each field info    */
   gotoxy(25,10);
   cprintf("Reading Field #%d",i);
   tFldName(tabname,i,fldname);        /* get field name */
   tFldType(tabname,i,fldtype);        /* get field type */
   fprintf(strfile,"%2d.  %-30s  %-4s\n",i,fldname,fldtype);
   }
 fclose(strfile);
 tClose(tabname);
}



