
/* SYBASE/MS SQL SERVER Stored Procedure to 
   display structure of an SQL Table similar
   to a 'Info Structure' or 'Display Structure' in PARADOX
   ** Sundar Rajan Mar 1994
   Catalog sp_dispstru by logging in as sa ;
   use master; execute procedure in SAF or iSQL
   sp_displaystructure can be used from all databases within the server
*/

if exists (select name from sysobjects where name = 'sp_displaystructure')
 drop procedure sp_displaystructure
go
create procedure sp_displaystructure @tab char(30) = NULL
as
        if (@tab is NULL)
                raiserror 20001 "Must specify table name for sp_displaystructure!"
        else
		begin
                declare @min_id int
               
		select C.colid 'column_id', C.name 'column_name', T.name 'column_type',
			T.usertype 'user_type',
		        T.type 'base_type', T.name 'source_type',
                        C.length 'column_length', C.status 'column_is_null'
                into #tab_descr
                from syscolumns C, sysobjects O, systypes T
                where C.id = O.id AND
                C.usertype = T.usertype AND
                O.name = @tab AND
                T.name <> 'sysname'


                if (@@rowcount = 0)
		   raiserror 20001 "Table specified does not exist"
		else
		begin
		update #tab_descr
		set user_type = systypes.usertype from systypes where
                	(systypes.type = #tab_descr.base_type and
					 systypes.usertype < 100)

		update #tab_descr
		set column_type = name from systypes where
				#tab_descr.user_type = systypes.usertype

		update #tab_descr
		set column_type = name from systypes, #tab_descr
				  where systypes.type = #tab_descr.base_type and
				        #tab_descr.user_type > 100
		update #tab_descr
                set column_type = "char("+LTRIM(RTRIM(str(column_length)))+")"
                where column_type = "char"
                update #tab_descr
                set column_type = column_type + " NOT NULL"
                where column_is_null = 0
                select @min_id = min(column_id)
                from #tab_descr
                update #tab_descr     

                set column_id = column_id - @min_id + 1
                print @tab
                select "("+LTRIM(str(column_id))+")" 'No.', column_name 'Column Name',
                        column_type 'Type', source_type 'source type'
                from #tab_descr
         
        	order by column_id
		end
		end
go
/* grant execute rights to public */
grant execute on sp_displaystructure to public
                                                                                                                                                                                                                                     


