;This file is copyright (c) 1991, 1992 Informant Communications Group and the
;article author. The material here may be used in an application provided
;that this copyright/disclaimer information is kept in the original source
;file. The material presented here is provided "as is" and with no guarantee.
;Informant Communications Group/Paradox Informant assume no responsibility
;for the use or misuse of the material contained within.
;
;Contents        : procedure Soundex_Code(word, s),
;                            Add_Soundex_To_Table(),
;                            Soundex_Code(word, s),
;                            Add_Soundex_To_Table()
;
;Source File     : SOUNDEX.SC
;Author          : Bill Todd
;                  Kallista, Inc.
;                  11 E. Adams Street
;                  Suite 1402
;                  Chicago, IL  60603
;                  (312) 663-0101
;
;Informant Issue : December 1992
;
;Description     : A Soundex searching technique
;
; Paradox Informant
; 10519 E. Stockton Blvd.
; Suite 142
; Elk Grove, CA  95624-9743
; Phone: (916) 686-6610
; Fax  : (916) 686-8497
; BBS  : (916) 686-4740

;--------------------------------------------------------
;Return the Soundex code for a word using a static array.
;	word 	= the word to be coded.
;	s	= the Soundex code array.
;--------------------------------------------------------
PROC Soundex_Code(word, s)
   PRIVATE current_char,
           scode,             ;The Soundex code.
           sptr,              ;Number of characters in Soundex code.
           cptr,              ;Current position within the word.
           word_len,          ;Length of the word.
           last_char,         ;Previous character.
           ssize              ;Maximum size of Soundex code.

   ssize = 4

   ;Convert the word to upper case, extract the first character, save
   ;it in last_char and put it in the Soundex string.

   word = upper(word)
   current_char = SubStr(word,1,1)
   last_char = current_char
   scode = current_char

   ;Set the pointers to the second character.

   sptr = 2
   cptr = 2

   ;Save the length of the word.

   word_len = Len(word)

   ;Loop through each character in the word untill all of the characters
   ;have been processed or the Soundex code reaches a lenght of 4.

   WHILE (word_len >= cptr) and (sptr <= ssize)

      ;Extract the next character from the word.

      current_char = SubStr(word, cptr, 1)

      ;Skip duplicate characters.

      IF current_char = last_char THEN
         cptr = cptr + 1
         loop
      ENDIF

      ;Compute the index to the Soundex array.  This produces 1 for A,
      ;2 for B, etc.

      current_num = Asc(current_char) - 64

      ;If the character is a valid letter and it exists in the Soundex
      ;array get the soundex code otherwise skip it.

      IF ((current_char >= "A") and (current_char <= "Z") and
         (isassigned(s[current_num]))) THEN
         scode = scode + s[current_num]
         last_char = current_char
         sptr = sptr + 1
      ELSE
         last_char = ""
      ENDIF
      cptr = cptr + 1
   ENDWHILE

   ;If the Soundex code is less than the maximum number of characters
   ;fill it with zeros.

   WHILE len(scode) < ssize
      scode = scode + "0"
   ENDWHILE

   RETURN scode
ENDPROC

;--------------------------------------------------
;Adds Soundex codes to all of the words in a table.
;--------------------------------------------------
PROC Add_Soundex_To_Table()
   PRIVATE s,
           start,
           x,
           stop

   array s[26]
   s[2] = "1"
   s[3] = "2"
   s[4] = "3"
   s[6] = "1"
   s[7] = "2"
   s[10] = "2"
   s[11] = "2"
   s[12] = "4"
   s[13] = "5"
   s[14] = "5"
   s[16] = "1"
   s[17] = "2"
   s[18] = "6"
   s[19] = "2"
   s[20] = "3"
   s[22] = "1"
   s[24] = "2"
   s[26] = "2"

   COEDIT "wrds"
   start = ticks()
   SCAN
      [soundex] = Soundex_Code([word], s)
   ENDSCAN
   stop = ticks()
   do_it!
   message "Time = ", stop - start
   x = getchar()
ENDPROC

Add_Soundex_To_Table()

;--------------------------------------------------------
;Return the Soundex code for a word using a dynarray.
;	word 	= the word to be coded.
;	s	= the Soundex cdoe array.
;--------------------------------------------------------
PROC Soundex_Code(word, s)
   PRIVATE current_char,
           scode,          ;The soundex code.
           sptr,           ;The number of characters in the Soundex code.
           cptr,           ;Current position in the word.
           word_len,       ;The length of the word.
           last_char,      ;The previous character in the word.
           ssize           ;Maximum size of the Soundex code.

   ssize = 4

   ;Convert the word to upper case, extract the first character, save
   ;it in last_char and put it in the Soundex string.

   word = upper(word)
   current_char = SubStr(word,1,1)
   last_char = current_char
   scode = current_char

   ;Set the pointers to the second character.

   sptr = 2
   cptr = 2

   ;Save the length of the word.

   word_len = Len(word)

   ;Loop through each character in the word untill all of the characters
   ;have been processed or the Soundex code reaches a lenght of 4.

   WHILE (word_len >= cptr) and (sptr <= ssize)

      ;Extract the next character from the word.

      current_char = SubStr(word, cptr, 1)

      ;Skip duplicate characters.

      IF current_char = last_char THEN
         cptr = cptr + 1
         loop
      ENDIF

      ;If the character exists in the Soundex
      ;array get the soundex code otherwise skip it.

      IF isassigned(s[current_char]) THEN
         scode = scode + s[current_char]
         last_char = current_char
         sptr = sptr + 1
      ELSE
         last_char = ""
      ENDIF
      cptr = cptr + 1
   ENDWHILE

   ;If the Soundex code is less than the maximum number of characters
   ;fill it with zeros.

   WHILE len(scode) < ssize
      scode = scode + "0"
   ENDWHILE

   RETURN scode
ENDPROC

;--------------------------------------------------
;Adds Soundex codes to all of the words in a table.
;--------------------------------------------------
PROC Add_Soundex_To_Table()
   PRIVATE s,
           start,
           x,
           stop

   dynarray s[]
   s["B"] = "1"
   s["C"] = "2"
   s["D"] = "3"
   s["F"] = "1"
   s["G"] = "2"
   s["J"] = "2"
   s["K"] = "2"
   s["L"] = "4"
   s["M"] = "5"
   s["N"] = "5"
   s["P"] = "1"
   s["Q"] = "2"
   s["R"] = "6"
   s["S"] = "2"
   s["T"] = "3"
   s["V"] = "1"
   s["X"] = "2"
   s["Z"] = "2"

   COEDIT "wrds"
   start = ticks()
   SCAN
      [soundex] = Soundex_Code([word], s)
   ENDSCAN
   stop = ticks()
   do_it!
   message "Time = ", stop - start
   x = getchar()
ENDPROC

Add_Soundex_to_Table()
