; ===========================================================================
; Set Date and/or Time
; ---------------------------------------------------------------------------
; My users need to be able to set the date = the application sometimes calls
; for "post dating" when they use the database, so I needed to develop a procedure
; to set the date.  Setcdate is an .exe file written and complied in C.
; Since I was doing that, I also developed an .exe file to set the system's
; time.  I changed the time procedure to use a 12 hour clock since I find,
; (and suspect my users do too), a 24 hour clock confusing.  They have
; less need to set the system time, but in case of daylight savings time
; it is nice for them to be able to correct their server's time.
; ---------------------------------------------------------------------------
; Marnie Parker   -  The Tame Computer  -  Concord, CA.   1994
; Feel free to use the code and files.
; ---------------------------------------------------------------------------

proc GetTime()
private curtime, hour, mins, secs, pam

  ;get hour, mins, secs
  curtime = strval(time())
  hour    = numval(substr(curtime, 1, 2))
  mins    = numval(substr(curtime, 4, 2))
  secs    = numval(substr(curtime, 7, 2))

  ;roll over hours from 24 hour clock to 12
  pam = "am"
  if hour = 0 then
     hour = 12
  else
    if hour >= 12 then
       pam = "pm"
       if hour > 12 then
          hour = hour - 12
       endif
    endif
  endif

  ;return 12 hour clock string with am/pm flag
  curtime = strval(hour)+":"+strval(mins)+":"+strval(secs)+" "+pam

  return curtime
endproc

proc ExtractTime(findstr)
private curnum,
        strlen

 strlen  = search(findstr, newtime)
 curnum  = numval(substr(newtime, 1, strlen-1))
 newtime = substr(newtime, strlen+1, len(newtime)-strlen)
 return curnum

endproc

PROC DlgSClckProc(triggertype,tagvalue,eventvalue,elementvalue)
   REPAINTDIALOG         ;repaint clock
   IF triggertype = "ACCEPT" THEN
      pm      = FALSE
      ;each subsequent return also leaves the string newtime a shorter
      ;string, the remainder after the ##:s are extracted
      curhour = ExtractTime(":")
      curmins = ExtractTime(":")
      cursecs = ExtractTime(" ")
      if newtime = "pm" then
         pm = TRUE
      endif
      if (curhour > 12) or (curmins > 59) or (cursecs > 59) then
         ;invalid time, give user message and reset time
         ;to default of current time
         Message "Invalid Time"
         SLEEP 1500
         newtime = GetTime()
         ;show reset time
         RESYNCCONTROL "newtime"
         MESSAGE ""
         RETURN FALSE
      endif
   ENDIF
ENDPROC

PROC SetDate()
 PRIVATE okbutton,                               ;  OK button variable
         newdate,                                ;  input time variable
         curmonth,                               ;  self evident
         curday,                                 ;
         curyear,                                ;
         sysinfo_bag                             ;  Dynarray for SYSINFO

  SYSINFO TO sysinfo_bag                         ;  Get screen height and width

  okbutton = "No"
  newdate  = TODAY()
  SHOWDIALOG "Set Date"
    @ INT((sysinfo_bag["ScreenHeight"]-9)/2),    ;  Center the dialog box
      INT((sysinfo_bag["ScreenWidth"] - 33)/2)
    HEIGHT 9 WIDTH 33

    @ 2,4 ?? TODAY()
    PAINTCANVAS ATTRIBUTE 47 2,3,2,12
    
    LABEL @ 1,16 "~N~ew Date:" FOR "newdate"

    ACCEPT
    @ 2,17
    WIDTH 11
    "D"
    MIN 1/1/90
    MAX 12/31/99
    TAG "newdate"
    TO newdate

    PUSHBUTTON @ 5,4
      WIDTH 10
      "~O~K"
      OK
      VALUE "Yes"
      TAG "OKTAG"
    TO okbutton

    PUSHBUTTON @ 5,16
      WIDTH 10
      "~C~ancel"
      CANCEL
      VALUE "No"
      TAG "OKTAG"
    TO okbutton

  ENDDIALOG
  IF okbutton = "Yes" THEN
     IF (newdate <> TODAY()) THEN
        MESSAGE "Setting New Date..."
        ;separate out month/day/year
        curmonth = strval(MONTH(newdate))
        curday   = strval(DAY(newdate))
        curyear  = strval(YEAR(newdate))
        ;run external .exe procedure (written in C) to set computer's date
        RUN NOREFRESH "setcdate "+curmonth+" "+curday+" "+curyear+" "
        MESSAGE ""
     ENDIF
  ENDIF

ENDPROC

PROC SetTime()
 PRIVATE okbutton,                               ;  OK button variable
         newtime,                                ;  input time variable
         pm,                                     ;  logical
         curhour,                                ;  self evident
         curmins,
         cursecs,
         sysinfo_bag                             ;  Dynarray for SYSINFO

  SYSINFO TO sysinfo_bag                         ;  Get screen height and width

  okbutton = "No"
  newtime  = GetTime()
  SHOWDIALOG "Set Time"
    PROC "DlgSClckProc" IDLE TRIGGER "ACCEPT"   ;  Both idle to repaint clock and
    @ INT((sysinfo_bag["ScreenHeight"]-9)/2),   ;  accept to validate time
      INT((sysinfo_bag["ScreenWidth"] - 37)/2)
    HEIGHT 9 WIDTH 37

    @ 2,3 ?? format("W11,AR", GetTime())            ;  Display current time
    PAINTCANVAS ATTRIBUTE 47 2,3,2,13

    LABEL @ 1,18 "~N~ew Time:" FOR "newtime"

    ACCEPT
    @ 2, 19
    WIDTH 14
    "A11"
    PICTURE "#[#];:#[#];:#[#]; {a,p};m"
    TAG "newtime"
    TO newtime

    PUSHBUTTON @ 5,6
      WIDTH 10
      "~O~K"
      OK
      VALUE "Yes"
      TAG "OKTAG"
    TO okbutton

    PUSHBUTTON @ 5,18
      WIDTH 10
      "~C~ancel"
      CANCEL
      VALUE "No"
      TAG "OKTAG"
    TO okbutton

  ENDDIALOG
  IF okbutton = "Yes" THEN
     MESSAGE "Setting New Time..."
     ;roll 12 hour clock back to 24 hour clock
     if pm then
        if curhour <> 12 then
           curhour = curhour + 12
        endif
     else
        if curhour = 12 then
           curhour = 0
        endif
     endif
     curhour = strval(curhour)
     curmins = strval(curmins)
     cursecs = strval(cursecs)
     ;run external .exe to set system time
     RUN NOREFRESH "setctime "+curhour+" "+curmins+" "+cursecs+" "
     MESSAGE ""
  ENDIF

ENDPROC
